#' SEM Forest Control Object
#' 
#' A SEM Forest control object to tune parameters of the forest learning
#' algorithm.
#' 
#' 
#' @aliases semforest.control print.semforest.control
#' @param num.trees Number of trees.
#' @param sampling Sampling procedure. Can be subsample or bootstrap.
#' @param control A SEM Tree control object. Will be generated by default.
#' @param mtry Number of subsampled covariates at each node.
#' @author Andreas M. Brandmaier, John J. Prindle
#' @references Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger,
#' U. (2013). Structural equation model trees. \emph{Psychological Methods},
#' 18(1), 71-86.
#' 
#' @export
semforest.control <- function(num.trees=5, sampling="subsample", control=NA, mtry=2)
{
	options <- list()
	options$num.trees <- num.trees
	options$sampling <- sampling
	options$premtry <- 0
	options$mtry <- mtry
	if (all(is.na(control))) {
		options$semtree.control <- semtree.control()
    options$semtree.control$method <- "fair"
    options$semtree.control$alpha <- 1
    options$semtree.control$exclude.heywood <- FALSE
	} else {
		options$semtree.control <- control
	}
	class(options) <- "semforest.control"
    return(options)
}
