% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by_models.R
\name{group_by_models}
\alias{group_by_models}
\title{Group Estimates By Models}
\usage{
group_by_models(
  object_list,
  ...,
  col_names = "est",
  group_first = FALSE,
  model_first = TRUE,
  use_standardizedSolution = FALSE
)
}
\arguments{
\item{object_list}{A named list of
\linkS4class{lavaan} objects, a named list
of the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}, or a
named list of the output of
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{...}{Optional arguments to be
passed to
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
Ignored if the elements in
object_list are the results of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{col_names}{A vector of the
column names in the parameter
estimate tables to be included.
Default is \code{"est"}, or \code{"est.std"}
if \code{use_standardizedSolution} is
\code{TRUE}.}

\item{group_first}{If \code{TRUE}, the
rows will be grouped by groups first
and then by parameters. Ignored if
the model has only one group. Default
is \code{FALSE}.}

\item{model_first}{If \code{TRUE}, the
columns will be grouped by models
first and then by columns in the
parameter estimates tables. Default
is \code{TRUE}.}

\item{use_standardizedSolution}{If \code{TRUE}
and \code{object_list} is not a list of
estimates tables,
then \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
will be used to generate the table.
If \code{FALSE}, the default, then
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} will
be used if necessary.}
}
\value{
A data-frame-like object of
the class \code{est_table}.
}
\description{
Groups parameter
estimates or other information such
as \emph{p}-values into a table with
models as columns.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model1 <-
'
m ~ a*x
y ~ b*m
ab := a*b
'
fit1 <- sem(model1, data = dat, fixed.x = FALSE)
model2 <-
'
m ~ a*x
y ~ b*m + x
ab := a*b
'
fit2 <- sem(model2, data = dat, fixed.x = FALSE)
parameterEstimates(fit1)
parameterEstimates(fit2)
group_by_models(list(no_direct = fit1,
                     direct = fit2),
                col_names = c("est", "pvalue"))
# Can also be used with some other functions in
# semhelpinghands
group_by_models(list(no_direct = fit1,
                     direct = fit2),
                col_names = c("est", "pvalue")) |>
                filter_by(op = "~")


}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
Inspired by the proposal Rönkkö posted in a GitHub
\url{https://github.com/simsem/semTools/issues/24#issue-235172313}
for \code{semTools}. I want something
simple for a quick overview and so
I wrote this function.
}
