% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootEff-fun.R
\name{bootEff}
\alias{bootEff}
\title{Bootstrap Effects}
\usage{
bootEff(
  mod,
  R,
  seed = NULL,
  type = c("nonparametric", "parametric", "semiparametric"),
  ran.eff = NULL,
  cor.err = NULL,
  catch.err = TRUE,
  parallel = c("snow", "multicore", "no"),
  ncpus = NULL,
  cl = NULL,
  bM.arg = NULL,
  ...
)
}
\arguments{
\item{mod}{A fitted model object, or a list or nested list of such objects.
Alternatively, a \code{"psem"} object from
\href{https://rdrr.io/cran/piecewiseSEM/man/psem.html}{\code{piecewiseSEM::psem()}}.
If model lists are unnamed, response variable names will be used.}

\item{R}{Number of bootstrap resamples to generate.}

\item{seed}{Seed for the random number generator. If not provided, a random
five-digit integer is used (see Details).}

\item{type}{The type of bootstrapping to perform. Can be \code{"nonparametric"}
(default), \code{"parametric"}, or \code{"semiparametric"} (the last two currently
only for mixed models, via \code{\link[=bootMer]{bootMer()}}).}

\item{ran.eff}{For nonparametric bootstrapping of mixed models, the name of
the (highest-level) random effect to resample (see Details).}

\item{cor.err}{Optional, names of SEM correlated errors to be bootstrapped
(ignored if \code{mod} is a \code{"psem"} object). Should be of the form: \code{c("var1 ~~ var2", "var3 ~~ var4", ...)} (spaces optional), using model/response
variable names.}

\item{catch.err}{Logical, should errors generated during model fitting or
estimation be caught and \code{NA} returned for estimates? If \code{FALSE}, any such
errors will cause the function to exit.}

\item{parallel}{The type of parallel processing to use. Can be one of
\code{"snow"}, \code{"multicore"}, or \code{"no"} (for none).}

\item{ncpus}{Number of system cores to use for parallel processing. If \code{NULL}
(default), all available cores are used.}

\item{cl}{Optional cluster to use if \code{parallel = "snow"}. If \code{NULL}
(default), a local cluster is created using the specified number of cores.}

\item{bM.arg}{A named list of any additional arguments to \code{\link[=bootMer]{bootMer()}}.}

\item{...}{Arguments to \code{\link[=stdEff]{stdEff()}}.}
}
\value{
An object of class \code{"boot"} containing the bootstrapped effects, or a
(named) list/nested list of such objects.
}
\description{
Bootstrap model effects (standardised coefficients) and optional
SEM correlated errors.
}
\details{
\code{bootEff()} uses \code{\link[boot:boot]{boot::boot()}} (primarily) to bootstrap
standardised effects from a fitted model or list of models (calculated
using \code{\link[=stdEff]{stdEff()}}). Bootstrapping is typically nonparametric, i.e. model
effects are calculated from data where the rows have been randomly sampled
with replacement. 10,000 such resamples should provide accurate coverage
for confidence intervals in most situations, with fewer sufficing in some
cases. To ensure that data is resampled in the same way across individual
bootstrap operations within the same run (e.g. models in a list), the same
seed is set per operation, with the value saved as an attribute to the
matrix of bootstrapped values (for reproducibility). The seed can either be
user-supplied or a randomly-generated five-digit number (default), and is
always re-initialised on exit (i.e. \code{set.seed(NULL)}).

Where \code{weights} are specified, bootstrapped effects will be a weighted
average across the set of candidate models for each response variable,
calculated after each model is first refit to the resampled dataset
(specifying \code{weights = "equal"} will use a simple average instead – see
\code{\link[=avgEst]{avgEst()}}). If no weights are specified and \code{mod} is a nested list of
models, the function will throw an error, as it will be expecting weights
for a presumed model averaging scenario. If instead the user wishes to
bootstrap each individual model, they should recursively apply the function
using \code{\link[=rMapply]{rMapply()}} (remember to set a seed).

Where names of response variables with correlated errors are specified to
\code{cor.err}, the function will also return bootstrapped Pearson correlated
errors (weighted residuals) for those models. If \code{weights} are supplied and
\code{mod} is a nested list, residuals will first be averaged across candidate
models. If any two models (or candidate sets) with correlated errors were
fit to different subsets of data observations, both models/sets are first
refit to data containing only the observations in common.

For nonparametric bootstrapping of mixed models, resampling should occur at
the group-level, as individual observations are not independent. The name
of the random effect to resample must be supplied to \code{ran.eff}. For nested
random effects, this should be the highest-level group (Davison & Hinkley,
1997; Ren et al., 2010). This form of resampling will result in datasets of
different sizes if observations are unbalanced across groups; however this
should not generally be an issue, as the number of independent units
(groups), and hence the 'degrees of freedom', remains
\href{https://stats.stackexchange.com/questions/46965/bootstrapping-unbalanced-clustered-data-non-parametric-bootstrap}{unchanged}.

For mixed models with \href{https://stats.stackexchange.com/questions/228800/crossed-vs-nested-random-effects-how-do-they-differ-and-how-are-they-specified}{non-nested random effects},
nonparametric resampling will not be appropriate. In these cases,
parametric or semiparametric bootstrapping can be performed instead via
\code{\link[lme4:bootMer]{lme4::bootMer()}} (with additional arguments passed to that function as
necessary). NOTE: As \code{\link[=bootMer]{bootMer()}} takes only a fitted model as its first
argument (i.e. no lists), any model averaging is calculated 'post-hoc'
using the estimates in boot objects for each candidate model, rather than
during the bootstrapping process itself (i.e. the default procedure via
\code{\link[=boot]{boot()}}). Results are then returned in a new boot object for each response
variable or correlated error estimate.

If supplied a list containing both mixed and non-mixed models, \code{\link[=bootEff]{bootEff()}}
with nonparametric bootstrapping will still work and will treat all models
as mixed models for resampling (with a warning). This is likely a
relatively rare scenario, but may occur where the user decides that
non-mixed models perform similarly and/or cause less fitting issues than
their mixed counterparts for at least some response variables (e.g. where
random effect variance estimates are at or near zero). The data will be
resampled on the supplied random effect for all models. If nonparametric
bootstrapping is not used in this scenario however, an error will occur, as
\code{\link[=bootMer]{bootMer()}} will only accept mixed models.

Parallel processing is used by default via the \link{parallel} package and
option \code{parallel = "snow"} (and is generally recommended), but users can
specify the type of parallel processing to use, or none. If \code{"snow"}, a
cluster of workers is created using \code{\link[=makeCluster]{makeCluster()}}, and the user can
specify the number of system cores to incorporate in the cluster (defaults
to all available). \code{\link[=bootEff]{bootEff()}} then exports all required objects and
functions to this cluster using \code{\link[=clusterExport]{clusterExport()}}, after performing a
(rough) match of all objects and functions in the current global
environment to those referenced in the model call(s). Users should load any
required external packages prior to calling the function.
}
\note{
Bootstrapping mixed (or indeed any other) models may take a very long
time when the number of replicates, observations, parameters, and/or models
is high. To decrease processing time, it may be worth trying different
optimisers and/or other options to generate faster estimates (always check
results).
}
\examples{
# Bootstrap Shipley SEM (test – 1 rep)
# (set 'site' as group for resampling – highest-level random effect)
bootEff(shipley.sem, R = 1, ran.eff = "site", parallel = "no")

# Check estimates (use saved boot object – 1000 reps)
lapply(shipley.sem.boot, "[[", 1)  # original
lapply(shipley.sem.boot, function(i) head(i$t))  # bootstrapped
}
\references{
Burnham, K. P., & Anderson, D. R. (2002). \emph{Model Selection and
Multimodel Inference: A Practical Information-Theoretic Approach} (2nd
ed.). Springer-Verlag. \url{https://link.springer.com/book/10.1007/b97636}

Davison, A. C., & Hinkley, D. V. (1997). \emph{Bootstrap Methods and their
Application}. Cambridge University Press.

Ren, S., Lai, H., Tong, W., Aminzadeh, M., Hou, X., & Lai, S. (2010).
Nonparametric bootstrapping for hierarchical data. \emph{Journal of Applied
Statistics}, \emph{37}(9), 1487–1498. \doi{10/dvfzcn}
}
