% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_coeff_fun.R
\name{VIF}
\alias{VIF}
\title{Generalised Variance Inflation Factors}
\usage{
VIF(mod, data = NULL, ...)
}
\arguments{
\item{mod}{A fitted model object of class \code{"lm"}, \code{"glm"}, or
\code{"merMod"}, or a list or nested list of such objects.}

\item{data}{An optional dataset used to first re-fit the model(s).}

\item{...}{Not currently used.}
}
\value{
A numeric vector of the VIF's, or an array, list of vectors/arrays,
  or nested list.
}
\description{
Calculate generalised variance inflation factors for terms in a
  fitted model via the variance-covariance matrix of coefficients.
}
\details{
\code{VIF} calculates generalised variance inflation factors (GVIF)
  as described in Fox & Monette (1992), and also implemented in the
  \code{vif} function in the \pkg{car} package. However, whereas \code{vif}
  returns both GVIF and GVIF^(1/(2*Df)) values, \code{VIF} simply returns the
  squared result of the latter measure, which equals the standard VIF for
  single-coefficient terms and is the equivalent measure for
  multi-coefficient terms (e.g. categorical or polynomial). Also, while
  \code{vif} returns values per model term (i.e. predictor variable),
  \code{VIF} returns values per coefficient, meaning that the same VIF will
  be returned per coefficient for multi-coefficient terms. Finally, \code{NA}
  is returned for any coefficients which could not be estimated in the model
  (e.g. aliased terms).
}
\examples{
## Model with two correlated terms
m <- Shipley.Growth[[3]]
VIF(m)  # Date & DD somewhat correlated
VIF(update(m, . ~ . - DD))  # drop DD

## Model with different types of predictor (some multi-coefficient terms)
x1 <- poly(rnorm(100), 2)  # polynomial
x2 <- as.factor(rep(c("a", "b", "c", "d"), each = 25))  # categorical
x3 <- rep(1, 100)  # no variation
m <- lm(rnorm(100) ~ x1 + x2 + x3)
VIF(m)
}
\references{
Fox, J. and Monette, G. (1992) Generalized Collinearity
  Diagnostics. \emph{Journal of the American Statistical Association}
  \strong{87}, 178-183. \url{https://doi.org/dm9wbw}
}
\seealso{
\href{https://www.rdocumentation.org/packages/car/versions/3.0-3/topics/vif}{
vif (web)}
}
