% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{elem_submit}
\alias{elem_submit}
\title{Submit an element}
\usage{
elem_submit(x, js = FALSE, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{js}{Whether to submit the form using JavaScript.}

\item{timeout}{How long to wait for the element to exist.}
}
\value{
\code{x}, invisibly.
}
\description{
If an element is an ancestor of a form, submits the form.
Works by walking up the DOM, checking each ancestor element until
the element is a \verb{<form>} element, which it then submits. If such
an element does not exist, an error is thrown.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<form>
<input type='submit'>
<p>Random text</p>
</form>
<a>Random link</a>
"

session <- minimal_selenider_session(html)

elem_submit(s("input"))
elem_submit(s("p"))

# Won't work since the element doesn't have a form ancestor
try(elem_submit(s("a"), timeout = 0.5))

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other actions: 
\code{\link{elem_click}()},
\code{\link{elem_hover}()},
\code{\link{elem_scroll_to}()},
\code{\link{elem_select}()},
\code{\link{elem_set_value}()}
}
\concept{actions}
