% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/deputies_get_ids.R
\name{deputies_get_ids}
\alias{deputies_get_ids}
\title{Getting deputies' ids}
\usage{
deputies_get_ids(dbname, user, password, host,
   windows = .Platform$OS.type == 'windows')
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}

\item{windows}{information of used operation system; default:
.Platform$OS.type == 'windows'}
}
\value{
named character vector
}
\description{
Function \code{deputies_get_ids} gets deputies' ids from \emph{deputies} table.
}
\details{
Function \code{deputies_get_ids} gets deputies' ids from \emph{deputies} table.
As result of this function you get named character vector with ids, where their
names are names and surnames of deputies. Because of encoding issue on Windows
operation system, you need to select if you use Windows.
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
deputies_get_ids(dbname, user, password, host, TRUE)
deputies_get_ids(dbname, user, password, host, FALSE)}
}
\author{
Piotr Smuda
}

