% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Likelihood_Function.R
\name{LOGLIKELIHOOD_func}
\alias{LOGLIKELIHOOD_func}
\title{Calculates the Log Likelihood for a new sample given the current state (i.e. log[L(G|x)P(G)])}
\usage{
LOGLIKELIHOOD_func(
  pars,
  Step,
  OBSERVATIONS,
  x_0,
  parameters,
  EPS_inner,
  INPUT,
  D,
  GIBBS_PAR,
  k,
  MU_JUMP,
  SIGMA_JUMP,
  eps_new,
  objectivfunc
)
}
\arguments{
\item{pars}{sampled hidden influence for state k (w_new) at time tn+1}

\item{Step}{time step of the sample algorithm corresponding to the given vector of time points}

\item{OBSERVATIONS}{observed values at the given time step/point}

\item{x_0}{initial values at the given time step/point}

\item{parameters}{model parameters estimates}

\item{EPS_inner}{current hidden inputs at time tn}

\item{INPUT}{discrete input function e.g. stimuli}

\item{D}{diagonal weight matrix of the current Gibbs step}

\item{GIBBS_PAR}{GIBBS_PAR[["BETA"]] and GIBBS_PAR[["ALPHA"]]; prespecified or calculated vector of state weights}

\item{k}{number state corresponding to the given hidden influence (w_new)}

\item{MU_JUMP}{mean of the normal distributed proposal distribution}

\item{SIGMA_JUMP}{variance of the normal distributed proposal distribution}

\item{eps_new}{current sample vector of the hidden influences (including all states)}

\item{objectivfunc, }{link function to match observations with modeled states}
}
\value{
returns the log-likelihood for two given hidden inputs
}
\description{
Algorithm implemented according to Engelhardt et al. 2017.
The function can be replaced by an user defined version if necessary.
}
