% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_function.R
\name{tm}
\alias{tm}
\title{Param: Average time}
\usage{
tm(data, trat, nrep, time)
}
\arguments{
\item{data}{data.frame containing the responses of the evaluations in separate columns side by side and without the columns with the identification of the factors}

\item{trat}{vector of treatments with n repetitions}

\item{nrep}{Number of repetitions}

\item{time}{vector containing time}
}
\value{
Returns the vector with the average time.
}
\description{
Calculates the average germination/emergence time according to Silva and Nakagawa (1995)
}
\examples{
data("substrate")
tm(substrate[,c(3:18)],
      trat = substrate$Trat,
      nrep = 4,
      time = 1:16)
}
\references{
SILVA, J. B. C.; NAKAGAWA, J. Estudos de formulas para calculo de germinacao. Informativo ABRATES, Londrina, v. 5, n. 1, p. 62-73, 1995.
}
