% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_prep.R
\name{create_default_shift_matrix}
\alias{create_default_shift_matrix}
\title{Helper function to create a default \code{shift_matrix} list}
\usage{
create_default_shift_matrix(
  state_names = c("0", "1"),
  num_concealed_states = 2,
  mu_vector = NULL
)
}
\arguments{
\item{state_names}{vector of names of all observed states.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}

\item{mu_vector}{previously defined mus - used to choose indicator number.}
}
\description{
This function generates a generic shift matrix to be used with the function
\code{\link[=create_q_matrix]{create_q_matrix()}}.
}
\examples{
shift_matrix <- create_default_shift_matrix(state_names = c(0, 1),
                                            num_concealed_states = 2,
                                            mu_vector = c(1, 2, 1, 2))
q_matrix <- create_q_matrix(state_names = c(0, 1),
                            num_concealed_states = 2,
                            shift_matrix = shift_matrix,
                            diff.conceal = FALSE)
}
