% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_layers}
\alias{load_layers}
\title{Load layers}
\usage{
load_layers(layercodes, equalarea=FALSE, rasterstack=TRUE,
  datadir=NULL)
}
\arguments{
\item{layercodes}{character vector or dataframe. Layer_codes of the layers to
be loaded or dataframe with a "layer_code" column.}

\item{equalarea}{logical. If \code{TRUE} then layers are loaded with a 
Behrmann cylindrical equal-area projection (\code{\link{equalareaproj}}), 
otherwise unprojected (\code{\link{lonlatproj}}). Default is \code{FALSE}.}

\item{rasterstack}{logical. If \code{TRUE} (default value) then the result is
a \code{\link[raster]{stack}} otherwise a list of rasters is returned.}

\item{datadir}{character. Directory where you want to store the data. The 
default value used is \code{file.path(path.expand("~"), "R", 
"sdmpredictors")} and can be overridden with 
\code{options(sdmpredictors_datadir = "<your preferred directory>")}.}
}
\value{
RasterStack or list of raster
}
\description{
Method to load rasters from disk or from the internet. By default a 
RasterStack is returned but this is only possible When all rasters have the 
same spatial extent and resolution.
}
\seealso{
\code{\link{list_layers}}, \code{\link{layer_stats}}, 
  \code{\link{layers_correlation}}
}

