% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{make_mesh}
\alias{make_mesh}
\alias{plot.sdmTMBmesh}
\title{Construct an SPDE mesh for sdmTMB}
\usage{
make_mesh(
  data,
  xy_cols,
  type = c("kmeans", "cutoff", "cutoff_search"),
  cutoff,
  n_knots,
  seed = 42,
  refine = list(min.angle = 21, max.edge = Inf, max.n.strict = -1, max.n = 1000),
  mesh = NULL
)

\method{plot}{sdmTMBmesh}(x, ...)
}
\arguments{
\item{data}{A data frame.}

\item{xy_cols}{A character vector of x and y column names contained in
\code{data}. These should likely be in an equal distance projection. For
a helper function to convert to UTMs, see \code{\link[=add_utm_columns]{add_utm_columns()}}.}

\item{type}{Method to create the mesh. Also see \code{mesh} argument to supply
your own mesh.}

\item{cutoff}{An optional cutoff if type is \code{"cutoff"}. "The minimum allowed
distance between points in the mesh". See \code{\link[INLA:inla.mesh.create]{INLA::inla.mesh.create()}}.
Smaller values create meshes with more knots. Points further apart than this
value will receive a separate vertex in the mesh before any mesh refinement.}

\item{n_knots}{The number of desired knots if \code{type} is not \code{"cutoff"}.}

\item{seed}{Random seed. Affects \code{\link[stats:kmeans]{stats::kmeans()}} determination of knot
locations if \code{type = "kmeans"}.}

\item{refine}{Logical or list to pass to \code{\link[INLA:inla.mesh.create]{INLA::inla.mesh.create()}}.}

\item{mesh}{An optional mesh created via INLA instead of using the above
convenience options.}

\item{x}{Output from \code{\link[=make_mesh]{make_mesh()}}.}

\item{...}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\value{
\code{make_mesh()}: A list of class \code{sdmTMBmesh}. The element \code{mesh} is the output from
\code{\link[INLA:inla.mesh.create]{INLA::inla.mesh.create()}} and the element \code{spde} is the output from
\code{\link[INLA:inla.spde2.matern]{INLA::inla.spde2.matern()}}.

\code{plot.sdmTMB()}: A plot of the mesh and data points.
}
\description{
Construct an SPDE mesh for use with sdmTMB.
}
\examples{
\dontshow{if (inla_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mesh <- make_mesh(pcod, c("X", "Y"), cutoff = 30, type = "cutoff")
plot(mesh)

\donttest{
mesh <- make_mesh(pcod, c("X", "Y"), cutoff = 5, type = "cutoff")
plot(mesh)

mesh <- make_mesh(pcod, c("X", "Y"), n_knots = 50, type = "cutoff_search")
plot(mesh)

mesh <- make_mesh(pcod, c("X", "Y"), n_knots = 50, type = "kmeans")
plot(mesh)

# Defining a mesh directly with INLA:
bnd <- INLA::inla.nonconvex.hull(cbind(pcod$X, pcod$Y), convex = -0.05)
inla_mesh <- INLA::inla.mesh.2d(
  boundary = bnd,
  max.edge = c(20, 50),
  offset = -0.05,
  cutoff = c(2, 5),
  min.angle = 10
)
mesh <- make_mesh(pcod, c("X", "Y"), mesh = inla_mesh)
plot(mesh)
}
\dontshow{\}) # examplesIf}
}
