% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_sdg.R
\name{plot_compared_sdg}
\alias{plot_compared_sdg}
\title{Plot the distribution of a varaible from the synthetic data comparing with the real data.}
\usage{
plot_compared_sdg(
  target_var,
  training_set,
  syn_data_names,
  generated_data1,
  generated_data2 = NA,
  generated_data3 = NA,
  generated_data4 = NA,
  generated_data5 = NA,
  generated_data6 = NA
)
}
\arguments{
\item{target_var}{A string of the comparision variable name.}

\item{training_set}{A data frame of the training data.}

\item{syn_data_names}{A string vector of names of the generators.}

\item{generated_data1}{A data frame of synthetic data 1.}

\item{generated_data2}{A data frame of synthetic data 2.}

\item{generated_data3}{A data frame of synthetic data 3.}

\item{generated_data4}{A data frame of synthetic data 4.}

\item{generated_data5}{A data frame of synthetic data 5.}

\item{generated_data6}{A data frame of synthetic data 6.}
}
\value{
The output is a plot of the comparision of the
    distribution of synthetic data vs real data. If the
    \code{target_var} is discrete, the plot is a bar plot,
    If the \code{target_var} is continous, the plot is
    a density plot,
}
\description{
\code{plot_compared_sdg} return a plot of the comparision of
the distribution of synthetic data vs real data.
}
\examples{
adult_data <- split_data(adult[1:100,], 70)
bn_learn <- gen_bn_learn(adult_data$training_set, "hc")
plot_compared_sdg(target_var = "age",
    training_set = adult_data$training_set,
    syn_data_names = c("bn_learn"),
    generated_data1 = bn_learn$gen_data)
plot_compared_sdg(target_var = "race",
    training_set = adult_data$training_set,
    syn_data_names = c("bn_learn"),
    generated_data1 = bn_learn$gen_data)

}
