% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drifts.R
\name{driftMixIndVm}
\alias{driftMixIndVm}
\title{Drift for the mivM diffusion}
\usage{
driftMixIndVm(x, A, M, sigma, p, expTrc = 30)
}
\arguments{
\item{x}{matrix of size \code{c(n, p)} with the evaluation points for the drift.}

\item{A}{matrix of size \code{c(m, p)} giving the strengths of the drifts.}

\item{M}{matrix of size \code{c(m, p)} giving the means.}

\item{sigma}{diffusion coefficient.}

\item{p}{vector of length \code{m} giving the proportions. Must add to one.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A matrix of the same size as \code{x} containing the drift.
}
\description{
Drift for the Langevin diffusion associated to a mixture of \code{m} independent (multivariate) von Mises (mivM) of dimension \code{p}.
}
\details{
\code{\link{driftMixVm}} is more efficient for the circular case. The diffusion matrix is \eqn{\sigma\bold{I}}{sigma}. See Section 2.2.4 in García-Portugués et al. (2019) for details.
}
\examples{
# 1D
x <- seq(-pi, pi, l = 200)
plot(x, x, type = "n", ylab = "drift")
for (i in 1:10) {
  lines(x, driftMixIndVm(x = cbind(x), A = cbind(c(2, 2)),
        M = cbind(c(0, -pi + 2 * pi * i / 10)), sigma = 1, p = c(0.5, 0.5)),
        col = rainbow(10)[i])
}

# 2D
x <- seq(-pi, pi, l = 100)
plotSurface2D(x, x, f = function(x) sqrt(rowSums(driftMixIndVm(x = x,
              A = rbind(c(1, 1), c(1, 1)), M = rbind(c(1, 1), c(-1, -1)),
              sigma = 1, p = c(0.25, 0.75))^2)), fVect = TRUE)
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019) Langevin diffusions on the torus: estimation and applications. \emph{Statistics and Computing}, 29(2):1--22. \url{https://doi.org/10.1007/s11222-017-9790-2}
}
