% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.r
\name{calcRisks}
\alias{calcRisks}
\title{Recompute Risk and Frequencies for a sdcMicroObj}
\usage{
calcRisks(obj, ...)
}
\arguments{
\item{obj}{an object of class \code{\link{sdcMicroObj-class}}}

\item{...}{no arguments at the moment}
}
\description{
Recomputation of Risk should be done after manual changing the content of an
object of class \code{\link{sdcMicroObj-class}}
}
\details{
By applying this function, the dislosure risk is re-estimated and the
corresponding slots of an object of class \code{\link{sdcMicroObj-class}} are updated.
This function mostly used internally to automatically update the risk after
an sdc method is applied.
}
\examples{
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- calcRisks(sdc)

}
\seealso{
\code{\link{sdcMicroObj-class}}
}
