% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topBotCoding.R
\docType{methods}
\name{topBotCoding}
\alias{topBotCoding}
\title{Top and Bottom Coding}
\usage{
topBotCoding(obj, value, replacement, kind = "top", column = NULL)
}
\arguments{
\item{obj}{a numeric vector, a \code{data.frame} or a \code{\link{sdcMicroObj-class}}-object}

\item{value}{limit, from where it should be top- or bottom-coded}

\item{replacement}{replacement value.}

\item{kind}{top or bottom}

\item{column}{variable name in case the input is a \code{data.frame} or an object of class \code{\link{sdcMicroObj-class}}.}
}
\value{
Top or bottom coded data or modified \code{\link{sdcMicroObj-class}}.
}
\description{
Function for Top and Bottom Coding.
}
\details{
Extreme values larger or lower than \code{value} are replaced by a different value (\code{replacement} in order to reduce the disclosure risk.
}
\note{
top-/bottom coding of factors is no longer possible as of sdcMicro >=4.7.0
}
\examples{
data(free1)
res <- topBotCoding(free1[,"DEBTS"], value=9000, replacement=9100, kind="top")
max(res)

data(testdata)
range(testdata$age)
testdata <- topBotCoding(testdata, value=80, replacement=81, kind="top", column="age")
range(testdata$age)

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2, keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
           numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- topBotCoding(sdc, value=500000, replacement=1000, column="income")
testdataout <- extractManipData(sdc)
}
\seealso{
\code{\link{indivRisk}}
}
\author{
Matthias Templ and Bernhard Meindl
}
\keyword{manip}
