% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_var.R
\name{sample_var}
\alias{sample_var}
\title{Compute the sample variance}
\usage{
sample_var(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector}

\item{na.rm}{(logical) Should missing values be removed?}
}
\value{
A single numeric value equal to the sample variance
}
\description{
\code{sample_var} computes the sample variance, i.e. the sum of squared deviations of \code{x} from the mean divided by the total number of observations. This is in contrast to \code{var}, which computes an unbiased estimate of the variance (i.e. it divides the sum of squared deviations by n - 1).
}
\examples{
data(anchoring)
sample_var(anchoring$everest_feet)
}
