% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grimmer-map.R
\name{grimmer_map}
\alias{grimmer_map}
\title{GRIMMER-test many cases at once}
\usage{
grimmer_map(
  data,
  items = 1,
  merge_items = TRUE,
  x = NULL,
  sd = NULL,
  n = NULL,
  show_reason = TRUE,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE,
  tolerance = .Machine$double.eps^0.5
)
}
\arguments{
\item{data}{Data frame with columns \code{x}, \code{sd}, \code{n}, and optionally \code{items}
(see documentation for \code{grim()}). Any other columns in \code{data} will be
returned alongside GRIMMER test results.}

\item{items}{Integer. If there is no \code{items} column in \code{data}, this specifies
the number of items composing the \code{x} values. Default is 1, the most common
case.}

\item{merge_items}{Boolean. If \code{TRUE} (the default), there will be no \code{items}
column in the output. Instead, values from an \code{items} column or argument
will be multiplied with values in the \code{n} column. This does not affect
GRIM- or GRIMMER-testing.}

\item{x, sd, n}{Optionally, specify these arguments as column names in \code{data}.}

\item{show_reason}{Boolean (length 1). Should there be a \code{reason} column that
shows the reasons for inconsistencies (and \code{NA} for consistent values)?
Default is \code{FALSE}.}

\item{rounding, threshold, symmetric, tolerance}{Further parameters of
GRIMMER-testing; see documentation for \code{grimmer()}.}
}
\value{
A tibble with these columns --
\itemize{
\item \code{x}, \code{sd}, \code{n}: the inputs.
\item \code{consistency}: GRIMMER consistency of \code{x}, \code{n}, and \code{items}.
\item \verb{<extra>}: any columns from \code{data} other than \code{x}, \code{n}, and \code{items}.
}

The tibble has the \code{scr_grimmer_map} class, which is recognized by the
\code{audit()} generic. It also has the \code{scr_grim_map} class, so it can be
visualized by \code{grim_plot()}.
}
\description{
Call \code{grimmer_map()} to GRIMMER-test any number of combinations
of mean, standard deviation, sample size, and number of items. Mapping
function for GRIMMER-testing.

For summary statistics, call \code{audit()} on the results. Visualize results
using \code{grim_plot()}, as with GRIM results.
}
\section{Summaries with \code{audit()}}{
 There is an S3 method for \code{audit()}, so
you can call \code{audit()} following \code{grimmer_map()} to get a summary of
\code{grimmer_map()}'s results. It is a tibble with a single row and these
columns --
\enumerate{
\item \code{incons_cases}: number of GRIMMER-inconsistent value sets.
\item \code{all_cases}: total number of value sets.
\item \code{incons_rate}: proportion of GRIMMER-inconsistent value sets.
\item \code{fail_grim}: number of value sets that fail the GRIM test.
\item \code{fail_test1}: number of value sets that fail the first GRIMMER test (sum
of squares is a whole number)
\item \code{fail_test2}: number of value sets that fail the second GRIMMER test
(matching SDs)
\item \code{fail_test3}: number of value sets that fail the third GRIMMER test (equal
parity)
}
}

\examples{
# Use `grimmer_map()` on data like these:
pigs5

# The `consistency` column shows whether
# the values to its left are GRIMMER-consistent.
# If they aren't, the `reason` column says why:
pigs5 \%>\%
  grimmer_map()

# Get summaries with `audit()`:
pigs5 \%>\%
  grimmer_map() \%>\%
  audit()
}
\references{
Allard, A. (2018). Analytic-GRIMMER: a new way of testing the
possibility of standard deviations.
https://aurelienallard.netlify.app/post/anaytic-grimmer-possibility-standard-deviations/

Anaya, J. (2016). The GRIMMER test: A method for testing the validity of
reported measures of variability. \emph{PeerJ Preprints.}
https://peerj.com/preprints/2400v1/
}
