% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-binary.R
\name{scoring-functions-binary}
\alias{scoring-functions-binary}
\alias{brier_score}
\alias{logs_binary}
\title{Metrics for binary outcomes}
\usage{
brier_score(observed, predicted)

logs_binary(observed, predicted)
}
\arguments{
\item{observed}{A factor of length n with exactly two levels, holding
the observed values.
The highest factor level is assumed to be the reference level. This means
that \code{predicted} represents the probability that the observed value is
equal to the highest factor level.}

\item{predicted}{A numeric vector of length n, holding probabilities.
Values represent the probability that the corresponding outcome is equal to
the highest level of the factor \code{observed}.}
}
\value{
A numeric vector of size n with the Brier scores

A numeric vector of size n with log scores
}
\description{
\strong{Brier score}

The Brier Score is the mean squared error between the probabilistic
prediction and the observed outcome. The Brier score is a proper scoring
rule. Small values are better (best is 0, the worst is 1).

\deqn{
  \textrm{Brier\_Score} = (\textrm{prediction} - \textrm{outcome})^2,
}{
  Brier_Score = (prediction - outcome)²,
} where \eqn{\textrm{outcome} \in \{0, 1\}}{outcome in {0, 1}}, and
\eqn{\textrm{prediction} \in [0, 1]}{prediction in [0, 1]} represents
the probability that the outcome is equal to 1.

\strong{Log score for binary outcomes}

The Log Score is the negative logarithm of the probability
assigned to the observed value. It is a proper scoring rule. Small values
are better (best is zero, worst is infinity).
}
\details{
The functions require users to provide observed values as a factor in order
to distinguish its input from the input format required for scoring point
forecasts. Internally, however, factors will be converted to numeric values.
A factor \verb{observed = factor(c(0, 1, 1, 0, 1)} with two levels (\code{0} and \code{1})
would internally be coerced to a numeric vector (in this case this would
result in the numeric vector \code{c(1, 2, 2, 1, 1)}). After subtracting 1, the
resulting vector (\code{c(0, 1, 1, 0)} in this case) is used for internal
calculations. All predictions are assumed represent the probability that the
outcome is equal of the last/highest factor level (in this case that the
outcome is equal to 1).

You could alternatively also provide a vector like
\code{observed = factor(c("a", "b", "b", "a"))} (with two levels, \code{a} and \code{b}),
which would result in exactly the same internal representation. Probabilities
then represent the probability that the outcome is equal to "b".
If you want your predictions to be probabilities that the outcome is "a",
then you could of course make \code{observed} a factor with levels swapped, i.e.
\code{observed = factor(c("a", "b", "b", "a"), levels = c("b", "a"))}
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-binary-point.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for binary and point forecasts
}
\if{latex}{
  \figure{metrics-binary-point.png}
}
}

\examples{
observed <- factor(sample(c(0, 1), size = 30, replace = TRUE))
predicted <- runif(n = 30, min = 0, max = 1)

brier_score(observed, predicted)
logs_binary(observed, predicted)
}
\seealso{
Other log score functions: 
\code{\link{logs_categorical}()},
\code{\link{logs_sample}()}
}
\concept{log score functions}
\keyword{metric}
