% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_replication.R
\name{run_casestudy}
\alias{run_casestudy}
\title{Run the case study in KLTG (2019), or a smaller version thereof}
\usage{
run_casestudy(data_df, burnin_size = 5000, max_mcmc_sample_size = 5000,
  nr_of_chains = 3, first_vint = "1996Q2", last_vint = "2014Q3",
  forecast_horizon = 1, random_seed = 816)
}
\arguments{
\item{data_df}{data frame in the same format as the \link{gdp} data set in this package.}

\item{burnin_size}{length of the burn-in period used for each forecast.}

\item{max_mcmc_sample_size}{maximal number of MCMC draws to consider (integer, must equal either 1000, 5000, 10000, 20000 or 40000). Defaults to 5000.}

\item{nr_of_chains}{number of parallel MCMC for each forecast date (integer, defaults to 3).}

\item{first_vint, last_vint}{first and last data vintage (= time point at which forecasts are made). Default to "19962Q2" and "2014Q3", respectively.}

\item{forecast_horizon}{forecast horizon to be analyzed (integer, defaults to 1).}

\item{random_seed}{seed for random numbers used during the MCMC sampling process. Defaults to 816.}
}
\value{
Object of class "casestudy", containing the results of the analysis. This object can be passed to \code{plot} for plotting, see the documentation for \link{plot.casestudy}.
}
\description{
Run the case study in KLTG (2019), or a smaller version thereof
}
\details{
The full results in Section 5 of KLTG (2019) are based on the following setup: \code{burnin_size = 10000},
\code{max_mcmc_sample_size = 50000}, \code{nr_of_chains = 16}, \code{data_df = gdp}, \code{first_vint = "1996Q2"}, 
\code{last_vint = "2014Q3"}, and \code{forecast_horizon = 1}. Since running this full configuration is very 
time consuming, the default setup offers the possibility to run a small-scale study which reproduces the 
qualitative outcomes of the analysis. Running the small-scale study implied by the defaults of \code{run_study} as well as the GDP data (\code{data_df = gdp}) takes about 40 minutes on an Intel i7 processor.
}
\examples{
\dontrun{
data(gdp)
cs <- run_casestudy(data_df = gdp, last_vint = "1999Q4")
plot(cs)
}
}
\references{
Krueger, F., Lerch, S., Thorarinsdottir, T.L. and T. Gneiting (2019): `Predictive inference based on Markov chain Monte Carlo output', working paper, Heidelberg Institute for Theoretical Studies, available at \url{http://arxiv.org/abs/1608.06802}.
}
\seealso{
\link{plot.casestudy} produces a summary plot of the results generated by \link{run_casestudy}
\link{run_casestudy} uses \link{ar_ms} to fit a Bayesian Markov Switching model, recursively for several time periods.
}
\author{
Fabian Krueger
}
\keyword{replication}
