% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tape_logJacdet}
\alias{tape_logJacdet}
\title{Tape the log of Jacobian determinant of a CppAD Tape}
\usage{
tape_logJacdet(pfun)
}
\arguments{
\item{pfun}{An \code{Rcpp_ADFun} object.}
}
\value{
An \code{Rcpp_ADFun} object.
}
\description{
Creates a tape of the log of the Jacobian determinant of a function taped by CppAD.
The \code{x} vector is used as the value to conduct the taping.

For creating this tape, the values of \code{pfun$xtape} and \code{pfun$dyntape} are used.
}
\seealso{
Other tape builders: 
\code{\link{tape_Hessian}()},
\code{\link{tape_Jacobian}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_smd}()},
\code{\link{tape_swap}()},
\code{\link{tape_uld}()}
}
\concept{tape builders}
