% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_ply}
\alias{woebin_ply}
\title{WOE/BIN Transformation}
\usage{
woebin_ply(dt, bins, to = "woe", no_cores = 2, print_step = 0L,
  replace_blank_inf = TRUE, ...)
}
\arguments{
\item{dt}{A data frame.}

\item{bins}{Binning information generated from \code{woebin}.}

\item{to}{Converting original values to woe or bin. Defaults to woe.}

\item{no_cores}{Number of CPU cores for parallel computation. Defaults to 2, if it sets to NULL then 90 percent of total cpu cores will be used.}

\item{print_step}{A non-negative integer. Defaults to 1. If print_step>0, print variable names by each print_step-th iteration. If print_step=0 or no_cores>1, no message is print.}

\item{replace_blank_inf}{Logical. Replace blank values with NA and infinite with -1. Defaults to TRUE. This argument should be the same with \code{woebin}'s.}

\item{...}{Additional parameters.}
}
\value{
A data frame with columns for variables converted into woe values.
}
\description{
\code{woebin_ply} converts original values of input data into woe or bin based on the binning information generated from \code{woebin}.
}
\examples{
# load germancredit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "credit.amount", "purpose")]

# binning for dt
bins = woebin(dt, y = "creditability")

# converting to woe
dt_woe = woebin_ply(dt, bins=bins)
str(dt_woe)

# converting to bin
dt_bin = woebin_ply(dt, bins=bins, to = 'bin')
str(dt_bin)

\donttest{
# Example II
# binning for germancredit dataset
bins_germancredit = woebin(germancredit, y="creditability")

# converting the values in germancredit to woe
# bins is a list which generated from woebin()
germancredit_woe = woebin_ply(germancredit, bins_germancredit)

# bins is a data frame
bins_df = data.table::rbindlist(bins_germancredit)
germancredit_woe = woebin_ply(germancredit, bins_df)

}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_plot}}, \code{\link{woebin_adj}}
}
