% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{imanDavenportTest}
\alias{imanDavenportTest}
\title{Iman Davenport's modification of Friedman's test}
\usage{
imanDavenportTest(data, ...)
}
\arguments{
\item{data}{Matrix where the test is performed}

\item{...}{Ignored}
}
\value{
A list with class "htest" containing the following components: \code{statistic}, the value of the statistic used in the test; \code{parameter}, the two degrees of freedom of the F distribution; \code{p.value}, the p-value for the test; \code{method}, a character string indicating what type of test was performed and \code{data.name}, a character string giving the name of the data.
}
\description{
This function performs Iman-Davenport modification of Friedman's test
}
\details{
The test has been implemented according to the version in Demsar (2006), page 11
}
\examples{
data(data_gh_2008)
imanDavenportTest(data.gh.2008)
}
\references{
Demsar, J. (2006) Statistical Comparisons of Classifiers over Multiple Data Sets. \emph{Journal of Machine Learning Research}, 7, 1-30.
}

