% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{schwab_marketHours}
\alias{schwab_marketHours}
\title{Get Market Hours}
\usage{
schwab_marketHours(
  marketType = c("EQUITY", "OPTION", "BOND", "FUTURE", "FOREX"),
  date = Sys.Date(),
  accessTokenList = NULL
)
}
\arguments{
\item{marketType}{The asset class to pull:
'EQUITY','OPTION','BOND','FUTURE','FOREX'. Default is EQUITY}

\item{date}{Current or future date to check hours}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
List output of times and if the current date is a trading day
}
\description{
Returns a list output for current day and specified market that details the
trading window
}
\examples{
\dontrun{

# Access Token must be set using schwab_auth_accessToken
# Market hours for the current date
schwab_marketHours()
schwab_marketHours('2020-06-24', 'OPTION')

}
}
