% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataIO.R
\name{ImportSeurat}
\alias{ImportSeurat}
\title{Convert Other Formats to SeuratObject.}
\usage{
ImportSeurat(
  obj = NULL,
  assay = "RNA",
  from = c("SCE", "AnnData", "CellDataSet", "cell_data_set", "loom"),
  count.assay = "counts",
  data.assay = "logcounts",
  slot = "counts",
  anndata.file = NULL,
  loom.file = NULL,
  conda.path = NULL,
  ...
)
}
\arguments{
\item{obj}{Other formats object (eg: SingleCellExperiment, CellDataSet).
Default: NULL (used when \code{from} is "AnnData").}

\item{assay}{Assay name to store expression matrices in SeuratObject. Default: RNA.}

\item{from}{The source formats, chosen from "SCE" (SingleCellExperiment), "AnnData", "CellDataSet", "cell_data_set". Default: "SCE".}

\item{count.assay}{The assay of source formats to save raw counts,
used when \code{from} is "SCE" or cell_data_set. Default: counts.}

\item{data.assay}{The assay of source formats to save log transformed counts,
used when \code{from} is "SCE" or cell_data_set. Default: logcounts.}

\item{slot}{Slot to store expression data as, used when \code{from} is "CellDataSet". Default: counts.}

\item{anndata.file}{The file contains AnnData. Default: NULL.}

\item{loom.file}{The file contains loom. Default: NULL.}

\item{conda.path}{Conda environment path, used when \code{from} is "AnnData". Default: NULL.}

\item{...}{Parameter for \code{\link{as.Seurat}}, \code{sceasy::convertFormat}, \code{\link{as.Seurat}}, \code{\link{as.Seurat}},
\code{\link{as.Seurat}}, corresponding to \code{from}.}
}
\value{
A Seurat object.
}
\description{
Convert Other Formats to SeuratObject.
}
\examples{
\dontrun{
# import data from SingleCellExperiment
seu.obj <- ImportSeurat(
  obj = sce.obj, from = "SCE", count.assay = "counts",
  data.assay = "logcounts", assay = "RNA"
)
# import data from CellDataSet
seu.obj <- ImportSeurat(obj = cds.obj, from = "CellDataSet", count.assay = "counts", assay = "RNA")
# import data from cell_data_set
seu.obj <- ImportSeurat(
  obj = sce.obj, from = "cell_data_set", count.assay = "counts",
  data.assay = "logcounts", assay = "RNA"
)
# import data from AnnData, need users to provide the file for conversion
seu.obj <- ImportSeurat(anndata.file = "path/to/h5ad", from = "AnnData", assay = "RNA")
# import data from loom, need users to provide the file for conversion
seu.obj <- ImportSeurat(loom.file = "path/to/loom", from = "loom")
}
}
