% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPS-ES-functions.R
\name{effect_size_ABk}
\alias{effect_size_ABk}
\title{Calculates HPS effect size}
\usage{
effect_size_ABk(
  outcome,
  treatment,
  id,
  phase,
  time,
  data = NULL,
  phi = NULL,
  rho = NULL
)
}
\arguments{
\item{outcome}{Vector of outcome data or name of variable within \code{data}. May not contain any missing values.}

\item{treatment}{Vector of treatment indicators or name of variable within \code{data}. Must be the same length as \code{outcome}.}

\item{id}{factor vector indicating unique cases or name of variable within \code{data}. Must be the same length as \code{outcome}.}

\item{phase}{factor vector indicating unique phases (each containing one contiguous control 
condition and one contiguous treatment condition) or name of variable within \code{data}. Must be the same length as \code{outcome}.}

\item{time}{vector of measurement occasion times or name of variable within \code{data}. Must be the same length as \code{outcome}.}

\item{data}{Optional dataset to use for analysis. Must be data.frame.}

\item{phi}{Optional value of the auto-correlation nuisance parameter, to be used 
in calculating the small-sample adjusted effect size}

\item{rho}{Optional value of the intra-class correlation nuisance parameter, to be used 
in calculating the small-sample adjusted effect size}
}
\value{
A list with the following components
\tabular{ll}{
\code{M_a} \tab Matrix reporting the total number of time points with data for all ids, 
by phase and treatment condition \cr
\code{M_dot} \tab Total number of time points used to calculate the total variance (the sum of \code{M_a}) \cr
\code{D_bar} \tab numerator of effect size estimate \cr
\code{S_sq} \tab sample variance, pooled across time points and treatment groups \cr
\code{delta_hat_unadj} \tab unadjusted effect size estimate \cr
\code{phi} \tab corrected estimate of first-order auto-correlation \cr
\code{sigma_sq_w} \tab corrected estimate of within-case variance \cr
\code{rho} \tab estimated intra-class correlation \cr
\code{theta} \tab estimated scalar constant \cr
\code{nu} \tab estimated degrees of freedom \cr
\code{delta_hat} \tab corrected effect size estimate \cr
\code{V_delta_hat} \tab estimated variance of the effect size
}
}
\description{
Calculates the HPS effect size estimator based on data from an (AB)^k design, 
as described in Hedges, Pustejovsky, & Shadish (2012). Note that the data must contain one row per 
measurement occasion per subject.
}
\note{
If phi or rho is left unspecified (or both), estimates for the nuisance
parameters will be calculated.
}
\examples{
data(Lambert)
effect_size_ABk(outcome = outcome, treatment = treatment, id = case, 
                phase = phase, time = time, data = Lambert)
   
data(Anglesea)
effect_size_ABk(outcome = outcome, treatment = condition, id = case, 
                phase = phase, time = session, data = Anglesea)

}
\references{
Hedges, L. V., Pustejovsky, J. E., & Shadish, W. R. (2012).
A standardized mean difference effect size for single case designs. 
\emph{Research Synthesis Methods, 3}, 224-239. doi:\href{http://doi.org/10.1002/jrsm.1052}{10.1002/jrsm.1052}
}
