% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{dwt.write}
\alias{dwt.write}
\title{Write a dwt file to disk. Writes DOS line endings. Dwells are in milliseconds}
\usage{
dwt.write(segments, file = "", seg = 1, append = FALSE)
}
\arguments{
\item{segments}{A segment or multiple segments with $dwells and $states}

\item{file}{Filename to write to}

\item{seg}{Segment number to write in .dwt header.}

\item{append}{Add ot the end of a file or overwrite? (defaults to false)}
}
\description{
Write a dwt file to disk. Writes DOS line endings. Dwells are in milliseconds
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)

dwt.write(dwells, file=file.path(tempdir(), "dwells.dwt"))

}
