% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{dwt.read}
\alias{dwt.read}
\title{Read a .dwt file.}
\usage{
dwt.read(filename, separating_factor = 1000)
}
\arguments{
\item{filename}{Filename to read from}

\item{separating_factor}{In lieu of a known time between segments, seperate with a multple of the longest dwell.}
}
\value{
A list of bursts (possibly a singleton)
}
\description{
Read a .dwt file. Result is a list of "segments", which is a dataframe extra data. See "segment" for more details. Converts millisecond dwells to seconds.
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)

dwt.write(dwells, file=file.path(tempdir(), "dwells.dwt"))

# Quit R, come back the next day
\dontrun{
dwells <- dwt.read("dwells.dwt")
}

}
