% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_lines_histogram.R
\name{scatter_lines_histogram}
\alias{scatter_lines_histogram}
\title{scatter_lines_histogram}
\usage{
scatter_lines_histogram(
  xy,
  xlim = c(min(xy[, c(1, 3)]), max(xy[, c(1, 3)])),
  ylim = c(min(xy[, c(2, 4)]), max(xy[, c(2, 4)])),
  out_size = c(512, 512),
  skip_start_pixel = FALSE,
  skip_end_pixel = TRUE
)
}
\arguments{
\item{xy}{4-column matrix with point coordinates. Format is
\verb{(x_begin, y_begin, x_end, y_end)}. As usual with
rasters in R, X axis grows right, and Y axis grows DOWN.
Flipping \code{ylim} causes the "usual" mathematical behavior.}

\item{xlim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{ylim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{out_size}{2-element vector size of the result raster,
defaults to \code{c(512,512)}.}

\item{skip_start_pixel}{TRUE if the start pixel of a line should not be plotted,
otherwise 'FALSE', defaults to \code{FALSE}.}

\item{skip_end_pixel}{TRUE if the end pixel of a line should not be plotted,
otherwise 'FALSE', defaults to \code{TRUE}.}
}
\value{
Histogram with the result.
}
\description{
Create histogram using lines with given start and end points.
}
