% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_negbin.R
\name{negbin_mcsim}
\alias{negbin_mcsim}
\title{Monte Carlo simulation of negative binomial score scan statistics.}
\usage{
negbin_mcsim(table, zones, n_mcsim, version = "ordinary")
}
\arguments{
\item{table}{A \code{data.table} with at least the columns \code{mu} and
\code{theta}. The parameter \eqn{\theta} (theta) is the same as 
\code{size} in \code{\link[stats]{rnbinom}}.}

\item{zones}{A \code{set} of zones, each zone itself being a \code{set}
containing locations. Locations should be encoded as integers.}

\item{n_mcsim}{A positive integer; the number of replicate scan 
statistics to generate.}

\item{version}{Either "ordinary" (default) or "increasing".}
}
\value{
A numeric vector of length \code{n_mcsim}.
}
\description{
This function generates \code{n_mcsim} negative binomial-distributed 
data sets according to the parameters in the input table, and calculates the 
value of the score scan statistic for each generated data set using the 
supplied \code{zones}. The score can be calculated either according to the 
ordinary cluster model or the increasing outbreak/event/anomaly model.
}
\keyword{internal}

