% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert}
\alias{convert}
\title{Convert}
\usage{
convert(
  scdf,
  file = "",
  study_name = "study",
  case_name = "case",
  inline = FALSE,
  indent = 2,
  silent = FALSE
)
}
\arguments{
\item{scdf}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{file}{A filename for exporting the syntax.}

\item{study_name}{Character string. Name of the study object.}

\item{case_name}{Character string. Name of the scdf objects.}

\item{inline}{If TRUE, phase definition is in an online version.}

\item{indent}{Integer. Indentation.}

\item{silent}{If TRUE, syntax is not printed to the console}
}
\value{
Returns a string (invisible).
}
\description{
Converts an scdf object into R code
}
\examples{
filename <- tempfile()
convert(exampleABC, file = filename)
source(filename)
all.equal(study, exampleABC)
unlink(filename)
}
\seealso{
Other io-functions: 
\code{\link{read_scdf}()},
\code{\link{write_scdf}()}
}
\concept{io-functions}
\keyword{io}
