\name{smooth.construct.mpd.smooth.spec}
%\Rdversion{1.0}
\alias{smooth.construct.mpd.smooth.spec}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Constructor for monotone decreasing P-splines in SCAMs
}
\description{This is a special method function
  for creating smooths subject to monotone decreasing constraints which is built by 
  the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}. 
  It is constructed using monotonic P-splines. This smooth is specified via model terms such as 
\code{s(x,k,bs="mpd",m=2)}, 
  where \code{k} denotes the basis dimension and \code{m+1} is the order of the B-spline basis.

}
\usage{
smooth.construct.mpd.smooth.spec(object, data, knots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the data required by this term,
     with names given by \code{object$term}. The \code{by} variable is the last element.}
 
  \item{knots}{An optional list containing the knots supplied for basis setup.  
          If it is \code{NULL} then the knot locations are generated automatically.}

}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{An object of class \code{"mpd.smooth"}. 
}
\references{
Pya, N. (2010) \emph{Additive models with shape constraints}. PhD thesis. University of Bath. Department of Mathematical Sciences

}
\author{ 
   Natalya Pya <nat.pya@gmail.com>

}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{smooth.construct.mpi.smooth.spec}}, \code{\link{smooth.construct.mdcv.smooth.spec}}, 
\code{\link{smooth.construct.mdcx.smooth.spec}}, \code{\link{smooth.construct.micv.smooth.spec}}, 
\code{\link{smooth.construct.micx.smooth.spec}}

}
\examples{
  \dontrun{
## Monotone decreasing P-splines example 
  ## simulating data...
   set.seed(3)
   n <- 100
   x <- runif(n)*3-1
   f <- exp(-1.3*x)
   y <- rpois(n,exp(f))
   dat <- data.frame(x=x,y=y)
 ## fit model ...
   b <- scam(y~s(x,k=15,bs="mpd",m=2),family=poisson(link="log"),
       data=dat,sp=NULL)

# UNCONSTRAINED FIT *****************
   b1 <- scam(y~s(x,k=15,bs="ps",m=2),family=poisson(link="log"),
         data=dat,sp=NULL)

## plot results ...
   plot(x,y,xlab="x",ylab="y")
   x1 <- sort(x,index=TRUE)
   lines(x1$x,exp(f)[x1$ix])      ## the true function
   lines(x1$x,b$fitted.values[x1$ix],col=2)  ## monotone fit 
   lines(x1$x,b1$fitted.values[x1$ix],col=3) ## unconstrained fit 
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models} \keyword{regression}%-- one or more ..





