% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotVideoVariance}
\alias{plotVideoVariance}
\title{Plot a summary of the fluorescence in the video.}
\usage{
plotVideoVariance(
  scalpelOutput,
  neuronSet = "",
  videoType = "processed",
  neuronsToOutline = "all",
  shrinkLargest = FALSE,
  shrinkQuantile = 0.95,
  title = "",
  Y = NULL
)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep0}}, \code{\link{scalpelStep1}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{This argument is ignored unless the class of \code{scalpelOutput} is \code{scalpel} or \code{scalpelStep3}, and \code{neuronsToOutline} is not \code{"none"}. It gives which set of neurons should be plotted:
use \code{"A"} for those resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A}, or use \code{"Afilter"} for those resulting from
\code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}.}

\item{videoType}{Specify whether to plot the processed data from Step 0 (default; \code{videoType="processed"}) or raw data (\code{videoType="raw"}).
This is ignored if \code{Y} is provided.}

\item{neuronsToOutline}{Specify whether to plot outlines of all neurons (default; \code{neuronsToOutline="all"}),
none of the neurons (\code{neuronsToOutline="none"}), or outlines of only the neurons kept
using a previous call to \code{\link{reviewNeurons}} or \code{\link{reviewNeuronsInteractive}} (\code{neuronsToOutline="kept"}).
If \code{scalpelOutput} is not of the class \code{scalpel}, \code{scalpelStep2}, or \code{scalpelStep3}, this argument is ignored.}

\item{shrinkLargest}{Logical value indicating whether the values above \code{shrinkQuantile} should be shrunk when plotting. Shrinking these values
allows us to better visualize the areas with the highest variance fluorescence.}

\item{shrinkQuantile}{The quantile value above which pixel values will be shrunk. By default, this is the 95th quantile.}

\item{title}{Label for the title.}

\item{Y}{An object of class \code{scalpelY}, which results from running the \code{\link{getY}} function. When not specified, \code{Y}
is automatically read in, but specifying \code{Y} is recommended when the user
would like to call this function many times, as this avoids reading the video into memory repeatedly.}
}
\value{
None
}
\description{
We plot a heat map of the variance of each pixel across the frames.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#simplest example with default parameters:
plotVideoVariance(scalpelOutput = scalpelOutput, neuronSet = "Afilter")

#example with optional parameters:
#previous showed summary of processed data,
#can instead show raw data, not outline the neurons found, and add a title
plotVideoVariance(scalpelOutput = scalpelOutput, videoType = "raw",
                 neuronsToOutline = "none", title = "Raw Data")

#if you have video data read in already using 'getY' function, you can provide it
rawY = getY(scalpelOutput = scalpelOutput, videoType = "raw")
plotVideoVariance(scalpelOutput = scalpelOutput, neuronSet = "Afilter", Y = rawY)
}
}
\seealso{
\code{\link{scalpelStep0}}, \code{\link{scalpel}}
}
