% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.r
\name{trans_new}
\alias{trans_new}
\alias{trans}
\alias{is.trans}
\title{Create a new transformation object.}
\usage{
trans_new(name, transform, inverse, breaks = extended_breaks(),
  minor_breaks = regular_minor_breaks(), format = format_format(),
  domain = c(-Inf, Inf))
}
\arguments{
\item{name}{transformation name}

\item{transform}{function, or name of function, that performs the
transformation}

\item{inverse}{function, or name of function, that performs the
inverse of the transformation}

\item{breaks}{default breaks function for this transformation. The breaks
function is applied to the raw data.}

\item{minor_breaks}{default minor breaks function for this transformation.}

\item{format}{default format for this transformation. The format is applied
to breaks generated to the raw data.}

\item{domain}{domain, as numeric vector of length 2, over which
transformation is valued}
}
\description{
A transformation encapsulates a transformation and its inverse, as well
as the information needed to create pleasing breaks and labels. The breaks
function is applied on the transformed range of the range, and it's
expected that the labels function will perform some kind of inverse
transformation on these breaks to give them labels that are meaningful on
the original scale.
}
\seealso{
\Sexpr[results=rd,stage=build]{scales:::seealso_trans()}
}
