% Generated by roxygen2 (4.0.0): do not edit by hand
\name{cscale}
\alias{cscale}
\title{Continuous scale.}
\usage{
cscale(x, palette, na.value = NA_real_, trans = identity_trans())
}
\arguments{
\item{x}{vector of continuous values to scale}

\item{palette}{palette to use.

  Built in palettes:
  \Sexpr[results=rd,stage=build]{scales:::seealso_pal()}}

\item{na.value}{value to use for missing values}

\item{trans}{transformation object describing the how to transform the
 raw data prior to scaling.  Defaults to the identity transformation which
 leaves the data unchanged.

 Built in transformations:
 \Sexpr[results=rd,stage=build]{scales:::seealso_trans()}.}
}
\description{
Continuous scale.
}
\examples{
with(mtcars, plot(disp, mpg, cex = cscale(hp, rescale_pal())))
with(mtcars, plot(disp, mpg, cex = cscale(hp, rescale_pal(),
  trans = sqrt_trans())))
with(mtcars, plot(disp, mpg, cex = cscale(hp, area_pal())))
with(mtcars, plot(disp, mpg, pch = 20, cex = 5,
  col = cscale(hp, seq_gradient_pal("grey80", "black"))))
}

