% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creating_spatial_processes.R
\name{GenerateSpatialPattern}
\alias{GenerateSpatialPattern}
\title{Generate Spatial Point Pattern}
\usage{
GenerateSpatialPattern(
  sim_object,
  lambda = 25,
  ...,
  overwrite = FALSE,
  gridded = FALSE,
  grid_shift = 0.5
)
}
\arguments{
\item{sim_object}{A 'SpatSimObj' containing a window.}

\item{lambda}{The intensity of the point pattern Default is 25.}

\item{...}{Additional arguments passed to 'rpoispp'.}

\item{overwrite}{boolean indicating whether or not to replace point patterns if they exist in object}

\item{gridded}{boolean value to whether or not simulate the point pattern in a grid. See details for more.}

\item{grid_shift}{the amount to move alternative columns down when gridded; between -0.5 and 0.5}
}
\value{
The updated 'sim_object' with a simulated point process added to the 'Processes' slot.
}
\description{
Generate a spatial point pattern within the simulation object's window using a Poisson point process.
}
\details{
This function generates a spatial point process within the window of the 'sim_object'
using a Poisson point pattern with intensity 'lambda'. The simulated point pattern is added
to the 'Patterns' slot of the 'sim_object'. Additional arguments can be passed to the 'rpoispp' function.

The \code{gridded} parameter is used for simulating point patterns that would represent som spatial transcriptomic
technologies such as visium, where rather than like cell being randomly distributed in a sample, the spots where
data is measured is evenly spaced.
}
\examples{
sim_object <- CreateSimulationObject()
sim_object <- GenerateSpatialPattern(sim_object, lambda = 30)
}
