% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_simObject.R
\name{CreateSimulationObject}
\alias{CreateSimulationObject}
\title{Create a spatial simulation object.}
\usage{
CreateSimulationObject(window = NULL, sims = NULL, cell_types = 1)
}
\arguments{
\item{window}{An object of class \code{owin} representing the simulation
window. If \code{NULL}, defaults to a rectangular window of size (0,10)
in both x and y directions.}

\item{sims}{The number of simulations to perform. If \code{NULL} or l
ess than 1, defaults to 3.}

\item{cell_types}{The number of cell types. Defaults to 1.}
}
\value{
A \code{SpatSimObj} containing the simulation
window, the number of simulations to perform, and lists of cells,
Tissue1/Tissue2, holes, and spatial files.
}
\description{
This function creates a \code{SpatSimObj} for
spatial simulations. The object contains information about the
simulation window, the number of simulations to perform, and
lists of cells, Tissue1/Tissue2, holes, and spatial files.
}
\details{
The simulation window is represented by an object of class
\code{owin}, which specifies the extent and shape of the spatial
domain in which the simulations will be performed. If no window
is provided, the function creates a rectangular window of size
(0,10) in both x and y directions.

The \code{sims} argument specifies the number of simulations to
perform. If it is set to \code{NULL} or less than 1, the function
defaults to 3.

The \code{cell_types} argument specifies the number of cell
types to include in the simulation. By default, the function
creates a single cell type, represented by an object of class
\code{Cell}.

The \code{SpatSimObj} is composed of the following classes:

\itemize{
\item A \code{Window} object of class \code{owin}.
\item An integer \code{Sims} specifying the number of simulations to perform.
\item A list of \code{Cells} of class \code{Cell}.
\item A \code{Tissue} object of class \code{Tissue1/Tissue2}, representing the Tissue1/Tissue2 components of the simulation.
\item A \code{Holes} object of class \code{Holes}, representing holes in the simulation.
\item A list of \code{Spatial Files} containing any spatial data associated with the simulation.
}
}
\examples{
CreateSimulationObject()
}
