% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sclink_norm}
\alias{sclink_norm}
\title{Pre-process data for scLink}
\usage{
sclink_norm(
  count,
  scale.factor = 1e+06,
  filter.genes = FALSE,
  gene.names = NULL,
  n = 500
)
}
\arguments{
\item{count}{A full gene count matrix with rows representing cells and columns representing genes.
Gene names are given as column names.}

\item{scale.factor}{A number specifying the sclae factor used for library size normalization.
Defaults to 1e6.}

\item{filter.genes}{A Boolean specifying whether scLink should select genes based on mean expression.
When set to \code{FALSE}, users need to speicfy a set of genes to be used for network construction with
\code{gene.names}. When set to \code{TRUE}, scLink will select genes based on their mean expression,
and users need to specify the number of genes to be selected with \code{n}.}

\item{gene.names}{A character vector specifying the genes used for network construction.
Only needed when \code{filter.genes = FALSE}.}

\item{n}{An integer specifying the number of genes to be selected by scLink (defaults to 500).
Only needed when \code{filter.genes = TRUE}.}
}
\value{
A transformed and normalized gene expression matrix that can be used for correlation calculation
and network construction.
}
\description{
Pre-process data for scLink
}
\examples{
\donttest{
count = readRDS(system.file("extdata", "example.rds", package = "scLink"))
count.norm = sclink_norm(count, scale.factor = 1e6, filter.genes = TRUE, n = 500)
}
}
\author{
Wei Vivian Li, \email{vivian.li@rutgers.edu}
}
