% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_tucker_ica.R
\name{run_tucker_ica}
\alias{run_tucker_ica}
\title{Run the Tucker decomposition and rotate the factors}
\usage{
run_tucker_ica(
  container,
  ranks,
  tucker_type = "regular",
  rotation_type = "hybrid",
  sparsity = sqrt(2)
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{ranks}{numeric The number of donor factors and gene factors, respectively,
to decompose the data into. Since we rearrange the standard output of
the Tucker decomposition to be 'donor centric', the number of donor factors will
also be the total number of main factors that can be used for downstream analysis.
The number of gene factors will only impact the quality of the decomposition.}

\item{tucker_type}{character Set to 'regular' to run regular tucker or to 'sparse' to run tucker
with sparsity constraints. The 'sparse' method is still under development, so we recommend
using 'regular'. (default='regular')}

\item{rotation_type}{character Set to 'hybrid' to optimize loadings via our hybrid
method (see paper for details). Set to 'ica_dsc' to perform ICA rotation
on resulting donor factor matrix. Set to 'ica_lds' to optimize loadings by the
ICA rotation. (default='hybrid')}

\item{sparsity}{numeric To use with sparse tucker. Higher indicates more sparse (default=sqrt(2))}
}
\value{
The project container with results of the decomposition in container$tucker_results.
The results object is a list with the donor scores matrix in the first element and the unfolded
loadings matrix in the second element.
}
\description{
Run the Tucker decomposition and rotate the factors
}
\examples{
test_container <- run_tucker_ica(test_container,ranks=c(2,4))
}
