% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_LR_interact.R
\name{compute_LR_interact}
\alias{compute_LR_interact}
\title{Compute and plot the LR interactions for one factor}
\usage{
compute_LR_interact(
  container,
  lr_pairs,
  sig_thresh = 0.05,
  percentile_exp_rec = 0.75,
  add_ld_fact_sig = TRUE,
  ncores = container$experiment_params$ncores
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{lr_pairs}{data.frame Data of ligand-receptor pairs. First column should
be ligands and second column should be one or more receptors separated by an
underscore such as receptor1_receptor2 in the case that multiple receptors are
required for signaling.}

\item{sig_thresh}{numeric The p-value significance threshold to use for module-
factor associations and ligand-factor associations (default=0.05)}

\item{percentile_exp_rec}{numeric The percentile above which the top donors expressing the
ligand all must be expressing the receptor (default=0.75)}

\item{add_ld_fact_sig}{logical Set to TRUE to append a heatmap showing significance
of associations between each ligand hit and each factor (default=TRUE)}

\item{ncores}{numeric The number of cores to use (default=container$experiment_params$ncores)}
}
\value{
The LR analysis results heatmap as ComplexHeatmap object. Adjusted p-values
for all results are placed in container$lr_res.
}
\description{
Compute and plot the LR interactions for one factor
}
