% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{subset,Satellite-method}
\alias{subset,Satellite-method}
\alias{[[,Satellite,ANY,ANY-method}
\title{Subset of Satellite object data layers}
\usage{
\S4method{subset}{Satellite}(x, sid, cid)

\S4method{[[}{Satellite,ANY,ANY}(x, i)
}
\arguments{
\item{x}{Satellite object providing the source band(s) to be adjusted.}

\item{sid}{Band numbers or bcde which should be extracted}

\item{cid}{Calibration information used for subsetting (only works if sid is
not supplied to the function)}

\item{i}{Layer index(es) for subsetting.}
}
\value{
A Satellite object

A Satellite object

A Satellite object
}
\description{
Create a subset of data layers from a \code{Satellite} object and return it 
as a standalone \code{Satellite} object.
}
\examples{
## sample data
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

sat[[2:5]]
subset(sat, cid = "SC")
}
