% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.estimate.r
\name{graph.estimate}
\alias{graph.estimate}
\title{Plots probability of a guilty verdict with confidence interval based on juror-level statistics}
\usage{
graph.estimate(
  sample_pg,
  sample_n,
  jury_n = 12,
  pstrikes = 0,
  dstrikes = 0,
  accuracy = 0.15
)
}
\arguments{
\item{sample_pg}{The proportion of jurors who favor a guilty verdict in the sample condition}

\item{sample_n}{The size of the sample used to estimate sample_pg_actual}

\item{jury_n}{Size of the jury (i.e. 6, 8, or 12); default value is 12.}

\item{pstrikes}{Number of peremptory strikes by prosecution; default value is 0.}

\item{dstrikes}{Number of peremptory strikes by defendant; default value is 0.}

\item{accuracy}{Accuracy of parties' peremptory strikes; a number between 0 and 1; default value is .15.}
}
\value{
No return (creates plot)
}
\description{
Plots probability of guilty verdict with confidence interval based on juror-level
             statistics supplied by user. Similar to graph.effect.defendant, but plots one condition.
}
\examples{
   library(sate)
   graph.estimate(sample_pg=.70, sample_n=400)

   graph.estimate(sample_pg=.75, sample_n=450, jury_n=6, pstrikes=3, dstrikes=3)
}
