% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.with.strikes.r
\name{select.with.strikes}
\alias{select.with.strikes}
\title{Generates the distribution of initial votes for guilty verdict on juries}
\usage{
select.with.strikes(
  p_g,
  jury_n = 12,
  pstrikes = 0,
  dstrikes = 0,
  accuracy = 0.15
)
}
\arguments{
\item{p_g}{The proportion of jurors in the jury pool who favor a guilty verdict}

\item{jury_n}{Size of the jury (i.e. 6, 8, or 12); default value is 12.}

\item{pstrikes}{Number of peremptory strikes by prosecution; default value is 0.}

\item{dstrikes}{Number of peremptory strikes by defendant; default value is 0.}

\item{accuracy}{Accuracy of parties' peremptory strikes; a number between 0 and 1; default value is .15.}
}
\value{
A vector of probabilities for 0:jury_n initial guilty votes
}
\description{
Calculates and returns probability distribution of initial votes for guilty verdict
             from 0:jury_n with options for peremptory strikes and strike accuracy
}
\examples{
   library(sate)
   select.with.strikes(p_g=.70, jury_n=6)

   select.with.strikes(p_g=.75, jury_n=12, pstrikes=6, dstrikes=10)

}
