% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{diurnal_centroid}
\alias{diurnal_centroid}
\title{Diurnal centroid calculation}
\usage{
diurnal_centroid(variable)
}
\arguments{
\item{variable}{A numeric vector containing the sapflow values for a day at a
regular intervals. Missing values are allowed but not recommended}
}
\value{
A numeric value with the diurnal centroid value (0 to 24 h)
}
\description{
Calculate the diurnal centroid for sapflow variables
}
\details{
The code for this function has been kindly provided by Jacob Nelson in python
(see https://github.com/jnelson18/FluxnetTools/blob/master/FileS3.py) and has
been translated to a tidy data phylosophy in R to be used inside a
\code{\link[dplyr]{summarise}} statement.
}
\section{Diurnal centroid algorithm}{

Given a continuous subdaily sapflow values at regular intervals
\eqn{V = {x_1, ..., x_n}} to obtain the diurnal centroid each value is
multiplied by its interval index and summed up and divided
by the sum of the values for the day and finally the value is normalized to
24h:

\deqn{
\sum {x_1 * 1, x_2 * 2, ... , x_n * n} / \sum {x_1, x_2, ... , x_n} * (24/n)
}

With even values for all the intervals (i.e. 100 for all), centroid converges
to 12h at more than 1000 intervals per day. With only 48 (half hourly
measurements) centroid converges to 12.25h and with 24 intervals (hourly
measurements) centroid converges to 12.5h. So, using diurnal centroid value
in half hourly datasets or above can have a considerable error associated.
}

\examples{
# dplyr
library(dplyr)

# check convergence to 12h:
diurnal_centroid(rep(1, 1000)) # 12.012 h
diurnal_centroid(rep(10000, 1000)) # 12.012 h, variable scale not affects calculation

# sapflow diurnal centroid
data('ARG_TRE', package = 'sapfluxnetr')

sfn_metrics(
  ARG_TRE,
  period = '1 day',
  .funs = list(~ diurnal_centroid(.),
               ~ data_coverage(., timestep, period_minutes)),
  solar = FALSE,
  interval = 'general'
)

}
\author{
Jacob Nelson & Víctor Granda
}
