% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss4pH.R
\name{ss4pH}
\alias{ss4pH}
\title{The required sample size for testing a null hyphotesis for a single proportion}
\usage{
ss4pH(N, p, p0, DEFF = 1, conf = 0.95, power = 0.8, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{p}{The value of the estimated proportion.}

\item{p0}{The value to test for the single proportion.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{power}{The statistical power. By default \code{power = 0.80}.}

\item{plot}{Optionally plot the effect against the sample size.}
}
\description{
This function returns the minimum sample size required for testing a null hyphotesis regarding a single proportion.
}
\details{
We assume that it is of interest to test the following set of hyphotesis:
\deqn{H_0: P - P_0 = 0 \ \ \ \ vs. \ \ \ \ H_a: P - P_0 = D \neq 0 }
Note that the minimun sample size, restricted to the predefined power \eqn{\beta} and confidence \eqn{1-\alpha}, is defined by: 
\deqn{n = \frac{S^2}{\frac{D^2}{(z_{1-\alpha} + z_{\beta})^2}+\frac{S^2}{N}}}
Where \deqn{S^2=p(1-p)DEFF}
}
\examples{
ss4pH(N = 10000, p = 0.5, p0 = 0.55)
ss4pH(N = 10000, p = 0.5, p0 = 0.55, plot=TRUE)
ss4pH(N = 10000, p = 0.5, p0 = 0.55, DEFF = 2, plot=TRUE)
ss4pH(N = 10000, p = 0.5, p0 = 0.55, conf = 0.99, power = 0.9, DEFF = 2, plot=TRUE)

#############################
# Example with BigLucy data #
#############################
data(BigLucy)
attach(BigLucy)

N <- nrow(BigLucy)
p <- prop.table(table(SPAM))[1]

# The minimum sample size for testing 
# H_0: P - P_0 = 0   vs.   H_a: P - P_0 = D = 0.1
D = 0.1 
p0 = p - D 
ss4pH(N, p, p0, conf = 0.99, power = 0.9, DEFF = 2, plot=TRUE)

# The minimum sample size for testing 
# H_0: P - P_0 = 0   vs.   H_a: P - P_0 = D = 0.02
D = 0.02
p0 = p - D 
ss4pH(N, p, p0, conf = 0.99, power = 0.9, DEFF = 3.45, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{e4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
