% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e4ddm.R
\name{e4ddm}
\alias{e4ddm}
\title{Statistical errors for the estimation of a double difference of means}
\usage{
e4ddm(N, n, mu1, mu2, mu3, mu4, sigma1, sigma2, sigma3, sigma4, DEFF = 1,
  conf = 0.95, T = 0, R = 1, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{mu1}{The value of the estimated mean of the variable of interes for the first population.}

\item{mu2}{The value of the estimated mean of the variable of interes for the second population.}

\item{mu3}{The value of the estimated mean of the variable of interes for the third population.}

\item{mu4}{The value of the estimated mean of the variable of interes for the fourth population.}

\item{sigma1}{The value of the estimated variance of the variable of interes for the first population.}

\item{sigma2}{The value of the estimated mean of a variable of interes for the second population.}

\item{sigma3}{The value of the estimated variance of the variable of interes for the third population.}

\item{sigma4}{The value of the estimated mean of a variable of interes for the fourth population.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{T}{The overlap between waves. By default \code{T = 0}.}

\item{R}{The correlation between waves. By default \code{R = 1}.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\value{
The coefficient of variation and the margin of error for a predefined sample size.
}
\description{
This function computes the cofficient of variation and the standard error when estimating a double difference of means under a complex sample design.
}
\details{
We note that the coefficent of variation is defined as: \deqn{cve = \frac{\sqrt{Var((\bar{y}_1 - \bar{y}_2)-(\bar{y}_1 - \bar{y}_2))}}{(\bar{y}_1 - \bar{y}_2)-(\bar{y}_3 - \bar{y}_4)}} 
Also, note that the magin of error is defined as: \deqn{\varepsilon = z_{1-\frac{\alpha}{2}}\sqrt{Var((\bar{y}_1 - \bar{y}_2)-(\bar{y}_3 - \bar{y}_4))}}
}
\examples{
e4ddm(N=10000, n=400, mu1=50, mu2=55, mu3=50, mu4=65, 
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12)
e4ddm(N=10000, n=400, mu1=50, mu2=55, mu3=50, mu4=65, 
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, plot=TRUE)
e4ddm(N=10000, n=400, mu1=50, mu2=55, mu3=50, mu4=65, 
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, DEFF=3.45, conf=0.99, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
