% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_equalizer_Function.R
\name{dataequalizer}
\alias{dataequalizer}
\title{Equalize dataframes}
\usage{
dataequalizer(target_df, source_df, variables = NULL, silence = FALSE)
}
\arguments{
\item{target_df}{A data frame}

\item{source_df}{A data frame containing some column-names named equally in target_df}

\item{variables}{A vector to indicate variable names that should be in the copy of the source_df
if they are also in the target_df.}

\item{silence}{A logic value. If FALSE, warnings will be returned indicating, what variables where removed,
from the survey.}
}
\value{
Returns a copy of source_df containing only variables with names contained
also in the target_df data frame.
}
\description{
\code{dataequalizer} compares two data frames and looks if both data frames contain columns
with the same Name. A copy of source_df is returned, containing only columns named identical
in target_df and source_df data frames. The function is mainly used in the other functions of the package.
}
\examples{
## Get Data to equalize 
card<-wooldridge::card

##reduce data frame
card2<-card[c("id","age","educ","fatheduc","motheduc","IQ","wage")]

card_equalized<-sampcompR::dataequalizer(card2,card,variables=c("age","educ","IQ","wage"))
card_equalized[1:20,]

}
