% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.salso.summary.R
\name{plot.salso.summary}
\alias{plot.salso.summary}
\title{Heatmap, Multidimensional Scaling, Pairs, and Dendrogram Plotting for
Partition Estimation}
\usage{
\method{plot}{salso.summary}(
  x,
  type = c("heatmap", "mds", "pairs", "dendrogram")[1],
  data = NULL,
  showLabels = TRUE,
  showIDs = length(x$estimate) <= 50,
  cexAdjustment = 0.7,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{summary(y)}, where \code{y} itself is
returned by the \code{\link{salso}} function.}

\item{type}{A string equal to \code{"heatmap"}, \code{"mds"}, \code{"pairs"},
or \code{"dendrogram"}.}

\item{data}{The data from which the partition estimation was obtained. This
is required when \code{type='pairs'} and ignored otherwise.}

\item{showLabels}{Should the cluster labels be shown in the plot when
\code{type="heatmap"}?}

\item{showIDs}{Should the ID of the items be shown in the plot?}

\item{cexAdjustment}{Scalar multiplier for adjust text size.}

\item{...}{Arguments to be passed to methods, such as graphical parameters
(see \code{\link{par}}).}
}
\value{
\code{NULL}, invisibly.
}
\description{
This function produces one of four plots:  1. \code{"heatmap"}: A heatmap
showing the pairwise allocation probabilities that items are clustered. 2.
\code{"mds"}: A scatter plot using classical multidimensional scaling (also
known as principal coordinates analysis) with the exemplar (i.e., the most
representative observation) of each cluster emphasized. 3. \code{"pairs"}:
Pairs plots of all the variables with the exemplar (i.e., the most
representative observation) of each cluster emphasized. 4.
\code{"dendrogram"}: A dendrogram based on expected partition loss showing
the relationships among clusters when merging pairs of clusters such that the
increase in the expectation of the posterior loss is minimized.
}
\examples{
# For examples, use 'nCores=1' per CRAN rules, but in practice omit this.
data(iris.clusterings)
draws <- iris.clusterings
est <- salso(draws, nCores=1)
summ <- summary(est)
plot(summ, type="heatmap")
plot(summ, type="mds")
plot(summ, type="pairs", data=iris)
plot(summ, type="dendrogram")

}
\seealso{
\code{\link{salso}}, \code{\link{summary.salso.estimate}},
\code{\link[stats]{cmdscale}}.
}
