% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-metadata.R
\name{metadata_type_validator}
\alias{metadata_type_validator}
\title{Metadata Data Type Validator}
\usage{
metadata_type_validator(obj_type, obj_data)
}
\arguments{
\item{obj_type}{a string from one of the object types described above}

\item{obj_data}{a \code{list} of \code{lists} or a \code{data.frame} with the required inputs to create the
the obj_type specified.}
}
\value{
a \code{list} that can be used as input to one of the CRUD Metadata API
operations: \link{sf_create_metadata}, \link{sf_update_metadata}, \link{sf_update_metadata}
}
\description{
A function to create a variety of objects that are part of the Metadata API service
Below is a list of objects and their required components to be created with this function:
}
\details{
\strong{AccessMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_accessmapping.htm}{Salesforce Documentation for AccessMapping}
\describe{
 \item{accessLevel}{a character}
 \item{object}{a character}
 \item{objectField}{a character}
 \item{userField}{a character}
}

\strong{AccountSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_accountsettings.htm}{Salesforce Documentation for AccountSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableAccountOwnerReport}{a character either 'true' or 'false'}
 \item{enableAccountTeams}{a character either 'true' or 'false'}
 \item{showViewHierarchyLink}{a character either 'true' or 'false'}
}

\strong{AccountSharingRuleSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_accountsharingrulesettings.htm}{Salesforce Documentation for AccountSharingRuleSettings}
\describe{
 \item{caseAccessLevel}{a character}
 \item{contactAccessLevel}{a character}
 \item{opportunityAccessLevel}{a character}
}

\strong{ActionLinkGroupTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_actionlinkgrouptemplate.htm}{Salesforce Documentation for ActionLinkGroupTemplate}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionLinkTemplates}{a ActionLinkTemplate}
 \item{category}{a PlatformActionGroupCategory - which is a character taking one of the following values: 
   \itemize{
     \item{Primary}
     \item{Overflow}
   }
  }
 \item{executionsAllowed}{a ActionLinkExecutionsAllowed - which is a character taking one of the following values: 
   \itemize{
     \item{Once}
     \item{OncePerUser}
     \item{Unlimited}
   }
  }
 \item{hoursUntilExpiration}{a integer}
 \item{isPublished}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{ActionLinkTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_actionlinktemplate.htm}{Salesforce Documentation for ActionLinkTemplate}
\describe{
 \item{actionUrl}{a character}
 \item{headers}{a character}
 \item{isConfirmationRequired}{a character either 'true' or 'false'}
 \item{isGroupDefault}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{labelKey}{a character}
 \item{linkType}{a ActionLinkType - which is a character taking one of the following values: 
   \itemize{
     \item{API}
     \item{APIAsync}
     \item{Download}
     \item{UI}
   }
  }
 \item{method}{a ActionLinkHttpMethod - which is a character taking one of the following values: 
   \itemize{
     \item{HttpDelete}
     \item{HttpHead}
     \item{HttpGet}
     \item{HttpPatch}
     \item{HttpPost}
     \item{HttpPut}
   }
  }
 \item{position}{a integer}
 \item{requestBody}{a character}
 \item{userAlias}{a character}
 \item{userVisibility}{a ActionLinkUserVisibility - which is a character taking one of the following values: 
   \itemize{
     \item{Creator}
     \item{Everyone}
     \item{EveryoneButCreator}
     \item{Manager}
     \item{CustomUser}
     \item{CustomExcludedUser}
   }
  }
}

\strong{ActionOverride}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_actionoverride.htm}{Salesforce Documentation for ActionOverride}
\describe{
 \item{actionName}{a character}
 \item{comment}{a character}
 \item{content}{a character}
 \item{formFactor}{a FormFactor - which is a character taking one of the following values: 
   \itemize{
     \item{Small}
     \item{Medium}
     \item{Large}
   }
  }
 \item{skipRecordTypeSelect}{a character either 'true' or 'false'}
 \item{type}{a ActionOverrideType - which is a character taking one of the following values: 
   \itemize{
     \item{Default}
     \item{Standard}
     \item{Scontrol}
     \item{Visualforce}
     \item{Flexipage}
     \item{LightningComponent}
   }
  }
}

\strong{ActivitiesSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_activitiessettings.htm}{Salesforce Documentation for ActivitiesSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{allowUsersToRelateMultipleContactsToTasksAndEvents}{a character either 'true' or 'false'}
 \item{autoRelateEventAttendees}{a character either 'true' or 'false'}
 \item{enableActivityReminders}{a character either 'true' or 'false'}
 \item{enableClickCreateEvents}{a character either 'true' or 'false'}
 \item{enableDragAndDropScheduling}{a character either 'true' or 'false'}
 \item{enableEmailTracking}{a character either 'true' or 'false'}
 \item{enableGroupTasks}{a character either 'true' or 'false'}
 \item{enableListViewScheduling}{a character either 'true' or 'false'}
 \item{enableLogNote}{a character either 'true' or 'false'}
 \item{enableMultidayEvents}{a character either 'true' or 'false'}
 \item{enableRecurringEvents}{a character either 'true' or 'false'}
 \item{enableRecurringTasks}{a character either 'true' or 'false'}
 \item{enableSidebarCalendarShortcut}{a character either 'true' or 'false'}
 \item{enableSimpleTaskCreateUI}{a character either 'true' or 'false'}
 \item{enableUNSTaskDelegatedToNotifications}{a character either 'true' or 'false'}
 \item{meetingRequestsLogo}{a character}
 \item{showCustomLogoMeetingRequests}{a character either 'true' or 'false'}
 \item{showEventDetailsMultiUserCalendar}{a character either 'true' or 'false'}
 \item{showHomePageHoverLinksForEvents}{a character either 'true' or 'false'}
 \item{showMyTasksHoverLinks}{a character either 'true' or 'false'}
}

\strong{AddressSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_addresssettings.htm}{Salesforce Documentation for AddressSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{countriesAndStates}{a CountriesAndStates}
}

\strong{AdjustmentsSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_adjustmentssettings.htm}{Salesforce Documentation for AdjustmentsSettings}
\describe{
 \item{enableAdjustments}{a character either 'true' or 'false'}
 \item{enableOwnerAdjustments}{a character either 'true' or 'false'}
}

\strong{AgentConfigAssignments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_agentconfigassignments.htm}{Salesforce Documentation for AgentConfigAssignments}
\describe{
 \item{profiles}{a AgentConfigProfileAssignments}
 \item{users}{a AgentConfigUserAssignments}
}

\strong{AgentConfigButtons}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_agentconfigbuttons.htm}{Salesforce Documentation for AgentConfigButtons}
\describe{
 \item{button}{a character}
}

\strong{AgentConfigProfileAssignments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_agentconfigprofileassignments.htm}{Salesforce Documentation for AgentConfigProfileAssignments}
\describe{
 \item{profile}{a character}
}

\strong{AgentConfigSkills}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_agentconfigskills.htm}{Salesforce Documentation for AgentConfigSkills}
\describe{
 \item{skill}{a character}
}

\strong{AgentConfigUserAssignments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_agentconfiguserassignments.htm}{Salesforce Documentation for AgentConfigUserAssignments}
\describe{
 \item{user}{a character}
}

\strong{AnalyticsCloudComponentLayoutItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_analyticscloudcomponentlayoutitem.htm}{Salesforce Documentation for AnalyticsCloudComponentLayoutItem}
\describe{
 \item{assetType}{a character}
 \item{devName}{a character}
 \item{error}{a character}
 \item{filter}{a character}
 \item{height}{a integer}
 \item{hideOnError}{a character either 'true' or 'false'}
 \item{showHeader}{a character either 'true' or 'false'}
 \item{showSharing}{a character either 'true' or 'false'}
 \item{showTitle}{a character either 'true' or 'false'}
 \item{width}{a character}
}

\strong{AnalyticSnapshot}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_analyticsnapshot.htm}{Salesforce Documentation for AnalyticSnapshot}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{groupColumn}{a character}
 \item{mappings}{a AnalyticSnapshotMapping}
 \item{name}{a character}
 \item{runningUser}{a character}
 \item{sourceReport}{a character}
 \item{targetObject}{a character}
}

\strong{AnalyticSnapshotMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_analyticsnapshotmapping.htm}{Salesforce Documentation for AnalyticSnapshotMapping}
\describe{
 \item{aggregateType}{a ReportSummaryType - which is a character taking one of the following values: 
   \itemize{
     \item{Sum}
     \item{Average}
     \item{Maximum}
     \item{Minimum}
     \item{None}
   }
  }
 \item{sourceField}{a character}
 \item{sourceType}{a ReportJobSourceTypes - which is a character taking one of the following values: 
   \itemize{
     \item{tabular}
     \item{summary}
     \item{snapshot}
   }
  }
 \item{targetField}{a character}
}

\strong{ApexClass}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_apexclass.htm}{Salesforce Documentation for ApexClass}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{apiVersion}{a numeric}
 \item{packageVersions}{a PackageVersion}
 \item{status}{a ApexCodeUnitStatus - which is a character taking one of the following values: 
   \itemize{
     \item{Inactive}
     \item{Active}
     \item{Deleted}
   }
  }
}

\strong{ApexComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_apexcomponent.htm}{Salesforce Documentation for ApexComponent}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{apiVersion}{a numeric}
 \item{description}{a character}
 \item{label}{a character}
 \item{packageVersions}{a PackageVersion}
}

\strong{ApexPage}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_apexpage.htm}{Salesforce Documentation for ApexPage}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{apiVersion}{a numeric}
 \item{availableInTouch}{a character either 'true' or 'false'}
 \item{confirmationTokenRequired}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{label}{a character}
 \item{packageVersions}{a PackageVersion}
}

\strong{ApexTestSuite}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_apextestsuite.htm}{Salesforce Documentation for ApexTestSuite}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{testClassName}{a character}
}

\strong{ApexTrigger}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_apextrigger.htm}{Salesforce Documentation for ApexTrigger}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{apiVersion}{a numeric}
 \item{packageVersions}{a PackageVersion}
 \item{status}{a ApexCodeUnitStatus - which is a character taking one of the following values: 
   \itemize{
     \item{Inactive}
     \item{Active}
     \item{Deleted}
   }
  }
}

\strong{AppActionOverride}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appactionoverride.htm}{Salesforce Documentation for AppActionOverride}
\describe{
 \item{actionName}{a character (inherited from ActionOverride)}
 \item{comment}{a character (inherited from ActionOverride)}
 \item{content}{a character (inherited from ActionOverride)}
 \item{formFactor}{a FormFactor (inherited from ActionOverride)}
 \item{skipRecordTypeSelect}{a character either 'true' or 'false' (inherited from ActionOverride)}
 \item{type}{a ActionOverrideType (inherited from ActionOverride)}
 \item{pageOrSobjectType}{a character}
}

\strong{AppBrand}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appbrand.htm}{Salesforce Documentation for AppBrand}
\describe{
 \item{footerColor}{a character}
 \item{headerColor}{a character}
 \item{logo}{a character}
 \item{logoVersion}{a integer}
 \item{shouldOverrideOrgTheme}{a character either 'true' or 'false'}
}

\strong{AppComponentList}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appcomponentlist.htm}{Salesforce Documentation for AppComponentList}
\describe{
 \item{alignment}{a character}
 \item{components}{a character}
}

\strong{AppMenu}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appmenu.htm}{Salesforce Documentation for AppMenu}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{appMenuItems}{a AppMenuItem}
}

\strong{AppMenuItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appmenuitem.htm}{Salesforce Documentation for AppMenuItem}
\describe{
 \item{name}{a character}
 \item{type}{a character}
}

\strong{AppPreferences}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_apppreferences.htm}{Salesforce Documentation for AppPreferences}
\describe{
 \item{enableCustomizeMyTabs}{a character either 'true' or 'false'}
 \item{enableKeyboardShortcuts}{a character either 'true' or 'false'}
 \item{enableListViewHover}{a character either 'true' or 'false'}
 \item{enableListViewReskin}{a character either 'true' or 'false'}
 \item{enableMultiMonitorComponents}{a character either 'true' or 'false'}
 \item{enablePinTabs}{a character either 'true' or 'false'}
 \item{enableTabHover}{a character either 'true' or 'false'}
 \item{enableTabLimits}{a character either 'true' or 'false'}
 \item{saveUserSessions}{a character either 'true' or 'false'}
}

\strong{AppProfileActionOverride}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appprofileactionoverride.htm}{Salesforce Documentation for AppProfileActionOverride}
\describe{
 \item{actionName}{a character (inherited from ProfileActionOverride)}
 \item{content}{a character (inherited from ProfileActionOverride)}
 \item{formFactor}{a FormFactor (inherited from ProfileActionOverride)}
 \item{pageOrSobjectType}{a character (inherited from ProfileActionOverride)}
 \item{recordType}{a character (inherited from ProfileActionOverride)}
 \item{type}{a ActionOverrideType (inherited from ProfileActionOverride)}
 \item{profile}{a character}
}

\strong{ApprovalAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalaction.htm}{Salesforce Documentation for ApprovalAction}
\describe{
 \item{action}{a WorkflowActionReference}
}

\strong{ApprovalEntryCriteria}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalentrycriteria.htm}{Salesforce Documentation for ApprovalEntryCriteria}
\describe{
 \item{booleanFilter}{a character}
 \item{criteriaItems}{a FilterItem}
 \item{formula}{a character}
}

\strong{ApprovalPageField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalpagefield.htm}{Salesforce Documentation for ApprovalPageField}
\describe{
 \item{field}{a character}
}

\strong{ApprovalProcess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalprocess.htm}{Salesforce Documentation for ApprovalProcess}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{allowRecall}{a character either 'true' or 'false'}
 \item{allowedSubmitters}{a ApprovalSubmitter}
 \item{approvalPageFields}{a ApprovalPageField}
 \item{approvalStep}{a ApprovalStep}
 \item{description}{a character}
 \item{emailTemplate}{a character}
 \item{enableMobileDeviceAccess}{a character either 'true' or 'false'}
 \item{entryCriteria}{a ApprovalEntryCriteria}
 \item{finalApprovalActions}{a ApprovalAction}
 \item{finalApprovalRecordLock}{a character either 'true' or 'false'}
 \item{finalRejectionActions}{a ApprovalAction}
 \item{finalRejectionRecordLock}{a character either 'true' or 'false'}
 \item{initialSubmissionActions}{a ApprovalAction}
 \item{label}{a character}
 \item{nextAutomatedApprover}{a NextAutomatedApprover}
 \item{postTemplate}{a character}
 \item{recallActions}{a ApprovalAction}
 \item{recordEditability}{a RecordEditabilityType - which is a character taking one of the following values: 
   \itemize{
     \item{AdminOnly}
     \item{AdminOrCurrentApprover}
   }
  }
 \item{showApprovalHistory}{a character either 'true' or 'false'}
}

\strong{ApprovalStep}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalstep.htm}{Salesforce Documentation for ApprovalStep}
\describe{
 \item{allowDelegate}{a character either 'true' or 'false'}
 \item{approvalActions}{a ApprovalAction}
 \item{assignedApprover}{a ApprovalStepApprover}
 \item{description}{a character}
 \item{entryCriteria}{a ApprovalEntryCriteria}
 \item{ifCriteriaNotMet}{a StepCriteriaNotMetType - which is a character taking one of the following values: 
   \itemize{
     \item{ApproveRecord}
     \item{RejectRecord}
     \item{GotoNextStep}
   }
  }
 \item{label}{a character}
 \item{name}{a character}
 \item{rejectBehavior}{a ApprovalStepRejectBehavior}
 \item{rejectionActions}{a ApprovalAction}
}

\strong{ApprovalStepApprover}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalstepapprover.htm}{Salesforce Documentation for ApprovalStepApprover}
\describe{
 \item{approver}{a Approver}
 \item{whenMultipleApprovers}{a RoutingType - which is a character taking one of the following values: 
   \itemize{
     \item{Unanimous}
     \item{FirstResponse}
   }
  }
}

\strong{ApprovalStepRejectBehavior}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalsteprejectbehavior.htm}{Salesforce Documentation for ApprovalStepRejectBehavior}
\describe{
 \item{type}{a StepRejectBehaviorType - which is a character taking one of the following values: 
   \itemize{
     \item{RejectRequest}
     \item{BackToPrevious}
   }
  }
}

\strong{ApprovalSubmitter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approvalsubmitter.htm}{Salesforce Documentation for ApprovalSubmitter}
\describe{
 \item{submitter}{a character}
 \item{type}{a ProcessSubmitterType - which is a character taking one of the following values: 
   \itemize{
     \item{group}
     \item{role}
     \item{user}
     \item{roleSubordinates}
     \item{roleSubordinatesInternal}
     \item{owner}
     \item{creator}
     \item{partnerUser}
     \item{customerPortalUser}
     \item{portalRole}
     \item{portalRoleSubordinates}
     \item{allInternalUsers}
   }
  }
}

\strong{Approver}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_approver.htm}{Salesforce Documentation for Approver}
\describe{
 \item{name}{a character}
 \item{type}{a NextOwnerType - which is a character taking one of the following values: 
   \itemize{
     \item{adhoc}
     \item{user}
     \item{userHierarchyField}
     \item{relatedUserField}
     \item{queue}
   }
  }
}

\strong{AppWorkspaceConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_appworkspaceconfig.htm}{Salesforce Documentation for AppWorkspaceConfig}
\describe{
 \item{mappings}{a WorkspaceMapping}
}

\strong{ArticleTypeChannelDisplay}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_articletypechanneldisplay.htm}{Salesforce Documentation for ArticleTypeChannelDisplay}
\describe{
 \item{articleTypeTemplates}{a ArticleTypeTemplate}
}

\strong{ArticleTypeTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_articletypetemplate.htm}{Salesforce Documentation for ArticleTypeTemplate}
\describe{
 \item{channel}{a Channel - which is a character taking one of the following values: 
   \itemize{
     \item{AllChannels}
     \item{App}
     \item{Pkb}
     \item{Csp}
     \item{Prm}
   }
  }
 \item{page}{a character}
 \item{template}{a Template - which is a character taking one of the following values: 
   \itemize{
     \item{Page}
     \item{Tab}
     \item{Toc}
   }
  }
}

\strong{AssignmentRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_assignmentrule.htm}{Salesforce Documentation for AssignmentRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{ruleEntry}{a RuleEntry}
}

\strong{AssignmentRules}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_assignmentrules.htm}{Salesforce Documentation for AssignmentRules}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{assignmentRule}{a AssignmentRule}
}

\strong{AssistantRecommendationType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_assistantrecommendationtype.htm}{Salesforce Documentation for AssistantRecommendationType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{platformActionlist}{a PlatformActionList}
 \item{sobjectType}{a character}
 \item{title}{a character}
}

\strong{Attachment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_attachment.htm}{Salesforce Documentation for Attachment}
\describe{
 \item{content}{a character formed using RCurl::base64Encode}
 \item{name}{a character}
}

\strong{AuraDefinitionBundle}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_auradefinitionbundle.htm}{Salesforce Documentation for AuraDefinitionBundle}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{SVGContent}{a character formed using RCurl::base64Encode}
 \item{apiVersion}{a numeric}
 \item{controllerContent}{a character formed using RCurl::base64Encode}
 \item{description}{a character}
 \item{designContent}{a character formed using RCurl::base64Encode}
 \item{documentationContent}{a character formed using RCurl::base64Encode}
 \item{helperContent}{a character formed using RCurl::base64Encode}
 \item{markup}{a character formed using RCurl::base64Encode}
 \item{modelContent}{a character formed using RCurl::base64Encode}
 \item{packageVersions}{a PackageVersion}
 \item{rendererContent}{a character formed using RCurl::base64Encode}
 \item{styleContent}{a character formed using RCurl::base64Encode}
 \item{testsuiteContent}{a character formed using RCurl::base64Encode}
 \item{type}{a AuraBundleType - which is a character taking one of the following values: 
   \itemize{
     \item{Application}
     \item{Component}
     \item{Event}
     \item{Interface}
     \item{Tokens}
   }
  }
}

\strong{AuthProvider}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_authprovider.htm}{Salesforce Documentation for AuthProvider}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{authorizeUrl}{a character}
 \item{consumerKey}{a character}
 \item{consumerSecret}{a character}
 \item{customMetadataTypeRecord}{a character}
 \item{defaultScopes}{a character}
 \item{errorUrl}{a character}
 \item{executionUser}{a character}
 \item{friendlyName}{a character}
 \item{iconUrl}{a character}
 \item{idTokenIssuer}{a character}
 \item{includeOrgIdInIdentifier}{a character either 'true' or 'false'}
 \item{logoutUrl}{a character}
 \item{plugin}{a character}
 \item{portal}{a character}
 \item{providerType}{a AuthProviderType - which is a character taking one of the following values: 
   \itemize{
     \item{Facebook}
     \item{Janrain}
     \item{Salesforce}
     \item{OpenIdConnect}
     \item{MicrosoftACS}
     \item{LinkedIn}
     \item{Twitter}
     \item{Google}
     \item{GitHub}
     \item{Custom}
   }
  }
 \item{registrationHandler}{a character}
 \item{sendAccessTokenInHeader}{a character either 'true' or 'false'}
 \item{sendClientCredentialsInHeader}{a character either 'true' or 'false'}
 \item{tokenUrl}{a character}
 \item{userInfoUrl}{a character}
}

\strong{AutoResponseRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_autoresponserule.htm}{Salesforce Documentation for AutoResponseRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{ruleEntry}{a RuleEntry}
}

\strong{AutoResponseRules}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_autoresponserules.htm}{Salesforce Documentation for AutoResponseRules}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{autoResponseRule}{a AutoResponseRule}
}

\strong{BrandingSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_brandingset.htm}{Salesforce Documentation for BrandingSet}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{brandingSetProperty}{a BrandingSetProperty}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{type}{a character}
}

\strong{BrandingSetProperty}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_brandingsetproperty.htm}{Salesforce Documentation for BrandingSetProperty}
\describe{
 \item{propertyName}{a character}
 \item{propertyValue}{a character}
}

\strong{BusinessHoursEntry}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_businesshoursentry.htm}{Salesforce Documentation for BusinessHoursEntry}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{default}{a character either 'true' or 'false'}
 \item{fridayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{fridayStartTime}{a character formatted as 'hh:mm:ssZ}
 \item{mondayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{mondayStartTime}{a character formatted as 'hh:mm:ssZ}
 \item{name}{a character}
 \item{saturdayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{saturdayStartTime}{a character formatted as 'hh:mm:ssZ}
 \item{sundayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{sundayStartTime}{a character formatted as 'hh:mm:ssZ}
 \item{thursdayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{thursdayStartTime}{a character formatted as 'hh:mm:ssZ}
 \item{timeZoneId}{a character}
 \item{tuesdayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{tuesdayStartTime}{a character formatted as 'hh:mm:ssZ}
 \item{wednesdayEndTime}{a character formatted as 'hh:mm:ssZ}
 \item{wednesdayStartTime}{a character formatted as 'hh:mm:ssZ}
}

\strong{BusinessHoursSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_businesshourssettings.htm}{Salesforce Documentation for BusinessHoursSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{businessHours}{a BusinessHoursEntry}
 \item{holidays}{a Holiday}
}

\strong{BusinessProcess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_businessprocess.htm}{Salesforce Documentation for BusinessProcess}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{isActive}{a character either 'true' or 'false'}
 \item{values}{a PicklistValue}
}

\strong{CallCenter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_callcenter.htm}{Salesforce Documentation for CallCenter}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{adapterUrl}{a character}
 \item{customSettings}{a character}
 \item{displayName}{a character}
 \item{displayNameLabel}{a character}
 \item{internalNameLabel}{a character}
 \item{sections}{a CallCenterSection}
 \item{version}{a character}
}

\strong{CallCenterItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_callcenteritem.htm}{Salesforce Documentation for CallCenterItem}
\describe{
 \item{label}{a character}
 \item{name}{a character}
 \item{value}{a character}
}

\strong{CallCenterSection}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_callcentersection.htm}{Salesforce Documentation for CallCenterSection}
\describe{
 \item{items}{a CallCenterItem}
 \item{label}{a character}
 \item{name}{a character}
}

\strong{CampaignInfluenceModel}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_campaigninfluencemodel.htm}{Salesforce Documentation for CampaignInfluenceModel}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{isActive}{a character either 'true' or 'false'}
 \item{isDefaultModel}{a character either 'true' or 'false'}
 \item{isModelLocked}{a character either 'true' or 'false'}
 \item{modelDescription}{a character}
 \item{name}{a character}
 \item{recordPreference}{a character}
}

\strong{CaseSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_casesettings.htm}{Salesforce Documentation for CaseSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{caseAssignNotificationTemplate}{a character}
 \item{caseCloseNotificationTemplate}{a character}
 \item{caseCommentNotificationTemplate}{a character}
 \item{caseCreateNotificationTemplate}{a character}
 \item{caseFeedItemSettings}{a FeedItemSettings}
 \item{closeCaseThroughStatusChange}{a character either 'true' or 'false'}
 \item{defaultCaseOwner}{a character}
 \item{defaultCaseOwnerType}{a character}
 \item{defaultCaseUser}{a character}
 \item{emailActionDefaultsHandlerClass}{a character}
 \item{emailToCase}{a EmailToCaseSettings}
 \item{enableCaseFeed}{a character either 'true' or 'false'}
 \item{enableDraftEmails}{a character either 'true' or 'false'}
 \item{enableEarlyEscalationRuleTriggers}{a character either 'true' or 'false'}
 \item{enableEmailActionDefaultsHandler}{a character either 'true' or 'false'}
 \item{enableSuggestedArticlesApplication}{a character either 'true' or 'false'}
 \item{enableSuggestedArticlesCustomerPortal}{a character either 'true' or 'false'}
 \item{enableSuggestedArticlesPartnerPortal}{a character either 'true' or 'false'}
 \item{enableSuggestedSolutions}{a character either 'true' or 'false'}
 \item{keepRecordTypeOnAssignmentRule}{a character either 'true' or 'false'}
 \item{notifyContactOnCaseComment}{a character either 'true' or 'false'}
 \item{notifyDefaultCaseOwner}{a character either 'true' or 'false'}
 \item{notifyOwnerOnCaseComment}{a character either 'true' or 'false'}
 \item{notifyOwnerOnCaseOwnerChange}{a character either 'true' or 'false'}
 \item{showEmailAttachmentsInCaseAttachmentsRL}{a character either 'true' or 'false'}
 \item{showFewerCloseActions}{a character either 'true' or 'false'}
 \item{systemUserEmail}{a character}
 \item{useSystemEmailAddress}{a character either 'true' or 'false'}
 \item{useSystemUserAsDefaultCaseUser}{a character either 'true' or 'false'}
 \item{webToCase}{a WebToCaseSettings}
}

\strong{CaseSubjectParticle}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_casesubjectparticle.htm}{Salesforce Documentation for CaseSubjectParticle}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{index}{a integer}
 \item{textField}{a character}
 \item{type}{a CaseSubjectParticleType - which is a character taking one of the following values: 
   \itemize{
     \item{ProvidedString}
     \item{Source}
     \item{MessageType}
     \item{SocialHandle}
     \item{SocialNetwork}
     \item{Sentiment}
     \item{RealName}
     \item{Content}
     \item{PipeSeparator}
     \item{ColonSeparator}
     \item{HyphenSeparator}
   }
  }
}

\strong{Certificate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_certificate.htm}{Salesforce Documentation for Certificate}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{caSigned}{a character either 'true' or 'false'}
 \item{encryptedWithPlatformEncryption}{a character either 'true' or 'false'}
 \item{expirationDate}{a character formatted as 'yyyy-mm-ddThh:mm:ssZ'}
 \item{keySize}{a integer}
 \item{masterLabel}{a character}
 \item{privateKeyExportable}{a character either 'true' or 'false'}
}

\strong{ChannelLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_channellayout.htm}{Salesforce Documentation for ChannelLayout}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enabledChannels}{a character}
 \item{label}{a character}
 \item{layoutItems}{a ChannelLayoutItem}
 \item{recordType}{a character}
}

\strong{ChannelLayoutItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_channellayoutitem.htm}{Salesforce Documentation for ChannelLayoutItem}
\describe{
 \item{field}{a character}
}

\strong{ChartSummary}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_chartsummary.htm}{Salesforce Documentation for ChartSummary}
\describe{
 \item{aggregate}{a ReportSummaryType - which is a character taking one of the following values: 
   \itemize{
     \item{Sum}
     \item{Average}
     \item{Maximum}
     \item{Minimum}
     \item{None}
   }
  }
 \item{axisBinding}{a ChartAxis - which is a character taking one of the following values: 
   \itemize{
     \item{x}
     \item{y}
     \item{y2}
     \item{r}
   }
  }
 \item{column}{a character}
}

\strong{ChatterAnswersReputationLevel}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_chatteranswersreputationlevel.htm}{Salesforce Documentation for ChatterAnswersReputationLevel}
\describe{
 \item{name}{a character}
 \item{value}{a integer}
}

\strong{ChatterAnswersSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_chatteranswerssettings.htm}{Salesforce Documentation for ChatterAnswersSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{emailFollowersOnBestAnswer}{a character either 'true' or 'false'}
 \item{emailFollowersOnReply}{a character either 'true' or 'false'}
 \item{emailOwnerOnPrivateReply}{a character either 'true' or 'false'}
 \item{emailOwnerOnReply}{a character either 'true' or 'false'}
 \item{enableAnswerViaEmail}{a character either 'true' or 'false'}
 \item{enableChatterAnswers}{a character either 'true' or 'false'}
 \item{enableFacebookSSO}{a character either 'true' or 'false'}
 \item{enableInlinePublisher}{a character either 'true' or 'false'}
 \item{enableReputation}{a character either 'true' or 'false'}
 \item{enableRichTextEditor}{a character either 'true' or 'false'}
 \item{facebookAuthProvider}{a character}
 \item{showInPortals}{a character either 'true' or 'false'}
}

\strong{ChatterExtension}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_chatterextension.htm}{Salesforce Documentation for ChatterExtension}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{compositionComponent}{a character}
 \item{description}{a character}
 \item{extensionName}{a character}
 \item{headerText}{a character}
 \item{hoverText}{a character}
 \item{icon}{a character}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{renderComponent}{a character}
 \item{type}{a ChatterExtensionType - which is a character taking one of the following values: 
   \itemize{
     \item{Lightning}
   }
  }
}

\strong{ChatterMobileSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_chattermobilesettings.htm}{Salesforce Documentation for ChatterMobileSettings}
\describe{
 \item{enablePushNotifications}{a character either 'true' or 'false'}
}

\strong{CleanDataService}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_cleandataservice.htm}{Salesforce Documentation for CleanDataService}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{cleanRules}{a CleanRule}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{matchEngine}{a character}
}

\strong{CleanRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_cleanrule.htm}{Salesforce Documentation for CleanRule}
\describe{
 \item{bulkEnabled}{a character either 'true' or 'false'}
 \item{bypassTriggers}{a character either 'true' or 'false'}
 \item{bypassWorkflow}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{developerName}{a character}
 \item{fieldMappings}{a FieldMapping}
 \item{masterLabel}{a character}
 \item{matchRule}{a character}
 \item{sourceSobjectType}{a character}
 \item{status}{a CleanRuleStatus - which is a character taking one of the following values: 
   \itemize{
     \item{Inactive}
     \item{Active}
   }
  }
 \item{targetSobjectType}{a character}
}

\strong{CodeLocation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_codelocation.htm}{Salesforce Documentation for CodeLocation}
\describe{
 \item{column}{a integer}
 \item{line}{a integer}
 \item{numExecutions}{a integer}
 \item{time}{a numeric}
}

\strong{Community}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_community.htm}{Salesforce Documentation for Community}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{chatterAnswersFacebookSsoUrl}{a character}
 \item{communityFeedPage}{a character}
 \item{dataCategoryName}{a character}
 \item{description}{a character}
 \item{emailFooterDocument}{a character}
 \item{emailHeaderDocument}{a character}
 \item{emailNotificationUrl}{a character}
 \item{enableChatterAnswers}{a character either 'true' or 'false'}
 \item{enablePrivateQuestions}{a character either 'true' or 'false'}
 \item{expertsGroup}{a character}
 \item{portal}{a character}
 \item{reputationLevels}{a ReputationLevels}
 \item{showInPortal}{a character either 'true' or 'false'}
 \item{site}{a character}
}

\strong{CommunityCustomThemeLayoutType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communitycustomthemelayouttype.htm}{Salesforce Documentation for CommunityCustomThemeLayoutType}
\describe{
 \item{description}{a character}
 \item{label}{a character}
}

\strong{CommunityRoles}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communityroles.htm}{Salesforce Documentation for CommunityRoles}
\describe{
 \item{customerUserRole}{a character}
 \item{employeeUserRole}{a character}
 \item{partnerUserRole}{a character}
}

\strong{CommunityTemplateBundleInfo}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communitytemplatebundleinfo.htm}{Salesforce Documentation for CommunityTemplateBundleInfo}
\describe{
 \item{description}{a character}
 \item{image}{a character}
 \item{order}{a integer}
 \item{title}{a character}
 \item{type}{a CommunityTemplateBundleInfoType - which is a character taking one of the following values: 
   \itemize{
     \item{Highlight}
     \item{PreviewImage}
   }
  }
}

\strong{CommunityTemplateDefinition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communitytemplatedefinition.htm}{Salesforce Documentation for CommunityTemplateDefinition}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{baseTemplate}{a CommunityBaseTemplate - which is a character taking one of the following values: 
   \itemize{
     \item{c}
   }
  }
 \item{bundlesInfo}{a CommunityTemplateBundleInfo}
 \item{category}{a CommunityTemplateCategory - which is a character taking one of the following values: 
   \itemize{
     \item{IT}
     \item{Marketing}
     \item{Sales}
     \item{Service}
   }
  }
 \item{defaultBrandingSet}{a character}
 \item{defaultThemeDefinition}{a character}
 \item{description}{a character}
 \item{enableExtendedCleanUpOnDelete}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{navigationLinkSet}{a NavigationLinkSet}
 \item{pageSetting}{a CommunityTemplatePageSetting}
}

\strong{CommunityTemplatePageSetting}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communitytemplatepagesetting.htm}{Salesforce Documentation for CommunityTemplatePageSetting}
\describe{
 \item{page}{a character}
 \item{themeLayout}{a character}
}

\strong{CommunityThemeDefinition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communitythemedefinition.htm}{Salesforce Documentation for CommunityThemeDefinition}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customThemeLayoutType}{a CommunityCustomThemeLayoutType}
 \item{description}{a character}
 \item{enableExtendedCleanUpOnDelete}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{themeSetting}{a CommunityThemeSetting}
}

\strong{CommunityThemeSetting}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_communitythemesetting.htm}{Salesforce Documentation for CommunityThemeSetting}
\describe{
 \item{customThemeLayoutType}{a character}
 \item{themeLayout}{a character}
 \item{themeLayoutType}{a CommunityThemeLayoutType - which is a character taking one of the following values: 
   \itemize{
     \item{Login}
     \item{Home}
     \item{Inner}
   }
  }
}

\strong{CompactLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_compactlayout.htm}{Salesforce Documentation for CompactLayout}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{fields}{a character}
 \item{label}{a character}
}

\strong{CompanySettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_companysettings.htm}{Salesforce Documentation for CompanySettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{fiscalYear}{a FiscalYearSettings}
}

\strong{ComponentInstance}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_componentinstance.htm}{Salesforce Documentation for ComponentInstance}
\describe{
 \item{componentInstanceProperties}{a ComponentInstanceProperty}
 \item{componentName}{a character}
 \item{visibilityRule}{a UiFormulaRule}
}

\strong{ComponentInstanceProperty}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_componentinstanceproperty.htm}{Salesforce Documentation for ComponentInstanceProperty}
\describe{
 \item{name}{a character}
 \item{type}{a ComponentInstancePropertyTypeEnum - which is a character taking one of the following values: 
   \itemize{
     \item{decorator}
   }
  }
 \item{value}{a character}
}

\strong{ConnectedApp}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedapp.htm}{Salesforce Documentation for ConnectedApp}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{attributes}{a ConnectedAppAttribute}
 \item{canvasConfig}{a ConnectedAppCanvasConfig}
 \item{contactEmail}{a character}
 \item{contactPhone}{a character}
 \item{description}{a character}
 \item{iconUrl}{a character}
 \item{infoUrl}{a character}
 \item{ipRanges}{a ConnectedAppIpRange}
 \item{label}{a character}
 \item{logoUrl}{a character}
 \item{mobileAppConfig}{a ConnectedAppMobileDetailConfig}
 \item{mobileStartUrl}{a character}
 \item{oauthConfig}{a ConnectedAppOauthConfig}
 \item{plugin}{a character}
 \item{samlConfig}{a ConnectedAppSamlConfig}
 \item{startUrl}{a character}
}

\strong{ConnectedAppAttribute}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedappattribute.htm}{Salesforce Documentation for ConnectedAppAttribute}
\describe{
 \item{formula}{a character}
 \item{key}{a character}
}

\strong{ConnectedAppCanvasConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedappcanvasconfig.htm}{Salesforce Documentation for ConnectedAppCanvasConfig}
\describe{
 \item{accessMethod}{a AccessMethod - which is a character taking one of the following values: 
   \itemize{
     \item{Get}
     \item{Post}
   }
  }
 \item{canvasUrl}{a character}
 \item{lifecycleClass}{a character}
 \item{locations}{a CanvasLocationOptions - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Chatter}
     \item{UserProfile}
     \item{Visualforce}
     \item{Aura}
     \item{Publisher}
     \item{ChatterFeed}
     \item{ServiceDesk}
     \item{OpenCTI}
     \item{AppLauncher}
     \item{MobileNav}
     \item{PageLayout}
   }
  }
 \item{options}{a CanvasOptions - which is a character taking one of the following values: 
   \itemize{
     \item{HideShare}
     \item{HideHeader}
     \item{PersonalEnabled}
   }
  }
 \item{samlInitiationMethod}{a SamlInitiationMethod - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{IdpInitiated}
     \item{SpInitiated}
   }
  }
}

\strong{ConnectedAppIpRange}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedappiprange.htm}{Salesforce Documentation for ConnectedAppIpRange}
\describe{
 \item{description}{a character}
 \item{end}{a character}
 \item{start}{a character}
}

\strong{ConnectedAppMobileDetailConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedappmobiledetailconfig.htm}{Salesforce Documentation for ConnectedAppMobileDetailConfig}
\describe{
 \item{applicationBinaryFile}{a character formed using RCurl::base64Encode}
 \item{applicationBinaryFileName}{a character}
 \item{applicationBundleIdentifier}{a character}
 \item{applicationFileLength}{a integer}
 \item{applicationIconFile}{a character}
 \item{applicationIconFileName}{a character}
 \item{applicationInstallUrl}{a character}
 \item{devicePlatform}{a DevicePlatformType - which is a character taking one of the following values: 
   \itemize{
     \item{ios}
     \item{android}
   }
  }
 \item{deviceType}{a DeviceType - which is a character taking one of the following values: 
   \itemize{
     \item{phone}
     \item{tablet}
     \item{minitablet}
   }
  }
 \item{minimumOsVersion}{a character}
 \item{privateApp}{a character either 'true' or 'false'}
 \item{version}{a character}
}

\strong{ConnectedAppOauthConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedappoauthconfig.htm}{Salesforce Documentation for ConnectedAppOauthConfig}
\describe{
 \item{callbackUrl}{a character}
 \item{certificate}{a character}
 \item{consumerKey}{a character}
 \item{consumerSecret}{a character}
 \item{scopes}{a ConnectedAppOauthAccessScope - which is a character taking one of the following values: 
   \itemize{
     \item{Basic}
     \item{Api}
     \item{Web}
     \item{Full}
     \item{Chatter}
     \item{CustomApplications}
     \item{RefreshToken}
     \item{OpenID}
     \item{Profile}
     \item{Email}
     \item{Address}
     \item{Phone}
     \item{OfflineAccess}
     \item{CustomPermissions}
     \item{Wave}
     \item{Eclair}
   }
  }
 \item{singleLogoutUrl}{a character}
}

\strong{ConnectedAppSamlConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_connectedappsamlconfig.htm}{Salesforce Documentation for ConnectedAppSamlConfig}
\describe{
 \item{acsUrl}{a character}
 \item{certificate}{a character}
 \item{encryptionCertificate}{a character}
 \item{encryptionType}{a SamlEncryptionType - which is a character taking one of the following values: 
   \itemize{
     \item{AES_128}
     \item{AES_256}
     \item{Triple_Des}
   }
  }
 \item{entityUrl}{a character}
 \item{issuer}{a character}
 \item{samlIdpSLOBindingEnum}{a SamlIdpSLOBinding - which is a character taking one of the following values: 
   \itemize{
     \item{RedirectBinding}
     \item{PostBinding}
   }
  }
 \item{samlNameIdFormat}{a SamlNameIdFormatType - which is a character taking one of the following values: 
   \itemize{
     \item{Unspecified}
     \item{EmailAddress}
     \item{Persistent}
     \item{Transient}
   }
  }
 \item{samlSloUrl}{a character}
 \item{samlSubjectCustomAttr}{a character}
 \item{samlSubjectType}{a SamlSubjectType - which is a character taking one of the following values: 
   \itemize{
     \item{Username}
     \item{FederationId}
     \item{UserId}
     \item{SpokeId}
     \item{CustomAttribute}
     \item{PersistentId}
   }
  }
}

\strong{Container}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_container.htm}{Salesforce Documentation for Container}
\describe{
 \item{height}{a integer}
 \item{isContainerAutoSizeEnabled}{a character either 'true' or 'false'}
 \item{region}{a character}
 \item{sidebarComponents}{a SidebarComponent}
 \item{style}{a character}
 \item{unit}{a character}
 \item{width}{a integer}
}

\strong{ContentAsset}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_contentasset.htm}{Salesforce Documentation for ContentAsset}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{format}{a ContentAssetFormat - which is a character taking one of the following values: 
   \itemize{
     \item{Original}
     \item{ZippedVersions}
   }
  }
 \item{language}{a character}
 \item{masterLabel}{a character}
 \item{originNetwork}{a character}
 \item{relationships}{a ContentAssetRelationships}
 \item{versions}{a ContentAssetVersions}
}

\strong{ContentAssetLink}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_contentassetlink.htm}{Salesforce Documentation for ContentAssetLink}
\describe{
 \item{access}{a ContentAssetAccess - which is a character taking one of the following values: 
   \itemize{
     \item{VIEWER}
     \item{COLLABORATOR}
     \item{INFERRED}
   }
  }
 \item{isManagingWorkspace}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{ContentAssetRelationships}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_contentassetrelationships.htm}{Salesforce Documentation for ContentAssetRelationships}
\describe{
 \item{insightsApplication}{a ContentAssetLink}
 \item{network}{a ContentAssetLink}
 \item{organization}{a ContentAssetLink}
 \item{workspace}{a ContentAssetLink}
}

\strong{ContentAssetVersion}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_contentassetversion.htm}{Salesforce Documentation for ContentAssetVersion}
\describe{
 \item{number}{a character}
 \item{pathOnClient}{a character}
 \item{zipEntry}{a character}
}

\strong{ContentAssetVersions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_contentassetversions.htm}{Salesforce Documentation for ContentAssetVersions}
\describe{
 \item{version}{a ContentAssetVersion}
}

\strong{ContractSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_contractsettings.htm}{Salesforce Documentation for ContractSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{autoCalculateEndDate}{a character either 'true' or 'false'}
 \item{autoExpirationDelay}{a character}
 \item{autoExpirationRecipient}{a character}
 \item{autoExpireContracts}{a character either 'true' or 'false'}
 \item{enableContractHistoryTracking}{a character either 'true' or 'false'}
 \item{notifyOwnersOnContractExpiration}{a character either 'true' or 'false'}
}

\strong{CorsWhitelistOrigin}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_corswhitelistorigin.htm}{Salesforce Documentation for CorsWhitelistOrigin}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{urlPattern}{a character}
}

\strong{CountriesAndStates}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_countriesandstates.htm}{Salesforce Documentation for CountriesAndStates}
\describe{
 \item{countries}{a Country}
}

\strong{Country}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_country.htm}{Salesforce Documentation for Country}
\describe{
 \item{active}{a character either 'true' or 'false'}
 \item{integrationValue}{a character}
 \item{isoCode}{a character}
 \item{label}{a character}
 \item{orgDefault}{a character either 'true' or 'false'}
 \item{standard}{a character either 'true' or 'false'}
 \item{states}{a State}
 \item{visible}{a character either 'true' or 'false'}
}

\strong{CspTrustedSite}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_csptrustedsite.htm}{Salesforce Documentation for CspTrustedSite}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{endpointUrl}{a character}
 \item{isActive}{a character either 'true' or 'false'}
}

\strong{CustomApplication}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customapplication.htm}{Salesforce Documentation for CustomApplication}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionOverrides}{a AppActionOverride}
 \item{brand}{a AppBrand}
 \item{consoleConfig}{a ServiceCloudConsoleConfig}
 \item{defaultLandingTab}{a character}
 \item{description}{a character}
 \item{formFactors}{a FormFactor - which is a character taking one of the following values: 
   \itemize{
     \item{Small}
     \item{Medium}
     \item{Large}
   }
  }
 \item{isServiceCloudConsole}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{logo}{a character}
 \item{navType}{a NavType - which is a character taking one of the following values: 
   \itemize{
     \item{Standard}
     \item{Console}
   }
  }
 \item{preferences}{a AppPreferences}
 \item{profileActionOverrides}{a AppProfileActionOverride}
 \item{setupExperience}{a character}
 \item{subscriberTabs}{a character}
 \item{tabs}{a character}
 \item{uiType}{a UiType - which is a character taking one of the following values: 
   \itemize{
     \item{Aloha}
     \item{Lightning}
   }
  }
 \item{utilityBar}{a character}
 \item{workspaceConfig}{a AppWorkspaceConfig}
}

\strong{CustomApplicationComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customapplicationcomponent.htm}{Salesforce Documentation for CustomApplicationComponent}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{buttonIconUrl}{a character}
 \item{buttonStyle}{a character}
 \item{buttonText}{a character}
 \item{buttonWidth}{a integer}
 \item{height}{a integer}
 \item{isHeightFixed}{a character either 'true' or 'false'}
 \item{isHidden}{a character either 'true' or 'false'}
 \item{isWidthFixed}{a character either 'true' or 'false'}
 \item{visualforcePage}{a character}
 \item{width}{a integer}
}

\strong{CustomApplicationTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customapplicationtranslation.htm}{Salesforce Documentation for CustomApplicationTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{CustomConsoleComponents}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customconsolecomponents.htm}{Salesforce Documentation for CustomConsoleComponents}
\describe{
 \item{primaryTabComponents}{a PrimaryTabComponents}
 \item{subtabComponents}{a SubtabComponents}
}

\strong{CustomDataType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customdatatype.htm}{Salesforce Documentation for CustomDataType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customDataTypeComponents}{a CustomDataTypeComponent}
 \item{description}{a character}
 \item{displayFormula}{a character}
 \item{editComponentsOnSeparateLines}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{rightAligned}{a character either 'true' or 'false'}
 \item{supportComponentsInReports}{a character either 'true' or 'false'}
}

\strong{CustomDataTypeComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customdatatypecomponent.htm}{Salesforce Documentation for CustomDataTypeComponent}
\describe{
 \item{developerSuffix}{a character}
 \item{enforceFieldRequiredness}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{length}{a integer}
 \item{precision}{a integer}
 \item{scale}{a integer}
 \item{sortOrder}{a SortOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
 \item{sortPriority}{a integer}
 \item{type}{a FieldType - which is a character taking one of the following values: 
   \itemize{
     \item{AutoNumber}
     \item{Lookup}
     \item{MasterDetail}
     \item{Checkbox}
     \item{Currency}
     \item{Date}
     \item{DateTime}
     \item{Email}
     \item{Number}
     \item{Percent}
     \item{Phone}
     \item{Picklist}
     \item{MultiselectPicklist}
     \item{Text}
     \item{TextArea}
     \item{LongTextArea}
     \item{Html}
     \item{Url}
     \item{EncryptedText}
     \item{Summary}
     \item{Hierarchy}
     \item{File}
     \item{MetadataRelationship}
     \item{Location}
     \item{ExternalLookup}
     \item{IndirectLookup}
     \item{CustomDataType}
     \item{Time}
   }
  }
}

\strong{CustomDataTypeComponentTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customdatatypecomponenttranslation.htm}{Salesforce Documentation for CustomDataTypeComponentTranslation}
\describe{
 \item{developerSuffix}{a character}
 \item{label}{a character}
}

\strong{CustomDataTypeTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customdatatypetranslation.htm}{Salesforce Documentation for CustomDataTypeTranslation}
\describe{
 \item{components}{a CustomDataTypeComponentTranslation}
 \item{customDataTypeName}{a character}
 \item{description}{a character}
 \item{label}{a character}
}

\strong{CustomExperience}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customexperience.htm}{Salesforce Documentation for CustomExperience}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{allowInternalUserLogin}{a character either 'true' or 'false'}
 \item{branding}{a CustomExperienceBranding}
 \item{changePasswordEmailTemplate}{a character}
 \item{emailFooterLogo}{a character}
 \item{emailFooterText}{a character}
 \item{emailSenderAddress}{a character}
 \item{emailSenderName}{a character}
 \item{enableErrorPageOverridesForVisualforce}{a character either 'true' or 'false'}
 \item{forgotPasswordEmailTemplate}{a character}
 \item{picassoSite}{a character}
 \item{sObjectType}{a character}
 \item{sendWelcomeEmail}{a character either 'true' or 'false'}
 \item{site}{a character}
 \item{siteAsContainerEnabled}{a character either 'true' or 'false'}
 \item{tabs}{a CustomExperienceTabSet}
 \item{urlPathPrefix}{a character}
 \item{welcomeEmailTemplate}{a character}
}

\strong{CustomExperienceBranding}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customexperiencebranding.htm}{Salesforce Documentation for CustomExperienceBranding}
\describe{
 \item{loginFooterText}{a character}
 \item{loginLogo}{a character}
 \item{pageFooter}{a character}
 \item{pageHeader}{a character}
 \item{primaryColor}{a character}
 \item{primaryComplementColor}{a character}
 \item{quaternaryColor}{a character}
 \item{quaternaryComplementColor}{a character}
 \item{secondaryColor}{a character}
 \item{tertiaryColor}{a character}
 \item{tertiaryComplementColor}{a character}
 \item{zeronaryColor}{a character}
 \item{zeronaryComplementColor}{a character}
}

\strong{CustomExperienceTabSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customexperiencetabset.htm}{Salesforce Documentation for CustomExperienceTabSet}
\describe{
 \item{customTab}{a character}
 \item{defaultTab}{a character}
 \item{standardTab}{a character}
}

\strong{CustomFeedFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customfeedfilter.htm}{Salesforce Documentation for CustomFeedFilter}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{criteria}{a FeedFilterCriterion}
 \item{description}{a character}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{label}{a character}
}

\strong{CustomField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customfield.htm}{Salesforce Documentation for CustomField}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{businessOwnerGroup}{a character}
 \item{businessOwnerUser}{a character}
 \item{businessStatus}{a character}
 \item{caseSensitive}{a character either 'true' or 'false'}
 \item{customDataType}{a character}
 \item{defaultValue}{a character}
 \item{deleteConstraint}{a DeleteConstraint - which is a character taking one of the following values: 
   \itemize{
     \item{Cascade}
     \item{Restrict}
     \item{SetNull}
   }
  }
 \item{deprecated}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{displayFormat}{a character}
 \item{encrypted}{a character either 'true' or 'false'}
 \item{escapeMarkup}{a character either 'true' or 'false'}
 \item{externalDeveloperName}{a character}
 \item{externalId}{a character either 'true' or 'false'}
 \item{fieldManageability}{a FieldManageability - which is a character taking one of the following values: 
   \itemize{
     \item{DeveloperControlled}
     \item{SubscriberControlled}
     \item{Locked}
   }
  }
 \item{formula}{a character}
 \item{formulaTreatBlanksAs}{a TreatBlanksAs - which is a character taking one of the following values: 
   \itemize{
     \item{BlankAsBlank}
     \item{BlankAsZero}
   }
  }
 \item{inlineHelpText}{a character}
 \item{isConvertLeadDisabled}{a character either 'true' or 'false'}
 \item{isFilteringDisabled}{a character either 'true' or 'false'}
 \item{isNameField}{a character either 'true' or 'false'}
 \item{isSortingDisabled}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{length}{a integer}
 \item{lookupFilter}{a LookupFilter}
 \item{maskChar}{a EncryptedFieldMaskChar - which is a character taking one of the following values: 
   \itemize{
     \item{asterisk}
     \item{X}
   }
  }
 \item{maskType}{a EncryptedFieldMaskType - which is a character taking one of the following values: 
   \itemize{
     \item{all}
     \item{creditCard}
     \item{ssn}
     \item{lastFour}
     \item{sin}
     \item{nino}
   }
  }
 \item{metadataRelationshipControllingField}{a character}
 \item{populateExistingRows}{a character either 'true' or 'false'}
 \item{precision}{a integer}
 \item{referenceTargetField}{a character}
 \item{referenceTo}{a character}
 \item{relationshipLabel}{a character}
 \item{relationshipName}{a character}
 \item{relationshipOrder}{a integer}
 \item{reparentableMasterDetail}{a character either 'true' or 'false'}
 \item{required}{a character either 'true' or 'false'}
 \item{restrictedAdminField}{a character either 'true' or 'false'}
 \item{scale}{a integer}
 \item{securityClassification}{a SecurityClassification - which is a character taking one of the following values: 
   \itemize{
     \item{AccountInformation}
     \item{ConfigurationAndUsageData}
     \item{DataIntendedToBePublic}
     \item{BusinessSetupDataBusinessDataAndAggregates}
     \item{AssociativeBusinessOrPersonalData}
     \item{AuthenticationData}
   }
  }
 \item{startingNumber}{a integer}
 \item{stripMarkup}{a character either 'true' or 'false'}
 \item{summarizedField}{a character}
 \item{summaryFilterItems}{a FilterItem}
 \item{summaryForeignKey}{a character}
 \item{summaryOperation}{a SummaryOperations - which is a character taking one of the following values: 
   \itemize{
     \item{count}
     \item{sum}
     \item{min}
     \item{max}
   }
  }
 \item{trackFeedHistory}{a character either 'true' or 'false'}
 \item{trackHistory}{a character either 'true' or 'false'}
 \item{trackTrending}{a character either 'true' or 'false'}
 \item{type}{a FieldType - which is a character taking one of the following values: 
   \itemize{
     \item{AutoNumber}
     \item{Lookup}
     \item{MasterDetail}
     \item{Checkbox}
     \item{Currency}
     \item{Date}
     \item{DateTime}
     \item{Email}
     \item{Number}
     \item{Percent}
     \item{Phone}
     \item{Picklist}
     \item{MultiselectPicklist}
     \item{Text}
     \item{TextArea}
     \item{LongTextArea}
     \item{Html}
     \item{Url}
     \item{EncryptedText}
     \item{Summary}
     \item{Hierarchy}
     \item{File}
     \item{MetadataRelationship}
     \item{Location}
     \item{ExternalLookup}
     \item{IndirectLookup}
     \item{CustomDataType}
     \item{Time}
   }
  }
 \item{unique}{a character either 'true' or 'false'}
 \item{valueSet}{a ValueSet}
 \item{visibleLines}{a integer}
 \item{writeRequiresMasterRead}{a character either 'true' or 'false'}
}

\strong{CustomFieldTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customfieldtranslation.htm}{Salesforce Documentation for CustomFieldTranslation}
\describe{
 \item{caseValues}{a ObjectNameCaseValue}
 \item{gender}{a Gender - which is a character taking one of the following values: 
   \itemize{
     \item{Neuter}
     \item{Masculine}
     \item{Feminine}
     \item{AnimateMasculine}
   }
  }
 \item{help}{a character}
 \item{label}{a character}
 \item{lookupFilter}{a LookupFilterTranslation}
 \item{name}{a character}
 \item{picklistValues}{a PicklistValueTranslation}
 \item{relationshipLabel}{a character}
 \item{startsWith}{a StartsWith - which is a character taking one of the following values: 
   \itemize{
     \item{Consonant}
     \item{Vowel}
     \item{Special}
   }
  }
}

\strong{CustomLabel}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customlabel.htm}{Salesforce Documentation for CustomLabel}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{categories}{a character}
 \item{language}{a character}
 \item{protected}{a character either 'true' or 'false'}
 \item{shortDescription}{a character}
 \item{value}{a character}
}

\strong{CustomLabels}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customlabels.htm}{Salesforce Documentation for CustomLabels}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{labels}{a CustomLabel}
}

\strong{CustomLabelTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customlabeltranslation.htm}{Salesforce Documentation for CustomLabelTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{CustomMetadata}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_custommetadata.htm}{Salesforce Documentation for CustomMetadata}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{label}{a character}
 \item{protected}{a character either 'true' or 'false'}
 \item{values}{a CustomMetadataValue}
}

\strong{CustomMetadataValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_custommetadatavalue.htm}{Salesforce Documentation for CustomMetadataValue}
\describe{
 \item{field}{a character}
 \item{value}{a character that appears similar to any of the other accepted types (integer, numeric, date, datetime, boolean)}
}

\strong{CustomNotificationType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customnotificationtype.htm}{Salesforce Documentation for CustomNotificationType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customNotifTypeName}{a character}
 \item{description}{a character}
 \item{desktop}{a character either 'true' or 'false'}
 \item{email}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{mobile}{a character either 'true' or 'false'}
}

\strong{CustomObject}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customobject.htm}{Salesforce Documentation for CustomObject}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionOverrides}{a ActionOverride}
 \item{allowInChatterGroups}{a character either 'true' or 'false'}
 \item{articleTypeChannelDisplay}{a ArticleTypeChannelDisplay}
 \item{businessProcesses}{a BusinessProcess}
 \item{compactLayoutAssignment}{a character}
 \item{compactLayouts}{a CompactLayout}
 \item{customHelp}{a character}
 \item{customHelpPage}{a character}
 \item{customSettingsType}{a CustomSettingsType - which is a character taking one of the following values: 
   \itemize{
     \item{List}
     \item{Hierarchy}
   }
  }
 \item{dataStewardGroup}{a character}
 \item{dataStewardUser}{a character}
 \item{deploymentStatus}{a DeploymentStatus - which is a character taking one of the following values: 
   \itemize{
     \item{InDevelopment}
     \item{Deployed}
   }
  }
 \item{deprecated}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{enableActivities}{a character either 'true' or 'false'}
 \item{enableBulkApi}{a character either 'true' or 'false'}
 \item{enableChangeDataCapture}{a character either 'true' or 'false'}
 \item{enableDivisions}{a character either 'true' or 'false'}
 \item{enableEnhancedLookup}{a character either 'true' or 'false'}
 \item{enableFeeds}{a character either 'true' or 'false'}
 \item{enableHistory}{a character either 'true' or 'false'}
 \item{enableReports}{a character either 'true' or 'false'}
 \item{enableSearch}{a character either 'true' or 'false'}
 \item{enableSharing}{a character either 'true' or 'false'}
 \item{enableStreamingApi}{a character either 'true' or 'false'}
 \item{eventType}{a PlatformEventType - which is a character taking one of the following values: 
   \itemize{
     \item{HighVolume}
     \item{StandardVolume}
   }
  }
 \item{externalDataSource}{a character}
 \item{externalName}{a character}
 \item{externalRepository}{a character}
 \item{externalSharingModel}{a SharingModel - which is a character taking one of the following values: 
   \itemize{
     \item{Private}
     \item{Read}
     \item{ReadSelect}
     \item{ReadWrite}
     \item{ReadWriteTransfer}
     \item{FullAccess}
     \item{ControlledByParent}
   }
  }
 \item{fieldSets}{a FieldSet}
 \item{fields}{a CustomField}
 \item{gender}{a Gender - which is a character taking one of the following values: 
   \itemize{
     \item{Neuter}
     \item{Masculine}
     \item{Feminine}
     \item{AnimateMasculine}
   }
  }
 \item{historyRetentionPolicy}{a HistoryRetentionPolicy}
 \item{household}{a character either 'true' or 'false'}
 \item{indexes}{a Index}
 \item{label}{a character}
 \item{listViews}{a ListView}
 \item{nameField}{a CustomField}
 \item{pluralLabel}{a character}
 \item{recordTypeTrackFeedHistory}{a character either 'true' or 'false'}
 \item{recordTypeTrackHistory}{a character either 'true' or 'false'}
 \item{recordTypes}{a RecordType}
 \item{searchLayouts}{a SearchLayouts}
 \item{sharingModel}{a SharingModel - which is a character taking one of the following values: 
   \itemize{
     \item{Private}
     \item{Read}
     \item{ReadSelect}
     \item{ReadWrite}
     \item{ReadWriteTransfer}
     \item{FullAccess}
     \item{ControlledByParent}
   }
  }
 \item{sharingReasons}{a SharingReason}
 \item{sharingRecalculations}{a SharingRecalculation}
 \item{startsWith}{a StartsWith - which is a character taking one of the following values: 
   \itemize{
     \item{Consonant}
     \item{Vowel}
     \item{Special}
   }
  }
 \item{validationRules}{a ValidationRule}
 \item{visibility}{a SetupObjectVisibility - which is a character taking one of the following values: 
   \itemize{
     \item{Protected}
     \item{Public}
   }
  }
 \item{webLinks}{a WebLink}
}

\strong{CustomObjectTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customobjecttranslation.htm}{Salesforce Documentation for CustomObjectTranslation}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{caseValues}{a ObjectNameCaseValue}
 \item{fieldSets}{a FieldSetTranslation}
 \item{fields}{a CustomFieldTranslation}
 \item{gender}{a Gender - which is a character taking one of the following values: 
   \itemize{
     \item{Neuter}
     \item{Masculine}
     \item{Feminine}
     \item{AnimateMasculine}
   }
  }
 \item{layouts}{a LayoutTranslation}
 \item{nameFieldLabel}{a character}
 \item{quickActions}{a QuickActionTranslation}
 \item{recordTypes}{a RecordTypeTranslation}
 \item{sharingReasons}{a SharingReasonTranslation}
 \item{standardFields}{a StandardFieldTranslation}
 \item{startsWith}{a StartsWith - which is a character taking one of the following values: 
   \itemize{
     \item{Consonant}
     \item{Vowel}
     \item{Special}
   }
  }
 \item{validationRules}{a ValidationRuleTranslation}
 \item{webLinks}{a WebLinkTranslation}
 \item{workflowTasks}{a WorkflowTaskTranslation}
}

\strong{CustomPageWebLink}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_custompageweblink.htm}{Salesforce Documentation for CustomPageWebLink}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{availability}{a WebLinkAvailability - which is a character taking one of the following values: 
   \itemize{
     \item{online}
     \item{offline}
   }
  }
 \item{description}{a character}
 \item{displayType}{a WebLinkDisplayType - which is a character taking one of the following values: 
   \itemize{
     \item{link}
     \item{button}
     \item{massActionButton}
   }
  }
 \item{encodingKey}{a Encoding - which is a character taking one of the following values: 
   \itemize{
     \item{UTF-8}
     \item{ISO-8859-1}
     \item{Shift_JIS}
     \item{ISO-2022-JP}
     \item{EUC-JP}
     \item{ks_c_5601-1987}
     \item{Big5}
     \item{GB2312}
     \item{Big5-HKSCS}
     \item{x-SJIS_0213}
   }
  }
 \item{hasMenubar}{a character either 'true' or 'false'}
 \item{hasScrollbars}{a character either 'true' or 'false'}
 \item{hasToolbar}{a character either 'true' or 'false'}
 \item{height}{a integer}
 \item{isResizable}{a character either 'true' or 'false'}
 \item{linkType}{a WebLinkType - which is a character taking one of the following values: 
   \itemize{
     \item{url}
     \item{sControl}
     \item{javascript}
     \item{page}
     \item{flow}
   }
  }
 \item{masterLabel}{a character}
 \item{openType}{a WebLinkWindowType - which is a character taking one of the following values: 
   \itemize{
     \item{newWindow}
     \item{sidebar}
     \item{noSidebar}
     \item{replace}
     \item{onClickJavaScript}
   }
  }
 \item{page}{a character}
 \item{position}{a WebLinkPosition - which is a character taking one of the following values: 
   \itemize{
     \item{fullScreen}
     \item{none}
     \item{topLeft}
   }
  }
 \item{protected}{a character either 'true' or 'false'}
 \item{requireRowSelection}{a character either 'true' or 'false'}
 \item{scontrol}{a character}
 \item{showsLocation}{a character either 'true' or 'false'}
 \item{showsStatus}{a character either 'true' or 'false'}
 \item{url}{a character}
 \item{width}{a integer}
}

\strong{CustomPageWebLinkTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_custompageweblinktranslation.htm}{Salesforce Documentation for CustomPageWebLinkTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{CustomPermission}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_custompermission.htm}{Salesforce Documentation for CustomPermission}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{connectedApp}{a character}
 \item{description}{a character}
 \item{label}{a character}
 \item{requiredPermission}{a CustomPermissionDependencyRequired}
}

\strong{CustomPermissionDependencyRequired}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_custompermissiondependencyrequired.htm}{Salesforce Documentation for CustomPermissionDependencyRequired}
\describe{
 \item{customPermission}{a character}
 \item{dependency}{a character either 'true' or 'false'}
}

\strong{CustomShortcut}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customshortcut.htm}{Salesforce Documentation for CustomShortcut}
\describe{
 \item{action}{a character (inherited from DefaultShortcut)}
 \item{active}{a character either 'true' or 'false' (inherited from DefaultShortcut)}
 \item{keyCommand}{a character (inherited from DefaultShortcut)}
 \item{description}{a character}
 \item{eventName}{a character}
}

\strong{CustomSite}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customsite.htm}{Salesforce Documentation for CustomSite}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{allowHomePage}{a character either 'true' or 'false'}
 \item{allowStandardAnswersPages}{a character either 'true' or 'false'}
 \item{allowStandardIdeasPages}{a character either 'true' or 'false'}
 \item{allowStandardLookups}{a character either 'true' or 'false'}
 \item{allowStandardPortalPages}{a character either 'true' or 'false'}
 \item{allowStandardSearch}{a character either 'true' or 'false'}
 \item{analyticsTrackingCode}{a character}
 \item{authorizationRequiredPage}{a character}
 \item{bandwidthExceededPage}{a character}
 \item{browserXssProtection}{a character either 'true' or 'false'}
 \item{changePasswordPage}{a character}
 \item{chatterAnswersForgotPasswordConfirmPage}{a character}
 \item{chatterAnswersForgotPasswordPage}{a character}
 \item{chatterAnswersHelpPage}{a character}
 \item{chatterAnswersLoginPage}{a character}
 \item{chatterAnswersRegistrationPage}{a character}
 \item{clickjackProtectionLevel}{a SiteClickjackProtectionLevel - which is a character taking one of the following values: 
   \itemize{
     \item{AllowAllFraming}
     \item{SameOriginOnly}
     \item{NoFraming}
   }
  }
 \item{contentSniffingProtection}{a character either 'true' or 'false'}
 \item{cspUpgradeInsecureRequests}{a character either 'true' or 'false'}
 \item{customWebAddresses}{a SiteWebAddress}
 \item{description}{a character}
 \item{favoriteIcon}{a character}
 \item{fileNotFoundPage}{a character}
 \item{forgotPasswordPage}{a character}
 \item{genericErrorPage}{a character}
 \item{guestProfile}{a character}
 \item{inMaintenancePage}{a character}
 \item{inactiveIndexPage}{a character}
 \item{indexPage}{a character}
 \item{masterLabel}{a character}
 \item{myProfilePage}{a character}
 \item{portal}{a character}
 \item{referrerPolicyOriginWhenCrossOrigin}{a character either 'true' or 'false'}
 \item{requireHttps}{a character either 'true' or 'false'}
 \item{requireInsecurePortalAccess}{a character either 'true' or 'false'}
 \item{robotsTxtPage}{a character}
 \item{rootComponent}{a character}
 \item{selfRegPage}{a character}
 \item{serverIsDown}{a character}
 \item{siteAdmin}{a character}
 \item{siteRedirectMappings}{a SiteRedirectMapping}
 \item{siteTemplate}{a character}
 \item{siteType}{a SiteType - which is a character taking one of the following values: 
   \itemize{
     \item{Siteforce}
     \item{Visualforce}
     \item{User}
   }
  }
 \item{subdomain}{a character}
 \item{urlPathPrefix}{a character}
}

\strong{CustomTab}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customtab.htm}{Salesforce Documentation for CustomTab}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionOverrides}{a ActionOverride}
 \item{auraComponent}{a character}
 \item{customObject}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{flexiPage}{a character}
 \item{frameHeight}{a integer}
 \item{hasSidebar}{a character either 'true' or 'false'}
 \item{icon}{a character}
 \item{label}{a character}
 \item{mobileReady}{a character either 'true' or 'false'}
 \item{motif}{a character}
 \item{page}{a character}
 \item{scontrol}{a character}
 \item{splashPageLink}{a character}
 \item{url}{a character}
 \item{urlEncodingKey}{a Encoding - which is a character taking one of the following values: 
   \itemize{
     \item{UTF-8}
     \item{ISO-8859-1}
     \item{Shift_JIS}
     \item{ISO-2022-JP}
     \item{EUC-JP}
     \item{ks_c_5601-1987}
     \item{Big5}
     \item{GB2312}
     \item{Big5-HKSCS}
     \item{x-SJIS_0213}
   }
  }
}

\strong{CustomTabTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customtabtranslation.htm}{Salesforce Documentation for CustomTabTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{CustomValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_customvalue.htm}{Salesforce Documentation for CustomValue}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{color}{a character}
 \item{default}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{isActive}{a character either 'true' or 'false'}
 \item{label}{a character}
}

\strong{Dashboard}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboard.htm}{Salesforce Documentation for Dashboard}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{backgroundEndColor}{a character}
 \item{backgroundFadeDirection}{a ChartBackgroundDirection - which is a character taking one of the following values: 
   \itemize{
     \item{TopToBottom}
     \item{LeftToRight}
     \item{Diagonal}
   }
  }
 \item{backgroundStartColor}{a character}
 \item{chartTheme}{a ChartTheme - which is a character taking one of the following values: 
   \itemize{
     \item{light}
     \item{dark}
   }
  }
 \item{colorPalette}{a ChartColorPalettes - which is a character taking one of the following values: 
   \itemize{
     \item{Default}
     \item{gray}
     \item{colorSafe}
     \item{unity}
     \item{justice}
     \item{nightfall}
     \item{sunrise}
     \item{bluegrass}
     \item{tropic}
     \item{heat}
     \item{dusk}
     \item{pond}
     \item{watermelon}
     \item{fire}
     \item{water}
     \item{earth}
     \item{accessible}
   }
  }
 \item{dashboardChartTheme}{a ChartTheme - which is a character taking one of the following values: 
   \itemize{
     \item{light}
     \item{dark}
   }
  }
 \item{dashboardColorPalette}{a ChartColorPalettes - which is a character taking one of the following values: 
   \itemize{
     \item{Default}
     \item{gray}
     \item{colorSafe}
     \item{unity}
     \item{justice}
     \item{nightfall}
     \item{sunrise}
     \item{bluegrass}
     \item{tropic}
     \item{heat}
     \item{dusk}
     \item{pond}
     \item{watermelon}
     \item{fire}
     \item{water}
     \item{earth}
     \item{accessible}
   }
  }
 \item{dashboardFilters}{a DashboardFilter}
 \item{dashboardGridLayout}{a DashboardGridLayout}
 \item{dashboardResultRefreshedDate}{a character}
 \item{dashboardResultRunningUser}{a character}
 \item{dashboardType}{a DashboardType - which is a character taking one of the following values: 
   \itemize{
     \item{SpecifiedUser}
     \item{LoggedInUser}
     \item{MyTeamUser}
   }
  }
 \item{description}{a character}
 \item{folderName}{a character}
 \item{isGridLayout}{a character either 'true' or 'false'}
 \item{leftSection}{a DashboardComponentSection}
 \item{middleSection}{a DashboardComponentSection}
 \item{numSubscriptions}{a integer}
 \item{rightSection}{a DashboardComponentSection}
 \item{runningUser}{a character}
 \item{textColor}{a character}
 \item{title}{a character}
 \item{titleColor}{a character}
 \item{titleSize}{a integer}
}

\strong{DashboardComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardcomponent.htm}{Salesforce Documentation for DashboardComponent}
\describe{
 \item{autoselectColumnsFromReport}{a character either 'true' or 'false'}
 \item{chartAxisRange}{a ChartRangeType - which is a character taking one of the following values: 
   \itemize{
     \item{Auto}
     \item{Manual}
   }
  }
 \item{chartAxisRangeMax}{a numeric}
 \item{chartAxisRangeMin}{a numeric}
 \item{chartSummary}{a ChartSummary}
 \item{componentChartTheme}{a ChartTheme - which is a character taking one of the following values: 
   \itemize{
     \item{light}
     \item{dark}
   }
  }
 \item{componentType}{a DashboardComponentType - which is a character taking one of the following values: 
   \itemize{
     \item{Bar}
     \item{BarGrouped}
     \item{BarStacked}
     \item{BarStacked100}
     \item{Column}
     \item{ColumnGrouped}
     \item{ColumnStacked}
     \item{ColumnStacked100}
     \item{Line}
     \item{LineGrouped}
     \item{Pie}
     \item{Table}
     \item{Metric}
     \item{Gauge}
     \item{LineCumulative}
     \item{LineGroupedCumulative}
     \item{Scontrol}
     \item{VisualforcePage}
     \item{Donut}
     \item{Funnel}
     \item{ColumnLine}
     \item{ColumnLineGrouped}
     \item{ColumnLineStacked}
     \item{ColumnLineStacked100}
     \item{Scatter}
     \item{ScatterGrouped}
     \item{FlexTable}
   }
  }
 \item{dashboardFilterColumns}{a DashboardFilterColumn}
 \item{dashboardTableColumn}{a DashboardTableColumn}
 \item{displayUnits}{a ChartUnits - which is a character taking one of the following values: 
   \itemize{
     \item{Auto}
     \item{Integer}
     \item{Hundreds}
     \item{Thousands}
     \item{Millions}
     \item{Billions}
     \item{Trillions}
   }
  }
 \item{drillDownUrl}{a character}
 \item{drillEnabled}{a character either 'true' or 'false'}
 \item{drillToDetailEnabled}{a character either 'true' or 'false'}
 \item{enableHover}{a character either 'true' or 'false'}
 \item{expandOthers}{a character either 'true' or 'false'}
 \item{flexComponentProperties}{a DashboardFlexTableComponentProperties}
 \item{footer}{a character}
 \item{gaugeMax}{a numeric}
 \item{gaugeMin}{a numeric}
 \item{groupingColumn}{a character}
 \item{header}{a character}
 \item{indicatorBreakpoint1}{a numeric}
 \item{indicatorBreakpoint2}{a numeric}
 \item{indicatorHighColor}{a character}
 \item{indicatorLowColor}{a character}
 \item{indicatorMiddleColor}{a character}
 \item{legendPosition}{a ChartLegendPosition - which is a character taking one of the following values: 
   \itemize{
     \item{Right}
     \item{Bottom}
     \item{OnChart}
   }
  }
 \item{maxValuesDisplayed}{a integer}
 \item{metricLabel}{a character}
 \item{page}{a character}
 \item{pageHeightInPixels}{a integer}
 \item{report}{a character}
 \item{scontrol}{a character}
 \item{scontrolHeightInPixels}{a integer}
 \item{showPercentage}{a character either 'true' or 'false'}
 \item{showPicturesOnCharts}{a character either 'true' or 'false'}
 \item{showPicturesOnTables}{a character either 'true' or 'false'}
 \item{showRange}{a character either 'true' or 'false'}
 \item{showTotal}{a character either 'true' or 'false'}
 \item{showValues}{a character either 'true' or 'false'}
 \item{sortBy}{a DashboardComponentFilter - which is a character taking one of the following values: 
   \itemize{
     \item{RowLabelAscending}
     \item{RowLabelDescending}
     \item{RowValueAscending}
     \item{RowValueDescending}
   }
  }
 \item{title}{a character}
 \item{useReportChart}{a character either 'true' or 'false'}
}

\strong{DashboardComponentColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardcomponentcolumn.htm}{Salesforce Documentation for DashboardComponentColumn}
\describe{
 \item{breakPoint1}{a numeric}
 \item{breakPoint2}{a numeric}
 \item{breakPointOrder}{a integer}
 \item{highRangeColor}{a integer}
 \item{lowRangeColor}{a integer}
 \item{midRangeColor}{a integer}
 \item{reportColumn}{a character}
 \item{showTotal}{a character either 'true' or 'false'}
 \item{type}{a DashboardComponentColumnType - which is a character taking one of the following values: 
   \itemize{
     \item{NA}
   }
  }
}

\strong{DashboardComponentSection}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardcomponentsection.htm}{Salesforce Documentation for DashboardComponentSection}
\describe{
 \item{columnSize}{a DashboardComponentSize - which is a character taking one of the following values: 
   \itemize{
     \item{Narrow}
     \item{Medium}
     \item{Wide}
   }
  }
 \item{components}{a DashboardComponent}
}

\strong{DashboardComponentSortInfo}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardcomponentsortinfo.htm}{Salesforce Documentation for DashboardComponentSortInfo}
\describe{
 \item{sortColumn}{a character}
 \item{sortOrder}{a character}
}

\strong{DashboardFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardfilter.htm}{Salesforce Documentation for DashboardFilter}
\describe{
 \item{dashboardFilterOptions}{a DashboardFilterOption}
 \item{name}{a character}
}

\strong{DashboardFilterColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardfiltercolumn.htm}{Salesforce Documentation for DashboardFilterColumn}
\describe{
 \item{column}{a character}
}

\strong{DashboardFilterOption}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardfilteroption.htm}{Salesforce Documentation for DashboardFilterOption}
\describe{
 \item{operator}{a DashboardFilterOperation - which is a character taking one of the following values: 
   \itemize{
     \item{equals}
     \item{notEqual}
     \item{lessThan}
     \item{greaterThan}
     \item{lessOrEqual}
     \item{greaterOrEqual}
     \item{contains}
     \item{notContain}
     \item{startsWith}
     \item{includes}
     \item{excludes}
     \item{between}
   }
  }
 \item{values}{a character}
}

\strong{DashboardFlexTableComponentProperties}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardflextablecomponentproperties.htm}{Salesforce Documentation for DashboardFlexTableComponentProperties}
\describe{
 \item{flexTableColumn}{a DashboardComponentColumn}
 \item{flexTableSortInfo}{a DashboardComponentSortInfo}
 \item{hideChatterPhotos}{a character either 'true' or 'false'}
}

\strong{DashboardFolder}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardfolder.htm}{Salesforce Documentation for DashboardFolder}
\describe{
 \item{accessType}{a FolderAccessTypes (inherited from Folder)}
 \item{folderShares}{a FolderShare (inherited from Folder)}
 \item{name}{a character (inherited from Folder)}
 \item{publicFolderAccess}{a PublicFolderAccess (inherited from Folder)}
 \item{sharedTo}{a SharedTo (inherited from Folder)}
}

\strong{DashboardGridComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardgridcomponent.htm}{Salesforce Documentation for DashboardGridComponent}
\describe{
 \item{colSpan}{a integer}
 \item{columnIndex}{a integer}
 \item{dashboardComponent}{a DashboardComponent}
 \item{rowIndex}{a integer}
 \item{rowSpan}{a integer}
}

\strong{DashboardGridLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardgridlayout.htm}{Salesforce Documentation for DashboardGridLayout}
\describe{
 \item{dashboardGridComponents}{a DashboardGridComponent}
 \item{numberOfColumns}{a integer}
 \item{rowHeight}{a integer}
}

\strong{DashboardMobileSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardmobilesettings.htm}{Salesforce Documentation for DashboardMobileSettings}
\describe{
 \item{enableDashboardIPadApp}{a character either 'true' or 'false'}
}

\strong{DashboardTableColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_dashboardtablecolumn.htm}{Salesforce Documentation for DashboardTableColumn}
\describe{
 \item{aggregateType}{a ReportSummaryType - which is a character taking one of the following values: 
   \itemize{
     \item{Sum}
     \item{Average}
     \item{Maximum}
     \item{Minimum}
     \item{None}
   }
  }
 \item{calculatePercent}{a character either 'true' or 'false'}
 \item{column}{a character}
 \item{decimalPlaces}{a integer}
 \item{showTotal}{a character either 'true' or 'false'}
 \item{sortBy}{a DashboardComponentFilter - which is a character taking one of the following values: 
   \itemize{
     \item{RowLabelAscending}
     \item{RowLabelDescending}
     \item{RowValueAscending}
     \item{RowValueDescending}
   }
  }
}

\strong{DataCategory}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_datacategory.htm}{Salesforce Documentation for DataCategory}
\describe{
 \item{dataCategory}{a DataCategory}
 \item{label}{a character}
 \item{name}{a character}
}

\strong{DataCategoryGroup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_datacategorygroup.htm}{Salesforce Documentation for DataCategoryGroup}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{dataCategory}{a DataCategory}
 \item{description}{a character}
 \item{label}{a character}
 \item{objectUsage}{a ObjectUsage}
}

\strong{DataPipeline}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_datapipeline.htm}{Salesforce Documentation for DataPipeline}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{apiVersion}{a numeric}
 \item{label}{a character}
 \item{scriptType}{a DataPipelineType - which is a character taking one of the following values: 
   \itemize{
     \item{Pig}
   }
  }
}

\strong{DefaultShortcut}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_defaultshortcut.htm}{Salesforce Documentation for DefaultShortcut}
\describe{
 \item{action}{a character}
 \item{active}{a character either 'true' or 'false'}
 \item{keyCommand}{a character}
}

\strong{DelegateGroup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_delegategroup.htm}{Salesforce Documentation for DelegateGroup}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customObjects}{a character}
 \item{groups}{a character}
 \item{label}{a character}
 \item{loginAccess}{a character either 'true' or 'false'}
 \item{permissionSets}{a character}
 \item{profiles}{a character}
 \item{roles}{a character}
}

\strong{DeployDetails}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_deploydetails.htm}{Salesforce Documentation for DeployDetails}
\describe{
 \item{componentFailures}{a DeployMessage}
 \item{componentSuccesses}{a DeployMessage}
 \item{retrieveResult}{a RetrieveResult}
 \item{runTestResult}{a RunTestsResult}
}

\strong{DeployOptions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_deployoptions.htm}{Salesforce Documentation for DeployOptions}
\describe{
 \item{allowMissingFiles}{a character either 'true' or 'false'}
 \item{autoUpdatePackage}{a character either 'true' or 'false'}
 \item{checkOnly}{a character either 'true' or 'false'}
 \item{ignoreWarnings}{a character either 'true' or 'false'}
 \item{performRetrieve}{a character either 'true' or 'false'}
 \item{purgeOnDelete}{a character either 'true' or 'false'}
 \item{rollbackOnError}{a character either 'true' or 'false'}
 \item{runTests}{a character}
 \item{singlePackage}{a character either 'true' or 'false'}
 \item{testLevel}{a TestLevel - which is a character taking one of the following values: 
   \itemize{
     \item{NoTestRun}
     \item{RunSpecifiedTests}
     \item{RunLocalTests}
     \item{RunAllTestsInOrg}
   }
  }
}

\strong{DescribeMetadataObject}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_describemetadataobject.htm}{Salesforce Documentation for DescribeMetadataObject}
\describe{
 \item{childXmlNames}{a character}
 \item{directoryName}{a character}
 \item{inFolder}{a character either 'true' or 'false'}
 \item{metaFile}{a character either 'true' or 'false'}
 \item{suffix}{a character}
 \item{xmlName}{a character}
}

\strong{Document}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_document.htm}{Salesforce Documentation for Document}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{description}{a character}
 \item{internalUseOnly}{a character either 'true' or 'false'}
 \item{keywords}{a character}
 \item{name}{a character}
 \item{public}{a character either 'true' or 'false'}
}

\strong{DocumentFolder}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_documentfolder.htm}{Salesforce Documentation for DocumentFolder}
\describe{
 \item{accessType}{a FolderAccessTypes (inherited from Folder)}
 \item{folderShares}{a FolderShare (inherited from Folder)}
 \item{name}{a character (inherited from Folder)}
 \item{publicFolderAccess}{a PublicFolderAccess (inherited from Folder)}
 \item{sharedTo}{a SharedTo (inherited from Folder)}
}

\strong{DuplicateRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_duplicaterule.htm}{Salesforce Documentation for DuplicateRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionOnInsert}{a DupeActionType - which is a character taking one of the following values: 
   \itemize{
     \item{Allow}
     \item{Block}
   }
  }
 \item{actionOnUpdate}{a DupeActionType - which is a character taking one of the following values: 
   \itemize{
     \item{Allow}
     \item{Block}
   }
  }
 \item{alertText}{a character}
 \item{description}{a character}
 \item{duplicateRuleFilter}{a DuplicateRuleFilter}
 \item{duplicateRuleMatchRules}{a DuplicateRuleMatchRule}
 \item{isActive}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{operationsOnInsert}{a character}
 \item{operationsOnUpdate}{a character}
 \item{securityOption}{a DupeSecurityOptionType - which is a character taking one of the following values: 
   \itemize{
     \item{EnforceSharingRules}
     \item{BypassSharingRules}
   }
  }
 \item{sortOrder}{a integer}
}

\strong{DuplicateRuleFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_duplicaterulefilter.htm}{Salesforce Documentation for DuplicateRuleFilter}
\describe{
 \item{booleanFilter}{a character}
 \item{duplicateRuleFilterItems}{a DuplicateRuleFilterItem}
}

\strong{DuplicateRuleFilterItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_duplicaterulefilteritem.htm}{Salesforce Documentation for DuplicateRuleFilterItem}
\describe{
 \item{field}{a character (inherited from FilterItem)}
 \item{operation}{a FilterOperation (inherited from FilterItem)}
 \item{value}{a character (inherited from FilterItem)}
 \item{valueField}{a character (inherited from FilterItem)}
 \item{sortOrder}{a integer}
 \item{table}{a character}
}

\strong{DuplicateRuleMatchRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_duplicaterulematchrule.htm}{Salesforce Documentation for DuplicateRuleMatchRule}
\describe{
 \item{matchRuleSObjectType}{a character}
 \item{matchingRule}{a character}
 \item{objectMapping}{a ObjectMapping}
}

\strong{EclairGeoData}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_eclairgeodata.htm}{Salesforce Documentation for EclairGeoData}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{maps}{a EclairMap}
 \item{masterLabel}{a character}
}

\strong{EclairMap}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_eclairmap.htm}{Salesforce Documentation for EclairMap}
\describe{
 \item{boundingBoxBottom}{a numeric}
 \item{boundingBoxLeft}{a numeric}
 \item{boundingBoxRight}{a numeric}
 \item{boundingBoxTop}{a numeric}
 \item{mapLabel}{a character}
 \item{mapName}{a character}
 \item{projection}{a character}
}

\strong{EmailFolder}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_emailfolder.htm}{Salesforce Documentation for EmailFolder}
\describe{
 \item{accessType}{a FolderAccessTypes (inherited from Folder)}
 \item{folderShares}{a FolderShare (inherited from Folder)}
 \item{name}{a character (inherited from Folder)}
 \item{publicFolderAccess}{a PublicFolderAccess (inherited from Folder)}
 \item{sharedTo}{a SharedTo (inherited from Folder)}
}

\strong{EmailServicesAddress}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_emailservicesaddress.htm}{Salesforce Documentation for EmailServicesAddress}
\describe{
 \item{authorizedSenders}{a character}
 \item{developerName}{a character}
 \item{isActive}{a character either 'true' or 'false'}
 \item{localPart}{a character}
 \item{runAsUser}{a character}
}

\strong{EmailServicesFunction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_emailservicesfunction.htm}{Salesforce Documentation for EmailServicesFunction}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{apexClass}{a character}
 \item{attachmentOption}{a EmailServicesAttOptions - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{TextOnly}
     \item{BinaryOnly}
     \item{All}
     \item{NoContent}
   }
  }
 \item{authenticationFailureAction}{a EmailServicesErrorAction - which is a character taking one of the following values: 
   \itemize{
     \item{UseSystemDefault}
     \item{Bounce}
     \item{Discard}
     \item{Requeue}
   }
  }
 \item{authorizationFailureAction}{a EmailServicesErrorAction - which is a character taking one of the following values: 
   \itemize{
     \item{UseSystemDefault}
     \item{Bounce}
     \item{Discard}
     \item{Requeue}
   }
  }
 \item{authorizedSenders}{a character}
 \item{emailServicesAddresses}{a EmailServicesAddress}
 \item{errorRoutingAddress}{a character}
 \item{functionInactiveAction}{a EmailServicesErrorAction - which is a character taking one of the following values: 
   \itemize{
     \item{UseSystemDefault}
     \item{Bounce}
     \item{Discard}
     \item{Requeue}
   }
  }
 \item{functionName}{a character}
 \item{isActive}{a character either 'true' or 'false'}
 \item{isAuthenticationRequired}{a character either 'true' or 'false'}
 \item{isErrorRoutingEnabled}{a character either 'true' or 'false'}
 \item{isTextAttachmentsAsBinary}{a character either 'true' or 'false'}
 \item{isTlsRequired}{a character either 'true' or 'false'}
 \item{overLimitAction}{a EmailServicesErrorAction - which is a character taking one of the following values: 
   \itemize{
     \item{UseSystemDefault}
     \item{Bounce}
     \item{Discard}
     \item{Requeue}
   }
  }
}

\strong{EmailTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_emailtemplate.htm}{Salesforce Documentation for EmailTemplate}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{apiVersion}{a numeric}
 \item{attachedDocuments}{a character}
 \item{attachments}{a Attachment}
 \item{available}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{encodingKey}{a Encoding - which is a character taking one of the following values: 
   \itemize{
     \item{UTF-8}
     \item{ISO-8859-1}
     \item{Shift_JIS}
     \item{ISO-2022-JP}
     \item{EUC-JP}
     \item{ks_c_5601-1987}
     \item{Big5}
     \item{GB2312}
     \item{Big5-HKSCS}
     \item{x-SJIS_0213}
   }
  }
 \item{letterhead}{a character}
 \item{name}{a character}
 \item{packageVersions}{a PackageVersion}
 \item{relatedEntityType}{a character}
 \item{style}{a EmailTemplateStyle - which is a character taking one of the following values: 
   \itemize{
     \item{none}
     \item{freeForm}
     \item{formalLetter}
     \item{promotionRight}
     \item{promotionLeft}
     \item{newsletter}
     \item{products}
   }
  }
 \item{subject}{a character}
 \item{textOnly}{a character}
 \item{type}{a EmailTemplateType - which is a character taking one of the following values: 
   \itemize{
     \item{text}
     \item{html}
     \item{custom}
     \item{visualforce}
   }
  }
 \item{uiType}{a EmailTemplateUiType - which is a character taking one of the following values: 
   \itemize{
     \item{Aloha}
     \item{SFX}
     \item{SFX_Sample}
   }
  }
}

\strong{EmailToCaseRoutingAddress}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_emailtocaseroutingaddress.htm}{Salesforce Documentation for EmailToCaseRoutingAddress}
\describe{
 \item{addressType}{a EmailToCaseRoutingAddressType - which is a character taking one of the following values: 
   \itemize{
     \item{EmailToCase}
     \item{Outlook}
   }
  }
 \item{authorizedSenders}{a character}
 \item{caseOrigin}{a character}
 \item{caseOwner}{a character}
 \item{caseOwnerType}{a character}
 \item{casePriority}{a character}
 \item{createTask}{a character either 'true' or 'false'}
 \item{emailAddress}{a character}
 \item{emailServicesAddress}{a character}
 \item{isVerified}{a character either 'true' or 'false'}
 \item{routingName}{a character}
 \item{saveEmailHeaders}{a character either 'true' or 'false'}
 \item{taskStatus}{a character}
}

\strong{EmailToCaseSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_emailtocasesettings.htm}{Salesforce Documentation for EmailToCaseSettings}
\describe{
 \item{enableE2CSourceTracking}{a character either 'true' or 'false'}
 \item{enableEmailToCase}{a character either 'true' or 'false'}
 \item{enableHtmlEmail}{a character either 'true' or 'false'}
 \item{enableOnDemandEmailToCase}{a character either 'true' or 'false'}
 \item{enableThreadIDInBody}{a character either 'true' or 'false'}
 \item{enableThreadIDInSubject}{a character either 'true' or 'false'}
 \item{notifyOwnerOnNewCaseEmail}{a character either 'true' or 'false'}
 \item{overEmailLimitAction}{a EmailToCaseOnFailureActionType - which is a character taking one of the following values: 
   \itemize{
     \item{Bounce}
     \item{Discard}
     \item{Requeue}
   }
  }
 \item{preQuoteSignature}{a character either 'true' or 'false'}
 \item{routingAddresses}{a EmailToCaseRoutingAddress}
 \item{unauthorizedSenderAction}{a EmailToCaseOnFailureActionType - which is a character taking one of the following values: 
   \itemize{
     \item{Bounce}
     \item{Discard}
     \item{Requeue}
   }
  }
}

\strong{EmbeddedServiceBranding}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_embeddedservicebranding.htm}{Salesforce Documentation for EmbeddedServiceBranding}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{contrastInvertedColor}{a character}
 \item{contrastPrimaryColor}{a character}
 \item{embeddedServiceConfig}{a character}
 \item{font}{a character}
 \item{masterLabel}{a character}
 \item{navBarColor}{a character}
 \item{primaryColor}{a character}
 \item{secondaryColor}{a character}
}

\strong{EmbeddedServiceConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_embeddedserviceconfig.htm}{Salesforce Documentation for EmbeddedServiceConfig}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{masterLabel}{a character}
 \item{site}{a character}
}

\strong{EmbeddedServiceFieldService}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_embeddedservicefieldservice.htm}{Salesforce Documentation for EmbeddedServiceFieldService}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{appointmentBookingFlowName}{a character}
 \item{cancelApptBookingFlowName}{a character}
 \item{embeddedServiceConfig}{a character}
 \item{enabled}{a character either 'true' or 'false'}
 \item{fieldServiceConfirmCardImg}{a character}
 \item{fieldServiceHomeImg}{a character}
 \item{fieldServiceLogoImg}{a character}
 \item{masterLabel}{a character}
 \item{modifyApptBookingFlowName}{a character}
 \item{shouldShowExistingAppointment}{a character either 'true' or 'false'}
 \item{shouldShowNewAppointment}{a character either 'true' or 'false'}
}

\strong{EmbeddedServiceLiveAgent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_embeddedserviceliveagent.htm}{Salesforce Documentation for EmbeddedServiceLiveAgent}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{avatarImg}{a character}
 \item{customPrechatComponent}{a character}
 \item{embeddedServiceConfig}{a character}
 \item{embeddedServiceQuickActions}{a EmbeddedServiceQuickAction}
 \item{enabled}{a character either 'true' or 'false'}
 \item{fontSize}{a EmbeddedServiceFontSize - which is a character taking one of the following values: 
   \itemize{
     \item{Small}
     \item{Medium}
     \item{Large}
   }
  }
 \item{headerBackgroundImg}{a character}
 \item{liveAgentChatUrl}{a character}
 \item{liveAgentContentUrl}{a character}
 \item{liveChatButton}{a character}
 \item{liveChatDeployment}{a character}
 \item{masterLabel}{a character}
 \item{prechatBackgroundImg}{a character}
 \item{prechatEnabled}{a character either 'true' or 'false'}
 \item{prechatJson}{a character}
 \item{scenario}{a EmbeddedServiceScenario - which is a character taking one of the following values: 
   \itemize{
     \item{Sales}
     \item{Service}
     \item{Basic}
   }
  }
 \item{smallCompanyLogoImg}{a character}
 \item{waitingStateBackgroundImg}{a character}
}

\strong{EmbeddedServiceQuickAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_embeddedservicequickaction.htm}{Salesforce Documentation for EmbeddedServiceQuickAction}
\describe{
 \item{embeddedServiceLiveAgent}{a character}
 \item{order}{a integer}
 \item{quickActionDefinition}{a character}
}

\strong{EntitlementProcess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_entitlementprocess.htm}{Salesforce Documentation for EntitlementProcess}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{SObjectType}{a character}
 \item{active}{a character either 'true' or 'false'}
 \item{businessHours}{a character}
 \item{description}{a character}
 \item{entryStartDateField}{a character}
 \item{exitCriteriaBooleanFilter}{a character}
 \item{exitCriteriaFilterItems}{a FilterItem}
 \item{exitCriteriaFormula}{a character}
 \item{isRecordTypeApplied}{a character either 'true' or 'false'}
 \item{isVersionDefault}{a character either 'true' or 'false'}
 \item{milestones}{a EntitlementProcessMilestoneItem}
 \item{name}{a character}
 \item{recordType}{a character}
 \item{versionMaster}{a character}
 \item{versionNotes}{a character}
 \item{versionNumber}{a integer}
}

\strong{EntitlementProcessMilestoneItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_entitlementprocessmilestoneitem.htm}{Salesforce Documentation for EntitlementProcessMilestoneItem}
\describe{
 \item{businessHours}{a character}
 \item{criteriaBooleanFilter}{a character}
 \item{milestoneCriteriaFilterItems}{a FilterItem}
 \item{milestoneCriteriaFormula}{a character}
 \item{milestoneName}{a character}
 \item{minutesCustomClass}{a character}
 \item{minutesToComplete}{a integer}
 \item{successActions}{a WorkflowActionReference}
 \item{timeTriggers}{a EntitlementProcessMilestoneTimeTrigger}
 \item{useCriteriaStartTime}{a character either 'true' or 'false'}
}

\strong{EntitlementProcessMilestoneTimeTrigger}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_entitlementprocessmilestonetimetrigger.htm}{Salesforce Documentation for EntitlementProcessMilestoneTimeTrigger}
\describe{
 \item{actions}{a WorkflowActionReference}
 \item{timeLength}{a integer}
 \item{workflowTimeTriggerUnit}{a MilestoneTimeUnits - which is a character taking one of the following values: 
   \itemize{
     \item{Minutes}
     \item{Hours}
     \item{Days}
   }
  }
}

\strong{EntitlementSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_entitlementsettings.htm}{Salesforce Documentation for EntitlementSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{assetLookupLimitedToActiveEntitlementsOnAccount}{a character either 'true' or 'false'}
 \item{assetLookupLimitedToActiveEntitlementsOnContact}{a character either 'true' or 'false'}
 \item{assetLookupLimitedToSameAccount}{a character either 'true' or 'false'}
 \item{assetLookupLimitedToSameContact}{a character either 'true' or 'false'}
 \item{enableEntitlementVersioning}{a character either 'true' or 'false'}
 \item{enableEntitlements}{a character either 'true' or 'false'}
 \item{entitlementLookupLimitedToActiveStatus}{a character either 'true' or 'false'}
 \item{entitlementLookupLimitedToSameAccount}{a character either 'true' or 'false'}
 \item{entitlementLookupLimitedToSameAsset}{a character either 'true' or 'false'}
 \item{entitlementLookupLimitedToSameContact}{a character either 'true' or 'false'}
}

\strong{EntitlementTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_entitlementtemplate.htm}{Salesforce Documentation for EntitlementTemplate}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{businessHours}{a character}
 \item{casesPerEntitlement}{a integer}
 \item{entitlementProcess}{a character}
 \item{isPerIncident}{a character either 'true' or 'false'}
 \item{term}{a integer}
 \item{type}{a character}
}

\strong{EscalationAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_escalationaction.htm}{Salesforce Documentation for EscalationAction}
\describe{
 \item{assignedTo}{a character}
 \item{assignedToTemplate}{a character}
 \item{assignedToType}{a AssignToLookupValueType - which is a character taking one of the following values: 
   \itemize{
     \item{User}
     \item{Queue}
   }
  }
 \item{minutesToEscalation}{a integer}
 \item{notifyCaseOwner}{a character either 'true' or 'false'}
 \item{notifyEmail}{a character}
 \item{notifyTo}{a character}
 \item{notifyToTemplate}{a character}
}

\strong{EscalationRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_escalationrule.htm}{Salesforce Documentation for EscalationRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{ruleEntry}{a RuleEntry}
}

\strong{EscalationRules}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_escalationrules.htm}{Salesforce Documentation for EscalationRules}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{escalationRule}{a EscalationRule}
}

\strong{EventDelivery}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_eventdelivery.htm}{Salesforce Documentation for EventDelivery}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{eventParameters}{a EventParameterMap}
 \item{eventSubscription}{a character}
 \item{referenceData}{a character}
 \item{type}{a EventDeliveryType - which is a character taking one of the following values: 
   \itemize{
     \item{StartFlow}
     \item{ResumeFlow}
   }
  }
}

\strong{EventParameterMap}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_eventparametermap.htm}{Salesforce Documentation for EventParameterMap}
\describe{
 \item{parameterName}{a character}
 \item{parameterValue}{a character}
}

\strong{EventSubscription}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_eventsubscription.htm}{Salesforce Documentation for EventSubscription}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{eventParameters}{a EventParameterMap}
 \item{eventType}{a character}
 \item{referenceData}{a character}
}

\strong{ExtendedErrorDetails}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_extendederrordetails.htm}{Salesforce Documentation for ExtendedErrorDetails}
\describe{
 \item{extendedErrorCode}{a ExtendedErrorCode - which is a character taking one of the following values: 
   \itemize{
     \item{ACTIONCALL_DUPLICATE_INPUT_PARAM - Errors with this extended error code have the following properties:
actionCallName, parameterName}
     \item{ACTIONCALL_DUPLICATE_OUTPUT_PARAM - Errors with this extended error code have the following properties:
actionCallName, parameterName}
     \item{ACTIONCALL_MISSING_NAME - Errors with this extended error code have the following properties:}
     \item{ACTIONCALL_MISSING_REQUIRED_PARAM - Errors with this extended error code have the following properties:
actionCallName, parameterName}
     \item{ACTIONCALL_MISSING_REQUIRED_TYPE - Errors with this extended error code have the following properties:
actionCallName}
     \item{ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE - Errors with this extended error code have the following properties:}
     \item{ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE - Errors with this extended error code have the following properties:
processType}
     \item{APEXCALLOUT_INPUT_DUPLICATE - Errors with this extended error code have the following properties:
apexClassName, parameterName}
     \item{APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
apexClassName, parameterName}
     \item{APEXCALLOUT_INVALID - Errors with this extended error code have the following properties:
apexClassName}
     \item{APEXCALLOUT_MISSING_CLASSNAME - Errors with this extended error code have the following properties:
apexClassName}
     \item{APEXCALLOUT_NOT_FOUND - Errors with this extended error code have the following properties:
apexClassName}
     \item{APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
apexClassName, parameterName}
     \item{APEXCALLOUT_OUTPUT_NOT_FOUND - Errors with this extended error code have the following properties:
apexClassName, parameterName}
     \item{APEXCALLOUT_REQUIRED_INPUT_MISSING - Errors with this extended error code have the following properties:
apexClassName, parameterName}
     \item{APEXCLASS_MISSING_INTERFACE - Errors with this extended error code have the following properties:
apexClassName, parentScreenFieldName}
     \item{ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE - Errors with this extended error code have the following properties:
assignmentName, operatorName, elementName}
     \item{ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName, assignmentName, elementType}
     \item{ASSIGNMENTITEM_FIELD_INVALID_DATATYPE - Errors with this extended error code have the following properties:
fieldValue, dataType, incompatibleDataType}
     \item{ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT - Errors with this extended error code have the following properties:
elementName, acceptedDataType, dataType, fieldValue}
     \item{ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES - Errors with this extended error code have the following properties:
assignmentName, operatorName, leftElementName, leftElementType,
rightElementName, rightElementType}
     \item{ASSIGNMENTITEM_INVALID_COLLECTION - Errors with this extended error code have the following properties:
assignmentName, operatorName, leftElementName, rightElementName}
     \item{ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT - Errors with this extended error code have the following properties:
elementName, dataType, incompatibleDataType}
     \item{ASSIGNMENTITEM_INVALID_REFERENCE - Errors with this extended error code have the following properties:
parameterName, operatorName}
     \item{ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR - Errors with this extended error code have the following properties:
assignmentName, operatorName, dataType, elementName}
     \item{ASSIGNMENTITEM_MODIFIES_NONVARIABLE - Errors with this extended error code have the following properties:
assignmentName}
     \item{ASSIGNMENTITEM_NONEXISTENT_REFERENCE - Errors with this extended error code have the following properties:
parameterName, operatorName}
     \item{ASSIGNMENTITEM_REQUIRED - Errors with this extended error code have the following properties:
assignmentName}
     \item{ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR - Errors with this extended error code have the following properties:
elementName}
     \item{AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED - Errors with this extended error code have the following properties:
choiceLookupName}
     \item{AUTOLAUNCHED_CHOICE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
choiceName}
     \item{AUTOLAUNCHED_SCREEN_NOT_SUPPORTED - Errors with this extended error code have the following properties:}
     \item{AUTOLAUNCHED_STEP_NOT_SUPPORTED - Errors with this extended error code have the following properties:}
     \item{AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE - Errors with this extended error code have the following properties:
subflowType}
     \item{AUTOLAUNCHED_WAIT_NOT_SUPPORTED - Errors with this extended error code have the following properties:}
     \item{CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND - Errors with this extended error code have the following properties:
screenFieldName}
     \item{CHOICEFIELD_MISSING_CHOICE - Errors with this extended error code have the following properties:
questionName}
     \item{CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD - Errors with this extended error code have the following properties:
choiceName, parentScreenFieldName}
     \item{CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD - Errors with this extended error code have the following properties:
choiceName, parentScreenFieldName}
     \item{CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE - Errors with this extended error code have the following properties:
elementName, screenFieldName}
     \item{CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD - Errors with this extended error code have the following properties:
choiceName}
     \item{CONDITION_DATATYPE_INCOMPATIBLE - Errors with this extended error code have the following properties:
leftElementName, leftElementType, operatorName, rightElementName,
rightElementType, ruleName}
     \item{CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT - Errors with this extended error code have the following properties:
elementName, dataType, operatorName, parameterName, ruleName}
     \item{CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE - Errors with this extended error code have the following properties:
elementName, leftElementType, operatorName, rightElementType, ruleName}
     \item{CONDITION_INVALID_LEFTOPERAND - Errors with this extended error code have the following properties: ruleName}
     \item{CONDITION_INVALID_LEFT_ELEMENT - Errors with this extended error code have the following properties:
elementName, dataType, operatorName, parameterName, ruleName}
     \item{CONDITION_LOGIC_EXCEEDS_LIMIT - Errors with this extended error code have the following properties:
elementName, characterLimit}
     \item{CONDITION_LOGIC_INVALID - Errors with this extended error code have the following properties:
elementName}
     \item{CONDITION_LOGIC_MISSING - Errors with this extended error code have the following properties:
elementName}
     \item{CONDITION_MISSING_DATATYPE - Errors with this extended error code have the following properties:
elementName, dataType, operatorName, parameterName, ruleName}
     \item{CONDITION_MISSING_OPERATOR - Errors with this extended error code have the following properties: ruleName}
     \item{CONDITION_REFERENCED_ELEMENT_NOT_FOUND - Errors with this extended error code have the following properties: ruleName}
     \item{CONDITION_RIGHTOPERAND_NULL - Errors with this extended error code have the following properties: ruleName}
     \item{CONNECTOR_MISSING_TARGET - Errors with this extended error code have the following properties:
elementName}
     \item{CONSTANT_INCLUDES_REFERENCES - Errors with this extended error code have the following properties:
constantName}
     \item{CUSTOMEVENTS_NOT_ENABLED - Errors with this extended error code have the following properties:}
     \item{CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES - Errors with this extended error code have the following properties:}
     \item{CUSTOMEVENT_OBJECTTYPE_NOT_FOUND - Errors with this extended error code have the following properties:
objectType}
     \item{CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
objectType}
     \item{CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME - Errors with this extended error code have the following properties:
metadataValue}
     \item{CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME - Errors with this extended error code have the following properties:
metadataValue}
     \item{DATATYPE_INVALID - Errors with this extended error code have the following properties:
elementName, dataType}
     \item{DATATYPE_MISSING - Errors with this extended error code have the following properties:
elementName}
     \item{DECISION_DEFAULT_CONNECTOR_MISSING_LABEL - Errors with this extended error code have the following properties:
flowDecision}
     \item{DECISION_MISSING_OUTCOME - Errors with this extended error code have the following properties:
flowDecision}
     \item{ELEMENT_CONNECTS_TO_SELF - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_COORDINATES_INVALID - Errors with this extended error code have the following properties:
coordinateLimit, coordinateName}
     \item{ELEMENT_INVALID_CONNECTOR - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_INVALID_REFERENCE - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_MISSING_CONNECTOR - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_MISSING_LABEL - Errors with this extended error code have the following properties:
characterLimit, elementName}
     \item{ELEMENT_MISSING_NAME - Errors with this extended error code have the following properties:
characterLimit}
     \item{ELEMENT_MISSING_REFERENCE - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_MORE_THAN_ONE_FIELD - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_NAME_INVALID - Errors with this extended error code have the following properties:}
     \item{ELEMENT_NEVER_USED - Errors with this extended error code have the following properties:
elementName}
     \item{ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE - Errors with this extended error code have the following properties:
elementName}
     \item{EXTERNAL_OBJECTS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
objectName}
     \item{EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldReference}
     \item{FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
fieldName, elementName}
     \item{FIELDASSIGNMENT_INVALID_DATATYPE - Errors with this extended error code have the following properties:
fieldName, elementName, assignmentName}
     \item{FIELDASSIGNMENT_INVALID_ELEMENT - Errors with this extended error code have the following properties:
fieldName, elementName, elementType}
     \item{FIELDASSIGNMENT_INVALID_REFERENCE - Errors with this extended error code have the following properties:
fieldName, parameterName}
     \item{FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD - Errors with this extended error code have the following properties:
fieldName}
     \item{FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
fieldName, dataType}
     \item{FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE - Errors with this extended error code have the following properties:
fieldName, elementName, elementType}
     \item{FIELDSERVICE_UNSUPPORTED_FIELD_TYPE - Errors with this extended error code have the following properties:
elementName}
     \item{FIELD_INVALID_VALUE - Errors with this extended error code have the following properties:
fieldName, parameterName}
     \item{FIELD_NOT_FOUND - Errors with this extended error code have the following properties:
objectName, fieldName}
     \item{FIELD_RELATIONSHIP_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldRelationshipName}
     \item{FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION - Errors with this extended error code have the following properties:
componentName, propertyName, propertyType, errorCode, invalidTokens}
     \item{FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION - Errors with this extended error code have the following properties:
componentName, propertyName, propertyType, errorIdentifier, errorParams}
     \item{FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED - Errors with this extended error code have the following properties:
componentName, propertyName, propertyType}
     \item{FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG - Errors with this extended error code have the following properties:
componentName, propertyName, propertyType, maxLength}
     \item{FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION - Errors with this extended error code have the following properties:}
     \item{FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION - Errors with this extended error code have the following properties:
componentName, criterionIndex}
     \item{FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION - Errors with this extended error code have the following properties:
componentName, propertyName, propertyType, invalidValue}
     \item{FLOW_INCLUDES_STEP - Errors with this extended error code have the following properties:
elementName}
     \item{FLOW_NAME_USED_IN_OTHER_CLIENT - Errors with this extended error code have the following properties: flowName}
     \item{FLOW_STAGE_INCLUDES_REFERENCES - Errors with this extended error code have the following properties:
stageName}
     \item{FORMULA_EXPRESSION_INVALID - Errors with this extended error code have the following properties:
formulaExpression}
     \item{INPUTPARAM_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
parameterName}
     \item{INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE - Errors with this extended error code have the following properties:
parameterName}
     \item{INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE - Errors with this extended error code have the following properties:
parameterName}
     \item{INPUTPARAM_MISMATCHED_OBJECTTYPE - Errors with this extended error code have the following properties:
parameterName}
     \item{INVALID_FLOW - Errors with this extended error code have the following properties:}
     \item{INVALID_SURVEY_VARIABLE_NAME_OR_TYPE - Errors with this extended error code have the following properties:
surveyName}
     \item{LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE - Errors with this extended error code have the following properties:
elementName}
     \item{LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE - Errors with this extended error code have the following properties:
elementName}
     \item{LOOP_ASSIGNNEXTVALUETO_MISSING - Errors with this extended error code have the following properties:
elementName}
     \item{LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE - Errors with this extended error code have the following properties:
elementName}
     \item{LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND - Errors with this extended error code have the following properties:
fieldRelationshipName}
     \item{LOOP_COLLECTION_ELEMENT_NOT_FOUND - Errors with this extended error code have the following properties:
elementName}
     \item{LOOP_COLLECTION_NOT_FOUND - Errors with this extended error code have the following properties:
elementName}
     \item{LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD - Errors with this extended error code have the following properties:
fieldName}
     \item{LOOP_MISSING_COLLECTION - Errors with this extended error code have the following properties:}
     \item{OBJECTTYPE_INVALID - Errors with this extended error code have the following properties:
objectType}
     \item{OBJECT_CANNOT_BE_CREATED - Errors with this extended error code have the following properties:
objectName}
     \item{OBJECT_CANNOT_BE_DELETED - Errors with this extended error code have the following properties:
objectName}
     \item{OBJECT_CANNOT_BE_QUERIED - Errors with this extended error code have the following properties:
objectName}
     \item{OBJECT_CANNOT_BE_UPDATED - Errors with this extended error code have the following properties:
objectName}
     \item{OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldName}
     \item{OBJECT_NOT_FOUND - Errors with this extended error code have the following properties:
objectName}
     \item{OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND - Errors with this extended error code have the following properties:
parameterName}
     \item{OUTPUTPARAM_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
parameterName}
     \item{OUTPUTPARAM_MISMATCHED_OBJECTTYPE - Errors with this extended error code have the following properties:
parameterName}
     \item{OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE - Errors with this extended error code have the following properties:
parameterName}
     \item{OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE - Errors with this extended error code have the following properties:
parameterName}
     \item{OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE - Errors with this extended error code have the following properties:
parameterName}
     \item{PARAM_DATATYPE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
parameterName}
     \item{PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE - Errors with this extended error code have the following properties:
processType, metadataValue}
     \item{PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT - Errors with this extended error code have the following properties:
metadataValue}
     \item{PROCESSTYPE_ELEMENT_NOT_SUPPORTED - Errors with this extended error code have the following properties:
processType, elementType}
     \item{PROCESSTYPE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
processType}
     \item{RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldName}
     \item{RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldName, objectName}
     \item{RECORDFILTER_INVALID_DATATYPE - Errors with this extended error code have the following properties:
fieldName, elementName, elementType, operatorName}
     \item{RECORDFILTER_INVALID_ELEMENT - Errors with this extended error code have the following properties:
fieldName, assignmentName, elementName, elementType}
     \item{RECORDFILTER_INVALID_OPERATOR - Errors with this extended error code have the following properties:
fieldName, operatorName}
     \item{RECORDFILTER_INVALID_REFERENCE - Errors with this extended error code have the following properties:
fieldName, operatorName}
     \item{RECORDFILTER_MISSING_DATATYPE - Errors with this extended error code have the following properties:
fieldName, elementName, elementType, operatorName}
     \item{RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD - Errors with this extended error code have the following properties:
fieldName}
     \item{RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
elementName}
     \item{RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND - Errors with this extended error code have the following properties:
elementName}
     \item{RECORDUPDATE_MISSING_FILTERS - Errors with this extended error code have the following properties:
objectName}
     \item{REFERENCED_ELEMENT_NOT_FOUND - Errors with this extended error code have the following properties:
elementName, mergeFieldReference}
     \item{RULE_MISSING_CONDITION - Errors with this extended error code have the following properties:
elementName, ruleName}
     \item{SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE - Errors with this extended error code have the following properties:
fieldName}
     \item{SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName}
     \item{SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL - Errors with this extended error code have the following properties:
elementName}
     \item{SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM - Errors with this extended error code have the following properties:
elementName, extensionName, parameterName}
     \item{SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM - Errors with this extended error code have the following properties:
elementName, extensionName, parameterName}
     \item{SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID - Errors with this extended error code have the following properties:
elementName, extensionName}
     \item{SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID - Errors with this extended error code have the following properties:
elementName, extensionName, parameterName}
     \item{SCREENFIELD_EXTENSION_NAME_INVALID - Errors with this extended error code have the following properties:
elementName, extensionName}
     \item{SCREENFIELD_EXTENSION_NAME_MISSING - Errors with this extended error code have the following properties:
elementName, fieldType}
     \item{SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName, fieldType}
     \item{SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID - Errors with this extended error code have the following properties:
elementName, extensionName, parameterName}
     \item{SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING - Errors with this extended error code have the following properties:
elementName, extensionName, parameterName}
     \item{SCREENFIELD_INPUTS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName, fieldType}
     \item{SCREENFIELD_INVALID_DATATYPE - Errors with this extended error code have the following properties:
dataType, fieldType}
     \item{SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED - Errors with this extended error code have the following properties:
choiceName}
     \item{SCREENFIELD_OUTPUTS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName, fieldType}
     \item{SCREENFIELD_TYPE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName, fieldType}
     \item{SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE - Errors with this extended error code have the following properties:
choiceName}
     \item{SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
elementName}
     \item{SCREENRULE_ACTION_INVALID_ATTRIBUTE - Errors with this extended error code have the following properties:
screenRuleName, attributeName}
     \item{SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION - Errors with this extended error code have the following properties:
screenRuleName, attributeName}
     \item{SCREENRULE_ACTION_INVALID_VALUE - Errors with this extended error code have the following properties:
screenRuleName, acceptedValues, actionValue}
     \item{SCREENRULE_ACTION_MISSING_ATTRIBUTE - Errors with this extended error code have the following properties:
screenRuleName}
     \item{SCREENRULE_ACTION_MISSING_FIELDREFERENCE - Errors with this extended error code have the following properties:
screenRuleName}
     \item{SCREENRULE_ACTION_MISSING_VALUE - Errors with this extended error code have the following properties:
screenRuleName}
     \item{SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD - Errors with this extended error code have the following properties:
screenRuleName, attributeName, fieldName}
     \item{SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN - Errors with this extended error code have the following properties:
screenRuleName, fieldValue}
     \item{SCREENRULE_MISSING_ACTION - Errors with this extended error code have the following properties:
screenRuleName}
     \item{SCREENRULE_NOT_SUPPORTED_IN_ORG - Errors with this extended error code have the following properties:}
     \item{SCREENRULE_SCREENFIELD_NOT_VISIBLE - Errors with this extended error code have the following properties:
fieldName}
     \item{SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG - Errors with this extended error code have the following properties:}
     \item{SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE - Errors with this extended error code have the following properties:}
     \item{SCREEN_CONTAINS_LIGHTNING_COMPONENT - Errors with this extended error code have the following properties:
elementName}
     \item{SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT - Errors with this extended error code have the following properties:}
     \item{SCREEN_MISSING_LABEL - Errors with this extended error code have the following properties:
characterLimit}
     \item{SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT - Errors with this extended error code have the following properties:
choiceName}
     \item{SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE - Errors with this extended error code have the following properties:
fieldName}
     \item{SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED - Errors with this extended error code have the following properties:
fieldName, requiredField}
     \item{SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED - Errors with this extended error code have the following properties:
fieldName, otherFieldName}
     \item{SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE - Errors with this extended error code have the following properties:
fieldName, fieldValue}
     \item{SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE - Errors with this extended error code have the following properties:
objectType, sobjectName}
     \item{SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldName, objectType}
     \item{SORT_FIELD_MISSING - Errors with this extended error code have the following properties:
sortOrder}
     \item{SORT_FIELD_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldName, objectName}
     \item{SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED - Errors with this extended error code have the following properties:
fieldName, objectName}
     \item{SORT_LIMIT_INVALID - Errors with this extended error code have the following properties: maxLimit}
     \item{SORT_ORDER_MISSING - Errors with this extended error code have the following properties:
fieldName}
     \item{SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED - Errors with this extended error code have the following properties:
fieldName, fieldType, requiedField}
     \item{START_ELEMENT_MISSING - Errors with this extended error code have the following properties:}
     \item{SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED - Errors with this extended error code have the following properties: flowName}
     \item{SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES - Errors with this extended error code have the following properties:
subflowName, inputAssignmentNames}
     \item{SUBFLOW_INPUT_INVALID_VALUE - Errors with this extended error code have the following properties:
subflowName, inputAssignmentNames}
     \item{SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES - Errors with this extended error code have the following properties:
subflowName, inputParameterNames}
     \item{SUBFLOW_INPUT_MISMATCHED_OBJECTS - Errors with this extended error code have the following properties:
subflowName, inputParameterNames}
     \item{SUBFLOW_INPUT_MISSING_NAME - Errors with this extended error code have the following properties:
subflowName}
     \item{SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE - Errors with this extended error code have the following properties:
inputVariableName}
     \item{SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE - Errors with this extended error code have the following properties:
inputVariableName}
     \item{SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES - Errors with this extended error code have the following properties:
subflowName, inputAssignmentNames}
     \item{SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW - Errors with this extended error code have the following properties:
subflowName, inputAssignmentNames}
     \item{SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW - Errors with this extended error code have the following properties:
subflowName, inputAssignmentNames}
     \item{SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS - Errors with this extended error code have the following properties:
subflowName, inputAssignmentNames}
     \item{SUBFLOW_INVALID_NAME - Errors with this extended error code have the following properties:}
     \item{SUBFLOW_INVALID_REFERENCE - Errors with this extended error code have the following properties: flowName}
     \item{SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED - Errors with this extended error code have the following properties:
parentFlowName}
     \item{SUBFLOW_MISSING_NAME - Errors with this extended error code have the following properties:}
     \item{SUBFLOW_NO_ACTIVE_VERSION - Errors with this extended error code have the following properties:
subflowName, flowName}
     \item{SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES - Errors with this extended error code have the following properties:
subflowName, flowVersion, outputParameterNames}
     \item{SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES - Errors with this extended error code have the following properties:
subflowName, flowVersion, outputParameterNames}
     \item{SUBFLOW_OUTPUT_MISMATCHED_OBJECTS - Errors with this extended error code have the following properties:
subflowName, flowVersion, outputParameterNames}
     \item{SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE - Errors with this extended error code have the following properties:
outputAssignment}
     \item{SUBFLOW_OUTPUT_MISSING_NAME - Errors with this extended error code have the following properties:
subflowName}
     \item{SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE - Errors with this extended error code have the following properties:
outputVariableName}
     \item{SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE - Errors with this extended error code have the following properties:
outputAssignment}
     \item{SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW - Errors with this extended error code have the following properties:
subflowName, outputAssignmentName}
     \item{SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW - Errors with this extended error code have the following properties:
subflowName, variableName}
     \item{SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW - Errors with this extended error code have the following properties:
subflowName, flowVersion, outputParameterNames}
     \item{SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS - Errors with this extended error code have the following properties:
subflowName, variableName}
     \item{SUBFLOW_REFERENCES_MASTERFLOW - Errors with this extended error code have the following properties:}
     \item{SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION - Errors with this extended error code have the following properties:
choiceName}
     \item{SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS - Errors with this extended error code have the following properties:
choiceName}
     \item{SURVEY_INACTIVE_SUBFLOWS - Errors with this extended error code have the following properties:
subflowName}
     \item{SURVEY_MISSING_QUESTION_OR_SUBFLOW - Errors with this extended error code have the following properties:
surveyName}
     \item{SURVEY_MISSING_REQUIRED_VARIABLES - Errors with this extended error code have the following properties:
surveyName}
     \item{SURVEY_NESTED_SUBFLOWS - Errors with this extended error code have the following properties:
subflowName}
     \item{SURVEY_NONSURVEY_SUBFLOWS - Errors with this extended error code have the following properties:
subflowName}
     \item{SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION - Errors with this extended error code have the following properties:
elementName}
     \item{SURVEY_START_ELEMENT_INVALID - Errors with this extended error code have the following properties:}
     \item{SURVEY_VARIABLE_ACCESS_INVALID - Errors with this extended error code have the following properties:
surveyName}
     \item{UNEXPECTED_ERROR - Errors with this extended error code have the following properties:}
     \item{VALUE_CHAR_LIMIT_EXCEEDED - Errors with this extended error code have the following properties:
elementName, characterLimit}
     \item{VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE - Errors with this extended error code have the following properties:
fieldName, datatype}
     \item{VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION - Errors with this extended error code have the following properties:
fieldName, datatype}
     \item{VARIABLE_FIELD_REQUIRED_FOR_DATATYPE - Errors with this extended error code have the following properties:
datatype, fieldName}
     \item{VARIABLE_SCALE_EXCEEDS_LIMIT - Errors with this extended error code have the following properties:
elementName}
     \item{VARIABLE_SCALE_NEGATIVE_INTEGER - Errors with this extended error code have the following properties:
elementName}
     \item{VARIABLE_SCALE_NULL - Errors with this extended error code have the following properties:
elementName}
     \item{WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL - Errors with this extended error code have the following properties:
waitEventName}
     \item{WAITEVENT_DUPLICATE_INPUT_PARAM - Errors with this extended error code have the following properties:
parameterName}
     \item{WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE - Errors with this extended error code have the following properties:
waitEventName, inputParameterName}
     \item{WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE - Errors with this extended error code have the following properties:
waitEventName, parameterName}
     \item{WAITEVENT_INVALID_CONDITION_LOGIC - Errors with this extended error code have the following properties:
waitEventName}
     \item{WAITEVENT_MISSING - Errors with this extended error code have the following properties:}
     \item{WAITEVENT_MISSING_CONNECTOR - Errors with this extended error code have the following properties:
waitEventName}
     \item{WAITEVENT_MISSING_EVENTTYPE - Errors with this extended error code have the following properties:
waitEventName}
     \item{WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE - Errors with this extended error code have the following properties:
waitEventName}
     \item{WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE - Errors with this extended error code have the following properties:
waitEventName, outputParameter}
     \item{WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD - Errors with this extended error code have the following properties:
waitEventName, eventParameterName, incompatibleValue}
     \item{WAITEVENT_RELATIVEALARM_INVALID_FIELD - Errors with this extended error code have the following properties:
waitEventName, eventParameterName, incompatibleValue}
     \item{WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE - Errors with this extended error code have the following properties:
waitEventName, inputParameterName}
     \item{WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER - Errors with this extended error code have the following properties:
waitEventName, eventParameterName, incompatibleValue}
     \item{WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT - Errors with this extended error code have the following properties:
waitEventName, eventParameterName, incompatibleValue}
     \item{WAITEVENT_REQUIRED_INPUT_MISSING - Errors with this extended error code have the following properties:
waitEventName, parameterName}
     \item{WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED - Errors with this extended error code have the following properties:
waitEventName}
     \item{WORKFLOW_MISSING_PROCESSMETADATAVALUES - Errors with this extended error code have the following properties: flowName}
     \item{WORKFLOW_OBJECTTYPE_NOT_FOUND - Errors with this extended error code have the following properties:
objectType}
     \item{WORKFLOW_OBJECTTYPE_NOT_SUPPORTED - Errors with this extended error code have the following properties:
objectType}
     \item{WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE - Errors with this extended error code have the following properties:
objectVariableName, oldObjectVariableName}
     \item{WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT - Errors with this extended error code have the following properties:
objectType, objectVariableName}
     \item{WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT - Errors with this extended error code have the following properties:
objectType, oldObjectVariableName}
     \item{WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME - Errors with this extended error code have the following properties:
metadataValue}
     \item{WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME - Errors with this extended error code have the following properties:
metadataValue}
     \item{WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT - Errors with this extended error code have the following properties:
elementName}
     \item{WORKFLOW_TRIGGERTYPE_INVALID_VALUE - Errors with this extended error code have the following properties:}
   }
  }
}

\strong{ExternalDataSource}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_externaldatasource.htm}{Salesforce Documentation for ExternalDataSource}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{authProvider}{a character}
 \item{certificate}{a character}
 \item{customConfiguration}{a character}
 \item{endpoint}{a character}
 \item{isWritable}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{oauthRefreshToken}{a character}
 \item{oauthScope}{a character}
 \item{oauthToken}{a character}
 \item{password}{a character}
 \item{principalType}{a ExternalPrincipalType - which is a character taking one of the following values: 
   \itemize{
     \item{Anonymous}
     \item{PerUser}
     \item{NamedUser}
   }
  }
 \item{protocol}{a AuthenticationProtocol - which is a character taking one of the following values: 
   \itemize{
     \item{NoAuthentication}
     \item{Oauth}
     \item{Password}
   }
  }
 \item{repository}{a character}
 \item{type}{a ExternalDataSourceType - which is a character taking one of the following values: 
   \itemize{
     \item{Datacloud}
     \item{Datajourney}
     \item{OpenSearch}
     \item{Identity}
     \item{outgoingemail}
     \item{recommendation}
     \item{SfdcOrg}
     \item{OData}
     \item{OData4}
     \item{SimpleURL}
     \item{Wrapper}
   }
  }
 \item{username}{a character}
 \item{version}{a character}
}

\strong{ExternalServiceRegistration}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_externalserviceregistration.htm}{Salesforce Documentation for ExternalServiceRegistration}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{label}{a character}
 \item{namedCredential}{a character}
 \item{schema}{a character}
 \item{schemaType}{a character}
 \item{schemaUrl}{a character}
 \item{status}{a character}
}

\strong{FeedFilterCriterion}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_feedfiltercriterion.htm}{Salesforce Documentation for FeedFilterCriterion}
\describe{
 \item{feedItemType}{a FeedItemType - which is a character taking one of the following values: 
   \itemize{
     \item{TrackedChange}
     \item{UserStatus}
     \item{TextPost}
     \item{AdvancedTextPost}
     \item{LinkPost}
     \item{ContentPost}
     \item{PollPost}
     \item{RypplePost}
     \item{ProfileSkillPost}
     \item{DashboardComponentSnapshot}
     \item{ApprovalPost}
     \item{CaseCommentPost}
     \item{ReplyPost}
     \item{EmailMessageEvent}
     \item{CallLogPost}
     \item{ChangeStatusPost}
     \item{AttachArticleEvent}
     \item{MilestoneEvent}
     \item{ActivityEvent}
     \item{ChatTranscriptPost}
     \item{CollaborationGroupCreated}
     \item{CollaborationGroupUnarchived}
     \item{SocialPost}
     \item{QuestionPost}
     \item{FacebookPost}
     \item{BasicTemplateFeedItem}
     \item{CreateRecordEvent}
     \item{CanvasPost}
     \item{AnnouncementPost}
   }
  }
 \item{feedItemVisibility}{a FeedItemVisibility - which is a character taking one of the following values: 
   \itemize{
     \item{AllUsers}
     \item{InternalUsers}
   }
  }
 \item{relatedSObjectType}{a character}
}

\strong{FeedItemSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_feeditemsettings.htm}{Salesforce Documentation for FeedItemSettings}
\describe{
 \item{characterLimit}{a integer}
 \item{collapseThread}{a character either 'true' or 'false'}
 \item{displayFormat}{a FeedItemDisplayFormat - which is a character taking one of the following values: 
   \itemize{
     \item{Default}
     \item{HideBlankLines}
   }
  }
 \item{feedItemType}{a FeedItemType - which is a character taking one of the following values: 
   \itemize{
     \item{TrackedChange}
     \item{UserStatus}
     \item{TextPost}
     \item{AdvancedTextPost}
     \item{LinkPost}
     \item{ContentPost}
     \item{PollPost}
     \item{RypplePost}
     \item{ProfileSkillPost}
     \item{DashboardComponentSnapshot}
     \item{ApprovalPost}
     \item{CaseCommentPost}
     \item{ReplyPost}
     \item{EmailMessageEvent}
     \item{CallLogPost}
     \item{ChangeStatusPost}
     \item{AttachArticleEvent}
     \item{MilestoneEvent}
     \item{ActivityEvent}
     \item{ChatTranscriptPost}
     \item{CollaborationGroupCreated}
     \item{CollaborationGroupUnarchived}
     \item{SocialPost}
     \item{QuestionPost}
     \item{FacebookPost}
     \item{BasicTemplateFeedItem}
     \item{CreateRecordEvent}
     \item{CanvasPost}
     \item{AnnouncementPost}
   }
  }
}

\strong{FeedLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_feedlayout.htm}{Salesforce Documentation for FeedLayout}
\describe{
 \item{autocollapsePublisher}{a character either 'true' or 'false'}
 \item{compactFeed}{a character either 'true' or 'false'}
 \item{feedFilterPosition}{a FeedLayoutFilterPosition - which is a character taking one of the following values: 
   \itemize{
     \item{CenterDropDown}
     \item{LeftFixed}
     \item{LeftFloat}
   }
  }
 \item{feedFilters}{a FeedLayoutFilter}
 \item{fullWidthFeed}{a character either 'true' or 'false'}
 \item{hideSidebar}{a character either 'true' or 'false'}
 \item{highlightExternalFeedItems}{a character either 'true' or 'false'}
 \item{leftComponents}{a FeedLayoutComponent}
 \item{rightComponents}{a FeedLayoutComponent}
 \item{useInlineFiltersInConsole}{a character either 'true' or 'false'}
}

\strong{FeedLayoutComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_feedlayoutcomponent.htm}{Salesforce Documentation for FeedLayoutComponent}
\describe{
 \item{componentType}{a FeedLayoutComponentType - which is a character taking one of the following values: 
   \itemize{
     \item{HelpAndToolLinks}
     \item{CustomButtons}
     \item{Following}
     \item{Followers}
     \item{CustomLinks}
     \item{Milestones}
     \item{Topics}
     \item{CaseUnifiedFiles}
     \item{Visualforce}
   }
  }
 \item{height}{a integer}
 \item{page}{a character}
}

\strong{FeedLayoutFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_feedlayoutfilter.htm}{Salesforce Documentation for FeedLayoutFilter}
\describe{
 \item{feedFilterName}{a character}
 \item{feedFilterType}{a FeedLayoutFilterType - which is a character taking one of the following values: 
   \itemize{
     \item{AllUpdates}
     \item{FeedItemType}
     \item{Custom}
   }
  }
 \item{feedItemType}{a FeedItemType - which is a character taking one of the following values: 
   \itemize{
     \item{TrackedChange}
     \item{UserStatus}
     \item{TextPost}
     \item{AdvancedTextPost}
     \item{LinkPost}
     \item{ContentPost}
     \item{PollPost}
     \item{RypplePost}
     \item{ProfileSkillPost}
     \item{DashboardComponentSnapshot}
     \item{ApprovalPost}
     \item{CaseCommentPost}
     \item{ReplyPost}
     \item{EmailMessageEvent}
     \item{CallLogPost}
     \item{ChangeStatusPost}
     \item{AttachArticleEvent}
     \item{MilestoneEvent}
     \item{ActivityEvent}
     \item{ChatTranscriptPost}
     \item{CollaborationGroupCreated}
     \item{CollaborationGroupUnarchived}
     \item{SocialPost}
     \item{QuestionPost}
     \item{FacebookPost}
     \item{BasicTemplateFeedItem}
     \item{CreateRecordEvent}
     \item{CanvasPost}
     \item{AnnouncementPost}
   }
  }
}

\strong{FieldMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldmapping.htm}{Salesforce Documentation for FieldMapping}
\describe{
 \item{SObjectType}{a character}
 \item{developerName}{a character}
 \item{fieldMappingRows}{a FieldMappingRow}
 \item{masterLabel}{a character}
}

\strong{FieldMappingField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldmappingfield.htm}{Salesforce Documentation for FieldMappingField}
\describe{
 \item{dataServiceField}{a character}
 \item{dataServiceObjectName}{a character}
 \item{priority}{a integer}
}

\strong{FieldMappingRow}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldmappingrow.htm}{Salesforce Documentation for FieldMappingRow}
\describe{
 \item{SObjectType}{a character}
 \item{fieldMappingFields}{a FieldMappingField}
 \item{fieldName}{a character}
 \item{mappingOperation}{a MappingOperation - which is a character taking one of the following values: 
   \itemize{
     \item{Autofill}
     \item{Overwrite}
   }
  }
}

\strong{FieldOverride}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldoverride.htm}{Salesforce Documentation for FieldOverride}
\describe{
 \item{field}{a character}
 \item{formula}{a character}
 \item{literalValue}{a character}
}

\strong{FieldServiceSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldservicesettings.htm}{Salesforce Documentation for FieldServiceSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{fieldServiceNotificationsOrgPref}{a character either 'true' or 'false'}
 \item{fieldServiceOrgPref}{a character either 'true' or 'false'}
 \item{serviceAppointmentsDueDateOffsetOrgValue}{a integer}
 \item{workOrderLineItemSearchFields}{a character}
 \item{workOrderSearchFields}{a character}
}

\strong{FieldSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldset.htm}{Salesforce Documentation for FieldSet}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{availableFields}{a FieldSetItem}
 \item{description}{a character}
 \item{displayedFields}{a FieldSetItem}
 \item{label}{a character}
}

\strong{FieldSetItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldsetitem.htm}{Salesforce Documentation for FieldSetItem}
\describe{
 \item{field}{a character}
 \item{isFieldManaged}{a character either 'true' or 'false'}
 \item{isRequired}{a character either 'true' or 'false'}
}

\strong{FieldSetTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldsettranslation.htm}{Salesforce Documentation for FieldSetTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{FieldValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fieldvalue.htm}{Salesforce Documentation for FieldValue}
\describe{
 \item{name}{a character}
 \item{value}{a character that appears similar to any of the other accepted types (integer, numeric, date, datetime, boolean)}
}

\strong{FileProperties}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fileproperties.htm}{Salesforce Documentation for FileProperties}
\describe{
 \item{createdById}{a character}
 \item{createdByName}{a character}
 \item{createdDate}{a character formatted as 'yyyy-mm-ddThh:mm:ssZ'}
 \item{fileName}{a character}
 \item{fullName}{a character}
 \item{id}{a character}
 \item{lastModifiedById}{a character}
 \item{lastModifiedByName}{a character}
 \item{lastModifiedDate}{a character formatted as 'yyyy-mm-ddThh:mm:ssZ'}
 \item{manageableState}{a ManageableState - which is a character taking one of the following values: 
   \itemize{
     \item{released}
     \item{deleted}
     \item{deprecated}
     \item{installed}
     \item{beta}
     \item{unmanaged}
   }
  }
 \item{namespacePrefix}{a character}
 \item{type}{a character}
}

\strong{FileTypeDispositionAssignmentBean}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_filetypedispositionassignmentbean.htm}{Salesforce Documentation for FileTypeDispositionAssignmentBean}
\describe{
 \item{behavior}{a FileDownloadBehavior - which is a character taking one of the following values: 
   \itemize{
     \item{DOWNLOAD}
     \item{EXECUTE_IN_BROWSER}
     \item{HYBRID}
   }
  }
 \item{fileType}{a FileType - which is a character taking one of the following values: 
   \itemize{
     \item{UNKNOWN}
     \item{PDF}
     \item{POWER_POINT}
     \item{POWER_POINT_X}
     \item{POWER_POINT_M}
     \item{POWER_POINT_T}
     \item{WORD}
     \item{WORD_X}
     \item{WORD_M}
     \item{WORD_T}
     \item{PPS}
     \item{PPSX}
     \item{EXCEL}
     \item{EXCEL_X}
     \item{EXCEL_M}
     \item{EXCEL_T}
     \item{GOOGLE_DOCUMENT}
     \item{GOOGLE_PRESENTATION}
     \item{GOOGLE_SPREADSHEET}
     \item{GOOGLE_DRAWING}
     \item{GOOGLE_FORM}
     \item{GOOGLE_SCRIPT}
     \item{LINK}
     \item{SLIDE}
     \item{AAC}
     \item{ACGI}
     \item{AI}
     \item{AVI}
     \item{BMP}
     \item{BOXNOTE}
     \item{CSV}
     \item{EPS}
     \item{EXE}
     \item{FLASH}
     \item{GIF}
     \item{GZIP}
     \item{HTM}
     \item{HTML}
     \item{HTX}
     \item{JPEG}
     \item{JPE}
     \item{PJP}
     \item{PJPEG}
     \item{JFIF}
     \item{JPG}
     \item{JS}
     \item{MHTM}
     \item{MHTML}
     \item{MP3}
     \item{M4A}
     \item{M4V}
     \item{MP4}
     \item{MPEG}
     \item{MPG}
     \item{MOV}
     \item{MSG}
     \item{ODP}
     \item{ODS}
     \item{ODT}
     \item{OGV}
     \item{PNG}
     \item{PSD}
     \item{RTF}
     \item{QUIPDOC}
     \item{QUIPSHEET}
     \item{SHTM}
     \item{SHTML}
     \item{SNOTE}
     \item{STYPI}
     \item{SVG}
     \item{SVGZ}
     \item{TEXT}
     \item{THTML}
     \item{VISIO}
     \item{WMV}
     \item{WRF}
     \item{XML}
     \item{ZIP}
     \item{XZIP}
     \item{WMA}
     \item{XSN}
     \item{TRTF}
     \item{TXML}
     \item{WEBVIEW}
     \item{RFC822}
     \item{ASF}
     \item{DWG}
     \item{JAR}
     \item{XJS}
     \item{OPX}
     \item{XPSD}
     \item{TIF}
     \item{TIFF}
     \item{WAV}
     \item{CSS}
     \item{THUMB720BY480}
     \item{THUMB240BY180}
     \item{THUMB120BY90}
     \item{ALLTHUMBS}
     \item{PAGED_FLASH}
     \item{PACK}
     \item{C}
     \item{CPP}
     \item{WORDT}
     \item{INI}
     \item{JAVA}
     \item{LOG}
     \item{POWER_POINTT}
     \item{SQL}
     \item{XHTML}
     \item{EXCELT}
   }
  }
 \item{securityRiskFileType}{a character either 'true' or 'false'}
}

\strong{FileUploadAndDownloadSecuritySettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fileuploadanddownloadsecuritysettings.htm}{Salesforce Documentation for FileUploadAndDownloadSecuritySettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{dispositions}{a FileTypeDispositionAssignmentBean}
 \item{noHtmlUploadAsAttachment}{a character either 'true' or 'false'}
}

\strong{FilterItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_filteritem.htm}{Salesforce Documentation for FilterItem}
\describe{
 \item{field}{a character}
 \item{operation}{a FilterOperation - which is a character taking one of the following values: 
   \itemize{
     \item{equals}
     \item{notEqual}
     \item{lessThan}
     \item{greaterThan}
     \item{lessOrEqual}
     \item{greaterOrEqual}
     \item{contains}
     \item{notContain}
     \item{startsWith}
     \item{includes}
     \item{excludes}
     \item{within}
   }
  }
 \item{value}{a character}
 \item{valueField}{a character}
}

\strong{FindSimilarOppFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_findsimilaroppfilter.htm}{Salesforce Documentation for FindSimilarOppFilter}
\describe{
 \item{similarOpportunitiesDisplayColumns}{a character}
 \item{similarOpportunitiesMatchFields}{a character}
}

\strong{FiscalYearSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_fiscalyearsettings.htm}{Salesforce Documentation for FiscalYearSettings}
\describe{
 \item{fiscalYearNameBasedOn}{a character}
 \item{startMonth}{a character}
}

\strong{FlexiPage}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flexipage.htm}{Salesforce Documentation for FlexiPage}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{flexiPageRegions}{a FlexiPageRegion}
 \item{masterLabel}{a character}
 \item{parentFlexiPage}{a character}
 \item{platformActionlist}{a PlatformActionList}
 \item{quickActionList}{a QuickActionList}
 \item{sobjectType}{a character}
 \item{template}{a FlexiPageTemplateInstance}
 \item{type}{a FlexiPageType - which is a character taking one of the following values: 
   \itemize{
     \item{AppPage}
     \item{ObjectPage}
     \item{RecordPage}
     \item{HomePage}
     \item{MailAppAppPage}
     \item{CommAppPage}
     \item{CommForgotPasswordPage}
     \item{CommLoginPage}
     \item{CommObjectPage}
     \item{CommQuickActionCreatePage}
     \item{CommRecordPage}
     \item{CommRelatedListPage}
     \item{CommSearchResultPage}
     \item{CommGlobalSearchResultPage}
     \item{CommSelfRegisterPage}
     \item{CommThemeLayoutPage}
     \item{UtilityBar}
     \item{RecordPreview}
   }
  }
}

\strong{FlexiPageRegion}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flexipageregion.htm}{Salesforce Documentation for FlexiPageRegion}
\describe{
 \item{appendable}{a RegionFlagStatus - which is a character taking one of the following values: 
   \itemize{
     \item{disabled}
     \item{enabled}
   }
  }
 \item{componentInstances}{a ComponentInstance}
 \item{mode}{a FlexiPageRegionMode - which is a character taking one of the following values: 
   \itemize{
     \item{Append}
     \item{Prepend}
     \item{Replace}
   }
  }
 \item{name}{a character}
 \item{prependable}{a RegionFlagStatus - which is a character taking one of the following values: 
   \itemize{
     \item{disabled}
     \item{enabled}
   }
  }
 \item{replaceable}{a RegionFlagStatus - which is a character taking one of the following values: 
   \itemize{
     \item{disabled}
     \item{enabled}
   }
  }
 \item{type}{a FlexiPageRegionType - which is a character taking one of the following values: 
   \itemize{
     \item{Region}
     \item{Facet}
   }
  }
}

\strong{FlexiPageTemplateInstance}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flexipagetemplateinstance.htm}{Salesforce Documentation for FlexiPageTemplateInstance}
\describe{
 \item{name}{a character}
 \item{properties}{a ComponentInstanceProperty}
}

\strong{Flow}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flow.htm}{Salesforce Documentation for Flow}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionCalls}{a FlowActionCall}
 \item{apexPluginCalls}{a FlowApexPluginCall}
 \item{assignments}{a FlowAssignment}
 \item{choices}{a FlowChoice}
 \item{constants}{a FlowConstant}
 \item{decisions}{a FlowDecision}
 \item{description}{a character}
 \item{dynamicChoiceSets}{a FlowDynamicChoiceSet}
 \item{formulas}{a FlowFormula}
 \item{interviewLabel}{a character}
 \item{label}{a character}
 \item{loops}{a FlowLoop}
 \item{processMetadataValues}{a FlowMetadataValue}
 \item{processType}{a FlowProcessType - which is a character taking one of the following values: 
   \itemize{
     \item{AutoLaunchedFlow}
     \item{Flow}
     \item{Workflow}
     \item{CustomEvent}
     \item{InvocableProcess}
     \item{LoginFlow}
     \item{ActionPlan}
     \item{JourneyBuilderIntegration}
     \item{UserProvisioningFlow}
     \item{Survey}
     \item{FieldServiceMobile}
     \item{OrchestrationFlow}
     \item{FieldServiceWeb}
     \item{TransactionSecurityFlow}
   }
  }
 \item{recordCreates}{a FlowRecordCreate}
 \item{recordDeletes}{a FlowRecordDelete}
 \item{recordLookups}{a FlowRecordLookup}
 \item{recordUpdates}{a FlowRecordUpdate}
 \item{screens}{a FlowScreen}
 \item{stages}{a FlowStage}
 \item{startElementReference}{a character}
 \item{steps}{a FlowStep}
 \item{subflows}{a FlowSubflow}
 \item{textTemplates}{a FlowTextTemplate}
 \item{variables}{a FlowVariable}
 \item{waits}{a FlowWait}
}

\strong{FlowActionCall}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowactioncall.htm}{Salesforce Documentation for FlowActionCall}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{actionName}{a character}
 \item{actionType}{a InvocableActionType - which is a character taking one of the following values: 
   \itemize{
     \item{apex}
     \item{chatterPost}
     \item{contentWorkspaceEnableFolders}
     \item{emailAlert}
     \item{emailSimple}
     \item{flow}
     \item{metricRefresh}
     \item{quickAction}
     \item{submit}
     \item{thanks}
     \item{thunderResponse}
     \item{createServiceReport}
     \item{deployOrchestration}
     \item{createResponseEventAction}
     \item{generateWorkOrders}
     \item{deactivateSessionPermSet}
     \item{activateSessionPermSet}
     \item{aggregateValue}
     \item{orchestrationTimer}
     \item{orchestrationDebugLog}
     \item{choosePricebook}
     \item{localAction}
   }
  }
 \item{connector}{a FlowConnector}
 \item{faultConnector}{a FlowConnector}
 \item{inputParameters}{a FlowActionCallInputParameter}
 \item{outputParameters}{a FlowActionCallOutputParameter}
}

\strong{FlowActionCallInputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowactioncallinputparameter.htm}{Salesforce Documentation for FlowActionCallInputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{name}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowActionCallOutputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowactioncalloutputparameter.htm}{Salesforce Documentation for FlowActionCallOutputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{name}{a character}
}

\strong{FlowApexPluginCall}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowapexplugincall.htm}{Salesforce Documentation for FlowApexPluginCall}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{apexClass}{a character}
 \item{connector}{a FlowConnector}
 \item{faultConnector}{a FlowConnector}
 \item{inputParameters}{a FlowApexPluginCallInputParameter}
 \item{outputParameters}{a FlowApexPluginCallOutputParameter}
}

\strong{FlowApexPluginCallInputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowapexplugincallinputparameter.htm}{Salesforce Documentation for FlowApexPluginCallInputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{name}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowApexPluginCallOutputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowapexplugincalloutputparameter.htm}{Salesforce Documentation for FlowApexPluginCallOutputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{name}{a character}
}

\strong{FlowAssignment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowassignment.htm}{Salesforce Documentation for FlowAssignment}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{assignmentItems}{a FlowAssignmentItem}
 \item{connector}{a FlowConnector}
}

\strong{FlowAssignmentItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowassignmentitem.htm}{Salesforce Documentation for FlowAssignmentItem}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{operator}{a FlowAssignmentOperator - which is a character taking one of the following values: 
   \itemize{
     \item{Assign}
     \item{Add}
     \item{Subtract}
     \item{AddItem}
   }
  }
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowBaseElement}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowbaseelement.htm}{Salesforce Documentation for FlowBaseElement}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue}
}

\strong{FlowCategory}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowcategory.htm}{Salesforce Documentation for FlowCategory}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{flowCategoryItems}{a FlowCategoryItems}
 \item{masterLabel}{a character}
}

\strong{FlowCategoryItems}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowcategoryitems.htm}{Salesforce Documentation for FlowCategoryItems}
\describe{
 \item{flow}{a character}
}

\strong{FlowChoice}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowchoice.htm}{Salesforce Documentation for FlowChoice}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{choiceText}{a character}
 \item{dataType}{a FlowDataType - which is a character taking one of the following values: 
   \itemize{
     \item{Currency}
     \item{Date}
     \item{Number}
     \item{String}
     \item{Boolean}
     \item{SObject}
     \item{DateTime}
     \item{Picklist}
     \item{Multipicklist}
   }
  }
 \item{userInput}{a FlowChoiceUserInput}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowChoiceTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowchoicetranslation.htm}{Salesforce Documentation for FlowChoiceTranslation}
\describe{
 \item{choiceText}{a character}
 \item{name}{a character}
 \item{userInput}{a FlowChoiceUserInputTranslation}
}

\strong{FlowChoiceUserInput}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowchoiceuserinput.htm}{Salesforce Documentation for FlowChoiceUserInput}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{isRequired}{a character either 'true' or 'false'}
 \item{promptText}{a character}
 \item{validationRule}{a FlowInputValidationRule}
}

\strong{FlowChoiceUserInputTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowchoiceuserinputtranslation.htm}{Salesforce Documentation for FlowChoiceUserInputTranslation}
\describe{
 \item{promptText}{a character}
 \item{validationRule}{a FlowInputValidationRuleTranslation}
}

\strong{FlowCondition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowcondition.htm}{Salesforce Documentation for FlowCondition}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{leftValueReference}{a character}
 \item{operator}{a FlowComparisonOperator - which is a character taking one of the following values: 
   \itemize{
     \item{EqualTo}
     \item{NotEqualTo}
     \item{GreaterThan}
     \item{LessThan}
     \item{GreaterThanOrEqualTo}
     \item{LessThanOrEqualTo}
     \item{StartsWith}
     \item{EndsWith}
     \item{Contains}
     \item{IsNull}
     \item{WasSet}
     \item{WasSelected}
     \item{WasVisited}
   }
  }
 \item{rightValue}{a FlowElementReferenceOrValue}
}

\strong{FlowConnector}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowconnector.htm}{Salesforce Documentation for FlowConnector}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{targetReference}{a character}
}

\strong{FlowConstant}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowconstant.htm}{Salesforce Documentation for FlowConstant}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{dataType}{a FlowDataType - which is a character taking one of the following values: 
   \itemize{
     \item{Currency}
     \item{Date}
     \item{Number}
     \item{String}
     \item{Boolean}
     \item{SObject}
     \item{DateTime}
     \item{Picklist}
     \item{Multipicklist}
   }
  }
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowDecision}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowdecision.htm}{Salesforce Documentation for FlowDecision}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{defaultConnector}{a FlowConnector}
 \item{defaultConnectorLabel}{a character}
 \item{rules}{a FlowRule}
}

\strong{FlowDefinition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowdefinition.htm}{Salesforce Documentation for FlowDefinition}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{activeVersionNumber}{a integer}
 \item{description}{a character}
 \item{masterLabel}{a character}
}

\strong{FlowDefinitionTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowdefinitiontranslation.htm}{Salesforce Documentation for FlowDefinitionTranslation}
\describe{
 \item{flows}{a FlowTranslation}
 \item{fullName}{a character}
 \item{label}{a character}
}

\strong{FlowDynamicChoiceSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowdynamicchoiceset.htm}{Salesforce Documentation for FlowDynamicChoiceSet}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{dataType}{a FlowDataType - which is a character taking one of the following values: 
   \itemize{
     \item{Currency}
     \item{Date}
     \item{Number}
     \item{String}
     \item{Boolean}
     \item{SObject}
     \item{DateTime}
     \item{Picklist}
     \item{Multipicklist}
   }
  }
 \item{displayField}{a character}
 \item{filters}{a FlowRecordFilter}
 \item{limit}{a integer}
 \item{object}{a character}
 \item{outputAssignments}{a FlowOutputFieldAssignment}
 \item{picklistField}{a character}
 \item{picklistObject}{a character}
 \item{sortField}{a character}
 \item{sortOrder}{a SortOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
 \item{valueField}{a character}
}

\strong{FlowElement}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowelement.htm}{Salesforce Documentation for FlowElement}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{description}{a character}
 \item{name}{a character}
}

\strong{FlowElementReferenceOrValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowelementreferenceorvalue.htm}{Salesforce Documentation for FlowElementReferenceOrValue}
\describe{
 \item{booleanValue}{a character either 'true' or 'false'}
 \item{dateTimeValue}{a character formatted as 'yyyy-mm-ddThh:mm:ssZ'}
 \item{dateValue}{a character formatted as 'yyyy-mm-dd'}
 \item{elementReference}{a character}
 \item{numberValue}{a numeric}
 \item{stringValue}{a character}
}

\strong{FlowFormula}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowformula.htm}{Salesforce Documentation for FlowFormula}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{dataType}{a FlowDataType - which is a character taking one of the following values: 
   \itemize{
     \item{Currency}
     \item{Date}
     \item{Number}
     \item{String}
     \item{Boolean}
     \item{SObject}
     \item{DateTime}
     \item{Picklist}
     \item{Multipicklist}
   }
  }
 \item{expression}{a character}
 \item{scale}{a integer}
}

\strong{FlowInputFieldAssignment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowinputfieldassignment.htm}{Salesforce Documentation for FlowInputFieldAssignment}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{field}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowInputValidationRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowinputvalidationrule.htm}{Salesforce Documentation for FlowInputValidationRule}
\describe{
 \item{errorMessage}{a character}
 \item{formulaExpression}{a character}
}

\strong{FlowInputValidationRuleTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowinputvalidationruletranslation.htm}{Salesforce Documentation for FlowInputValidationRuleTranslation}
\describe{
 \item{errorMessage}{a character}
}

\strong{FlowLoop}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowloop.htm}{Salesforce Documentation for FlowLoop}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{assignNextValueToReference}{a character}
 \item{collectionReference}{a character}
 \item{iterationOrder}{a IterationOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
 \item{nextValueConnector}{a FlowConnector}
 \item{noMoreValuesConnector}{a FlowConnector}
}

\strong{FlowMetadataValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowmetadatavalue.htm}{Salesforce Documentation for FlowMetadataValue}
\describe{
 \item{name}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowNode}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flownode.htm}{Salesforce Documentation for FlowNode}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{label}{a character}
 \item{locationX}{a integer}
 \item{locationY}{a integer}
}

\strong{FlowOutputFieldAssignment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowoutputfieldassignment.htm}{Salesforce Documentation for FlowOutputFieldAssignment}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{field}{a character}
}

\strong{FlowRecordCreate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowrecordcreate.htm}{Salesforce Documentation for FlowRecordCreate}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{assignRecordIdToReference}{a character}
 \item{connector}{a FlowConnector}
 \item{faultConnector}{a FlowConnector}
 \item{inputAssignments}{a FlowInputFieldAssignment}
 \item{inputReference}{a character}
 \item{object}{a character}
}

\strong{FlowRecordDelete}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowrecorddelete.htm}{Salesforce Documentation for FlowRecordDelete}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{connector}{a FlowConnector}
 \item{faultConnector}{a FlowConnector}
 \item{filters}{a FlowRecordFilter}
 \item{inputReference}{a character}
 \item{object}{a character}
}

\strong{FlowRecordFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowrecordfilter.htm}{Salesforce Documentation for FlowRecordFilter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{field}{a character}
 \item{operator}{a FlowRecordFilterOperator - which is a character taking one of the following values: 
   \itemize{
     \item{EqualTo}
     \item{NotEqualTo}
     \item{GreaterThan}
     \item{LessThan}
     \item{GreaterThanOrEqualTo}
     \item{LessThanOrEqualTo}
     \item{StartsWith}
     \item{EndsWith}
     \item{Contains}
     \item{IsNull}
   }
  }
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowRecordLookup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowrecordlookup.htm}{Salesforce Documentation for FlowRecordLookup}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{assignNullValuesIfNoRecordsFound}{a character either 'true' or 'false'}
 \item{connector}{a FlowConnector}
 \item{faultConnector}{a FlowConnector}
 \item{filters}{a FlowRecordFilter}
 \item{object}{a character}
 \item{outputAssignments}{a FlowOutputFieldAssignment}
 \item{outputReference}{a character}
 \item{queriedFields}{a character}
 \item{sortField}{a character}
 \item{sortOrder}{a SortOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
}

\strong{FlowRecordUpdate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowrecordupdate.htm}{Salesforce Documentation for FlowRecordUpdate}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{connector}{a FlowConnector}
 \item{faultConnector}{a FlowConnector}
 \item{filters}{a FlowRecordFilter}
 \item{inputAssignments}{a FlowInputFieldAssignment}
 \item{inputReference}{a character}
 \item{object}{a character}
}

\strong{FlowRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowrule.htm}{Salesforce Documentation for FlowRule}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{conditionLogic}{a character}
 \item{conditions}{a FlowCondition}
 \item{connector}{a FlowConnector}
 \item{label}{a character}
}

\strong{FlowScreen}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreen.htm}{Salesforce Documentation for FlowScreen}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{allowBack}{a character either 'true' or 'false'}
 \item{allowFinish}{a character either 'true' or 'false'}
 \item{allowPause}{a character either 'true' or 'false'}
 \item{connector}{a FlowConnector}
 \item{fields}{a FlowScreenField}
 \item{helpText}{a character}
 \item{pausedText}{a character}
 \item{rules}{a FlowScreenRule}
 \item{showFooter}{a character either 'true' or 'false'}
 \item{showHeader}{a character either 'true' or 'false'}
}

\strong{FlowScreenField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreenfield.htm}{Salesforce Documentation for FlowScreenField}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{choiceReferences}{a character}
 \item{dataType}{a FlowDataType - which is a character taking one of the following values: 
   \itemize{
     \item{Currency}
     \item{Date}
     \item{Number}
     \item{String}
     \item{Boolean}
     \item{SObject}
     \item{DateTime}
     \item{Picklist}
     \item{Multipicklist}
   }
  }
 \item{defaultSelectedChoiceReference}{a character}
 \item{defaultValue}{a FlowElementReferenceOrValue}
 \item{extensionName}{a character}
 \item{fieldText}{a character}
 \item{fieldType}{a FlowScreenFieldType - which is a character taking one of the following values: 
   \itemize{
     \item{DisplayText}
     \item{InputField}
     \item{LargeTextArea}
     \item{PasswordField}
     \item{RadioButtons}
     \item{DropdownBox}
     \item{MultiSelectCheckboxes}
     \item{MultiSelectPicklist}
     \item{ComponentInstance}
   }
  }
 \item{helpText}{a character}
 \item{inputParameters}{a FlowScreenFieldInputParameter}
 \item{isRequired}{a character either 'true' or 'false'}
 \item{isVisible}{a character either 'true' or 'false'}
 \item{outputParameters}{a FlowScreenFieldOutputParameter}
 \item{scale}{a integer}
 \item{validationRule}{a FlowInputValidationRule}
}

\strong{FlowScreenFieldInputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreenfieldinputparameter.htm}{Salesforce Documentation for FlowScreenFieldInputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{name}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowScreenFieldOutputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreenfieldoutputparameter.htm}{Salesforce Documentation for FlowScreenFieldOutputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{name}{a character}
}

\strong{FlowScreenFieldTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreenfieldtranslation.htm}{Salesforce Documentation for FlowScreenFieldTranslation}
\describe{
 \item{fieldText}{a character}
 \item{helpText}{a character}
 \item{name}{a character}
 \item{validationRule}{a FlowInputValidationRuleTranslation}
}

\strong{FlowScreenRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreenrule.htm}{Salesforce Documentation for FlowScreenRule}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{conditionLogic}{a character}
 \item{conditions}{a FlowCondition}
 \item{label}{a character}
 \item{ruleActions}{a FlowScreenRuleAction}
}

\strong{FlowScreenRuleAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreenruleaction.htm}{Salesforce Documentation for FlowScreenRuleAction}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{attribute}{a character}
 \item{fieldReference}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowScreenTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowscreentranslation.htm}{Salesforce Documentation for FlowScreenTranslation}
\describe{
 \item{fields}{a FlowScreenFieldTranslation}
 \item{helpText}{a character}
 \item{name}{a character}
 \item{pausedText}{a character}
}

\strong{FlowStage}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowstage.htm}{Salesforce Documentation for FlowStage}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{isActive}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{stageOrder}{a integer}
}

\strong{FlowStep}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowstep.htm}{Salesforce Documentation for FlowStep}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{connectors}{a FlowConnector}
}

\strong{FlowSubflow}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowsubflow.htm}{Salesforce Documentation for FlowSubflow}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{connector}{a FlowConnector}
 \item{flowName}{a character}
 \item{inputAssignments}{a FlowSubflowInputAssignment}
 \item{outputAssignments}{a FlowSubflowOutputAssignment}
}

\strong{FlowSubflowInputAssignment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowsubflowinputassignment.htm}{Salesforce Documentation for FlowSubflowInputAssignment}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{name}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowSubflowOutputAssignment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowsubflowoutputassignment.htm}{Salesforce Documentation for FlowSubflowOutputAssignment}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{name}{a character}
}

\strong{FlowTextTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowtexttemplate.htm}{Salesforce Documentation for FlowTextTemplate}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{text}{a character}
}

\strong{FlowTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowtranslation.htm}{Salesforce Documentation for FlowTranslation}
\describe{
 \item{choices}{a FlowChoiceTranslation}
 \item{fullName}{a character}
 \item{label}{a character}
 \item{screens}{a FlowScreenTranslation}
}

\strong{FlowVariable}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowvariable.htm}{Salesforce Documentation for FlowVariable}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{dataType}{a FlowDataType - which is a character taking one of the following values: 
   \itemize{
     \item{Currency}
     \item{Date}
     \item{Number}
     \item{String}
     \item{Boolean}
     \item{SObject}
     \item{DateTime}
     \item{Picklist}
     \item{Multipicklist}
   }
  }
 \item{isCollection}{a character either 'true' or 'false'}
 \item{isInput}{a character either 'true' or 'false'}
 \item{isOutput}{a character either 'true' or 'false'}
 \item{objectType}{a character}
 \item{scale}{a integer}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowWait}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowwait.htm}{Salesforce Documentation for FlowWait}
\describe{
 \item{label}{a character (inherited from FlowNode)}
 \item{locationX}{a integer (inherited from FlowNode)}
 \item{locationY}{a integer (inherited from FlowNode)}
 \item{defaultConnector}{a FlowConnector}
 \item{defaultConnectorLabel}{a character}
 \item{faultConnector}{a FlowConnector}
 \item{waitEvents}{a FlowWaitEvent}
}

\strong{FlowWaitEvent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowwaitevent.htm}{Salesforce Documentation for FlowWaitEvent}
\describe{
 \item{description}{a character (inherited from FlowElement)}
 \item{name}{a character (inherited from FlowElement)}
 \item{conditionLogic}{a character}
 \item{conditions}{a FlowCondition}
 \item{connector}{a FlowConnector}
 \item{eventType}{a character}
 \item{inputParameters}{a FlowWaitEventInputParameter}
 \item{label}{a character}
 \item{outputParameters}{a FlowWaitEventOutputParameter}
}

\strong{FlowWaitEventInputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowwaiteventinputparameter.htm}{Salesforce Documentation for FlowWaitEventInputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{name}{a character}
 \item{value}{a FlowElementReferenceOrValue}
}

\strong{FlowWaitEventOutputParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_flowwaiteventoutputparameter.htm}{Salesforce Documentation for FlowWaitEventOutputParameter}
\describe{
 \item{processMetadataValues}{a FlowMetadataValue (inherited from FlowBaseElement)}
 \item{assignToReference}{a character}
 \item{name}{a character}
}

\strong{Folder}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_folder.htm}{Salesforce Documentation for Folder}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{accessType}{a FolderAccessTypes - which is a character taking one of the following values: 
   \itemize{
     \item{Shared}
     \item{Public}
     \item{Hidden}
     \item{PublicInternal}
   }
  }
 \item{folderShares}{a FolderShare}
 \item{name}{a character}
 \item{publicFolderAccess}{a PublicFolderAccess - which is a character taking one of the following values: 
   \itemize{
     \item{ReadOnly}
     \item{ReadWrite}
   }
  }
 \item{sharedTo}{a SharedTo}
}

\strong{FolderShare}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_foldershare.htm}{Salesforce Documentation for FolderShare}
\describe{
 \item{accessLevel}{a FolderShareAccessLevel - which is a character taking one of the following values: 
   \itemize{
     \item{View}
     \item{EditAllContents}
     \item{Manage}
   }
  }
 \item{sharedTo}{a character}
 \item{sharedToType}{a FolderSharedToType - which is a character taking one of the following values: 
   \itemize{
     \item{Group}
     \item{Role}
     \item{RoleAndSubordinates}
     \item{RoleAndSubordinatesInternal}
     \item{Manager}
     \item{ManagerAndSubordinatesInternal}
     \item{Organization}
     \item{Territory}
     \item{TerritoryAndSubordinates}
     \item{AllPrmUsers}
     \item{User}
     \item{PartnerUser}
     \item{AllCspUsers}
     \item{CustomerPortalUser}
     \item{PortalRole}
     \item{PortalRoleAndSubordinates}
     \item{ChannelProgramGroup}
   }
  }
}

\strong{ForecastingCategoryMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_forecastingcategorymapping.htm}{Salesforce Documentation for ForecastingCategoryMapping}
\describe{
 \item{forecastingItemCategoryApiName}{a character}
 \item{weightedSourceCategories}{a WeightedSourceCategory}
}

\strong{ForecastingDisplayedFamilySettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_forecastingdisplayedfamilysettings.htm}{Salesforce Documentation for ForecastingDisplayedFamilySettings}
\describe{
 \item{productFamily}{a character}
}

\strong{ForecastingSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_forecastingsettings.htm}{Salesforce Documentation for ForecastingSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{displayCurrency}{a DisplayCurrency - which is a character taking one of the following values: 
   \itemize{
     \item{CORPORATE}
     \item{PERSONAL}
   }
  }
 \item{enableForecasts}{a character either 'true' or 'false'}
 \item{forecastingCategoryMappings}{a ForecastingCategoryMapping}
 \item{forecastingDisplayedFamilySettings}{a ForecastingDisplayedFamilySettings}
 \item{forecastingTypeSettings}{a ForecastingTypeSettings}
}

\strong{ForecastingTypeSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_forecastingtypesettings.htm}{Salesforce Documentation for ForecastingTypeSettings}
\describe{
 \item{active}{a character either 'true' or 'false'}
 \item{adjustmentsSettings}{a AdjustmentsSettings}
 \item{displayedCategoryApiNames}{a character}
 \item{forecastRangeSettings}{a ForecastRangeSettings}
 \item{forecastedCategoryApiNames}{a character}
 \item{forecastingDateType}{a ForecastingDateType - which is a character taking one of the following values: 
   \itemize{
     \item{OpportunityCloseDate}
     \item{ProductDate}
     \item{ScheduleDate}
   }
  }
 \item{hasProductFamily}{a character either 'true' or 'false'}
 \item{isAmount}{a character either 'true' or 'false'}
 \item{isAvailable}{a character either 'true' or 'false'}
 \item{isQuantity}{a character either 'true' or 'false'}
 \item{managerAdjustableCategoryApiNames}{a character}
 \item{masterLabel}{a character}
 \item{name}{a character}
 \item{opportunityListFieldsLabelMappings}{a OpportunityListFieldsLabelMapping}
 \item{opportunityListFieldsSelectedSettings}{a OpportunityListFieldsSelectedSettings}
 \item{opportunityListFieldsUnselectedSettings}{a OpportunityListFieldsUnselectedSettings}
 \item{opportunitySplitName}{a character}
 \item{ownerAdjustableCategoryApiNames}{a character}
 \item{quotasSettings}{a QuotasSettings}
 \item{territory2ModelName}{a character}
}

\strong{ForecastRangeSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_forecastrangesettings.htm}{Salesforce Documentation for ForecastRangeSettings}
\describe{
 \item{beginning}{a integer}
 \item{displaying}{a integer}
 \item{periodType}{a PeriodTypes - which is a character taking one of the following values: 
   \itemize{
     \item{Month}
     \item{Quarter}
     \item{Week}
     \item{Year}
   }
  }
}

\strong{GlobalPicklistValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_globalpicklistvalue.htm}{Salesforce Documentation for GlobalPicklistValue}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{color}{a character}
 \item{default}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{isActive}{a character either 'true' or 'false'}
}

\strong{GlobalQuickActionTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_globalquickactiontranslation.htm}{Salesforce Documentation for GlobalQuickActionTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{GlobalValueSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_globalvalueset.htm}{Salesforce Documentation for GlobalValueSet}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customValue}{a CustomValue}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{sorted}{a character either 'true' or 'false'}
}

\strong{GlobalValueSetTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_globalvaluesettranslation.htm}{Salesforce Documentation for GlobalValueSetTranslation}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{valueTranslation}{a ValueTranslation}
}

\strong{Group}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_group.htm}{Salesforce Documentation for Group}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{doesIncludeBosses}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{HistoryRetentionPolicy}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_historyretentionpolicy.htm}{Salesforce Documentation for HistoryRetentionPolicy}
\describe{
 \item{archiveAfterMonths}{a integer}
 \item{archiveRetentionYears}{a integer}
 \item{description}{a character}
}

\strong{Holiday}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_holiday.htm}{Salesforce Documentation for Holiday}
\describe{
 \item{activityDate}{a character formatted as 'yyyy-mm-dd'}
 \item{businessHours}{a character}
 \item{description}{a character}
 \item{endTime}{a character formatted as 'hh:mm:ssZ}
 \item{isRecurring}{a character either 'true' or 'false'}
 \item{name}{a character}
 \item{recurrenceDayOfMonth}{a integer}
 \item{recurrenceDayOfWeek}{a character}
 \item{recurrenceDayOfWeekMask}{a integer}
 \item{recurrenceEndDate}{a character formatted as 'yyyy-mm-dd'}
 \item{recurrenceInstance}{a character}
 \item{recurrenceInterval}{a integer}
 \item{recurrenceMonthOfYear}{a character}
 \item{recurrenceStartDate}{a character formatted as 'yyyy-mm-dd'}
 \item{recurrenceType}{a character}
 \item{startTime}{a character formatted as 'hh:mm:ssZ}
}

\strong{HomePageComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_homepagecomponent.htm}{Salesforce Documentation for HomePageComponent}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{body}{a character}
 \item{height}{a integer}
 \item{links}{a character}
 \item{page}{a character}
 \item{pageComponentType}{a PageComponentType - which is a character taking one of the following values: 
   \itemize{
     \item{links}
     \item{htmlArea}
     \item{imageOrNote}
     \item{visualforcePage}
   }
  }
 \item{showLabel}{a character either 'true' or 'false'}
 \item{showScrollbars}{a character either 'true' or 'false'}
 \item{width}{a PageComponentWidth - which is a character taking one of the following values: 
   \itemize{
     \item{narrow}
     \item{wide}
   }
  }
}

\strong{HomePageLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_homepagelayout.htm}{Salesforce Documentation for HomePageLayout}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{narrowComponents}{a character}
 \item{wideComponents}{a character}
}

\strong{IdeaReputationLevel}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_ideareputationlevel.htm}{Salesforce Documentation for IdeaReputationLevel}
\describe{
 \item{name}{a character}
 \item{value}{a integer}
}

\strong{IdeasSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_ideassettings.htm}{Salesforce Documentation for IdeasSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableChatterProfile}{a character either 'true' or 'false'}
 \item{enableIdeaThemes}{a character either 'true' or 'false'}
 \item{enableIdeas}{a character either 'true' or 'false'}
 \item{enableIdeasReputation}{a character either 'true' or 'false'}
 \item{halfLife}{a numeric}
 \item{ideasProfilePage}{a character}
}

\strong{Index}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_index.htm}{Salesforce Documentation for Index}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{fields}{a IndexField}
 \item{label}{a character}
}

\strong{IndexField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_indexfield.htm}{Salesforce Documentation for IndexField}
\describe{
 \item{name}{a character}
 \item{sortDirection}{a character}
}

\strong{InsightType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_insighttype.htm}{Salesforce Documentation for InsightType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{defaultTrendType}{a InsightTrendType - which is a character taking one of the following values: 
   \itemize{
     \item{Positive}
     \item{Negative}
     \item{Informational}
     \item{Suggestion}
   }
  }
 \item{description}{a character}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{parentType}{a InsightParentType - which is a character taking one of the following values: 
   \itemize{
     \item{Opportunity}
     \item{Account}
   }
  }
 \item{title}{a character}
}

\strong{InstalledPackage}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_installedpackage.htm}{Salesforce Documentation for InstalledPackage}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{password}{a character}
 \item{versionNumber}{a character}
}

\strong{IntegrationHubSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_integrationhubsettings.htm}{Salesforce Documentation for IntegrationHubSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{canonicalName}{a character}
 \item{canonicalNameBindingChar}{a character}
 \item{description}{a character}
 \item{isEnabled}{a character either 'true' or 'false'}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{setupData}{a character}
 \item{setupDefinition}{a character}
 \item{setupNamespace}{a character}
 \item{setupSimpleName}{a character}
 \item{uUID}{a character}
 \item{version}{a character}
 \item{versionBuild}{a integer}
 \item{versionMajor}{a integer}
 \item{versionMinor}{a integer}
}

\strong{IntegrationHubSettingsType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_integrationhubsettingstype.htm}{Salesforce Documentation for IntegrationHubSettingsType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{canonicalName}{a character}
 \item{canonicalNameBindingChar}{a character}
 \item{description}{a character}
 \item{isEnabled}{a character either 'true' or 'false'}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{setupNamespace}{a character}
 \item{setupSimpleName}{a character}
 \item{uUID}{a character}
 \item{version}{a character}
 \item{versionBuild}{a integer}
 \item{versionMajor}{a integer}
 \item{versionMinor}{a integer}
}

\strong{IpRange}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_iprange.htm}{Salesforce Documentation for IpRange}
\describe{
 \item{description}{a character}
 \item{end}{a character}
 \item{start}{a character}
}

\strong{KeyboardShortcuts}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_keyboardshortcuts.htm}{Salesforce Documentation for KeyboardShortcuts}
\describe{
 \item{customShortcuts}{a CustomShortcut}
 \item{defaultShortcuts}{a DefaultShortcut}
}

\strong{Keyword}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_keyword.htm}{Salesforce Documentation for Keyword}
\describe{
 \item{keyword}{a character}
}

\strong{KeywordList}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_keywordlist.htm}{Salesforce Documentation for KeywordList}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{keywords}{a Keyword}
 \item{masterLabel}{a character}
}

\strong{KnowledgeAnswerSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgeanswersettings.htm}{Salesforce Documentation for KnowledgeAnswerSettings}
\describe{
 \item{assignTo}{a character}
 \item{defaultArticleType}{a character}
 \item{enableArticleCreation}{a character either 'true' or 'false'}
}

\strong{KnowledgeCaseField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgecasefield.htm}{Salesforce Documentation for KnowledgeCaseField}
\describe{
 \item{name}{a character}
}

\strong{KnowledgeCaseFieldsSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgecasefieldssettings.htm}{Salesforce Documentation for KnowledgeCaseFieldsSettings}
\describe{
 \item{field}{a KnowledgeCaseField}
}

\strong{KnowledgeCaseSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgecasesettings.htm}{Salesforce Documentation for KnowledgeCaseSettings}
\describe{
 \item{articlePDFCreationProfile}{a character}
 \item{articlePublicSharingCommunities}{a KnowledgeCommunitiesSettings}
 \item{articlePublicSharingSites}{a KnowledgeSitesSettings}
 \item{articlePublicSharingSitesChatterAnswers}{a KnowledgeSitesSettings}
 \item{assignTo}{a character}
 \item{customizationClass}{a character}
 \item{defaultContributionArticleType}{a character}
 \item{editor}{a KnowledgeCaseEditor - which is a character taking one of the following values: 
   \itemize{
     \item{simple}
     \item{standard}
   }
  }
 \item{enableArticleCreation}{a character either 'true' or 'false'}
 \item{enableArticlePublicSharingSites}{a character either 'true' or 'false'}
 \item{enableCaseDataCategoryMapping}{a character either 'true' or 'false'}
 \item{useProfileForPDFCreation}{a character either 'true' or 'false'}
}

\strong{KnowledgeCommunitiesSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgecommunitiessettings.htm}{Salesforce Documentation for KnowledgeCommunitiesSettings}
\describe{
 \item{community}{a character}
}

\strong{KnowledgeLanguage}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgelanguage.htm}{Salesforce Documentation for KnowledgeLanguage}
\describe{
 \item{active}{a character either 'true' or 'false'}
 \item{defaultAssignee}{a character}
 \item{defaultAssigneeType}{a KnowledgeLanguageLookupValueType - which is a character taking one of the following values: 
   \itemize{
     \item{User}
     \item{Queue}
   }
  }
 \item{defaultReviewer}{a character}
 \item{defaultReviewerType}{a KnowledgeLanguageLookupValueType - which is a character taking one of the following values: 
   \itemize{
     \item{User}
     \item{Queue}
   }
  }
 \item{name}{a character}
}

\strong{KnowledgeLanguageSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgelanguagesettings.htm}{Salesforce Documentation for KnowledgeLanguageSettings}
\describe{
 \item{language}{a KnowledgeLanguage}
}

\strong{KnowledgeSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgesettings.htm}{Salesforce Documentation for KnowledgeSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{answers}{a KnowledgeAnswerSettings}
 \item{cases}{a KnowledgeCaseSettings}
 \item{defaultLanguage}{a character}
 \item{enableChatterQuestionKBDeflection}{a character either 'true' or 'false'}
 \item{enableCreateEditOnArticlesTab}{a character either 'true' or 'false'}
 \item{enableExternalMediaContent}{a character either 'true' or 'false'}
 \item{enableKnowledge}{a character either 'true' or 'false'}
 \item{enableLightningKnowledge}{a character either 'true' or 'false'}
 \item{languages}{a KnowledgeLanguageSettings}
 \item{showArticleSummariesCustomerPortal}{a character either 'true' or 'false'}
 \item{showArticleSummariesInternalApp}{a character either 'true' or 'false'}
 \item{showArticleSummariesPartnerPortal}{a character either 'true' or 'false'}
 \item{showValidationStatusField}{a character either 'true' or 'false'}
 \item{suggestedArticles}{a KnowledgeSuggestedArticlesSettings}
}

\strong{KnowledgeSitesSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgesitessettings.htm}{Salesforce Documentation for KnowledgeSitesSettings}
\describe{
 \item{site}{a character}
}

\strong{KnowledgeSuggestedArticlesSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgesuggestedarticlessettings.htm}{Salesforce Documentation for KnowledgeSuggestedArticlesSettings}
\describe{
 \item{caseFields}{a KnowledgeCaseFieldsSettings}
 \item{useSuggestedArticlesForCase}{a character either 'true' or 'false'}
 \item{workOrderFields}{a KnowledgeWorkOrderFieldsSettings}
 \item{workOrderLineItemFields}{a KnowledgeWorkOrderLineItemFieldsSettings}
}

\strong{KnowledgeWorkOrderField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgeworkorderfield.htm}{Salesforce Documentation for KnowledgeWorkOrderField}
\describe{
 \item{name}{a character}
}

\strong{KnowledgeWorkOrderFieldsSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgeworkorderfieldssettings.htm}{Salesforce Documentation for KnowledgeWorkOrderFieldsSettings}
\describe{
 \item{field}{a KnowledgeWorkOrderField}
}

\strong{KnowledgeWorkOrderLineItemField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgeworkorderlineitemfield.htm}{Salesforce Documentation for KnowledgeWorkOrderLineItemField}
\describe{
 \item{name}{a character}
}

\strong{KnowledgeWorkOrderLineItemFieldsSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_knowledgeworkorderlineitemfieldssettings.htm}{Salesforce Documentation for KnowledgeWorkOrderLineItemFieldsSettings}
\describe{
 \item{field}{a KnowledgeWorkOrderLineItemField}
}

\strong{Layout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_layout.htm}{Salesforce Documentation for Layout}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customButtons}{a character}
 \item{customConsoleComponents}{a CustomConsoleComponents}
 \item{emailDefault}{a character either 'true' or 'false'}
 \item{excludeButtons}{a character}
 \item{feedLayout}{a FeedLayout}
 \item{headers}{a LayoutHeader - which is a character taking one of the following values: 
   \itemize{
     \item{PersonalTagging}
     \item{PublicTagging}
   }
  }
 \item{layoutSections}{a LayoutSection}
 \item{miniLayout}{a MiniLayout}
 \item{multilineLayoutFields}{a character}
 \item{platformActionList}{a PlatformActionList}
 \item{quickActionList}{a QuickActionList}
 \item{relatedContent}{a RelatedContent}
 \item{relatedLists}{a RelatedListItem}
 \item{relatedObjects}{a character}
 \item{runAssignmentRulesDefault}{a character either 'true' or 'false'}
 \item{showEmailCheckbox}{a character either 'true' or 'false'}
 \item{showHighlightsPanel}{a character either 'true' or 'false'}
 \item{showInteractionLogPanel}{a character either 'true' or 'false'}
 \item{showKnowledgeComponent}{a character either 'true' or 'false'}
 \item{showRunAssignmentRulesCheckbox}{a character either 'true' or 'false'}
 \item{showSolutionSection}{a character either 'true' or 'false'}
 \item{showSubmitAndAttachButton}{a character either 'true' or 'false'}
 \item{summaryLayout}{a SummaryLayout}
}

\strong{LayoutColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_layoutcolumn.htm}{Salesforce Documentation for LayoutColumn}
\describe{
 \item{layoutItems}{a LayoutItem}
 \item{reserved}{a character}
}

\strong{LayoutItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_layoutitem.htm}{Salesforce Documentation for LayoutItem}
\describe{
 \item{analyticsCloudComponent}{a AnalyticsCloudComponentLayoutItem}
 \item{behavior}{a UiBehavior - which is a character taking one of the following values: 
   \itemize{
     \item{Edit}
     \item{Required}
     \item{Readonly}
   }
  }
 \item{canvas}{a character}
 \item{component}{a character}
 \item{customLink}{a character}
 \item{emptySpace}{a character either 'true' or 'false'}
 \item{field}{a character}
 \item{height}{a integer}
 \item{page}{a character}
 \item{reportChartComponent}{a ReportChartComponentLayoutItem}
 \item{scontrol}{a character}
 \item{showLabel}{a character either 'true' or 'false'}
 \item{showScrollbars}{a character either 'true' or 'false'}
 \item{width}{a character}
}

\strong{LayoutSection}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_layoutsection.htm}{Salesforce Documentation for LayoutSection}
\describe{
 \item{customLabel}{a character either 'true' or 'false'}
 \item{detailHeading}{a character either 'true' or 'false'}
 \item{editHeading}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{layoutColumns}{a LayoutColumn}
 \item{style}{a LayoutSectionStyle - which is a character taking one of the following values: 
   \itemize{
     \item{TwoColumnsTopToBottom}
     \item{TwoColumnsLeftToRight}
     \item{OneColumn}
     \item{CustomLinks}
   }
  }
}

\strong{LayoutSectionTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_layoutsectiontranslation.htm}{Salesforce Documentation for LayoutSectionTranslation}
\describe{
 \item{label}{a character}
 \item{section}{a character}
}

\strong{LayoutTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_layouttranslation.htm}{Salesforce Documentation for LayoutTranslation}
\describe{
 \item{layout}{a character}
 \item{layoutType}{a character}
 \item{sections}{a LayoutSectionTranslation}
}

\strong{LeadConvertSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_leadconvertsettings.htm}{Salesforce Documentation for LeadConvertSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{allowOwnerChange}{a character either 'true' or 'false'}
 \item{objectMapping}{a ObjectMapping}
 \item{opportunityCreationOptions}{a VisibleOrRequired - which is a character taking one of the following values: 
   \itemize{
     \item{VisibleOptional}
     \item{VisibleRequired}
     \item{NotVisible}
   }
  }
}

\strong{Letterhead}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_letterhead.htm}{Salesforce Documentation for Letterhead}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{available}{a character either 'true' or 'false'}
 \item{backgroundColor}{a character}
 \item{bodyColor}{a character}
 \item{bottomLine}{a LetterheadLine}
 \item{description}{a character}
 \item{footer}{a LetterheadHeaderFooter}
 \item{header}{a LetterheadHeaderFooter}
 \item{middleLine}{a LetterheadLine}
 \item{name}{a character}
 \item{topLine}{a LetterheadLine}
}

\strong{LetterheadHeaderFooter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_letterheadheaderfooter.htm}{Salesforce Documentation for LetterheadHeaderFooter}
\describe{
 \item{backgroundColor}{a character}
 \item{height}{a integer}
 \item{horizontalAlignment}{a LetterheadHorizontalAlignment - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Left}
     \item{Center}
     \item{Right}
   }
  }
 \item{logo}{a character}
 \item{verticalAlignment}{a LetterheadVerticalAlignment - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Top}
     \item{Middle}
     \item{Bottom}
   }
  }
}

\strong{LetterheadLine}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_letterheadline.htm}{Salesforce Documentation for LetterheadLine}
\describe{
 \item{color}{a character}
 \item{height}{a integer}
}

\strong{LicensedCustomPermissions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_licensedcustompermissions.htm}{Salesforce Documentation for LicensedCustomPermissions}
\describe{
 \item{customPermission}{a character}
 \item{licenseDefinition}{a character}
}

\strong{LicenseDefinition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_licensedefinition.htm}{Salesforce Documentation for LicenseDefinition}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{aggregationGroup}{a character}
 \item{description}{a character}
 \item{isPublished}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{licensedCustomPermissions}{a LicensedCustomPermissions}
 \item{licensingAuthority}{a character}
 \item{licensingAuthorityProvider}{a character}
 \item{minPlatformVersion}{a integer}
 \item{origin}{a character}
 \item{revision}{a integer}
 \item{trialLicenseDuration}{a integer}
 \item{trialLicenseQuantity}{a integer}
}

\strong{LightningBolt}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lightningbolt.htm}{Salesforce Documentation for LightningBolt}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{category}{a LightningBoltCategory - which is a character taking one of the following values: 
   \itemize{
     \item{IT}
     \item{Marketing}
     \item{Sales}
     \item{Service}
   }
  }
 \item{lightningBoltFeatures}{a LightningBoltFeatures}
 \item{lightningBoltImages}{a LightningBoltImages}
 \item{lightningBoltItems}{a LightningBoltItems}
 \item{masterLabel}{a character}
 \item{publisher}{a character}
 \item{summary}{a character}
}

\strong{LightningBoltFeatures}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lightningboltfeatures.htm}{Salesforce Documentation for LightningBoltFeatures}
\describe{
 \item{description}{a character}
 \item{order}{a integer}
 \item{title}{a character}
}

\strong{LightningBoltImages}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lightningboltimages.htm}{Salesforce Documentation for LightningBoltImages}
\describe{
 \item{image}{a character}
 \item{order}{a integer}
}

\strong{LightningBoltItems}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lightningboltitems.htm}{Salesforce Documentation for LightningBoltItems}
\describe{
 \item{name}{a character}
 \item{type}{a character}
}

\strong{LightningComponentBundle}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lightningcomponentbundle.htm}{Salesforce Documentation for LightningComponentBundle}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{apiVersion}{a numeric}
 \item{isExposed}{a character either 'true' or 'false'}
}

\strong{LightningExperienceTheme}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lightningexperiencetheme.htm}{Salesforce Documentation for LightningExperienceTheme}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{defaultBrandingSet}{a character}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{shouldOverrideLoadingImage}{a character either 'true' or 'false'}
}

\strong{ListMetadataQuery}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_listmetadataquery.htm}{Salesforce Documentation for ListMetadataQuery}
\describe{
 \item{folder}{a character}
 \item{type}{a character}
}

\strong{ListPlacement}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_listplacement.htm}{Salesforce Documentation for ListPlacement}
\describe{
 \item{height}{a integer}
 \item{location}{a character}
 \item{units}{a character}
 \item{width}{a integer}
}

\strong{ListView}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_listview.htm}{Salesforce Documentation for ListView}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{booleanFilter}{a character}
 \item{columns}{a character}
 \item{division}{a character}
 \item{filterScope}{a FilterScope - which is a character taking one of the following values: 
   \itemize{
     \item{Everything}
     \item{Mine}
     \item{Queue}
     \item{Delegated}
     \item{MyTerritory}
     \item{MyTeamTerritory}
     \item{Team}
     \item{AssignedToMe}
   }
  }
 \item{filters}{a ListViewFilter}
 \item{label}{a character}
 \item{language}{a Language - which is a character taking one of the following values: 
   \itemize{
     \item{en_US}
     \item{de}
     \item{es}
     \item{fr}
     \item{it}
     \item{ja}
     \item{sv}
     \item{ko}
     \item{zh_TW}
     \item{zh_CN}
     \item{pt_BR}
     \item{nl_NL}
     \item{da}
     \item{th}
     \item{fi}
     \item{ru}
     \item{es_MX}
     \item{no}
     \item{hu}
     \item{pl}
     \item{cs}
     \item{tr}
     \item{in}
     \item{ro}
     \item{vi}
     \item{uk}
     \item{iw}
     \item{el}
     \item{bg}
     \item{en_GB}
     \item{ar}
     \item{sk}
     \item{pt_PT}
     \item{hr}
     \item{sl}
     \item{fr_CA}
     \item{ka}
     \item{sr}
     \item{sh}
     \item{en_AU}
     \item{en_MY}
     \item{en_IN}
     \item{en_PH}
     \item{en_CA}
     \item{ro_MD}
     \item{bs}
     \item{mk}
     \item{lv}
     \item{lt}
     \item{et}
     \item{sq}
     \item{sh_ME}
     \item{mt}
     \item{ga}
     \item{eu}
     \item{cy}
     \item{is}
     \item{ms}
     \item{tl}
     \item{lb}
     \item{rm}
     \item{hy}
     \item{hi}
     \item{ur}
     \item{bn}
     \item{de_AT}
     \item{de_CH}
     \item{ta}
     \item{ar_DZ}
     \item{ar_BH}
     \item{ar_EG}
     \item{ar_IQ}
     \item{ar_JO}
     \item{ar_KW}
     \item{ar_LB}
     \item{ar_LY}
     \item{ar_MA}
     \item{ar_OM}
     \item{ar_QA}
     \item{ar_SA}
     \item{ar_SD}
     \item{ar_SY}
     \item{ar_TN}
     \item{ar_AE}
     \item{ar_YE}
     \item{zh_SG}
     \item{zh_HK}
     \item{en_HK}
     \item{en_IE}
     \item{en_SG}
     \item{en_ZA}
     \item{fr_BE}
     \item{fr_LU}
     \item{fr_CH}
     \item{de_BE}
     \item{de_LU}
     \item{it_CH}
     \item{nl_BE}
     \item{es_AR}
     \item{es_BO}
     \item{es_CL}
     \item{es_CO}
     \item{es_CR}
     \item{es_DO}
     \item{es_EC}
     \item{es_SV}
     \item{es_GT}
     \item{es_HN}
     \item{es_NI}
     \item{es_PA}
     \item{es_PY}
     \item{es_PE}
     \item{es_PR}
     \item{es_US}
     \item{es_UY}
     \item{es_VE}
     \item{ca}
     \item{eo}
     \item{iw_EO}
   }
  }
 \item{queue}{a character}
 \item{sharedTo}{a SharedTo}
}

\strong{ListViewFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_listviewfilter.htm}{Salesforce Documentation for ListViewFilter}
\describe{
 \item{field}{a character}
 \item{operation}{a FilterOperation - which is a character taking one of the following values: 
   \itemize{
     \item{equals}
     \item{notEqual}
     \item{lessThan}
     \item{greaterThan}
     \item{lessOrEqual}
     \item{greaterOrEqual}
     \item{contains}
     \item{notContain}
     \item{startsWith}
     \item{includes}
     \item{excludes}
     \item{within}
   }
  }
 \item{value}{a character}
}

\strong{LiveAgentConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_liveagentconfig.htm}{Salesforce Documentation for LiveAgentConfig}
\describe{
 \item{enableLiveChat}{a character either 'true' or 'false'}
 \item{openNewAccountSubtab}{a character either 'true' or 'false'}
 \item{openNewCaseSubtab}{a character either 'true' or 'false'}
 \item{openNewContactSubtab}{a character either 'true' or 'false'}
 \item{openNewLeadSubtab}{a character either 'true' or 'false'}
 \item{openNewVFPageSubtab}{a character either 'true' or 'false'}
 \item{pageNamesToOpen}{a character}
 \item{showKnowledgeArticles}{a character either 'true' or 'false'}
}

\strong{LiveAgentSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_liveagentsettings.htm}{Salesforce Documentation for LiveAgentSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableLiveAgent}{a character either 'true' or 'false'}
}

\strong{LiveChatAgentConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatagentconfig.htm}{Salesforce Documentation for LiveChatAgentConfig}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{assignments}{a AgentConfigAssignments}
 \item{autoGreeting}{a character}
 \item{capacity}{a integer}
 \item{criticalWaitTime}{a integer}
 \item{customAgentName}{a character}
 \item{enableAgentFileTransfer}{a character either 'true' or 'false'}
 \item{enableAgentSneakPeek}{a character either 'true' or 'false'}
 \item{enableAssistanceFlag}{a character either 'true' or 'false'}
 \item{enableAutoAwayOnDecline}{a character either 'true' or 'false'}
 \item{enableAutoAwayOnPushTimeout}{a character either 'true' or 'false'}
 \item{enableChatConferencing}{a character either 'true' or 'false'}
 \item{enableChatMonitoring}{a character either 'true' or 'false'}
 \item{enableChatTransferToAgent}{a character either 'true' or 'false'}
 \item{enableChatTransferToButton}{a character either 'true' or 'false'}
 \item{enableChatTransferToSkill}{a character either 'true' or 'false'}
 \item{enableLogoutSound}{a character either 'true' or 'false'}
 \item{enableNotifications}{a character either 'true' or 'false'}
 \item{enableRequestSound}{a character either 'true' or 'false'}
 \item{enableSneakPeek}{a character either 'true' or 'false'}
 \item{enableVisitorBlocking}{a character either 'true' or 'false'}
 \item{enableWhisperMessage}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{supervisorDefaultAgentStatusFilter}{a SupervisorAgentStatusFilter - which is a character taking one of the following values: 
   \itemize{
     \item{Online}
     \item{Away}
     \item{Offline}
   }
  }
 \item{supervisorDefaultButtonFilter}{a character}
 \item{supervisorDefaultSkillFilter}{a character}
 \item{supervisorSkills}{a SupervisorAgentConfigSkills}
 \item{transferableButtons}{a AgentConfigButtons}
 \item{transferableSkills}{a AgentConfigSkills}
}

\strong{LiveChatButton}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatbutton.htm}{Salesforce Documentation for LiveChatButton}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{animation}{a LiveChatButtonPresentation - which is a character taking one of the following values: 
   \itemize{
     \item{Slide}
     \item{Fade}
     \item{Appear}
     \item{Custom}
   }
  }
 \item{autoGreeting}{a character}
 \item{chasitorIdleTimeout}{a integer}
 \item{chasitorIdleTimeoutWarning}{a integer}
 \item{chatPage}{a character}
 \item{customAgentName}{a character}
 \item{deployments}{a LiveChatButtonDeployments}
 \item{enableQueue}{a character either 'true' or 'false'}
 \item{inviteEndPosition}{a LiveChatButtonInviteEndPosition - which is a character taking one of the following values: 
   \itemize{
     \item{TopLeft}
     \item{Top}
     \item{TopRight}
     \item{Left}
     \item{Center}
     \item{Right}
     \item{BottomLeft}
     \item{Bottom}
     \item{BottomRight}
   }
  }
 \item{inviteImage}{a character}
 \item{inviteStartPosition}{a LiveChatButtonInviteStartPosition - which is a character taking one of the following values: 
   \itemize{
     \item{TopLeft}
     \item{TopLeftTop}
     \item{Top}
     \item{TopRightTop}
     \item{TopRight}
     \item{TopRightRight}
     \item{Right}
     \item{BottomRightRight}
     \item{BottomRight}
     \item{BottomRightBottom}
     \item{Bottom}
     \item{BottomLeftBottom}
     \item{BottomLeft}
     \item{BottomLeftLeft}
     \item{Left}
     \item{TopLeftLeft}
   }
  }
 \item{isActive}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{numberOfReroutingAttempts}{a integer}
 \item{offlineImage}{a character}
 \item{onlineImage}{a character}
 \item{optionsCustomRoutingIsEnabled}{a character either 'true' or 'false'}
 \item{optionsHasChasitorIdleTimeout}{a character either 'true' or 'false'}
 \item{optionsHasInviteAfterAccept}{a character either 'true' or 'false'}
 \item{optionsHasInviteAfterReject}{a character either 'true' or 'false'}
 \item{optionsHasRerouteDeclinedRequest}{a character either 'true' or 'false'}
 \item{optionsIsAutoAccept}{a character either 'true' or 'false'}
 \item{optionsIsInviteAutoRemove}{a character either 'true' or 'false'}
 \item{overallQueueLength}{a integer}
 \item{perAgentQueueLength}{a integer}
 \item{postChatPage}{a character}
 \item{postChatUrl}{a character}
 \item{preChatFormPage}{a character}
 \item{preChatFormUrl}{a character}
 \item{pushTimeOut}{a integer}
 \item{routingType}{a LiveChatButtonRoutingType - which is a character taking one of the following values: 
   \itemize{
     \item{Choice}
     \item{LeastActive}
     \item{MostAvailable}
   }
  }
 \item{site}{a character}
 \item{skills}{a LiveChatButtonSkills}
 \item{timeToRemoveInvite}{a integer}
 \item{type}{a LiveChatButtonType - which is a character taking one of the following values: 
   \itemize{
     \item{Standard}
     \item{Invite}
   }
  }
 \item{windowLanguage}{a Language - which is a character taking one of the following values: 
   \itemize{
     \item{en_US}
     \item{de}
     \item{es}
     \item{fr}
     \item{it}
     \item{ja}
     \item{sv}
     \item{ko}
     \item{zh_TW}
     \item{zh_CN}
     \item{pt_BR}
     \item{nl_NL}
     \item{da}
     \item{th}
     \item{fi}
     \item{ru}
     \item{es_MX}
     \item{no}
     \item{hu}
     \item{pl}
     \item{cs}
     \item{tr}
     \item{in}
     \item{ro}
     \item{vi}
     \item{uk}
     \item{iw}
     \item{el}
     \item{bg}
     \item{en_GB}
     \item{ar}
     \item{sk}
     \item{pt_PT}
     \item{hr}
     \item{sl}
     \item{fr_CA}
     \item{ka}
     \item{sr}
     \item{sh}
     \item{en_AU}
     \item{en_MY}
     \item{en_IN}
     \item{en_PH}
     \item{en_CA}
     \item{ro_MD}
     \item{bs}
     \item{mk}
     \item{lv}
     \item{lt}
     \item{et}
     \item{sq}
     \item{sh_ME}
     \item{mt}
     \item{ga}
     \item{eu}
     \item{cy}
     \item{is}
     \item{ms}
     \item{tl}
     \item{lb}
     \item{rm}
     \item{hy}
     \item{hi}
     \item{ur}
     \item{bn}
     \item{de_AT}
     \item{de_CH}
     \item{ta}
     \item{ar_DZ}
     \item{ar_BH}
     \item{ar_EG}
     \item{ar_IQ}
     \item{ar_JO}
     \item{ar_KW}
     \item{ar_LB}
     \item{ar_LY}
     \item{ar_MA}
     \item{ar_OM}
     \item{ar_QA}
     \item{ar_SA}
     \item{ar_SD}
     \item{ar_SY}
     \item{ar_TN}
     \item{ar_AE}
     \item{ar_YE}
     \item{zh_SG}
     \item{zh_HK}
     \item{en_HK}
     \item{en_IE}
     \item{en_SG}
     \item{en_ZA}
     \item{fr_BE}
     \item{fr_LU}
     \item{fr_CH}
     \item{de_BE}
     \item{de_LU}
     \item{it_CH}
     \item{nl_BE}
     \item{es_AR}
     \item{es_BO}
     \item{es_CL}
     \item{es_CO}
     \item{es_CR}
     \item{es_DO}
     \item{es_EC}
     \item{es_SV}
     \item{es_GT}
     \item{es_HN}
     \item{es_NI}
     \item{es_PA}
     \item{es_PY}
     \item{es_PE}
     \item{es_PR}
     \item{es_US}
     \item{es_UY}
     \item{es_VE}
     \item{ca}
     \item{eo}
     \item{iw_EO}
   }
  }
}

\strong{LiveChatButtonDeployments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatbuttondeployments.htm}{Salesforce Documentation for LiveChatButtonDeployments}
\describe{
 \item{deployment}{a character}
}

\strong{LiveChatButtonSkills}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatbuttonskills.htm}{Salesforce Documentation for LiveChatButtonSkills}
\describe{
 \item{skill}{a character}
}

\strong{LiveChatDeployment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatdeployment.htm}{Salesforce Documentation for LiveChatDeployment}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{brandingImage}{a character}
 \item{connectionTimeoutDuration}{a integer}
 \item{connectionWarningDuration}{a integer}
 \item{displayQueuePosition}{a character either 'true' or 'false'}
 \item{domainWhiteList}{a LiveChatDeploymentDomainWhitelist}
 \item{enablePrechatApi}{a character either 'true' or 'false'}
 \item{enableTranscriptSave}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{mobileBrandingImage}{a character}
 \item{site}{a character}
 \item{windowTitle}{a character}
}

\strong{LiveChatDeploymentDomainWhitelist}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatdeploymentdomainwhitelist.htm}{Salesforce Documentation for LiveChatDeploymentDomainWhitelist}
\describe{
 \item{domain}{a character}
}

\strong{LiveChatSensitiveDataRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livechatsensitivedatarule.htm}{Salesforce Documentation for LiveChatSensitiveDataRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionType}{a SensitiveDataActionType - which is a character taking one of the following values: 
   \itemize{
     \item{Remove}
     \item{Replace}
   }
  }
 \item{description}{a character}
 \item{enforceOn}{a integer}
 \item{isEnabled}{a character either 'true' or 'false'}
 \item{pattern}{a character}
 \item{replacement}{a character}
}

\strong{LiveMessageSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_livemessagesettings.htm}{Salesforce Documentation for LiveMessageSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableLiveMessage}{a character either 'true' or 'false'}
}

\strong{LogInfo}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_loginfo.htm}{Salesforce Documentation for LogInfo}
\describe{
 \item{category}{a LogCategory - which is a character taking one of the following values: 
   \itemize{
     \item{Db}
     \item{Workflow}
     \item{Validation}
     \item{Callout}
     \item{Apex_code}
     \item{Apex_profiling}
     \item{Visualforce}
     \item{System}
     \item{Wave}
     \item{All}
   }
  }
 \item{level}{a LogCategoryLevel - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Finest}
     \item{Finer}
     \item{Fine}
     \item{Debug}
     \item{Info}
     \item{Warn}
     \item{Error}
   }
  }
}

\strong{LookupFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lookupfilter.htm}{Salesforce Documentation for LookupFilter}
\describe{
 \item{active}{a character either 'true' or 'false'}
 \item{booleanFilter}{a character}
 \item{description}{a character}
 \item{errorMessage}{a character}
 \item{filterItems}{a FilterItem}
 \item{infoMessage}{a character}
 \item{isOptional}{a character either 'true' or 'false'}
}

\strong{LookupFilterTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_lookupfiltertranslation.htm}{Salesforce Documentation for LookupFilterTranslation}
\describe{
 \item{errorMessage}{a character}
 \item{informationalMessage}{a character}
}

\strong{MacroSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_macrosettings.htm}{Salesforce Documentation for MacroSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableAdvancedSearch}{a character either 'true' or 'false'}
}

\strong{ManagedTopic}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_managedtopic.htm}{Salesforce Documentation for ManagedTopic}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{managedTopicType}{a character}
 \item{name}{a character}
 \item{parentName}{a character}
 \item{position}{a integer}
 \item{topicDescription}{a character}
}

\strong{ManagedTopics}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_managedtopics.htm}{Salesforce Documentation for ManagedTopics}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{managedTopic}{a ManagedTopic}
}

\strong{MarketingActionSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_marketingactionsettings.htm}{Salesforce Documentation for MarketingActionSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableMarketingAction}{a character either 'true' or 'false'}
}

\strong{MarketingResourceType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_marketingresourcetype.htm}{Salesforce Documentation for MarketingResourceType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{object}{a character}
 \item{provider}{a character}
}

\strong{MatchingRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_matchingrule.htm}{Salesforce Documentation for MatchingRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{booleanFilter}{a character}
 \item{description}{a character}
 \item{label}{a character}
 \item{matchingRuleItems}{a MatchingRuleItem}
 \item{ruleStatus}{a MatchingRuleStatus - which is a character taking one of the following values: 
   \itemize{
     \item{Inactive}
     \item{DeactivationFailed}
     \item{Activating}
     \item{Deactivating}
     \item{Active}
     \item{ActivationFailed}
   }
  }
}

\strong{MatchingRuleItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_matchingruleitem.htm}{Salesforce Documentation for MatchingRuleItem}
\describe{
 \item{blankValueBehavior}{a BlankValueBehavior - which is a character taking one of the following values: 
   \itemize{
     \item{MatchBlanks}
     \item{NullNotAllowed}
   }
  }
 \item{fieldName}{a character}
 \item{matchingMethod}{a MatchingMethod - which is a character taking one of the following values: 
   \itemize{
     \item{Exact}
     \item{FirstName}
     \item{LastName}
     \item{CompanyName}
     \item{Phone}
     \item{City}
     \item{Street}
     \item{Zip}
     \item{Title}
   }
  }
}

\strong{MatchingRules}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_matchingrules.htm}{Salesforce Documentation for MatchingRules}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{matchingRules}{a MatchingRule}
}

\strong{Metadata}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_metadata.htm}{Salesforce Documentation for Metadata}
\describe{
 \item{fullName}{a character}
}

\strong{MetadataWithContent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_metadatawithcontent.htm}{Salesforce Documentation for MetadataWithContent}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{content}{a character formed using RCurl::base64Encode}
}

\strong{MilestoneType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_milestonetype.htm}{Salesforce Documentation for MilestoneType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{recurrenceType}{a MilestoneTypeRecurrenceType - which is a character taking one of the following values: 
   \itemize{
     \item{none}
     \item{recursIndependently}
     \item{recursChained}
   }
  }
}

\strong{MiniLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_minilayout.htm}{Salesforce Documentation for MiniLayout}
\describe{
 \item{fields}{a character}
 \item{relatedLists}{a RelatedListItem}
}

\strong{MobileSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_mobilesettings.htm}{Salesforce Documentation for MobileSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{chatterMobile}{a ChatterMobileSettings}
 \item{dashboardMobile}{a DashboardMobileSettings}
 \item{salesforceMobile}{a SFDCMobileSettings}
 \item{touchMobile}{a TouchMobileSettings}
}

\strong{ModeratedEntityField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_moderatedentityfield.htm}{Salesforce Documentation for ModeratedEntityField}
\describe{
 \item{entityName}{a character}
 \item{fieldName}{a character}
 \item{keywordList}{a character}
}

\strong{ModerationRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_moderationrule.htm}{Salesforce Documentation for ModerationRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{action}{a ModerationRuleAction - which is a character taking one of the following values: 
   \itemize{
     \item{Block}
     \item{FreezeAndNotify}
     \item{Review}
     \item{Replace}
     \item{Flag}
   }
  }
 \item{actionLimit}{a integer}
 \item{active}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{entitiesAndFields}{a ModeratedEntityField}
 \item{masterLabel}{a character}
 \item{notifyLimit}{a integer}
 \item{timePeriod}{a RateLimitTimePeriod - which is a character taking one of the following values: 
   \itemize{
     \item{Short}
     \item{Medium}
   }
  }
 \item{type}{a ModerationRuleType - which is a character taking one of the following values: 
   \itemize{
     \item{Content}
     \item{Rate}
   }
  }
 \item{userCriteria}{a character}
 \item{userMessage}{a character}
}

\strong{NamedCredential}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_namedcredential.htm}{Salesforce Documentation for NamedCredential}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{allowMergeFieldsInBody}{a character either 'true' or 'false'}
 \item{allowMergeFieldsInHeader}{a character either 'true' or 'false'}
 \item{authProvider}{a character}
 \item{certificate}{a character}
 \item{endpoint}{a character}
 \item{generateAuthorizationHeader}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{oauthRefreshToken}{a character}
 \item{oauthScope}{a character}
 \item{oauthToken}{a character}
 \item{password}{a character}
 \item{principalType}{a ExternalPrincipalType - which is a character taking one of the following values: 
   \itemize{
     \item{Anonymous}
     \item{PerUser}
     \item{NamedUser}
   }
  }
 \item{protocol}{a AuthenticationProtocol - which is a character taking one of the following values: 
   \itemize{
     \item{NoAuthentication}
     \item{Oauth}
     \item{Password}
   }
  }
 \item{username}{a character}
}

\strong{NameSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_namesettings.htm}{Salesforce Documentation for NameSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableMiddleName}{a character either 'true' or 'false'}
 \item{enableNameSuffix}{a character either 'true' or 'false'}
}

\strong{NavigationLinkSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_navigationlinkset.htm}{Salesforce Documentation for NavigationLinkSet}
\describe{
 \item{navigationMenuItem}{a NavigationMenuItem}
}

\strong{NavigationMenuItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_navigationmenuitem.htm}{Salesforce Documentation for NavigationMenuItem}
\describe{
 \item{defaultListViewId}{a character}
 \item{label}{a character}
 \item{position}{a integer}
 \item{publiclyAvailable}{a character either 'true' or 'false'}
 \item{subMenu}{a NavigationSubMenu}
 \item{target}{a character}
 \item{targetPreference}{a character}
 \item{type}{a character}
}

\strong{NavigationSubMenu}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_navigationsubmenu.htm}{Salesforce Documentation for NavigationSubMenu}
\describe{
 \item{navigationMenuItem}{a NavigationMenuItem}
}

\strong{Network}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_network.htm}{Salesforce Documentation for Network}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{allowInternalUserLogin}{a character either 'true' or 'false'}
 \item{allowMembersToFlag}{a character either 'true' or 'false'}
 \item{allowedExtensions}{a character}
 \item{caseCommentEmailTemplate}{a character}
 \item{changePasswordTemplate}{a character}
 \item{communityRoles}{a CommunityRoles}
 \item{description}{a character}
 \item{disableReputationRecordConversations}{a character either 'true' or 'false'}
 \item{emailFooterLogo}{a character}
 \item{emailFooterText}{a character}
 \item{emailSenderAddress}{a character}
 \item{emailSenderName}{a character}
 \item{enableCustomVFErrorPageOverrides}{a character either 'true' or 'false'}
 \item{enableDirectMessages}{a character either 'true' or 'false'}
 \item{enableGuestChatter}{a character either 'true' or 'false'}
 \item{enableGuestFileAccess}{a character either 'true' or 'false'}
 \item{enableInvitation}{a character either 'true' or 'false'}
 \item{enableKnowledgeable}{a character either 'true' or 'false'}
 \item{enableNicknameDisplay}{a character either 'true' or 'false'}
 \item{enablePrivateMessages}{a character either 'true' or 'false'}
 \item{enableReputation}{a character either 'true' or 'false'}
 \item{enableShowAllNetworkSettings}{a character either 'true' or 'false'}
 \item{enableSiteAsContainer}{a character either 'true' or 'false'}
 \item{enableTalkingAboutStats}{a character either 'true' or 'false'}
 \item{enableTopicAssignmentRules}{a character either 'true' or 'false'}
 \item{enableTopicSuggestions}{a character either 'true' or 'false'}
 \item{enableUpDownVote}{a character either 'true' or 'false'}
 \item{feedChannel}{a character}
 \item{forgotPasswordTemplate}{a character}
 \item{gatherCustomerSentimentData}{a character either 'true' or 'false'}
 \item{logoutUrl}{a character}
 \item{maxFileSizeKb}{a integer}
 \item{navigationLinkSet}{a NavigationLinkSet}
 \item{networkMemberGroups}{a NetworkMemberGroup}
 \item{networkPageOverrides}{a NetworkPageOverride}
 \item{newSenderAddress}{a character}
 \item{picassoSite}{a character}
 \item{recommendationAudience}{a RecommendationAudience}
 \item{recommendationDefinition}{a RecommendationDefinition}
 \item{reputationLevels}{a ReputationLevelDefinitions}
 \item{reputationPointsRules}{a ReputationPointsRules}
 \item{selfRegProfile}{a character}
 \item{selfRegistration}{a character either 'true' or 'false'}
 \item{sendWelcomeEmail}{a character either 'true' or 'false'}
 \item{site}{a character}
 \item{status}{a NetworkStatus - which is a character taking one of the following values: 
   \itemize{
     \item{UnderConstruction}
     \item{Live}
     \item{DownForMaintenance}
   }
  }
 \item{tabs}{a NetworkTabSet}
 \item{urlPathPrefix}{a character}
 \item{welcomeTemplate}{a character}
}

\strong{NetworkAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_networkaccess.htm}{Salesforce Documentation for NetworkAccess}
\describe{
 \item{ipRanges}{a IpRange}
}

\strong{NetworkBranding}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_networkbranding.htm}{Salesforce Documentation for NetworkBranding}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{loginFooterText}{a character}
 \item{loginLogo}{a character}
 \item{loginLogoName}{a character}
 \item{loginPrimaryColor}{a character}
 \item{loginQuaternaryColor}{a character}
 \item{loginRightFrameUrl}{a character}
 \item{network}{a character}
 \item{pageFooter}{a character}
 \item{pageHeader}{a character}
 \item{primaryColor}{a character}
 \item{primaryComplementColor}{a character}
 \item{quaternaryColor}{a character}
 \item{quaternaryComplementColor}{a character}
 \item{secondaryColor}{a character}
 \item{staticLogoImageUrl}{a character}
 \item{tertiaryColor}{a character}
 \item{tertiaryComplementColor}{a character}
 \item{zeronaryColor}{a character}
 \item{zeronaryComplementColor}{a character}
}

\strong{NetworkMemberGroup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_networkmembergroup.htm}{Salesforce Documentation for NetworkMemberGroup}
\describe{
 \item{permissionSet}{a character}
 \item{profile}{a character}
}

\strong{NetworkPageOverride}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_networkpageoverride.htm}{Salesforce Documentation for NetworkPageOverride}
\describe{
 \item{changePasswordPageOverrideSetting}{a NetworkPageOverrideSetting - which is a character taking one of the following values: 
   \itemize{
     \item{Designer}
     \item{VisualForce}
     \item{Standard}
   }
  }
 \item{forgotPasswordPageOverrideSetting}{a NetworkPageOverrideSetting - which is a character taking one of the following values: 
   \itemize{
     \item{Designer}
     \item{VisualForce}
     \item{Standard}
   }
  }
 \item{homePageOverrideSetting}{a NetworkPageOverrideSetting - which is a character taking one of the following values: 
   \itemize{
     \item{Designer}
     \item{VisualForce}
     \item{Standard}
   }
  }
 \item{loginPageOverrideSetting}{a NetworkPageOverrideSetting - which is a character taking one of the following values: 
   \itemize{
     \item{Designer}
     \item{VisualForce}
     \item{Standard}
   }
  }
 \item{selfRegProfilePageOverrideSetting}{a NetworkPageOverrideSetting - which is a character taking one of the following values: 
   \itemize{
     \item{Designer}
     \item{VisualForce}
     \item{Standard}
   }
  }
}

\strong{NetworkTabSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_networktabset.htm}{Salesforce Documentation for NetworkTabSet}
\describe{
 \item{customTab}{a character}
 \item{defaultTab}{a character}
 \item{standardTab}{a character}
}

\strong{NextAutomatedApprover}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_nextautomatedapprover.htm}{Salesforce Documentation for NextAutomatedApprover}
\describe{
 \item{useApproverFieldOfRecordOwner}{a character either 'true' or 'false'}
 \item{userHierarchyField}{a character}
}

\strong{ObjectMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_objectmapping.htm}{Salesforce Documentation for ObjectMapping}
\describe{
 \item{inputObject}{a character}
 \item{mappingFields}{a ObjectMappingField}
 \item{outputObject}{a character}
}

\strong{ObjectMappingField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_objectmappingfield.htm}{Salesforce Documentation for ObjectMappingField}
\describe{
 \item{inputField}{a character}
 \item{outputField}{a character}
}

\strong{ObjectNameCaseValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_objectnamecasevalue.htm}{Salesforce Documentation for ObjectNameCaseValue}
\describe{
 \item{article}{a Article - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Indefinite}
     \item{Definite}
   }
  }
 \item{caseType}{a CaseType - which is a character taking one of the following values: 
   \itemize{
     \item{Nominative}
     \item{Accusative}
     \item{Genitive}
     \item{Dative}
     \item{Inessive}
     \item{Elative}
     \item{Illative}
     \item{Adessive}
     \item{Ablative}
     \item{Allative}
     \item{Essive}
     \item{Translative}
     \item{Partitive}
     \item{Objective}
     \item{Subjective}
     \item{Instrumental}
     \item{Prepositional}
     \item{Locative}
     \item{Vocative}
     \item{Sublative}
     \item{Superessive}
     \item{Delative}
     \item{Causalfinal}
     \item{Essiveformal}
     \item{Termanative}
     \item{Distributive}
     \item{Ergative}
     \item{Adverbial}
     \item{Abessive}
     \item{Comitative}
   }
  }
 \item{plural}{a character either 'true' or 'false'}
 \item{possessive}{a Possessive - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{First}
     \item{Second}
   }
  }
 \item{value}{a character}
}

\strong{ObjectRelationship}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_objectrelationship.htm}{Salesforce Documentation for ObjectRelationship}
\describe{
 \item{join}{a ObjectRelationship}
 \item{outerJoin}{a character either 'true' or 'false'}
 \item{relationship}{a character}
}

\strong{ObjectSearchSetting}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_objectsearchsetting.htm}{Salesforce Documentation for ObjectSearchSetting}
\describe{
 \item{enhancedLookupEnabled}{a character either 'true' or 'false'}
 \item{lookupAutoCompleteEnabled}{a character either 'true' or 'false'}
 \item{name}{a character}
 \item{resultsPerPageCount}{a integer}
}

\strong{ObjectUsage}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_objectusage.htm}{Salesforce Documentation for ObjectUsage}
\describe{
 \item{object}{a character}
}

\strong{OpportunityListFieldsLabelMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_opportunitylistfieldslabelmapping.htm}{Salesforce Documentation for OpportunityListFieldsLabelMapping}
\describe{
 \item{field}{a character}
 \item{label}{a character}
}

\strong{OpportunityListFieldsSelectedSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_opportunitylistfieldsselectedsettings.htm}{Salesforce Documentation for OpportunityListFieldsSelectedSettings}
\describe{
 \item{field}{a character}
}

\strong{OpportunityListFieldsUnselectedSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_opportunitylistfieldsunselectedsettings.htm}{Salesforce Documentation for OpportunityListFieldsUnselectedSettings}
\describe{
 \item{field}{a character}
}

\strong{OpportunitySettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_opportunitysettings.htm}{Salesforce Documentation for OpportunitySettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{autoActivateNewReminders}{a character either 'true' or 'false'}
 \item{enableFindSimilarOpportunities}{a character either 'true' or 'false'}
 \item{enableOpportunityTeam}{a character either 'true' or 'false'}
 \item{enableUpdateReminders}{a character either 'true' or 'false'}
 \item{findSimilarOppFilter}{a FindSimilarOppFilter}
 \item{promptToAddProducts}{a character either 'true' or 'false'}
}

\strong{Orchestration}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_orchestration.htm}{Salesforce Documentation for Orchestration}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{context}{a character}
 \item{masterLabel}{a character}
}

\strong{OrchestrationContext}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_orchestrationcontext.htm}{Salesforce Documentation for OrchestrationContext}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{events}{a OrchestrationContextEvent}
 \item{masterLabel}{a character}
 \item{runtimeType}{a character}
 \item{salesforceObject}{a character}
 \item{salesforceObjectPrimaryKey}{a character}
}

\strong{OrchestrationContextEvent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_orchestrationcontextevent.htm}{Salesforce Documentation for OrchestrationContextEvent}
\describe{
 \item{eventType}{a character}
 \item{orchestrationEvent}{a character}
 \item{platformEvent}{a character}
 \item{platformEventPrimaryKey}{a character}
}

\strong{OrderSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_ordersettings.htm}{Salesforce Documentation for OrderSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableNegativeQuantity}{a character either 'true' or 'false'}
 \item{enableOrders}{a character either 'true' or 'false'}
 \item{enableReductionOrders}{a character either 'true' or 'false'}
 \item{enableZeroQuantity}{a character either 'true' or 'false'}
}

\strong{OrganizationSettingsDetail}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_organizationsettingsdetail.htm}{Salesforce Documentation for OrganizationSettingsDetail}
\describe{
 \item{settingName}{a character}
 \item{settingValue}{a character either 'true' or 'false'}
}

\strong{OrgPreferenceSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_orgpreferencesettings.htm}{Salesforce Documentation for OrgPreferenceSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{preferences}{a OrganizationSettingsDetail}
}

\strong{Package}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_package.htm}{Salesforce Documentation for Package}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{apiAccessLevel}{a APIAccessLevel - which is a character taking one of the following values: 
   \itemize{
     \item{Unrestricted}
     \item{Restricted}
   }
  }
 \item{description}{a character}
 \item{namespacePrefix}{a character}
 \item{objectPermissions}{a ProfileObjectPermissions}
 \item{packageType}{a character}
 \item{postInstallClass}{a character}
 \item{setupWeblink}{a character}
 \item{types}{a PackageTypeMembers}
 \item{uninstallClass}{a character}
 \item{version}{a character}
}

\strong{PackageTypeMembers}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_packagetypemembers.htm}{Salesforce Documentation for PackageTypeMembers}
\describe{
 \item{members}{a character}
 \item{name}{a character}
}

\strong{PackageVersion}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_packageversion.htm}{Salesforce Documentation for PackageVersion}
\describe{
 \item{majorNumber}{a integer}
 \item{minorNumber}{a integer}
 \item{namespace}{a character}
}

\strong{PasswordPolicies}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_passwordpolicies.htm}{Salesforce Documentation for PasswordPolicies}
\describe{
 \item{apiOnlyUserHomePageURL}{a character}
 \item{complexity}{a Complexity - which is a character taking one of the following values: 
   \itemize{
     \item{NoRestriction}
     \item{AlphaNumeric}
     \item{SpecialCharacters}
     \item{UpperLowerCaseNumeric}
     \item{UpperLowerCaseNumericSpecialCharacters}
   }
  }
 \item{expiration}{a Expiration - which is a character taking one of the following values: 
   \itemize{
     \item{ThirtyDays}
     \item{SixtyDays}
     \item{NinetyDays}
     \item{SixMonths}
     \item{OneYear}
     \item{Never}
   }
  }
 \item{historyRestriction}{a character}
 \item{lockoutInterval}{a LockoutInterval - which is a character taking one of the following values: 
   \itemize{
     \item{FifteenMinutes}
     \item{ThirtyMinutes}
     \item{SixtyMinutes}
     \item{Forever}
   }
  }
 \item{maxLoginAttempts}{a MaxLoginAttempts - which is a character taking one of the following values: 
   \itemize{
     \item{ThreeAttempts}
     \item{FiveAttempts}
     \item{TenAttempts}
     \item{NoLimit}
   }
  }
 \item{minimumPasswordLength}{a character}
 \item{minimumPasswordLifetime}{a character either 'true' or 'false'}
 \item{obscureSecretAnswer}{a character either 'true' or 'false'}
 \item{passwordAssistanceMessage}{a character}
 \item{passwordAssistanceURL}{a character}
 \item{questionRestriction}{a QuestionRestriction - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{DoesNotContainPassword}
   }
  }
}

\strong{PathAssistant}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_pathassistant.htm}{Salesforce Documentation for PathAssistant}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{entityName}{a character}
 \item{fieldName}{a character}
 \item{masterLabel}{a character}
 \item{pathAssistantSteps}{a PathAssistantStep}
 \item{recordTypeName}{a character}
}

\strong{PathAssistantSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_pathassistantsettings.htm}{Salesforce Documentation for PathAssistantSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{pathAssistantEnabled}{a character either 'true' or 'false'}
}

\strong{PathAssistantStep}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_pathassistantstep.htm}{Salesforce Documentation for PathAssistantStep}
\describe{
 \item{fieldNames}{a character}
 \item{info}{a character}
 \item{picklistValueName}{a character}
}

\strong{PermissionSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionset.htm}{Salesforce Documentation for PermissionSet}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{applicationVisibilities}{a PermissionSetApplicationVisibility}
 \item{classAccesses}{a PermissionSetApexClassAccess}
 \item{customPermissions}{a PermissionSetCustomPermissions}
 \item{description}{a character}
 \item{externalDataSourceAccesses}{a PermissionSetExternalDataSourceAccess}
 \item{fieldPermissions}{a PermissionSetFieldPermissions}
 \item{hasActivationRequired}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{license}{a character}
 \item{objectPermissions}{a PermissionSetObjectPermissions}
 \item{pageAccesses}{a PermissionSetApexPageAccess}
 \item{recordTypeVisibilities}{a PermissionSetRecordTypeVisibility}
 \item{tabSettings}{a PermissionSetTabSetting}
 \item{userPermissions}{a PermissionSetUserPermission}
}

\strong{PermissionSetApexClassAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetapexclassaccess.htm}{Salesforce Documentation for PermissionSetApexClassAccess}
\describe{
 \item{apexClass}{a character}
 \item{enabled}{a character either 'true' or 'false'}
}

\strong{PermissionSetApexPageAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetapexpageaccess.htm}{Salesforce Documentation for PermissionSetApexPageAccess}
\describe{
 \item{apexPage}{a character}
 \item{enabled}{a character either 'true' or 'false'}
}

\strong{PermissionSetApplicationVisibility}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetapplicationvisibility.htm}{Salesforce Documentation for PermissionSetApplicationVisibility}
\describe{
 \item{application}{a character}
 \item{visible}{a character either 'true' or 'false'}
}

\strong{PermissionSetCustomPermissions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetcustompermissions.htm}{Salesforce Documentation for PermissionSetCustomPermissions}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{PermissionSetExternalDataSourceAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetexternaldatasourceaccess.htm}{Salesforce Documentation for PermissionSetExternalDataSourceAccess}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{externalDataSource}{a character}
}

\strong{PermissionSetFieldPermissions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetfieldpermissions.htm}{Salesforce Documentation for PermissionSetFieldPermissions}
\describe{
 \item{editable}{a character either 'true' or 'false'}
 \item{field}{a character}
 \item{readable}{a character either 'true' or 'false'}
}

\strong{PermissionSetGroup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetgroup.htm}{Salesforce Documentation for PermissionSetGroup}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{isCalculatingChanges}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{permissionSets}{a character}
}

\strong{PermissionSetObjectPermissions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetobjectpermissions.htm}{Salesforce Documentation for PermissionSetObjectPermissions}
\describe{
 \item{allowCreate}{a character either 'true' or 'false'}
 \item{allowDelete}{a character either 'true' or 'false'}
 \item{allowEdit}{a character either 'true' or 'false'}
 \item{allowRead}{a character either 'true' or 'false'}
 \item{modifyAllRecords}{a character either 'true' or 'false'}
 \item{object}{a character}
 \item{viewAllRecords}{a character either 'true' or 'false'}
}

\strong{PermissionSetRecordTypeVisibility}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetrecordtypevisibility.htm}{Salesforce Documentation for PermissionSetRecordTypeVisibility}
\describe{
 \item{recordType}{a character}
 \item{visible}{a character either 'true' or 'false'}
}

\strong{PermissionSetTabSetting}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsettabsetting.htm}{Salesforce Documentation for PermissionSetTabSetting}
\describe{
 \item{tab}{a character}
 \item{visibility}{a PermissionSetTabVisibility - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Available}
     \item{Visible}
   }
  }
}

\strong{PermissionSetUserPermission}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_permissionsetuserpermission.htm}{Salesforce Documentation for PermissionSetUserPermission}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{PersonalJourneySettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_personaljourneysettings.htm}{Salesforce Documentation for PersonalJourneySettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableExactTargetForSalesforceApps}{a character either 'true' or 'false'}
}

\strong{PersonListSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_personlistsettings.htm}{Salesforce Documentation for PersonListSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enablePersonList}{a character either 'true' or 'false'}
}

\strong{PicklistEntry}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_picklistentry.htm}{Salesforce Documentation for PicklistEntry}
\describe{
 \item{active}{a character either 'true' or 'false'}
 \item{defaultValue}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{validFor}{a character}
 \item{value}{a character}
}

\strong{PicklistValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_picklistvalue.htm}{Salesforce Documentation for PicklistValue}
\describe{
 \item{color}{a character (inherited from GlobalPicklistValue)}
 \item{default}{a character either 'true' or 'false' (inherited from GlobalPicklistValue)}
 \item{description}{a character (inherited from GlobalPicklistValue)}
 \item{isActive}{a character either 'true' or 'false' (inherited from GlobalPicklistValue)}
 \item{allowEmail}{a character either 'true' or 'false'}
 \item{closed}{a character either 'true' or 'false'}
 \item{controllingFieldValues}{a character}
 \item{converted}{a character either 'true' or 'false'}
 \item{cssExposed}{a character either 'true' or 'false'}
 \item{forecastCategory}{a ForecastCategories - which is a character taking one of the following values: 
   \itemize{
     \item{Omitted}
     \item{Pipeline}
     \item{BestCase}
     \item{Forecast}
     \item{Closed}
   }
  }
 \item{highPriority}{a character either 'true' or 'false'}
 \item{probability}{a integer}
 \item{reverseRole}{a character}
 \item{reviewed}{a character either 'true' or 'false'}
 \item{won}{a character either 'true' or 'false'}
}

\strong{PicklistValueTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_picklistvaluetranslation.htm}{Salesforce Documentation for PicklistValueTranslation}
\describe{
 \item{masterLabel}{a character}
 \item{translation}{a character}
}

\strong{PlatformActionList}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_platformactionlist.htm}{Salesforce Documentation for PlatformActionList}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actionListContext}{a PlatformActionListContext - which is a character taking one of the following values: 
   \itemize{
     \item{ListView}
     \item{RelatedList}
     \item{ListViewRecord}
     \item{RelatedListRecord}
     \item{Record}
     \item{FeedElement}
     \item{Chatter}
     \item{Global}
     \item{Flexipage}
     \item{MruList}
     \item{MruRow}
     \item{RecordEdit}
     \item{Photo}
     \item{BannerPhoto}
     \item{ObjectHomeChart}
     \item{ListViewDefinition}
     \item{Dockable}
     \item{Lookup}
     \item{Assistant}
   }
  }
 \item{platformActionListItems}{a PlatformActionListItem}
 \item{relatedSourceEntity}{a character}
}

\strong{PlatformActionListItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_platformactionlistitem.htm}{Salesforce Documentation for PlatformActionListItem}
\describe{
 \item{actionName}{a character}
 \item{actionType}{a PlatformActionType - which is a character taking one of the following values: 
   \itemize{
     \item{QuickAction}
     \item{StandardButton}
     \item{CustomButton}
     \item{ProductivityAction}
     \item{ActionLink}
     \item{InvocableAction}
   }
  }
 \item{sortOrder}{a integer}
 \item{subtype}{a character}
}

\strong{PlatformCachePartition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_platformcachepartition.htm}{Salesforce Documentation for PlatformCachePartition}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{isDefaultPartition}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{platformCachePartitionTypes}{a PlatformCachePartitionType}
}

\strong{PlatformCachePartitionType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_platformcachepartitiontype.htm}{Salesforce Documentation for PlatformCachePartitionType}
\describe{
 \item{allocatedCapacity}{a integer}
 \item{allocatedPurchasedCapacity}{a integer}
 \item{allocatedTrialCapacity}{a integer}
 \item{cacheType}{a PlatformCacheType - which is a character taking one of the following values: 
   \itemize{
     \item{Session}
     \item{Organization}
   }
  }
}

\strong{Portal}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_portal.htm}{Salesforce Documentation for Portal}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{admin}{a character}
 \item{defaultLanguage}{a character}
 \item{description}{a character}
 \item{emailSenderAddress}{a character}
 \item{emailSenderName}{a character}
 \item{enableSelfCloseCase}{a character either 'true' or 'false'}
 \item{footerDocument}{a character}
 \item{forgotPassTemplate}{a character}
 \item{headerDocument}{a character}
 \item{isSelfRegistrationActivated}{a character either 'true' or 'false'}
 \item{loginHeaderDocument}{a character}
 \item{logoDocument}{a character}
 \item{logoutUrl}{a character}
 \item{newCommentTemplate}{a character}
 \item{newPassTemplate}{a character}
 \item{newUserTemplate}{a character}
 \item{ownerNotifyTemplate}{a character}
 \item{selfRegNewUserUrl}{a character}
 \item{selfRegUserDefaultProfile}{a character}
 \item{selfRegUserDefaultRole}{a PortalRoles - which is a character taking one of the following values: 
   \itemize{
     \item{Executive}
     \item{Manager}
     \item{Worker}
     \item{PersonAccount}
   }
  }
 \item{selfRegUserTemplate}{a character}
 \item{showActionConfirmation}{a character either 'true' or 'false'}
 \item{stylesheetDocument}{a character}
 \item{type}{a PortalType - which is a character taking one of the following values: 
   \itemize{
     \item{CustomerSuccess}
     \item{Partner}
     \item{Network}
   }
  }
}

\strong{PostTemplate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_posttemplate.htm}{Salesforce Documentation for PostTemplate}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{default}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{fields}{a character}
 \item{label}{a character}
}

\strong{PrimaryTabComponents}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_primarytabcomponents.htm}{Salesforce Documentation for PrimaryTabComponents}
\describe{
 \item{containers}{a Container}
}

\strong{ProductSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_productsettings.htm}{Salesforce Documentation for ProductSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableCascadeActivateToRelatedPrices}{a character either 'true' or 'false'}
 \item{enableQuantitySchedule}{a character either 'true' or 'false'}
 \item{enableRevenueSchedule}{a character either 'true' or 'false'}
}

\strong{Profile}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profile.htm}{Salesforce Documentation for Profile}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{applicationVisibilities}{a ProfileApplicationVisibility}
 \item{categoryGroupVisibilities}{a ProfileCategoryGroupVisibility}
 \item{classAccesses}{a ProfileApexClassAccess}
 \item{custom}{a character either 'true' or 'false'}
 \item{customPermissions}{a ProfileCustomPermissions}
 \item{description}{a character}
 \item{externalDataSourceAccesses}{a ProfileExternalDataSourceAccess}
 \item{fieldPermissions}{a ProfileFieldLevelSecurity}
 \item{layoutAssignments}{a ProfileLayoutAssignment}
 \item{loginHours}{a ProfileLoginHours}
 \item{loginIpRanges}{a ProfileLoginIpRange}
 \item{objectPermissions}{a ProfileObjectPermissions}
 \item{pageAccesses}{a ProfileApexPageAccess}
 \item{profileActionOverrides}{a ProfileActionOverride}
 \item{recordTypeVisibilities}{a ProfileRecordTypeVisibility}
 \item{tabVisibilities}{a ProfileTabVisibility}
 \item{userLicense}{a character}
 \item{userPermissions}{a ProfileUserPermission}
}

\strong{ProfileActionOverride}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileactionoverride.htm}{Salesforce Documentation for ProfileActionOverride}
\describe{
 \item{actionName}{a character}
 \item{content}{a character}
 \item{formFactor}{a FormFactor - which is a character taking one of the following values: 
   \itemize{
     \item{Small}
     \item{Medium}
     \item{Large}
   }
  }
 \item{pageOrSobjectType}{a character}
 \item{recordType}{a character}
 \item{type}{a ActionOverrideType - which is a character taking one of the following values: 
   \itemize{
     \item{Default}
     \item{Standard}
     \item{Scontrol}
     \item{Visualforce}
     \item{Flexipage}
     \item{LightningComponent}
   }
  }
}

\strong{ProfileApexClassAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileapexclassaccess.htm}{Salesforce Documentation for ProfileApexClassAccess}
\describe{
 \item{apexClass}{a character}
 \item{enabled}{a character either 'true' or 'false'}
}

\strong{ProfileApexPageAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileapexpageaccess.htm}{Salesforce Documentation for ProfileApexPageAccess}
\describe{
 \item{apexPage}{a character}
 \item{enabled}{a character either 'true' or 'false'}
}

\strong{ProfileApplicationVisibility}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileapplicationvisibility.htm}{Salesforce Documentation for ProfileApplicationVisibility}
\describe{
 \item{application}{a character}
 \item{default}{a character either 'true' or 'false'}
 \item{visible}{a character either 'true' or 'false'}
}

\strong{ProfileCategoryGroupVisibility}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilecategorygroupvisibility.htm}{Salesforce Documentation for ProfileCategoryGroupVisibility}
\describe{
 \item{dataCategories}{a character}
 \item{dataCategoryGroup}{a character}
 \item{visibility}{a CategoryGroupVisibility - which is a character taking one of the following values: 
   \itemize{
     \item{ALL}
     \item{NONE}
     \item{CUSTOM}
   }
  }
}

\strong{ProfileCustomPermissions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilecustompermissions.htm}{Salesforce Documentation for ProfileCustomPermissions}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{ProfileExternalDataSourceAccess}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileexternaldatasourceaccess.htm}{Salesforce Documentation for ProfileExternalDataSourceAccess}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{externalDataSource}{a character}
}

\strong{ProfileFieldLevelSecurity}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilefieldlevelsecurity.htm}{Salesforce Documentation for ProfileFieldLevelSecurity}
\describe{
 \item{editable}{a character either 'true' or 'false'}
 \item{field}{a character}
 \item{readable}{a character either 'true' or 'false'}
}

\strong{ProfileLayoutAssignment}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilelayoutassignment.htm}{Salesforce Documentation for ProfileLayoutAssignment}
\describe{
 \item{layout}{a character}
 \item{recordType}{a character}
}

\strong{ProfileLoginHours}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileloginhours.htm}{Salesforce Documentation for ProfileLoginHours}
\describe{
 \item{fridayEnd}{a character}
 \item{fridayStart}{a character}
 \item{mondayEnd}{a character}
 \item{mondayStart}{a character}
 \item{saturdayEnd}{a character}
 \item{saturdayStart}{a character}
 \item{sundayEnd}{a character}
 \item{sundayStart}{a character}
 \item{thursdayEnd}{a character}
 \item{thursdayStart}{a character}
 \item{tuesdayEnd}{a character}
 \item{tuesdayStart}{a character}
 \item{wednesdayEnd}{a character}
 \item{wednesdayStart}{a character}
}

\strong{ProfileLoginIpRange}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileloginiprange.htm}{Salesforce Documentation for ProfileLoginIpRange}
\describe{
 \item{description}{a character}
 \item{endAddress}{a character}
 \item{startAddress}{a character}
}

\strong{ProfileObjectPermissions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileobjectpermissions.htm}{Salesforce Documentation for ProfileObjectPermissions}
\describe{
 \item{allowCreate}{a character either 'true' or 'false'}
 \item{allowDelete}{a character either 'true' or 'false'}
 \item{allowEdit}{a character either 'true' or 'false'}
 \item{allowRead}{a character either 'true' or 'false'}
 \item{modifyAllRecords}{a character either 'true' or 'false'}
 \item{object}{a character}
 \item{viewAllRecords}{a character either 'true' or 'false'}
}

\strong{ProfilePasswordPolicy}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilepasswordpolicy.htm}{Salesforce Documentation for ProfilePasswordPolicy}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{lockoutInterval}{a integer}
 \item{maxLoginAttempts}{a integer}
 \item{minimumPasswordLength}{a integer}
 \item{minimumPasswordLifetime}{a character either 'true' or 'false'}
 \item{obscure}{a character either 'true' or 'false'}
 \item{passwordComplexity}{a integer}
 \item{passwordExpiration}{a integer}
 \item{passwordHistory}{a integer}
 \item{passwordQuestion}{a integer}
 \item{profile}{a character}
}

\strong{ProfileRecordTypeVisibility}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilerecordtypevisibility.htm}{Salesforce Documentation for ProfileRecordTypeVisibility}
\describe{
 \item{default}{a character either 'true' or 'false'}
 \item{personAccountDefault}{a character either 'true' or 'false'}
 \item{recordType}{a character}
 \item{visible}{a character either 'true' or 'false'}
}

\strong{ProfileSessionSetting}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profilesessionsetting.htm}{Salesforce Documentation for ProfileSessionSetting}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{externalCommunityUserIdentityVerif}{a character either 'true' or 'false'}
 \item{forceLogout}{a character either 'true' or 'false'}
 \item{profile}{a character}
 \item{requiredSessionLevel}{a SessionSecurityLevel - which is a character taking one of the following values: 
   \itemize{
     \item{LOW}
     \item{STANDARD}
     \item{HIGH_ASSURANCE}
   }
  }
 \item{sessionPersistence}{a character either 'true' or 'false'}
 \item{sessionTimeout}{a integer}
 \item{sessionTimeoutWarning}{a character either 'true' or 'false'}
}

\strong{ProfileTabVisibility}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profiletabvisibility.htm}{Salesforce Documentation for ProfileTabVisibility}
\describe{
 \item{tab}{a character}
 \item{visibility}{a TabVisibility - which is a character taking one of the following values: 
   \itemize{
     \item{Hidden}
     \item{DefaultOff}
     \item{DefaultOn}
   }
  }
}

\strong{ProfileUserPermission}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_profileuserpermission.htm}{Salesforce Documentation for ProfileUserPermission}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{PublicGroups}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_publicgroups.htm}{Salesforce Documentation for PublicGroups}
\describe{
 \item{publicGroup}{a character}
}

\strong{PushNotification}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_pushnotification.htm}{Salesforce Documentation for PushNotification}
\describe{
 \item{fieldNames}{a character}
 \item{objectName}{a character}
}

\strong{Queue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_queue.htm}{Salesforce Documentation for Queue}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{doesSendEmailToMembers}{a character either 'true' or 'false'}
 \item{email}{a character}
 \item{name}{a character}
 \item{queueMembers}{a QueueMembers}
 \item{queueRoutingConfig}{a character}
 \item{queueSobject}{a QueueSobject}
}

\strong{QueueMembers}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_queuemembers.htm}{Salesforce Documentation for QueueMembers}
\describe{
 \item{publicGroups}{a PublicGroups}
 \item{roleAndSubordinates}{a RoleAndSubordinates}
 \item{roleAndSubordinatesInternal}{a RoleAndSubordinatesInternal}
 \item{roles}{a Roles}
 \item{users}{a Users}
}

\strong{QueueSobject}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_queuesobject.htm}{Salesforce Documentation for QueueSobject}
\describe{
 \item{sobjectType}{a character}
}

\strong{QuickAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickaction.htm}{Salesforce Documentation for QuickAction}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{canvas}{a character}
 \item{description}{a character}
 \item{fieldOverrides}{a FieldOverride}
 \item{flowDefinition}{a character}
 \item{height}{a integer}
 \item{icon}{a character}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{lightningComponent}{a character}
 \item{optionsCreateFeedItem}{a character either 'true' or 'false'}
 \item{page}{a character}
 \item{quickActionLayout}{a QuickActionLayout}
 \item{quickActionSendEmailOptions}{a QuickActionSendEmailOptions}
 \item{standardLabel}{a QuickActionLabel - which is a character taking one of the following values: 
   \itemize{
     \item{LogACall}
     \item{LogANote}
     \item{New}
     \item{NewRecordType}
     \item{Update}
     \item{NewChild}
     \item{NewChildRecordType}
     \item{CreateNew}
     \item{CreateNewRecordType}
     \item{SendEmail}
     \item{QuickRecordType}
     \item{Quick}
     \item{EditDescription}
     \item{Defer}
     \item{ChangeDueDate}
     \item{ChangePriority}
     \item{ChangeStatus}
     \item{SocialPost}
     \item{Escalate}
     \item{EscalateToRecord}
     \item{OfferFeedback}
     \item{RequestFeedback}
     \item{AddRecord}
     \item{AddMember}
     \item{Reply}
     \item{ReplyAll}
     \item{Forward}
   }
  }
 \item{successMessage}{a character}
 \item{targetObject}{a character}
 \item{targetParentField}{a character}
 \item{targetRecordType}{a character}
 \item{type}{a QuickActionType - which is a character taking one of the following values: 
   \itemize{
     \item{Create}
     \item{VisualforcePage}
     \item{Post}
     \item{SendEmail}
     \item{LogACall}
     \item{SocialPost}
     \item{Canvas}
     \item{Update}
     \item{LightningComponent}
     \item{Flow}
   }
  }
 \item{width}{a integer}
}

\strong{QuickActionLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactionlayout.htm}{Salesforce Documentation for QuickActionLayout}
\describe{
 \item{layoutSectionStyle}{a LayoutSectionStyle - which is a character taking one of the following values: 
   \itemize{
     \item{TwoColumnsTopToBottom}
     \item{TwoColumnsLeftToRight}
     \item{OneColumn}
     \item{CustomLinks}
   }
  }
 \item{quickActionLayoutColumns}{a QuickActionLayoutColumn}
}

\strong{QuickActionLayoutColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactionlayoutcolumn.htm}{Salesforce Documentation for QuickActionLayoutColumn}
\describe{
 \item{quickActionLayoutItems}{a QuickActionLayoutItem}
}

\strong{QuickActionLayoutItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactionlayoutitem.htm}{Salesforce Documentation for QuickActionLayoutItem}
\describe{
 \item{emptySpace}{a character either 'true' or 'false'}
 \item{field}{a character}
 \item{uiBehavior}{a UiBehavior - which is a character taking one of the following values: 
   \itemize{
     \item{Edit}
     \item{Required}
     \item{Readonly}
   }
  }
}

\strong{QuickActionList}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactionlist.htm}{Salesforce Documentation for QuickActionList}
\describe{
 \item{quickActionListItems}{a QuickActionListItem}
}

\strong{QuickActionListItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactionlistitem.htm}{Salesforce Documentation for QuickActionListItem}
\describe{
 \item{quickActionName}{a character}
}

\strong{QuickActionSendEmailOptions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactionsendemailoptions.htm}{Salesforce Documentation for QuickActionSendEmailOptions}
\describe{
 \item{defaultEmailTemplateName}{a character}
 \item{ignoreDefaultEmailTemplateSubject}{a character either 'true' or 'false'}
}

\strong{QuickActionTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quickactiontranslation.htm}{Salesforce Documentation for QuickActionTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{QuotasSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quotassettings.htm}{Salesforce Documentation for QuotasSettings}
\describe{
 \item{showQuotas}{a character either 'true' or 'false'}
}

\strong{QuoteSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_quotesettings.htm}{Salesforce Documentation for QuoteSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableQuote}{a character either 'true' or 'false'}
}

\strong{RecommendationAudience}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recommendationaudience.htm}{Salesforce Documentation for RecommendationAudience}
\describe{
 \item{recommendationAudienceDetails}{a RecommendationAudienceDetail}
}

\strong{RecommendationAudienceDetail}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recommendationaudiencedetail.htm}{Salesforce Documentation for RecommendationAudienceDetail}
\describe{
 \item{audienceCriteriaType}{a AudienceCriteriaType - which is a character taking one of the following values: 
   \itemize{
     \item{CustomList}
     \item{MaxDaysInCommunity}
   }
  }
 \item{audienceCriteriaValue}{a character}
 \item{setupName}{a character}
}

\strong{RecommendationDefinition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recommendationdefinition.htm}{Salesforce Documentation for RecommendationDefinition}
\describe{
 \item{recommendationDefinitionDetails}{a RecommendationDefinitionDetail}
}

\strong{RecommendationDefinitionDetail}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recommendationdefinitiondetail.htm}{Salesforce Documentation for RecommendationDefinitionDetail}
\describe{
 \item{actionUrl}{a character}
 \item{description}{a character}
 \item{linkText}{a character}
 \item{scheduledRecommendations}{a ScheduledRecommendation}
 \item{setupName}{a character}
 \item{title}{a character}
}

\strong{RecommendationStrategy}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recommendationstrategy.htm}{Salesforce Documentation for RecommendationStrategy}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{recommendationStrategyName}{a character}
 \item{strategyNode}{a StrategyNode}
}

\strong{RecordType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recordtype.htm}{Salesforce Documentation for RecordType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{businessProcess}{a character}
 \item{compactLayoutAssignment}{a character}
 \item{description}{a character}
 \item{label}{a character}
 \item{picklistValues}{a RecordTypePicklistValue}
}

\strong{RecordTypePicklistValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recordtypepicklistvalue.htm}{Salesforce Documentation for RecordTypePicklistValue}
\describe{
 \item{picklist}{a character}
 \item{values}{a PicklistValue}
}

\strong{RecordTypeTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_recordtypetranslation.htm}{Salesforce Documentation for RecordTypeTranslation}
\describe{
 \item{description}{a character}
 \item{label}{a character}
 \item{name}{a character}
}

\strong{RelatedContent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_relatedcontent.htm}{Salesforce Documentation for RelatedContent}
\describe{
 \item{relatedContentItems}{a RelatedContentItem}
}

\strong{RelatedContentItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_relatedcontentitem.htm}{Salesforce Documentation for RelatedContentItem}
\describe{
 \item{layoutItem}{a LayoutItem}
}

\strong{RelatedList}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_relatedlist.htm}{Salesforce Documentation for RelatedList}
\describe{
 \item{hideOnDetail}{a character either 'true' or 'false'}
 \item{name}{a character}
}

\strong{RelatedListItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_relatedlistitem.htm}{Salesforce Documentation for RelatedListItem}
\describe{
 \item{customButtons}{a character}
 \item{excludeButtons}{a character}
 \item{fields}{a character}
 \item{relatedList}{a character}
 \item{sortField}{a character}
 \item{sortOrder}{a SortOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
}

\strong{RemoteSiteSetting}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_remotesitesetting.htm}{Salesforce Documentation for RemoteSiteSetting}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{disableProtocolSecurity}{a character either 'true' or 'false'}
 \item{isActive}{a character either 'true' or 'false'}
 \item{url}{a character}
}

\strong{Report}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_report.htm}{Salesforce Documentation for Report}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{aggregates}{a ReportAggregate}
 \item{block}{a Report}
 \item{blockInfo}{a ReportBlockInfo}
 \item{buckets}{a ReportBucketField}
 \item{chart}{a ReportChart}
 \item{colorRanges}{a ReportColorRange}
 \item{columns}{a ReportColumn}
 \item{crossFilters}{a ReportCrossFilter}
 \item{currency}{a CurrencyIsoCode - which is a character taking one of the following values: 
   \itemize{
     \item{ADP}
     \item{AED}
     \item{AFA}
     \item{AFN}
     \item{ALL}
     \item{AMD}
     \item{ANG}
     \item{AOA}
     \item{ARS}
     \item{ATS}
     \item{AUD}
     \item{AWG}
     \item{AZM}
     \item{AZN}
     \item{BAM}
     \item{BBD}
     \item{BDT}
     \item{BEF}
     \item{BGL}
     \item{BGN}
     \item{BHD}
     \item{BIF}
     \item{BMD}
     \item{BND}
     \item{BOB}
     \item{BOV}
     \item{BRB}
     \item{BRL}
     \item{BSD}
     \item{BTN}
     \item{BWP}
     \item{BYB}
     \item{BYN}
     \item{BYR}
     \item{BZD}
     \item{CAD}
     \item{CDF}
     \item{CHF}
     \item{CLF}
     \item{CLP}
     \item{CNY}
     \item{COP}
     \item{CRC}
     \item{CSD}
     \item{CUC}
     \item{CUP}
     \item{CVE}
     \item{CYP}
     \item{CZK}
     \item{DEM}
     \item{DJF}
     \item{DKK}
     \item{DOP}
     \item{DZD}
     \item{ECS}
     \item{EEK}
     \item{EGP}
     \item{ERN}
     \item{ESP}
     \item{ETB}
     \item{EUR}
     \item{FIM}
     \item{FJD}
     \item{FKP}
     \item{FRF}
     \item{GBP}
     \item{GEL}
     \item{GHC}
     \item{GHS}
     \item{GIP}
     \item{GMD}
     \item{GNF}
     \item{GRD}
     \item{GTQ}
     \item{GWP}
     \item{GYD}
     \item{HKD}
     \item{HNL}
     \item{HRD}
     \item{HRK}
     \item{HTG}
     \item{HUF}
     \item{IDR}
     \item{IEP}
     \item{ILS}
     \item{INR}
     \item{IQD}
     \item{IRR}
     \item{ISK}
     \item{ITL}
     \item{JMD}
     \item{JOD}
     \item{JPY}
     \item{KES}
     \item{KGS}
     \item{KHR}
     \item{KMF}
     \item{KPW}
     \item{KRW}
     \item{KWD}
     \item{KYD}
     \item{KZT}
     \item{LAK}
     \item{LBP}
     \item{LKR}
     \item{LRD}
     \item{LSL}
     \item{LTL}
     \item{LUF}
     \item{LVL}
     \item{LYD}
     \item{MAD}
     \item{MDL}
     \item{MGA}
     \item{MGF}
     \item{MKD}
     \item{MMK}
     \item{MNT}
     \item{MOP}
     \item{MRO}
     \item{MTL}
     \item{MUR}
     \item{MVR}
     \item{MWK}
     \item{MXN}
     \item{MXV}
     \item{MYR}
     \item{MZM}
     \item{MZN}
     \item{NAD}
     \item{NGN}
     \item{NIO}
     \item{NLG}
     \item{NOK}
     \item{NPR}
     \item{NZD}
     \item{OMR}
     \item{PAB}
     \item{PEN}
     \item{PGK}
     \item{PHP}
     \item{PKR}
     \item{PLN}
     \item{PTE}
     \item{PYG}
     \item{QAR}
     \item{RMB}
     \item{ROL}
     \item{RON}
     \item{RSD}
     \item{RUB}
     \item{RUR}
     \item{RWF}
     \item{SAR}
     \item{SBD}
     \item{SCR}
     \item{SDD}
     \item{SDG}
     \item{SEK}
     \item{SGD}
     \item{SHP}
     \item{SIT}
     \item{SKK}
     \item{SLL}
     \item{SOS}
     \item{SRD}
     \item{SRG}
     \item{SSP}
     \item{STD}
     \item{SUR}
     \item{SVC}
     \item{SYP}
     \item{SZL}
     \item{THB}
     \item{TJR}
     \item{TJS}
     \item{TMM}
     \item{TMT}
     \item{TND}
     \item{TOP}
     \item{TPE}
     \item{TRL}
     \item{TRY}
     \item{TTD}
     \item{TWD}
     \item{TZS}
     \item{UAH}
     \item{UGX}
     \item{USD}
     \item{UYU}
     \item{UZS}
     \item{VEB}
     \item{VEF}
     \item{VND}
     \item{VUV}
     \item{WST}
     \item{XAF}
     \item{XCD}
     \item{XOF}
     \item{XPF}
     \item{YER}
     \item{YUM}
     \item{ZAR}
     \item{ZMK}
     \item{ZMW}
     \item{ZWD}
     \item{ZWL}
   }
  }
 \item{dataCategoryFilters}{a ReportDataCategoryFilter}
 \item{description}{a character}
 \item{division}{a character}
 \item{filter}{a ReportFilter}
 \item{folderName}{a character}
 \item{format}{a ReportFormat - which is a character taking one of the following values: 
   \itemize{
     \item{MultiBlock}
     \item{Matrix}
     \item{Summary}
     \item{Tabular}
   }
  }
 \item{groupingsAcross}{a ReportGrouping}
 \item{groupingsDown}{a ReportGrouping}
 \item{historicalSelector}{a ReportHistoricalSelector}
 \item{name}{a character}
 \item{numSubscriptions}{a integer}
 \item{params}{a ReportParam}
 \item{reportType}{a character}
 \item{roleHierarchyFilter}{a character}
 \item{rowLimit}{a integer}
 \item{scope}{a character}
 \item{showCurrentDate}{a character either 'true' or 'false'}
 \item{showDetails}{a character either 'true' or 'false'}
 \item{sortColumn}{a character}
 \item{sortOrder}{a SortOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
 \item{territoryHierarchyFilter}{a character}
 \item{timeFrameFilter}{a ReportTimeFrameFilter}
 \item{userFilter}{a character}
}

\strong{ReportAggregate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportaggregate.htm}{Salesforce Documentation for ReportAggregate}
\describe{
 \item{acrossGroupingContext}{a character}
 \item{calculatedFormula}{a character}
 \item{datatype}{a ReportAggregateDatatype - which is a character taking one of the following values: 
   \itemize{
     \item{currency}
     \item{percent}
     \item{number}
   }
  }
 \item{description}{a character}
 \item{developerName}{a character}
 \item{downGroupingContext}{a character}
 \item{isActive}{a character either 'true' or 'false'}
 \item{isCrossBlock}{a character either 'true' or 'false'}
 \item{masterLabel}{a character}
 \item{reportType}{a character}
 \item{scale}{a integer}
}

\strong{ReportAggregateReference}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportaggregatereference.htm}{Salesforce Documentation for ReportAggregateReference}
\describe{
 \item{aggregate}{a character}
}

\strong{ReportBlockInfo}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportblockinfo.htm}{Salesforce Documentation for ReportBlockInfo}
\describe{
 \item{aggregateReferences}{a ReportAggregateReference}
 \item{blockId}{a character}
 \item{joinTable}{a character}
}

\strong{ReportBucketField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportbucketfield.htm}{Salesforce Documentation for ReportBucketField}
\describe{
 \item{bucketType}{a ReportBucketFieldType - which is a character taking one of the following values: 
   \itemize{
     \item{text}
     \item{number}
     \item{picklist}
   }
  }
 \item{developerName}{a character}
 \item{masterLabel}{a character}
 \item{nullTreatment}{a ReportFormulaNullTreatment - which is a character taking one of the following values: 
   \itemize{
     \item{n}
     \item{z}
   }
  }
 \item{otherBucketLabel}{a character}
 \item{sourceColumnName}{a character}
 \item{useOther}{a character either 'true' or 'false'}
 \item{values}{a ReportBucketFieldValue}
}

\strong{ReportBucketFieldSourceValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportbucketfieldsourcevalue.htm}{Salesforce Documentation for ReportBucketFieldSourceValue}
\describe{
 \item{from}{a character}
 \item{sourceValue}{a character}
 \item{to}{a character}
}

\strong{ReportBucketFieldValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportbucketfieldvalue.htm}{Salesforce Documentation for ReportBucketFieldValue}
\describe{
 \item{sourceValues}{a ReportBucketFieldSourceValue}
 \item{value}{a character}
}

\strong{ReportChart}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportchart.htm}{Salesforce Documentation for ReportChart}
\describe{
 \item{backgroundColor1}{a character}
 \item{backgroundColor2}{a character}
 \item{backgroundFadeDir}{a ChartBackgroundDirection - which is a character taking one of the following values: 
   \itemize{
     \item{TopToBottom}
     \item{LeftToRight}
     \item{Diagonal}
   }
  }
 \item{chartSummaries}{a ChartSummary}
 \item{chartType}{a ChartType - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Scatter}
     \item{ScatterGrouped}
     \item{Bubble}
     \item{BubbleGrouped}
     \item{HorizontalBar}
     \item{HorizontalBarGrouped}
     \item{HorizontalBarStacked}
     \item{HorizontalBarStackedTo100}
     \item{VerticalColumn}
     \item{VerticalColumnGrouped}
     \item{VerticalColumnStacked}
     \item{VerticalColumnStackedTo100}
     \item{Line}
     \item{LineGrouped}
     \item{LineCumulative}
     \item{LineCumulativeGrouped}
     \item{Pie}
     \item{Donut}
     \item{Funnel}
     \item{VerticalColumnLine}
     \item{VerticalColumnGroupedLine}
     \item{VerticalColumnStackedLine}
     \item{Plugin}
   }
  }
 \item{enableHoverLabels}{a character either 'true' or 'false'}
 \item{expandOthers}{a character either 'true' or 'false'}
 \item{groupingColumn}{a character}
 \item{legendPosition}{a ChartLegendPosition - which is a character taking one of the following values: 
   \itemize{
     \item{Right}
     \item{Bottom}
     \item{OnChart}
   }
  }
 \item{location}{a ChartPosition - which is a character taking one of the following values: 
   \itemize{
     \item{CHART_TOP}
     \item{CHART_BOTTOM}
   }
  }
 \item{secondaryGroupingColumn}{a character}
 \item{showAxisLabels}{a character either 'true' or 'false'}
 \item{showPercentage}{a character either 'true' or 'false'}
 \item{showTotal}{a character either 'true' or 'false'}
 \item{showValues}{a character either 'true' or 'false'}
 \item{size}{a ReportChartSize - which is a character taking one of the following values: 
   \itemize{
     \item{Tiny}
     \item{Small}
     \item{Medium}
     \item{Large}
     \item{Huge}
   }
  }
 \item{summaryAxisManualRangeEnd}{a numeric}
 \item{summaryAxisManualRangeStart}{a numeric}
 \item{summaryAxisRange}{a ChartRangeType - which is a character taking one of the following values: 
   \itemize{
     \item{Auto}
     \item{Manual}
   }
  }
 \item{textColor}{a character}
 \item{textSize}{a integer}
 \item{title}{a character}
 \item{titleColor}{a character}
 \item{titleSize}{a integer}
}

\strong{ReportChartComponentLayoutItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportchartcomponentlayoutitem.htm}{Salesforce Documentation for ReportChartComponentLayoutItem}
\describe{
 \item{cacheData}{a character either 'true' or 'false'}
 \item{contextFilterableField}{a character}
 \item{error}{a character}
 \item{hideOnError}{a character either 'true' or 'false'}
 \item{includeContext}{a character either 'true' or 'false'}
 \item{reportName}{a character}
 \item{showTitle}{a character either 'true' or 'false'}
 \item{size}{a ReportChartComponentSize - which is a character taking one of the following values: 
   \itemize{
     \item{SMALL}
     \item{MEDIUM}
     \item{LARGE}
   }
  }
}

\strong{ReportColorRange}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportcolorrange.htm}{Salesforce Documentation for ReportColorRange}
\describe{
 \item{aggregate}{a ReportSummaryType - which is a character taking one of the following values: 
   \itemize{
     \item{Sum}
     \item{Average}
     \item{Maximum}
     \item{Minimum}
     \item{None}
   }
  }
 \item{columnName}{a character}
 \item{highBreakpoint}{a numeric}
 \item{highColor}{a character}
 \item{lowBreakpoint}{a numeric}
 \item{lowColor}{a character}
 \item{midColor}{a character}
}

\strong{ReportColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportcolumn.htm}{Salesforce Documentation for ReportColumn}
\describe{
 \item{aggregateTypes}{a ReportSummaryType - which is a character taking one of the following values: 
   \itemize{
     \item{Sum}
     \item{Average}
     \item{Maximum}
     \item{Minimum}
     \item{None}
   }
  }
 \item{field}{a character}
 \item{reverseColors}{a character either 'true' or 'false'}
 \item{showChanges}{a character either 'true' or 'false'}
}

\strong{ReportCrossFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportcrossfilter.htm}{Salesforce Documentation for ReportCrossFilter}
\describe{
 \item{criteriaItems}{a ReportFilterItem}
 \item{operation}{a ObjectFilterOperator - which is a character taking one of the following values: 
   \itemize{
     \item{with}
     \item{without}
   }
  }
 \item{primaryTableColumn}{a character}
 \item{relatedTable}{a character}
 \item{relatedTableJoinColumn}{a character}
}

\strong{ReportDataCategoryFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportdatacategoryfilter.htm}{Salesforce Documentation for ReportDataCategoryFilter}
\describe{
 \item{dataCategory}{a character}
 \item{dataCategoryGroup}{a character}
 \item{operator}{a DataCategoryFilterOperation - which is a character taking one of the following values: 
   \itemize{
     \item{above}
     \item{below}
     \item{at}
     \item{aboveOrBelow}
   }
  }
}

\strong{ReportFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportfilter.htm}{Salesforce Documentation for ReportFilter}
\describe{
 \item{booleanFilter}{a character}
 \item{criteriaItems}{a ReportFilterItem}
 \item{language}{a Language - which is a character taking one of the following values: 
   \itemize{
     \item{en_US}
     \item{de}
     \item{es}
     \item{fr}
     \item{it}
     \item{ja}
     \item{sv}
     \item{ko}
     \item{zh_TW}
     \item{zh_CN}
     \item{pt_BR}
     \item{nl_NL}
     \item{da}
     \item{th}
     \item{fi}
     \item{ru}
     \item{es_MX}
     \item{no}
     \item{hu}
     \item{pl}
     \item{cs}
     \item{tr}
     \item{in}
     \item{ro}
     \item{vi}
     \item{uk}
     \item{iw}
     \item{el}
     \item{bg}
     \item{en_GB}
     \item{ar}
     \item{sk}
     \item{pt_PT}
     \item{hr}
     \item{sl}
     \item{fr_CA}
     \item{ka}
     \item{sr}
     \item{sh}
     \item{en_AU}
     \item{en_MY}
     \item{en_IN}
     \item{en_PH}
     \item{en_CA}
     \item{ro_MD}
     \item{bs}
     \item{mk}
     \item{lv}
     \item{lt}
     \item{et}
     \item{sq}
     \item{sh_ME}
     \item{mt}
     \item{ga}
     \item{eu}
     \item{cy}
     \item{is}
     \item{ms}
     \item{tl}
     \item{lb}
     \item{rm}
     \item{hy}
     \item{hi}
     \item{ur}
     \item{bn}
     \item{de_AT}
     \item{de_CH}
     \item{ta}
     \item{ar_DZ}
     \item{ar_BH}
     \item{ar_EG}
     \item{ar_IQ}
     \item{ar_JO}
     \item{ar_KW}
     \item{ar_LB}
     \item{ar_LY}
     \item{ar_MA}
     \item{ar_OM}
     \item{ar_QA}
     \item{ar_SA}
     \item{ar_SD}
     \item{ar_SY}
     \item{ar_TN}
     \item{ar_AE}
     \item{ar_YE}
     \item{zh_SG}
     \item{zh_HK}
     \item{en_HK}
     \item{en_IE}
     \item{en_SG}
     \item{en_ZA}
     \item{fr_BE}
     \item{fr_LU}
     \item{fr_CH}
     \item{de_BE}
     \item{de_LU}
     \item{it_CH}
     \item{nl_BE}
     \item{es_AR}
     \item{es_BO}
     \item{es_CL}
     \item{es_CO}
     \item{es_CR}
     \item{es_DO}
     \item{es_EC}
     \item{es_SV}
     \item{es_GT}
     \item{es_HN}
     \item{es_NI}
     \item{es_PA}
     \item{es_PY}
     \item{es_PE}
     \item{es_PR}
     \item{es_US}
     \item{es_UY}
     \item{es_VE}
     \item{ca}
     \item{eo}
     \item{iw_EO}
   }
  }
}

\strong{ReportFilterItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportfilteritem.htm}{Salesforce Documentation for ReportFilterItem}
\describe{
 \item{column}{a character}
 \item{columnToColumn}{a character either 'true' or 'false'}
 \item{isUnlocked}{a character either 'true' or 'false'}
 \item{operator}{a FilterOperation - which is a character taking one of the following values: 
   \itemize{
     \item{equals}
     \item{notEqual}
     \item{lessThan}
     \item{greaterThan}
     \item{lessOrEqual}
     \item{greaterOrEqual}
     \item{contains}
     \item{notContain}
     \item{startsWith}
     \item{includes}
     \item{excludes}
     \item{within}
   }
  }
 \item{snapshot}{a character}
 \item{value}{a character}
}

\strong{ReportFolder}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportfolder.htm}{Salesforce Documentation for ReportFolder}
\describe{
 \item{accessType}{a FolderAccessTypes (inherited from Folder)}
 \item{folderShares}{a FolderShare (inherited from Folder)}
 \item{name}{a character (inherited from Folder)}
 \item{publicFolderAccess}{a PublicFolderAccess (inherited from Folder)}
 \item{sharedTo}{a SharedTo (inherited from Folder)}
}

\strong{ReportGrouping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportgrouping.htm}{Salesforce Documentation for ReportGrouping}
\describe{
 \item{aggregateType}{a ReportAggrType - which is a character taking one of the following values: 
   \itemize{
     \item{Sum}
     \item{Average}
     \item{Maximum}
     \item{Minimum}
     \item{RowCount}
   }
  }
 \item{dateGranularity}{a UserDateGranularity - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Day}
     \item{Week}
     \item{Month}
     \item{Quarter}
     \item{Year}
     \item{FiscalQuarter}
     \item{FiscalYear}
     \item{MonthInYear}
     \item{DayInMonth}
     \item{FiscalPeriod}
     \item{FiscalWeek}
   }
  }
 \item{field}{a character}
 \item{sortByName}{a character}
 \item{sortOrder}{a SortOrder - which is a character taking one of the following values: 
   \itemize{
     \item{Asc}
     \item{Desc}
   }
  }
 \item{sortType}{a ReportSortType - which is a character taking one of the following values: 
   \itemize{
     \item{Column}
     \item{Aggregate}
     \item{CustomSummaryFormula}
   }
  }
}

\strong{ReportHistoricalSelector}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporthistoricalselector.htm}{Salesforce Documentation for ReportHistoricalSelector}
\describe{
 \item{snapshot}{a character}
}

\strong{ReportLayoutSection}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportlayoutsection.htm}{Salesforce Documentation for ReportLayoutSection}
\describe{
 \item{columns}{a ReportTypeColumn}
 \item{masterLabel}{a character}
}

\strong{ReportParam}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reportparam.htm}{Salesforce Documentation for ReportParam}
\describe{
 \item{name}{a character}
 \item{value}{a character}
}

\strong{ReportTimeFrameFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporttimeframefilter.htm}{Salesforce Documentation for ReportTimeFrameFilter}
\describe{
 \item{dateColumn}{a character}
 \item{endDate}{a character formatted as 'yyyy-mm-dd'}
 \item{interval}{a UserDateInterval - which is a character taking one of the following values: 
   \itemize{
     \item{INTERVAL_CURRENT}
     \item{INTERVAL_CURNEXT1}
     \item{INTERVAL_CURPREV1}
     \item{INTERVAL_NEXT1}
     \item{INTERVAL_PREV1}
     \item{INTERVAL_CURNEXT3}
     \item{INTERVAL_CURFY}
     \item{INTERVAL_PREVFY}
     \item{INTERVAL_PREV2FY}
     \item{INTERVAL_AGO2FY}
     \item{INTERVAL_NEXTFY}
     \item{INTERVAL_PREVCURFY}
     \item{INTERVAL_PREVCUR2FY}
     \item{INTERVAL_CURNEXTFY}
     \item{INTERVAL_CUSTOM}
     \item{INTERVAL_YESTERDAY}
     \item{INTERVAL_TODAY}
     \item{INTERVAL_TOMORROW}
     \item{INTERVAL_LASTWEEK}
     \item{INTERVAL_THISWEEK}
     \item{INTERVAL_NEXTWEEK}
     \item{INTERVAL_LASTMONTH}
     \item{INTERVAL_THISMONTH}
     \item{INTERVAL_NEXTMONTH}
     \item{INTERVAL_LASTTHISMONTH}
     \item{INTERVAL_THISNEXTMONTH}
     \item{INTERVAL_CURRENTQ}
     \item{INTERVAL_CURNEXTQ}
     \item{INTERVAL_CURPREVQ}
     \item{INTERVAL_NEXTQ}
     \item{INTERVAL_PREVQ}
     \item{INTERVAL_CURNEXT3Q}
     \item{INTERVAL_CURY}
     \item{INTERVAL_PREVY}
     \item{INTERVAL_PREV2Y}
     \item{INTERVAL_AGO2Y}
     \item{INTERVAL_NEXTY}
     \item{INTERVAL_PREVCURY}
     \item{INTERVAL_PREVCUR2Y}
     \item{INTERVAL_CURNEXTY}
     \item{INTERVAL_LAST7}
     \item{INTERVAL_LAST30}
     \item{INTERVAL_LAST60}
     \item{INTERVAL_LAST90}
     \item{INTERVAL_LAST120}
     \item{INTERVAL_NEXT7}
     \item{INTERVAL_NEXT30}
     \item{INTERVAL_NEXT60}
     \item{INTERVAL_NEXT90}
     \item{INTERVAL_NEXT120}
     \item{LAST_FISCALWEEK}
     \item{THIS_FISCALWEEK}
     \item{NEXT_FISCALWEEK}
     \item{LAST_FISCALPERIOD}
     \item{THIS_FISCALPERIOD}
     \item{NEXT_FISCALPERIOD}
     \item{LASTTHIS_FISCALPERIOD}
     \item{THISNEXT_FISCALPERIOD}
     \item{CURRENT_ENTITLEMENT_PERIOD}
     \item{PREVIOUS_ENTITLEMENT_PERIOD}
     \item{PREVIOUS_TWO_ENTITLEMENT_PERIODS}
     \item{TWO_ENTITLEMENT_PERIODS_AGO}
     \item{CURRENT_AND_PREVIOUS_ENTITLEMENT_PERIOD}
     \item{CURRENT_AND_PREVIOUS_TWO_ENTITLEMENT_PERIODS}
   }
  }
 \item{startDate}{a character formatted as 'yyyy-mm-dd'}
}

\strong{ReportType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporttype.htm}{Salesforce Documentation for ReportType}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{autogenerated}{a character either 'true' or 'false'}
 \item{baseObject}{a character}
 \item{category}{a ReportTypeCategory - which is a character taking one of the following values: 
   \itemize{
     \item{accounts}
     \item{opportunities}
     \item{forecasts}
     \item{cases}
     \item{leads}
     \item{campaigns}
     \item{activities}
     \item{busop}
     \item{products}
     \item{admin}
     \item{territory}
     \item{other}
     \item{content}
     \item{usage_entitlement}
     \item{wdc}
     \item{calibration}
     \item{territory2}
   }
  }
 \item{deployed}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{join}{a ObjectRelationship}
 \item{label}{a character}
 \item{sections}{a ReportLayoutSection}
}

\strong{ReportTypeColumn}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporttypecolumn.htm}{Salesforce Documentation for ReportTypeColumn}
\describe{
 \item{checkedByDefault}{a character either 'true' or 'false'}
 \item{displayNameOverride}{a character}
 \item{field}{a character}
 \item{table}{a character}
}

\strong{ReportTypeColumnTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporttypecolumntranslation.htm}{Salesforce Documentation for ReportTypeColumnTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{ReportTypeSectionTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporttypesectiontranslation.htm}{Salesforce Documentation for ReportTypeSectionTranslation}
\describe{
 \item{columns}{a ReportTypeColumnTranslation}
 \item{label}{a character}
 \item{name}{a character}
}

\strong{ReportTypeTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reporttypetranslation.htm}{Salesforce Documentation for ReportTypeTranslation}
\describe{
 \item{description}{a character}
 \item{label}{a character}
 \item{name}{a character}
 \item{sections}{a ReportTypeSectionTranslation}
}

\strong{ReputationBranding}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reputationbranding.htm}{Salesforce Documentation for ReputationBranding}
\describe{
 \item{smallImage}{a character}
}

\strong{ReputationLevel}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reputationlevel.htm}{Salesforce Documentation for ReputationLevel}
\describe{
 \item{branding}{a ReputationBranding}
 \item{label}{a character}
 \item{lowerThreshold}{a numeric}
}

\strong{ReputationLevelDefinitions}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reputationleveldefinitions.htm}{Salesforce Documentation for ReputationLevelDefinitions}
\describe{
 \item{level}{a ReputationLevel}
}

\strong{ReputationLevels}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reputationlevels.htm}{Salesforce Documentation for ReputationLevels}
\describe{
 \item{chatterAnswersReputationLevels}{a ChatterAnswersReputationLevel}
 \item{ideaReputationLevels}{a IdeaReputationLevel}
}

\strong{ReputationPointsRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reputationpointsrule.htm}{Salesforce Documentation for ReputationPointsRule}
\describe{
 \item{eventType}{a character}
 \item{points}{a integer}
}

\strong{ReputationPointsRules}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_reputationpointsrules.htm}{Salesforce Documentation for ReputationPointsRules}
\describe{
 \item{pointsRule}{a ReputationPointsRule}
}

\strong{RetrieveRequest}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_retrieverequest.htm}{Salesforce Documentation for RetrieveRequest}
\describe{
 \item{apiVersion}{a numeric}
 \item{packageNames}{a character}
 \item{singlePackage}{a character either 'true' or 'false'}
 \item{specificFiles}{a character}
 \item{unpackaged}{a Package}
}

\strong{Role}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_role.htm}{Salesforce Documentation for Role}
\describe{
 \item{caseAccessLevel}{a character (inherited from RoleOrTerritory)}
 \item{contactAccessLevel}{a character (inherited from RoleOrTerritory)}
 \item{description}{a character (inherited from RoleOrTerritory)}
 \item{mayForecastManagerShare}{a character either 'true' or 'false' (inherited from RoleOrTerritory)}
 \item{name}{a character (inherited from RoleOrTerritory)}
 \item{opportunityAccessLevel}{a character (inherited from RoleOrTerritory)}
 \item{parentRole}{a character}
}

\strong{RoleAndSubordinates}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_roleandsubordinates.htm}{Salesforce Documentation for RoleAndSubordinates}
\describe{
 \item{roleAndSubordinate}{a character}
}

\strong{RoleAndSubordinatesInternal}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_roleandsubordinatesinternal.htm}{Salesforce Documentation for RoleAndSubordinatesInternal}
\describe{
 \item{roleAndSubordinateInternal}{a character}
}

\strong{RoleOrTerritory}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_roleorterritory.htm}{Salesforce Documentation for RoleOrTerritory}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{caseAccessLevel}{a character}
 \item{contactAccessLevel}{a character}
 \item{description}{a character}
 \item{mayForecastManagerShare}{a character either 'true' or 'false'}
 \item{name}{a character}
 \item{opportunityAccessLevel}{a character}
}

\strong{Roles}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_roles.htm}{Salesforce Documentation for Roles}
\describe{
 \item{role}{a character}
}

\strong{RuleEntry}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_ruleentry.htm}{Salesforce Documentation for RuleEntry}
\describe{
 \item{assignedTo}{a character}
 \item{assignedToType}{a AssignToLookupValueType - which is a character taking one of the following values: 
   \itemize{
     \item{User}
     \item{Queue}
   }
  }
 \item{booleanFilter}{a character}
 \item{businessHours}{a character}
 \item{businessHoursSource}{a BusinessHoursSourceType - which is a character taking one of the following values: 
   \itemize{
     \item{None}
     \item{Case}
     \item{Static}
   }
  }
 \item{criteriaItems}{a FilterItem}
 \item{disableEscalationWhenModified}{a character either 'true' or 'false'}
 \item{escalationAction}{a EscalationAction}
 \item{escalationStartTime}{a EscalationStartTimeType - which is a character taking one of the following values: 
   \itemize{
     \item{CaseCreation}
     \item{CaseLastModified}
   }
  }
 \item{formula}{a character}
 \item{notifyCcRecipients}{a character either 'true' or 'false'}
 \item{overrideExistingTeams}{a character either 'true' or 'false'}
 \item{replyToEmail}{a character}
 \item{senderEmail}{a character}
 \item{senderName}{a character}
 \item{team}{a character}
 \item{template}{a character}
}

\strong{SamlSsoConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_samlssoconfig.htm}{Salesforce Documentation for SamlSsoConfig}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{attributeName}{a character}
 \item{attributeNameIdFormat}{a character}
 \item{decryptionCertificate}{a character}
 \item{errorUrl}{a character}
 \item{executionUserId}{a character}
 \item{identityLocation}{a SamlIdentityLocationType - which is a character taking one of the following values: 
   \itemize{
     \item{SubjectNameId}
     \item{Attribute}
   }
  }
 \item{identityMapping}{a SamlIdentityType - which is a character taking one of the following values: 
   \itemize{
     \item{Username}
     \item{FederationId}
     \item{UserId}
   }
  }
 \item{issuer}{a character}
 \item{loginUrl}{a character}
 \item{logoutUrl}{a character}
 \item{name}{a character}
 \item{oauthTokenEndpoint}{a character}
 \item{redirectBinding}{a character either 'true' or 'false'}
 \item{requestSignatureMethod}{a character}
 \item{requestSigningCertId}{a character}
 \item{salesforceLoginUrl}{a character}
 \item{samlEntityId}{a character}
 \item{samlJitHandlerId}{a character}
 \item{samlVersion}{a SamlType - which is a character taking one of the following values: 
   \itemize{
     \item{SAML1_1}
     \item{SAML2_0}
   }
  }
 \item{singleLogoutBinding}{a SamlSpSLOBinding - which is a character taking one of the following values: 
   \itemize{
     \item{RedirectBinding}
     \item{PostBinding}
   }
  }
 \item{singleLogoutUrl}{a character}
 \item{userProvisioning}{a character either 'true' or 'false'}
 \item{validationCert}{a character}
}

\strong{ScheduledRecommendation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_scheduledrecommendation.htm}{Salesforce Documentation for ScheduledRecommendation}
\describe{
 \item{scheduledRecommendationDetails}{a ScheduledRecommendationDetail}
}

\strong{ScheduledRecommendationDetail}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_scheduledrecommendationdetail.htm}{Salesforce Documentation for ScheduledRecommendationDetail}
\describe{
 \item{channel}{a RecommendationChannel - which is a character taking one of the following values: 
   \itemize{
     \item{DefaultChannel}
     \item{CustomChannel1}
     \item{CustomChannel2}
     \item{CustomChannel3}
     \item{CustomChannel4}
     \item{CustomChannel5}
   }
  }
 \item{enabled}{a character either 'true' or 'false'}
 \item{rank}{a integer}
 \item{recommendationAudience}{a character}
}

\strong{Scontrol}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_scontrol.htm}{Salesforce Documentation for Scontrol}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{contentSource}{a SControlContentSource - which is a character taking one of the following values: 
   \itemize{
     \item{HTML}
     \item{URL}
     \item{Snippet}
   }
  }
 \item{description}{a character}
 \item{encodingKey}{a Encoding - which is a character taking one of the following values: 
   \itemize{
     \item{UTF-8}
     \item{ISO-8859-1}
     \item{Shift_JIS}
     \item{ISO-2022-JP}
     \item{EUC-JP}
     \item{ks_c_5601-1987}
     \item{Big5}
     \item{GB2312}
     \item{Big5-HKSCS}
     \item{x-SJIS_0213}
   }
  }
 \item{fileContent}{a character formed using RCurl::base64Encode}
 \item{fileName}{a character}
 \item{name}{a character}
 \item{supportsCaching}{a character either 'true' or 'false'}
}

\strong{ScontrolTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_scontroltranslation.htm}{Salesforce Documentation for ScontrolTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{SearchLayouts}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_searchlayouts.htm}{Salesforce Documentation for SearchLayouts}
\describe{
 \item{customTabListAdditionalFields}{a character}
 \item{excludedStandardButtons}{a character}
 \item{listViewButtons}{a character}
 \item{lookupDialogsAdditionalFields}{a character}
 \item{lookupFilterFields}{a character}
 \item{lookupPhoneDialogsAdditionalFields}{a character}
 \item{searchFilterFields}{a character}
 \item{searchResultsAdditionalFields}{a character}
 \item{searchResultsCustomButtons}{a character}
}

\strong{SearchSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_searchsettings.htm}{Salesforce Documentation for SearchSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{documentContentSearchEnabled}{a character either 'true' or 'false'}
 \item{optimizeSearchForCJKEnabled}{a character either 'true' or 'false'}
 \item{recentlyViewedUsersForBlankLookupEnabled}{a character either 'true' or 'false'}
 \item{searchSettingsByObject}{a SearchSettingsByObject}
 \item{sidebarAutoCompleteEnabled}{a character either 'true' or 'false'}
 \item{sidebarDropDownListEnabled}{a character either 'true' or 'false'}
 \item{sidebarLimitToItemsIOwnCheckboxEnabled}{a character either 'true' or 'false'}
 \item{singleSearchResultShortcutEnabled}{a character either 'true' or 'false'}
 \item{spellCorrectKnowledgeSearchEnabled}{a character either 'true' or 'false'}
}

\strong{SearchSettingsByObject}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_searchsettingsbyobject.htm}{Salesforce Documentation for SearchSettingsByObject}
\describe{
 \item{searchSettingsByObject}{a ObjectSearchSetting}
}

\strong{SecuritySettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_securitysettings.htm}{Salesforce Documentation for SecuritySettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{networkAccess}{a NetworkAccess}
 \item{passwordPolicies}{a PasswordPolicies}
 \item{sessionSettings}{a SessionSettings}
}

\strong{ServiceCloudConsoleConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_servicecloudconsoleconfig.htm}{Salesforce Documentation for ServiceCloudConsoleConfig}
\describe{
 \item{componentList}{a AppComponentList}
 \item{detailPageRefreshMethod}{a character}
 \item{footerColor}{a character}
 \item{headerColor}{a character}
 \item{keyboardShortcuts}{a KeyboardShortcuts}
 \item{listPlacement}{a ListPlacement}
 \item{listRefreshMethod}{a character}
 \item{liveAgentConfig}{a LiveAgentConfig}
 \item{primaryTabColor}{a character}
 \item{pushNotifications}{a PushNotification}
 \item{tabLimitConfig}{a TabLimitConfig}
 \item{whitelistedDomains}{a character}
}

\strong{SessionSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sessionsettings.htm}{Salesforce Documentation for SessionSettings}
\describe{
 \item{disableTimeoutWarning}{a character either 'true' or 'false'}
 \item{enableCSPOnEmail}{a character either 'true' or 'false'}
 \item{enableCSRFOnGet}{a character either 'true' or 'false'}
 \item{enableCSRFOnPost}{a character either 'true' or 'false'}
 \item{enableCacheAndAutocomplete}{a character either 'true' or 'false'}
 \item{enableClickjackNonsetupSFDC}{a character either 'true' or 'false'}
 \item{enableClickjackNonsetupUser}{a character either 'true' or 'false'}
 \item{enableClickjackNonsetupUserHeaderless}{a character either 'true' or 'false'}
 \item{enableClickjackSetup}{a character either 'true' or 'false'}
 \item{enableContentSniffingProtection}{a character either 'true' or 'false'}
 \item{enablePostForSessions}{a character either 'true' or 'false'}
 \item{enableSMSIdentity}{a character either 'true' or 'false'}
 \item{enableUpgradeInsecureRequests}{a character either 'true' or 'false'}
 \item{enableXssProtection}{a character either 'true' or 'false'}
 \item{enforceIpRangesEveryRequest}{a character either 'true' or 'false'}
 \item{forceLogoutOnSessionTimeout}{a character either 'true' or 'false'}
 \item{forceRelogin}{a character either 'true' or 'false'}
 \item{hstsOnForcecomSites}{a character either 'true' or 'false'}
 \item{identityConfirmationOnEmailChange}{a character either 'true' or 'false'}
 \item{identityConfirmationOnTwoFactorRegistrationEnabled}{a character either 'true' or 'false'}
 \item{lockSessionsToDomain}{a character either 'true' or 'false'}
 \item{lockSessionsToIp}{a character either 'true' or 'false'}
 \item{logoutURL}{a character}
 \item{redirectionWarning}{a character either 'true' or 'false'}
 \item{referrerPolicy}{a character either 'true' or 'false'}
 \item{requireHttpOnly}{a character either 'true' or 'false'}
 \item{requireHttps}{a character either 'true' or 'false'}
 \item{securityCentralKillSession}{a character either 'true' or 'false'}
 \item{sessionTimeout}{a SessionTimeout - which is a character taking one of the following values: 
   \itemize{
     \item{TwentyFourHours}
     \item{TwelveHours}
     \item{EightHours}
     \item{FourHours}
     \item{TwoHours}
     \item{SixtyMinutes}
     \item{ThirtyMinutes}
     \item{FifteenMinutes}
   }
  }
}

\strong{SFDCMobileSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sfdcmobilesettings.htm}{Salesforce Documentation for SFDCMobileSettings}
\describe{
 \item{enableMobileLite}{a character either 'true' or 'false'}
 \item{enableUserToDeviceLinking}{a character either 'true' or 'false'}
}

\strong{SharedTo}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharedto.htm}{Salesforce Documentation for SharedTo}
\describe{
 \item{allCustomerPortalUsers}{a character}
 \item{allInternalUsers}{a character}
 \item{allPartnerUsers}{a character}
 \item{channelProgramGroup}{a character}
 \item{channelProgramGroups}{a character}
 \item{group}{a character}
 \item{groups}{a character}
 \item{managerSubordinates}{a character}
 \item{managers}{a character}
 \item{portalRole}{a character}
 \item{portalRoleAndSubordinates}{a character}
 \item{queue}{a character}
 \item{role}{a character}
 \item{roleAndSubordinates}{a character}
 \item{roleAndSubordinatesInternal}{a character}
 \item{roles}{a character}
 \item{rolesAndSubordinates}{a character}
 \item{territories}{a character}
 \item{territoriesAndSubordinates}{a character}
 \item{territory}{a character}
 \item{territoryAndSubordinates}{a character}
}

\strong{SharingBaseRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingbaserule.htm}{Salesforce Documentation for SharingBaseRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{accessLevel}{a character}
 \item{accountSettings}{a AccountSharingRuleSettings}
 \item{description}{a character}
 \item{label}{a character}
 \item{sharedTo}{a SharedTo}
}

\strong{SharingCriteriaRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingcriteriarule.htm}{Salesforce Documentation for SharingCriteriaRule}
\describe{
 \item{accessLevel}{a character (inherited from SharingBaseRule)}
 \item{accountSettings}{a AccountSharingRuleSettings (inherited from SharingBaseRule)}
 \item{description}{a character (inherited from SharingBaseRule)}
 \item{label}{a character (inherited from SharingBaseRule)}
 \item{sharedTo}{a SharedTo (inherited from SharingBaseRule)}
 \item{booleanFilter}{a character}
 \item{criteriaItems}{a FilterItem}
}

\strong{SharingOwnerRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingownerrule.htm}{Salesforce Documentation for SharingOwnerRule}
\describe{
 \item{accessLevel}{a character (inherited from SharingBaseRule)}
 \item{accountSettings}{a AccountSharingRuleSettings (inherited from SharingBaseRule)}
 \item{description}{a character (inherited from SharingBaseRule)}
 \item{label}{a character (inherited from SharingBaseRule)}
 \item{sharedTo}{a SharedTo (inherited from SharingBaseRule)}
 \item{sharedFrom}{a SharedTo}
}

\strong{SharingReason}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingreason.htm}{Salesforce Documentation for SharingReason}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{label}{a character}
}

\strong{SharingReasonTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingreasontranslation.htm}{Salesforce Documentation for SharingReasonTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{SharingRecalculation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingrecalculation.htm}{Salesforce Documentation for SharingRecalculation}
\describe{
 \item{className}{a character}
}

\strong{SharingRules}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingrules.htm}{Salesforce Documentation for SharingRules}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{sharingCriteriaRules}{a SharingCriteriaRule}
 \item{sharingOwnerRules}{a SharingOwnerRule}
 \item{sharingTerritoryRules}{a SharingTerritoryRule}
}

\strong{SharingSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingset.htm}{Salesforce Documentation for SharingSet}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{accessMappings}{a AccessMapping}
 \item{description}{a character}
 \item{name}{a character}
 \item{profiles}{a character}
}

\strong{SharingTerritoryRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sharingterritoryrule.htm}{Salesforce Documentation for SharingTerritoryRule}
\describe{
 \item{sharedFrom}{a SharedTo (inherited from SharingOwnerRule)}
}

\strong{SidebarComponent}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sidebarcomponent.htm}{Salesforce Documentation for SidebarComponent}
\describe{
 \item{componentType}{a character}
 \item{createAction}{a character}
 \item{enableLinking}{a character either 'true' or 'false'}
 \item{height}{a integer}
 \item{label}{a character}
 \item{lookup}{a character}
 \item{page}{a character}
 \item{relatedLists}{a RelatedList}
 \item{unit}{a character}
 \item{updateAction}{a character}
 \item{width}{a integer}
}

\strong{SiteDotCom}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sitedotcom.htm}{Salesforce Documentation for SiteDotCom}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{label}{a character}
 \item{siteType}{a SiteType - which is a character taking one of the following values: 
   \itemize{
     \item{Siteforce}
     \item{Visualforce}
     \item{User}
   }
  }
}

\strong{SiteRedirectMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_siteredirectmapping.htm}{Salesforce Documentation for SiteRedirectMapping}
\describe{
 \item{action}{a SiteRedirect - which is a character taking one of the following values: 
   \itemize{
     \item{Permanent}
     \item{Temporary}
   }
  }
 \item{isActive}{a character either 'true' or 'false'}
 \item{source}{a character}
 \item{target}{a character}
}

\strong{SiteWebAddress}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_sitewebaddress.htm}{Salesforce Documentation for SiteWebAddress}
\describe{
 \item{certificate}{a character}
 \item{domainName}{a character}
 \item{primary}{a character either 'true' or 'false'}
}

\strong{Skill}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_skill.htm}{Salesforce Documentation for Skill}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{assignments}{a SkillAssignments}
 \item{description}{a character}
 \item{label}{a character}
}

\strong{SkillAssignments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_skillassignments.htm}{Salesforce Documentation for SkillAssignments}
\describe{
 \item{profiles}{a SkillProfileAssignments}
 \item{users}{a SkillUserAssignments}
}

\strong{SkillProfileAssignments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_skillprofileassignments.htm}{Salesforce Documentation for SkillProfileAssignments}
\describe{
 \item{profile}{a character}
}

\strong{SkillUserAssignments}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_skilluserassignments.htm}{Salesforce Documentation for SkillUserAssignments}
\describe{
 \item{user}{a character}
}

\strong{SocialCustomerServiceSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_socialcustomerservicesettings.htm}{Salesforce Documentation for SocialCustomerServiceSettings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{caseSubjectOption}{a CaseSubjectOption - which is a character taking one of the following values: 
   \itemize{
     \item{SocialPostSource}
     \item{SocialPostContent}
     \item{BuildCustom}
   }
  }
}

\strong{StandardFieldTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_standardfieldtranslation.htm}{Salesforce Documentation for StandardFieldTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{StandardValue}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_standardvalue.htm}{Salesforce Documentation for StandardValue}
\describe{
 \item{color}{a character (inherited from CustomValue)}
 \item{default}{a character either 'true' or 'false' (inherited from CustomValue)}
 \item{description}{a character (inherited from CustomValue)}
 \item{isActive}{a character either 'true' or 'false' (inherited from CustomValue)}
 \item{label}{a character (inherited from CustomValue)}
 \item{allowEmail}{a character either 'true' or 'false'}
 \item{closed}{a character either 'true' or 'false'}
 \item{converted}{a character either 'true' or 'false'}
 \item{cssExposed}{a character either 'true' or 'false'}
 \item{forecastCategory}{a ForecastCategories - which is a character taking one of the following values: 
   \itemize{
     \item{Omitted}
     \item{Pipeline}
     \item{BestCase}
     \item{Forecast}
     \item{Closed}
   }
  }
 \item{groupingString}{a character}
 \item{highPriority}{a character either 'true' or 'false'}
 \item{probability}{a integer}
 \item{reverseRole}{a character}
 \item{reviewed}{a character either 'true' or 'false'}
 \item{won}{a character either 'true' or 'false'}
}

\strong{StandardValueSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_standardvalueset.htm}{Salesforce Documentation for StandardValueSet}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{groupingStringEnum}{a character}
 \item{sorted}{a character either 'true' or 'false'}
 \item{standardValue}{a StandardValue}
}

\strong{StandardValueSetTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_standardvaluesettranslation.htm}{Salesforce Documentation for StandardValueSetTranslation}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{valueTranslation}{a ValueTranslation}
}

\strong{State}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_state.htm}{Salesforce Documentation for State}
\describe{
 \item{active}{a character either 'true' or 'false'}
 \item{integrationValue}{a character}
 \item{isoCode}{a character}
 \item{label}{a character}
 \item{standard}{a character either 'true' or 'false'}
 \item{visible}{a character either 'true' or 'false'}
}

\strong{StaticResource}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_staticresource.htm}{Salesforce Documentation for StaticResource}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{cacheControl}{a StaticResourceCacheControl - which is a character taking one of the following values: 
   \itemize{
     \item{Private}
     \item{Public}
   }
  }
 \item{contentType}{a character}
 \item{description}{a character}
}

\strong{StrategyNode}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_strategynode.htm}{Salesforce Documentation for StrategyNode}
\describe{
 \item{definition}{a character}
 \item{description}{a character}
 \item{name}{a character}
 \item{parentNode}{a character}
 \item{type}{a integer}
}

\strong{SubtabComponents}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_subtabcomponents.htm}{Salesforce Documentation for SubtabComponents}
\describe{
 \item{containers}{a Container}
}

\strong{SummaryLayout}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_summarylayout.htm}{Salesforce Documentation for SummaryLayout}
\describe{
 \item{masterLabel}{a character}
 \item{sizeX}{a integer}
 \item{sizeY}{a integer}
 \item{sizeZ}{a integer}
 \item{summaryLayoutItems}{a SummaryLayoutItem}
 \item{summaryLayoutStyle}{a SummaryLayoutStyle - which is a character taking one of the following values: 
   \itemize{
     \item{Default}
     \item{QuoteTemplate}
     \item{DefaultQuoteTemplate}
     \item{ServiceReportTemplate}
     \item{ChildServiceReportTemplateStyle}
     \item{DefaultServiceReportTemplate}
     \item{CaseInteraction}
     \item{QuickActionLayoutLeftRight}
     \item{QuickActionLayoutTopDown}
     \item{PathAssistant}
   }
  }
}

\strong{SummaryLayoutItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_summarylayoutitem.htm}{Salesforce Documentation for SummaryLayoutItem}
\describe{
 \item{customLink}{a character}
 \item{field}{a character}
 \item{posX}{a integer}
 \item{posY}{a integer}
 \item{posZ}{a integer}
}

\strong{SupervisorAgentConfigSkills}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_supervisoragentconfigskills.htm}{Salesforce Documentation for SupervisorAgentConfigSkills}
\describe{
 \item{skill}{a character}
}

\strong{SynonymDictionary}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_synonymdictionary.htm}{Salesforce Documentation for SynonymDictionary}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{groups}{a SynonymGroup}
 \item{isProtected}{a character either 'true' or 'false'}
 \item{label}{a character}
}

\strong{SynonymGroup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_synonymgroup.htm}{Salesforce Documentation for SynonymGroup}
\describe{
 \item{languages}{a Language - which is a character taking one of the following values: 
   \itemize{
     \item{en_US}
     \item{de}
     \item{es}
     \item{fr}
     \item{it}
     \item{ja}
     \item{sv}
     \item{ko}
     \item{zh_TW}
     \item{zh_CN}
     \item{pt_BR}
     \item{nl_NL}
     \item{da}
     \item{th}
     \item{fi}
     \item{ru}
     \item{es_MX}
     \item{no}
     \item{hu}
     \item{pl}
     \item{cs}
     \item{tr}
     \item{in}
     \item{ro}
     \item{vi}
     \item{uk}
     \item{iw}
     \item{el}
     \item{bg}
     \item{en_GB}
     \item{ar}
     \item{sk}
     \item{pt_PT}
     \item{hr}
     \item{sl}
     \item{fr_CA}
     \item{ka}
     \item{sr}
     \item{sh}
     \item{en_AU}
     \item{en_MY}
     \item{en_IN}
     \item{en_PH}
     \item{en_CA}
     \item{ro_MD}
     \item{bs}
     \item{mk}
     \item{lv}
     \item{lt}
     \item{et}
     \item{sq}
     \item{sh_ME}
     \item{mt}
     \item{ga}
     \item{eu}
     \item{cy}
     \item{is}
     \item{ms}
     \item{tl}
     \item{lb}
     \item{rm}
     \item{hy}
     \item{hi}
     \item{ur}
     \item{bn}
     \item{de_AT}
     \item{de_CH}
     \item{ta}
     \item{ar_DZ}
     \item{ar_BH}
     \item{ar_EG}
     \item{ar_IQ}
     \item{ar_JO}
     \item{ar_KW}
     \item{ar_LB}
     \item{ar_LY}
     \item{ar_MA}
     \item{ar_OM}
     \item{ar_QA}
     \item{ar_SA}
     \item{ar_SD}
     \item{ar_SY}
     \item{ar_TN}
     \item{ar_AE}
     \item{ar_YE}
     \item{zh_SG}
     \item{zh_HK}
     \item{en_HK}
     \item{en_IE}
     \item{en_SG}
     \item{en_ZA}
     \item{fr_BE}
     \item{fr_LU}
     \item{fr_CH}
     \item{de_BE}
     \item{de_LU}
     \item{it_CH}
     \item{nl_BE}
     \item{es_AR}
     \item{es_BO}
     \item{es_CL}
     \item{es_CO}
     \item{es_CR}
     \item{es_DO}
     \item{es_EC}
     \item{es_SV}
     \item{es_GT}
     \item{es_HN}
     \item{es_NI}
     \item{es_PA}
     \item{es_PY}
     \item{es_PE}
     \item{es_PR}
     \item{es_US}
     \item{es_UY}
     \item{es_VE}
     \item{ca}
     \item{eo}
     \item{iw_EO}
   }
  }
 \item{terms}{a character}
}

\strong{TabLimitConfig}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_tablimitconfig.htm}{Salesforce Documentation for TabLimitConfig}
\describe{
 \item{maxNumberOfPrimaryTabs}{a character}
 \item{maxNumberOfSubTabs}{a character}
}

\strong{Territory}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory.htm}{Salesforce Documentation for Territory}
\describe{
 \item{caseAccessLevel}{a character (inherited from RoleOrTerritory)}
 \item{contactAccessLevel}{a character (inherited from RoleOrTerritory)}
 \item{description}{a character (inherited from RoleOrTerritory)}
 \item{mayForecastManagerShare}{a character either 'true' or 'false' (inherited from RoleOrTerritory)}
 \item{name}{a character (inherited from RoleOrTerritory)}
 \item{opportunityAccessLevel}{a character (inherited from RoleOrTerritory)}
 \item{accountAccessLevel}{a character}
 \item{parentTerritory}{a character}
}

\strong{Territory2}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2.htm}{Salesforce Documentation for Territory2}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{accountAccessLevel}{a character}
 \item{caseAccessLevel}{a character}
 \item{contactAccessLevel}{a character}
 \item{customFields}{a FieldValue}
 \item{description}{a character}
 \item{name}{a character}
 \item{opportunityAccessLevel}{a character}
 \item{parentTerritory}{a character}
 \item{ruleAssociations}{a Territory2RuleAssociation}
 \item{territory2Type}{a character}
}

\strong{Territory2Model}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2model.htm}{Salesforce Documentation for Territory2Model}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customFields}{a FieldValue}
 \item{description}{a character}
 \item{name}{a character}
}

\strong{Territory2Rule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2rule.htm}{Salesforce Documentation for Territory2Rule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{booleanFilter}{a character}
 \item{name}{a character}
 \item{objectType}{a character}
 \item{ruleItems}{a Territory2RuleItem}
}

\strong{Territory2RuleAssociation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2ruleassociation.htm}{Salesforce Documentation for Territory2RuleAssociation}
\describe{
 \item{inherited}{a character either 'true' or 'false'}
 \item{ruleName}{a character}
}

\strong{Territory2RuleItem}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2ruleitem.htm}{Salesforce Documentation for Territory2RuleItem}
\describe{
 \item{field}{a character}
 \item{operation}{a FilterOperation - which is a character taking one of the following values: 
   \itemize{
     \item{equals}
     \item{notEqual}
     \item{lessThan}
     \item{greaterThan}
     \item{lessOrEqual}
     \item{greaterOrEqual}
     \item{contains}
     \item{notContain}
     \item{startsWith}
     \item{includes}
     \item{excludes}
     \item{within}
   }
  }
 \item{value}{a character}
}

\strong{Territory2Settings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2settings.htm}{Salesforce Documentation for Territory2Settings}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{defaultAccountAccessLevel}{a character}
 \item{defaultCaseAccessLevel}{a character}
 \item{defaultContactAccessLevel}{a character}
 \item{defaultOpportunityAccessLevel}{a character}
 \item{opportunityFilterSettings}{a Territory2SettingsOpportunityFilter}
}

\strong{Territory2SettingsOpportunityFilter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2settingsopportunityfilter.htm}{Salesforce Documentation for Territory2SettingsOpportunityFilter}
\describe{
 \item{apexClassName}{a character}
 \item{enableFilter}{a character either 'true' or 'false'}
 \item{runOnCreate}{a character either 'true' or 'false'}
}

\strong{Territory2Type}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_territory2type.htm}{Salesforce Documentation for Territory2Type}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{name}{a character}
 \item{priority}{a integer}
}

\strong{TopicsForObjects}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_topicsforobjects.htm}{Salesforce Documentation for TopicsForObjects}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{enableTopics}{a character either 'true' or 'false'}
 \item{entityApiName}{a character}
}

\strong{TouchMobileSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_touchmobilesettings.htm}{Salesforce Documentation for TouchMobileSettings}
\describe{
 \item{enableTouchAppIPad}{a character either 'true' or 'false'}
 \item{enableTouchAppIPhone}{a character either 'true' or 'false'}
 \item{enableTouchBrowserIPad}{a character either 'true' or 'false'}
 \item{enableTouchIosPhone}{a character either 'true' or 'false'}
 \item{enableVisualforceInTouch}{a character either 'true' or 'false'}
}

\strong{TransactionSecurityAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_transactionsecurityaction.htm}{Salesforce Documentation for TransactionSecurityAction}
\describe{
 \item{block}{a character either 'true' or 'false'}
 \item{endSession}{a character either 'true' or 'false'}
 \item{freezeUser}{a character either 'true' or 'false'}
 \item{notifications}{a TransactionSecurityNotification}
 \item{twoFactorAuthentication}{a character either 'true' or 'false'}
}

\strong{TransactionSecurityNotification}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_transactionsecuritynotification.htm}{Salesforce Documentation for TransactionSecurityNotification}
\describe{
 \item{inApp}{a character either 'true' or 'false'}
 \item{sendEmail}{a character either 'true' or 'false'}
 \item{user}{a character}
}

\strong{TransactionSecurityPolicy}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_transactionsecuritypolicy.htm}{Salesforce Documentation for TransactionSecurityPolicy}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{action}{a TransactionSecurityAction}
 \item{active}{a character either 'true' or 'false'}
 \item{apexClass}{a character}
 \item{description}{a character}
 \item{developerName}{a character}
 \item{eventName}{a TransactionSecurityEventName - which is a character taking one of the following values: 
   \itemize{
     \item{ReportEvent}
     \item{ApiEvent}
     \item{AdminSetupEvent}
     \item{LoginEvent}
   }
  }
 \item{eventType}{a MonitoredEvents - which is a character taking one of the following values: 
   \itemize{
     \item{AuditTrail}
     \item{Login}
     \item{Entity}
     \item{DataExport}
     \item{AccessResource}
   }
  }
 \item{executionUser}{a character}
 \item{flow}{a character}
 \item{masterLabel}{a character}
 \item{resourceName}{a character}
 \item{type}{a TxnSecurityPolicyType - which is a character taking one of the following values: 
   \itemize{
     \item{CustomApexPolicy}
     \item{CustomConditionBuilderPolicy}
   }
  }
}

\strong{Translations}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_translations.htm}{Salesforce Documentation for Translations}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{customApplications}{a CustomApplicationTranslation}
 \item{customDataTypeTranslations}{a CustomDataTypeTranslation}
 \item{customLabels}{a CustomLabelTranslation}
 \item{customPageWebLinks}{a CustomPageWebLinkTranslation}
 \item{customTabs}{a CustomTabTranslation}
 \item{flowDefinitions}{a FlowDefinitionTranslation}
 \item{quickActions}{a GlobalQuickActionTranslation}
 \item{reportTypes}{a ReportTypeTranslation}
 \item{scontrols}{a ScontrolTranslation}
}

\strong{UiFormulaCriterion}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_uiformulacriterion.htm}{Salesforce Documentation for UiFormulaCriterion}
\describe{
 \item{leftValue}{a character}
 \item{operator}{a character}
 \item{rightValue}{a character}
}

\strong{UiFormulaRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_uiformularule.htm}{Salesforce Documentation for UiFormulaRule}
\describe{
 \item{booleanFilter}{a character}
 \item{criteria}{a UiFormulaCriterion}
}

\strong{UiPlugin}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_uiplugin.htm}{Salesforce Documentation for UiPlugin}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{description}{a character}
 \item{extensionPointIdentifier}{a character}
 \item{isEnabled}{a character either 'true' or 'false'}
 \item{language}{a character}
 \item{masterLabel}{a character}
}

\strong{UserCriteria}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_usercriteria.htm}{Salesforce Documentation for UserCriteria}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{creationAgeInSeconds}{a integer}
 \item{description}{a character}
 \item{lastChatterActivityAgeInSeconds}{a integer}
 \item{masterLabel}{a character}
 \item{profiles}{a character}
 \item{userTypes}{a NetworkUserType - which is a character taking one of the following values: 
   \itemize{
     \item{Internal}
     \item{Customer}
     \item{Partner}
   }
  }
}

\strong{Users}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_users.htm}{Salesforce Documentation for Users}
\describe{
 \item{user}{a character}
}

\strong{ValidationRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_validationrule.htm}{Salesforce Documentation for ValidationRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{active}{a character either 'true' or 'false'}
 \item{description}{a character}
 \item{errorConditionFormula}{a character}
 \item{errorDisplayField}{a character}
 \item{errorMessage}{a character}
}

\strong{ValidationRuleTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_validationruletranslation.htm}{Salesforce Documentation for ValidationRuleTranslation}
\describe{
 \item{errorMessage}{a character}
 \item{name}{a character}
}

\strong{ValueSet}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_valueset.htm}{Salesforce Documentation for ValueSet}
\describe{
 \item{controllingField}{a character}
 \item{restricted}{a character either 'true' or 'false'}
 \item{valueSetDefinition}{a ValueSetValuesDefinition}
 \item{valueSetName}{a character}
 \item{valueSettings}{a ValueSettings}
}

\strong{ValueSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_valuesettings.htm}{Salesforce Documentation for ValueSettings}
\describe{
 \item{controllingFieldValue}{a character}
 \item{valueName}{a character}
}

\strong{ValueSetValuesDefinition}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_valuesetvaluesdefinition.htm}{Salesforce Documentation for ValueSetValuesDefinition}
\describe{
 \item{sorted}{a character either 'true' or 'false'}
 \item{value}{a CustomValue}
}

\strong{ValueTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_valuetranslation.htm}{Salesforce Documentation for ValueTranslation}
\describe{
 \item{masterLabel}{a character}
 \item{translation}{a character}
}

\strong{ValueTypeField}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_valuetypefield.htm}{Salesforce Documentation for ValueTypeField}
\describe{
 \item{fields}{a ValueTypeField}
 \item{foreignKeyDomain}{a character}
 \item{isForeignKey}{a character either 'true' or 'false'}
 \item{isNameField}{a character either 'true' or 'false'}
 \item{minOccurs}{a integer}
 \item{name}{a character}
 \item{picklistValues}{a PicklistEntry}
 \item{soapType}{a character}
 \item{valueRequired}{a character either 'true' or 'false'}
}

\strong{VisualizationPlugin}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_visualizationplugin.htm}{Salesforce Documentation for VisualizationPlugin}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{description}{a character}
 \item{developerName}{a character}
 \item{icon}{a character}
 \item{masterLabel}{a character}
 \item{visualizationResources}{a VisualizationResource}
 \item{visualizationTypes}{a VisualizationType}
}

\strong{VisualizationResource}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_visualizationresource.htm}{Salesforce Documentation for VisualizationResource}
\describe{
 \item{description}{a character}
 \item{file}{a character}
 \item{rank}{a integer}
 \item{type}{a VisualizationResourceType - which is a character taking one of the following values: 
   \itemize{
     \item{js}
     \item{css}
   }
  }
}

\strong{VisualizationType}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_visualizationtype.htm}{Salesforce Documentation for VisualizationType}
\describe{
 \item{description}{a character}
 \item{developerName}{a character}
 \item{icon}{a character}
 \item{masterLabel}{a character}
 \item{scriptBootstrapMethod}{a character}
}

\strong{WaveApplication}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_waveapplication.htm}{Salesforce Documentation for WaveApplication}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{assetIcon}{a character}
 \item{description}{a character}
 \item{folder}{a character}
 \item{masterLabel}{a character}
 \item{shares}{a FolderShare}
 \item{templateOrigin}{a character}
 \item{templateVersion}{a character}
}

\strong{WaveDashboard}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavedashboard.htm}{Salesforce Documentation for WaveDashboard}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{application}{a character}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{templateAssetSourceName}{a character}
}

\strong{WaveDataflow}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavedataflow.htm}{Salesforce Documentation for WaveDataflow}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{dataflowType}{a character}
 \item{description}{a character}
 \item{masterLabel}{a character}
}

\strong{WaveDataset}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavedataset.htm}{Salesforce Documentation for WaveDataset}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{application}{a character}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{templateAssetSourceName}{a character}
}

\strong{WaveLens}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavelens.htm}{Salesforce Documentation for WaveLens}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{application}{a character}
 \item{datasets}{a character}
 \item{description}{a character}
 \item{masterLabel}{a character}
 \item{templateAssetSourceName}{a character}
 \item{visualizationType}{a character}
}

\strong{WaveRecipe}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_waverecipe.htm}{Salesforce Documentation for WaveRecipe}
\describe{
 \item{content}{a character formed using RCurl::base64Encode (inherited from MetadataWithContent)}
 \item{dataflow}{a character}
 \item{masterLabel}{a character}
 \item{securityPredicate}{a character}
 \item{targetDatasetAlias}{a character}
}

\strong{WaveTemplateBundle}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavetemplatebundle.htm}{Salesforce Documentation for WaveTemplateBundle}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{assetIcon}{a character}
 \item{assetVersion}{a numeric}
 \item{description}{a character}
 \item{label}{a character}
 \item{templateBadgeIcon}{a character}
 \item{templateDetailIcon}{a character}
 \item{templateType}{a character}
}

\strong{WaveXmd}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmd.htm}{Salesforce Documentation for WaveXmd}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{application}{a character}
 \item{dataset}{a character}
 \item{datasetConnector}{a character}
 \item{datasetFullyQualifiedName}{a character}
 \item{dates}{a WaveXmdDate}
 \item{dimensions}{a WaveXmdDimension}
 \item{measures}{a WaveXmdMeasure}
 \item{organizations}{a WaveXmdOrganization}
 \item{origin}{a character}
 \item{type}{a character}
 \item{waveVisualization}{a character}
}

\strong{WaveXmdDate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmddate.htm}{Salesforce Documentation for WaveXmdDate}
\describe{
 \item{alias}{a character}
 \item{compact}{a character either 'true' or 'false'}
 \item{dateFieldDay}{a character}
 \item{dateFieldEpochDay}{a character}
 \item{dateFieldEpochSecond}{a character}
 \item{dateFieldFiscalMonth}{a character}
 \item{dateFieldFiscalQuarter}{a character}
 \item{dateFieldFiscalWeek}{a character}
 \item{dateFieldFiscalYear}{a character}
 \item{dateFieldFullYear}{a character}
 \item{dateFieldHour}{a character}
 \item{dateFieldMinute}{a character}
 \item{dateFieldMonth}{a character}
 \item{dateFieldQuarter}{a character}
 \item{dateFieldSecond}{a character}
 \item{dateFieldWeek}{a character}
 \item{dateFieldYear}{a character}
 \item{description}{a character}
 \item{firstDayOfWeek}{a integer}
 \item{fiscalMonthOffset}{a integer}
 \item{isYearEndFiscalYear}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{showInExplorer}{a character either 'true' or 'false'}
 \item{sortIndex}{a integer}
}

\strong{WaveXmdDimension}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmddimension.htm}{Salesforce Documentation for WaveXmdDimension}
\describe{
 \item{customActions}{a WaveXmdDimensionCustomAction}
 \item{customActionsEnabled}{a character either 'true' or 'false'}
 \item{dateFormat}{a character}
 \item{description}{a character}
 \item{field}{a character}
 \item{fullyQualifiedName}{a character}
 \item{imageTemplate}{a character}
 \item{isDerived}{a character either 'true' or 'false'}
 \item{isMultiValue}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{linkTemplate}{a character}
 \item{linkTemplateEnabled}{a character either 'true' or 'false'}
 \item{linkTooltip}{a character}
 \item{members}{a WaveXmdDimensionMember}
 \item{origin}{a character}
 \item{recordDisplayFields}{a WaveXmdRecordDisplayLookup}
 \item{recordIdField}{a character}
 \item{recordOrganizationIdField}{a character}
 \item{salesforceActions}{a WaveXmdDimensionSalesforceAction}
 \item{salesforceActionsEnabled}{a character either 'true' or 'false'}
 \item{showDetailsDefaultFieldIndex}{a integer}
 \item{showInExplorer}{a character either 'true' or 'false'}
 \item{sortIndex}{a integer}
}

\strong{WaveXmdDimensionCustomAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmddimensioncustomaction.htm}{Salesforce Documentation for WaveXmdDimensionCustomAction}
\describe{
 \item{customActionName}{a character}
 \item{enabled}{a character either 'true' or 'false'}
 \item{icon}{a character}
 \item{method}{a character}
 \item{sortIndex}{a integer}
 \item{target}{a character}
 \item{tooltip}{a character}
 \item{url}{a character}
}

\strong{WaveXmdDimensionMember}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmddimensionmember.htm}{Salesforce Documentation for WaveXmdDimensionMember}
\describe{
 \item{color}{a character}
 \item{label}{a character}
 \item{member}{a character}
 \item{sortIndex}{a integer}
}

\strong{WaveXmdDimensionSalesforceAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmddimensionsalesforceaction.htm}{Salesforce Documentation for WaveXmdDimensionSalesforceAction}
\describe{
 \item{enabled}{a character either 'true' or 'false'}
 \item{salesforceActionName}{a character}
 \item{sortIndex}{a integer}
}

\strong{WaveXmdMeasure}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmdmeasure.htm}{Salesforce Documentation for WaveXmdMeasure}
\describe{
 \item{dateFormat}{a character}
 \item{description}{a character}
 \item{field}{a character}
 \item{formatCustomFormat}{a character}
 \item{formatDecimalDigits}{a integer}
 \item{formatIsNegativeParens}{a character either 'true' or 'false'}
 \item{formatPrefix}{a character}
 \item{formatSuffix}{a character}
 \item{formatUnit}{a character}
 \item{formatUnitMultiplier}{a numeric}
 \item{fullyQualifiedName}{a character}
 \item{isDerived}{a character either 'true' or 'false'}
 \item{label}{a character}
 \item{origin}{a character}
 \item{showDetailsDefaultFieldIndex}{a integer}
 \item{showInExplorer}{a character either 'true' or 'false'}
 \item{sortIndex}{a integer}
}

\strong{WaveXmdOrganization}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmdorganization.htm}{Salesforce Documentation for WaveXmdOrganization}
\describe{
 \item{instanceUrl}{a character}
 \item{label}{a character}
 \item{organizationIdentifier}{a character}
 \item{sortIndex}{a integer}
}

\strong{WaveXmdRecordDisplayLookup}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_wavexmdrecorddisplaylookup.htm}{Salesforce Documentation for WaveXmdRecordDisplayLookup}
\describe{
 \item{recordDisplayField}{a character}
}

\strong{WebLink}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_weblink.htm}{Salesforce Documentation for WebLink}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{availability}{a WebLinkAvailability - which is a character taking one of the following values: 
   \itemize{
     \item{online}
     \item{offline}
   }
  }
 \item{description}{a character}
 \item{displayType}{a WebLinkDisplayType - which is a character taking one of the following values: 
   \itemize{
     \item{link}
     \item{button}
     \item{massActionButton}
   }
  }
 \item{encodingKey}{a Encoding - which is a character taking one of the following values: 
   \itemize{
     \item{UTF-8}
     \item{ISO-8859-1}
     \item{Shift_JIS}
     \item{ISO-2022-JP}
     \item{EUC-JP}
     \item{ks_c_5601-1987}
     \item{Big5}
     \item{GB2312}
     \item{Big5-HKSCS}
     \item{x-SJIS_0213}
   }
  }
 \item{hasMenubar}{a character either 'true' or 'false'}
 \item{hasScrollbars}{a character either 'true' or 'false'}
 \item{hasToolbar}{a character either 'true' or 'false'}
 \item{height}{a integer}
 \item{isResizable}{a character either 'true' or 'false'}
 \item{linkType}{a WebLinkType - which is a character taking one of the following values: 
   \itemize{
     \item{url}
     \item{sControl}
     \item{javascript}
     \item{page}
     \item{flow}
   }
  }
 \item{masterLabel}{a character}
 \item{openType}{a WebLinkWindowType - which is a character taking one of the following values: 
   \itemize{
     \item{newWindow}
     \item{sidebar}
     \item{noSidebar}
     \item{replace}
     \item{onClickJavaScript}
   }
  }
 \item{page}{a character}
 \item{position}{a WebLinkPosition - which is a character taking one of the following values: 
   \itemize{
     \item{fullScreen}
     \item{none}
     \item{topLeft}
   }
  }
 \item{protected}{a character either 'true' or 'false'}
 \item{requireRowSelection}{a character either 'true' or 'false'}
 \item{scontrol}{a character}
 \item{showsLocation}{a character either 'true' or 'false'}
 \item{showsStatus}{a character either 'true' or 'false'}
 \item{url}{a character}
 \item{width}{a integer}
}

\strong{WebLinkTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_weblinktranslation.htm}{Salesforce Documentation for WebLinkTranslation}
\describe{
 \item{label}{a character}
 \item{name}{a character}
}

\strong{WebToCaseSettings}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_webtocasesettings.htm}{Salesforce Documentation for WebToCaseSettings}
\describe{
 \item{caseOrigin}{a character}
 \item{defaultResponseTemplate}{a character}
 \item{enableWebToCase}{a character either 'true' or 'false'}
}

\strong{WeightedSourceCategory}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_weightedsourcecategory.htm}{Salesforce Documentation for WeightedSourceCategory}
\describe{
 \item{sourceCategoryApiName}{a character}
 \item{weight}{a numeric}
}

\strong{Workflow}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflow.htm}{Salesforce Documentation for Workflow}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{alerts}{a WorkflowAlert}
 \item{fieldUpdates}{a WorkflowFieldUpdate}
 \item{flowActions}{a WorkflowFlowAction}
 \item{knowledgePublishes}{a WorkflowKnowledgePublish}
 \item{outboundMessages}{a WorkflowOutboundMessage}
 \item{rules}{a WorkflowRule}
 \item{send}{a WorkflowSend}
 \item{tasks}{a WorkflowTask}
}

\strong{WorkflowAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowaction.htm}{Salesforce Documentation for WorkflowAction}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
}

\strong{WorkflowActionReference}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowactionreference.htm}{Salesforce Documentation for WorkflowActionReference}
\describe{
 \item{name}{a character}
 \item{type}{a WorkflowActionType - which is a character taking one of the following values: 
   \itemize{
     \item{FieldUpdate}
     \item{KnowledgePublish}
     \item{Task}
     \item{Alert}
     \item{Send}
     \item{OutboundMessage}
     \item{FlowAction}
   }
  }
}

\strong{WorkflowAlert}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowalert.htm}{Salesforce Documentation for WorkflowAlert}
\describe{
 \item{extends WorkflowAction}{see documentation for WorkflowAction}
 \item{ccEmails}{a character}
 \item{description}{a character}
 \item{protected}{a character either 'true' or 'false'}
 \item{recipients}{a WorkflowEmailRecipient}
 \item{senderAddress}{a character}
 \item{senderType}{a ActionEmailSenderType - which is a character taking one of the following values: 
   \itemize{
     \item{CurrentUser}
     \item{OrgWideEmailAddress}
     \item{DefaultWorkflowUser}
   }
  }
 \item{template}{a character}
}

\strong{WorkflowEmailRecipient}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowemailrecipient.htm}{Salesforce Documentation for WorkflowEmailRecipient}
\describe{
 \item{field}{a character}
 \item{recipient}{a character}
 \item{type}{a ActionEmailRecipientTypes - which is a character taking one of the following values: 
   \itemize{
     \item{group}
     \item{role}
     \item{user}
     \item{opportunityTeam}
     \item{accountTeam}
     \item{roleSubordinates}
     \item{owner}
     \item{creator}
     \item{partnerUser}
     \item{accountOwner}
     \item{customerPortalUser}
     \item{portalRole}
     \item{portalRoleSubordinates}
     \item{contactLookup}
     \item{userLookup}
     \item{roleSubordinatesInternal}
     \item{email}
     \item{caseTeam}
     \item{campaignMemberDerivedOwner}
   }
  }
}

\strong{WorkflowFieldUpdate}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowfieldupdate.htm}{Salesforce Documentation for WorkflowFieldUpdate}
\describe{
 \item{extends WorkflowAction}{see documentation for WorkflowAction}
 \item{description}{a character}
 \item{field}{a character}
 \item{formula}{a character}
 \item{literalValue}{a character}
 \item{lookupValue}{a character}
 \item{lookupValueType}{a LookupValueType - which is a character taking one of the following values: 
   \itemize{
     \item{User}
     \item{Queue}
     \item{RecordType}
   }
  }
 \item{name}{a character}
 \item{notifyAssignee}{a character either 'true' or 'false'}
 \item{operation}{a FieldUpdateOperation - which is a character taking one of the following values: 
   \itemize{
     \item{Formula}
     \item{Literal}
     \item{Null}
     \item{NextValue}
     \item{PreviousValue}
     \item{LookupValue}
   }
  }
 \item{protected}{a character either 'true' or 'false'}
 \item{reevaluateOnChange}{a character either 'true' or 'false'}
 \item{targetObject}{a character}
}

\strong{WorkflowFlowAction}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowflowaction.htm}{Salesforce Documentation for WorkflowFlowAction}
\describe{
 \item{extends WorkflowAction}{see documentation for WorkflowAction}
 \item{description}{a character}
 \item{flow}{a character}
 \item{flowInputs}{a WorkflowFlowActionParameter}
 \item{label}{a character}
 \item{language}{a character}
 \item{protected}{a character either 'true' or 'false'}
}

\strong{WorkflowFlowActionParameter}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowflowactionparameter.htm}{Salesforce Documentation for WorkflowFlowActionParameter}
\describe{
 \item{name}{a character}
 \item{value}{a character}
}

\strong{WorkflowKnowledgePublish}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowknowledgepublish.htm}{Salesforce Documentation for WorkflowKnowledgePublish}
\describe{
 \item{extends WorkflowAction}{see documentation for WorkflowAction}
 \item{action}{a KnowledgeWorkflowAction - which is a character taking one of the following values: 
   \itemize{
     \item{PublishAsNew}
     \item{Publish}
   }
  }
 \item{description}{a character}
 \item{label}{a character}
 \item{language}{a character}
 \item{protected}{a character either 'true' or 'false'}
}

\strong{WorkflowRule}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowrule.htm}{Salesforce Documentation for WorkflowRule}
\describe{
 \item{fullName}{a character (inherited from Metadata)}
 \item{actions}{a WorkflowActionReference}
 \item{active}{a character either 'true' or 'false'}
 \item{booleanFilter}{a character}
 \item{criteriaItems}{a FilterItem}
 \item{description}{a character}
 \item{formula}{a character}
 \item{triggerType}{a WorkflowTriggerTypes - which is a character taking one of the following values: 
   \itemize{
     \item{onCreateOnly}
     \item{onCreateOrTriggeringUpdate}
     \item{onAllChanges}
     \item{OnRecursiveUpdate}
   }
  }
 \item{workflowTimeTriggers}{a WorkflowTimeTrigger}
}

\strong{WorkflowSend}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowsend.htm}{Salesforce Documentation for WorkflowSend}
\describe{
 \item{extends WorkflowAction}{see documentation for WorkflowAction}
 \item{action}{a SendAction - which is a character taking one of the following values: 
   \itemize{
     \item{Send}
   }
  }
 \item{description}{a character}
 \item{label}{a character}
 \item{language}{a character}
 \item{protected}{a character either 'true' or 'false'}
}

\strong{WorkflowTask}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowtask.htm}{Salesforce Documentation for WorkflowTask}
\describe{
 \item{extends WorkflowAction}{see documentation for WorkflowAction}
 \item{assignedTo}{a character}
 \item{assignedToType}{a ActionTaskAssignedToTypes - which is a character taking one of the following values: 
   \itemize{
     \item{user}
     \item{role}
     \item{opportunityTeam}
     \item{accountTeam}
     \item{owner}
     \item{accountOwner}
     \item{creator}
     \item{accountCreator}
     \item{partnerUser}
     \item{portalRole}
   }
  }
 \item{description}{a character}
 \item{dueDateOffset}{a integer}
 \item{notifyAssignee}{a character either 'true' or 'false'}
 \item{offsetFromField}{a character}
 \item{priority}{a character}
 \item{protected}{a character either 'true' or 'false'}
 \item{status}{a character}
 \item{subject}{a character}
}

\strong{WorkflowTaskTranslation}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowtasktranslation.htm}{Salesforce Documentation for WorkflowTaskTranslation}
\describe{
 \item{description}{a character}
 \item{name}{a character}
 \item{subject}{a character}
}

\strong{WorkflowTimeTrigger}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workflowtimetrigger.htm}{Salesforce Documentation for WorkflowTimeTrigger}
\describe{
 \item{actions}{a WorkflowActionReference}
 \item{offsetFromField}{a character}
 \item{timeLength}{a character}
 \item{workflowTimeTriggerUnit}{a WorkflowTimeUnits - which is a character taking one of the following values: 
   \itemize{
     \item{Hours}
     \item{Days}
   }
  }
}

\strong{WorkspaceMapping}

\href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/meta_workspacemapping.htm}{Salesforce Documentation for WorkspaceMapping}
\describe{
 \item{fieldName}{a character}
 \item{tab}{a character}
}
}
