% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R
\docType{data}
\name{cow.saemix}
\alias{cow.saemix}
\title{Evolution of the weight of 560 cows, in SAEM format}
\format{
This data frame contains the following columns: 
\describe{
\item{cow}{the unique identifier for each cow } 
\item{time}{time (days)} 
\item{weight}{a numeric vector giving the weight of the cow (kg)}
\item{birthyear}{year of birth (between 1988 and 1998)}
\item{twin}{existence of a twin (no=1, yes=2)}
\item{birthrank}{the rank of birth (beetween 3 and 7)}
}
}
\usage{
cow.saemix
}
\description{
The \code{cow.saemix} data contains records of the weight of 560 cows on 9 or 10 occasions.
}
\details{
An exponential model was assumed to describe the weight gain with time:
 y_ij = A_i (1- B_i exp( - K_i t_ij)) +epsilon_ij
}
\examples{
data(cow.saemix)
saemix.data<-saemixData(name.data=cow.saemix,header=TRUE,name.group=c("cow"), 
      name.predictors=c("time"),name.response=c("weight"), 
      name.covariates=c("birthyear","twin","birthrank"), 
      units=list(x="days",y="kg",covariates=c("yr","-","-")))

growthcow<-function(psi,id,xidep) {
  x<-xidep[,1]
  a<-psi[id,1]
  b<-psi[id,2]
  k<-psi[id,3]
  f<-a*(1-b*exp(-k*x))
  return(f)
}
saemix.model<-saemixModel(model=growthcow,
      description="Exponential growth model", 
      psi0=matrix(c(700,0.9,0.02,0,0,0),ncol=3,byrow=TRUE, 
        dimnames=list(NULL,c("A","B","k"))),transform.par=c(1,1,1),fixed.estim=c(1,1,1), 
      covariate.model=matrix(c(0,0,0),ncol=3,byrow=TRUE), 
      covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE), 
      omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

saemix.options<-list(algorithms=c(1,1,1),nb.chains=1,nbiter.saemix=c(200,100), 
             seed=4526,save=FALSE,save.graphs=FALSE)

# Plotting the data
plot(saemix.data,xlab="Time (day)",ylab="Weight of the cow (kg)")
\donttest{
saemix.fit<-saemix(saemix.model,saemix.data,saemix.options)
}

}
\references{
Pinheiro, J. C. and Bates, D. M. (2000), \emph{Mixed-Effects Models in S and S-PLUS}, Springer, New York.  (Appendix A.19)
}
\keyword{datasets}
