% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SaemixObject.R
\docType{methods}
\name{logLik}
\alias{AIC.SaemixObject}
\alias{BIC.SaemixObject}
\alias{logLik}
\alias{logLik.SaemixObject}
\title{Extract likelihood from a saemixObject resulting from a call to saemix}
\usage{
\method{logLik}{SaemixObject}(object, method = "is", ...)

\method{AIC}{SaemixObject}(object, ..., k = 2)

\method{BIC}{SaemixObject}(object, ...)
}
\arguments{
\item{object}{name of an SaemixObject object}

\item{method}{character string, one of c("is","lin","gq"), to select one of the available approximations to the log-likelihood (is: Importance Sampling; lin: linearisation and gq: Gaussian Quadrature). See documentation for details}

\item{...}{additional arguments}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC}
}
\value{
Returns the selected statistical criterion (log-likelihood, AIC, BIC) extracted from the SaemixObject, computed with the 'method' argument if given (defaults to IS).
}
\description{
The likelihood in saemix can be computed by one of three methods: linearisation (linearisation of the model), importance sampling (stochastic integration) and gaussian quadrature (numerical integration). The linearised likelihood is obtained as a byproduct of the computation of the Fisher Information Matrix (argument FIM=TRUE in the options given to the saemix function).
If no method argument is given, this function will attempt to extract the likelihood computed by importance sampling (method="is"), unless the object contains the likelihood computed by linearisation, in which case the function will extract this component instead.
If the requested likelihood is not present in the object, it will be computed and aded to the object before returning.
}
\author{
Emmanuelle Comets \email{emmanuelle.comets@inserm.fr}

Audrey Lavenu

Marc Lavielle.
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis (2005), 49(4):1020-38.

Comets E, Lavenu A, Lavielle M. Parameter Estimation in Nonlinear Mixed Effect Models Using saemix, an R Implementation of the SAEM Algorithm. Journal of Statistical Software (2017), 80(3):1-41. doi:10.18637/jss.v080.i03
}
\seealso{
\code{\link{AIC}},\code{\link{BIC}}, \code{\link{saemixControl}}, \code{\link{saemix}}
}
\keyword{methods}

